/*
 * Decompiled with CFR 0.152.
 */
package org.piax.gtrans.ov.impl;

import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiConsumer;
import org.piax.common.Destination;
import org.piax.common.Endpoint;
import org.piax.common.Key;
import org.piax.common.ObjectId;
import org.piax.common.PeerId;
import org.piax.common.TransportId;
import org.piax.gtrans.FutureQueue;
import org.piax.gtrans.IdConflictException;
import org.piax.gtrans.Peer;
import org.piax.gtrans.ProtocolUnsupportedException;
import org.piax.gtrans.RemoteValue;
import org.piax.gtrans.TransOptions;
import org.piax.gtrans.Transport;
import org.piax.gtrans.dcl.DCLTranslator;
import org.piax.gtrans.dcl.DestinationCondition;
import org.piax.gtrans.dcl.parser.ParseException;
import org.piax.gtrans.impl.RequestTransportImpl;
import org.piax.gtrans.netty.idtrans.PrimaryKey;
import org.piax.gtrans.ov.Overlay;
import org.piax.gtrans.ov.OverlayListener;
import org.piax.gtrans.ov.OverlayReceivedMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class OverlayImpl<D extends Destination, K extends Key>
extends RequestTransportImpl<D>
implements Overlay<D, K> {
    private static final Logger logger = LoggerFactory.getLogger(OverlayImpl.class);
    private final Map<ObjectId, Map<K, Integer>> keysByUpper = new HashMap<ObjectId, Map<K, Integer>>();
    protected final Map<K, Integer> keyRegister = new ConcurrentHashMap<K, Integer>();
    protected volatile boolean isJoined = false;
    final DCLTranslator parser = new DCLTranslator();

    public OverlayImpl(Peer peer, TransportId transId, Transport<?> lowerTrans) throws IdConflictException {
        super(peer, transId, lowerTrans);
    }

    @Override
    public Class<?> getAvailableKeyType() {
        return Object.class;
    }

    @Override
    public void setListener(ObjectId upper, OverlayListener<D, K> listener) {
        super.setListener(upper, listener);
    }

    @Override
    public OverlayListener<D, K> getListener(ObjectId upper) {
        return (OverlayListener)super.getListener(upper);
    }

    @Override
    public void send(ObjectId sender, ObjectId receiver, String dstExp, Object msg) throws ParseException, ProtocolUnsupportedException, IOException {
        Destination dst = this.parser.parseDestination(dstExp);
        this.send(sender, receiver, dst, msg);
    }

    @Override
    public void send(TransportId transId, String dstExp, Object msg) throws ParseException, ProtocolUnsupportedException, IOException {
        this.send((ObjectId)transId, (ObjectId)transId, dstExp, msg);
    }

    @Override
    public <E> FutureQueue<E> singletonFutureQueue(E value) {
        FutureQueue fq = new FutureQueue();
        fq.add(new RemoteValue((Endpoint)this.peerId, value));
        fq.setEOFuture();
        return fq;
    }

    @Override
    public <E> FutureQueue<E> singletonFutureQueue(E value, Throwable t) {
        FutureQueue fq = new FutureQueue();
        fq.add(new RemoteValue((Endpoint)this.peerId, value, t));
        fq.setEOFuture();
        return fq;
    }

    @Override
    public void send(ObjectId appId, String dstExp, Object msg) throws ParseException, ProtocolUnsupportedException, IOException {
        this.send(appId, appId, dstExp, msg);
    }

    @Override
    public void send(String dstExp, Object msg) throws ParseException, ProtocolUnsupportedException, IOException {
        this.send(this.getDefaultAppId(), dstExp, msg);
    }

    @Override
    public FutureQueue<?> request(ObjectId sender, ObjectId receiver, String dstExp, Object msg) throws ParseException, ProtocolUnsupportedException, IOException {
        return this.request(sender, receiver, dstExp, msg, (TransOptions)null);
    }

    @Override
    public FutureQueue<?> request(ObjectId sender, ObjectId receiver, String dstExp, Object msg, TransOptions opts) throws ParseException, ProtocolUnsupportedException, IOException {
        try {
            Destination dst = this.parser.parseDestination(dstExp);
            return this.request(sender, receiver, dst, msg, opts);
        }
        catch (ParseException e) {
            DestinationCondition dc = this.parser.parseDCL(dstExp);
            return this.request(sender, receiver, dc, msg, opts);
        }
    }

    @Override
    public FutureQueue<?> request(ObjectId sender, ObjectId receiver, String dstExp, Object msg, int timeout) throws ParseException, ProtocolUnsupportedException, IOException {
        return this.request(sender, receiver, dstExp, msg, new TransOptions((long)timeout));
    }

    @Override
    public FutureQueue<?> request(TransportId transId, String dstExp, Object msg, int timeout) throws ParseException, ProtocolUnsupportedException, IOException {
        return this.request((ObjectId)transId, (ObjectId)transId, dstExp, msg, timeout);
    }

    @Override
    public FutureQueue<?> request(ObjectId appId, String dstExp, Object msg, TransOptions opts) throws ParseException, ProtocolUnsupportedException, IOException {
        return this.request(appId, appId, dstExp, msg, opts);
    }

    public FutureQueue<?> request(ObjectId appId, String dstExp, Object msg, int timeout) throws ParseException, ProtocolUnsupportedException, IOException {
        return this.request(appId, appId, dstExp, msg, timeout);
    }

    @Override
    public FutureQueue<?> request(ObjectId appId, String dstExp, Object msg) throws ParseException, ProtocolUnsupportedException, IOException {
        return this.request(appId, appId, dstExp, msg);
    }

    @Override
    public FutureQueue<?> request(String dstExp, Object msg) throws ParseException, ProtocolUnsupportedException, IOException {
        return this.request(this.getDefaultAppId(), dstExp, msg);
    }

    @Override
    public FutureQueue<?> request(String dstExp, Object msg, TransOptions opts) throws ParseException, ProtocolUnsupportedException, IOException {
        return this.request(this.getDefaultAppId(), dstExp, msg, opts);
    }

    @Override
    public FutureQueue<?> request(String dstExp, Object msg, int timeout) throws ParseException, ProtocolUnsupportedException, IOException {
        return this.request(this.getDefaultAppId(), dstExp, msg, timeout);
    }

    @Override
    public void requestAsync(ObjectId sender, ObjectId receiver, String dstExp, Object msg, BiConsumer<Object, Exception> responseReceiver, TransOptions opts) throws ParseException, ProtocolUnsupportedException, IOException {
        try {
            Destination dst = this.parser.parseDestination(dstExp);
            this.requestAsync(sender, receiver, dst, msg, responseReceiver, opts);
        }
        catch (ParseException e) {
            DestinationCondition dc = this.parser.parseDCL(dstExp);
            this.requestAsync(sender, receiver, dc, msg, responseReceiver, opts);
        }
    }

    protected Object selectOnReceive(OverlayListener<D, K> listener, Overlay<D, K> trans, OverlayReceivedMessage<K> rmsg) {
        logger.trace("ENTRY:");
        Object msg = rmsg.getMessage();
        logger.debug("msg {}", msg);
        Object inn = this.checkAndClearIsEasySend(msg);
        if (NON != inn) {
            rmsg.setMessage(inn);
            logger.debug("select onReceive: trans:{}", (Object)trans.getTransportId());
            listener.onReceive(trans, rmsg);
            return null;
        }
        return listener.onReceiveRequest(trans, rmsg);
    }

    protected int numOfRegisteredKey(K key) {
        Integer count = this.keyRegister.get(key);
        if (count == null) {
            return 0;
        }
        return count;
    }

    protected void registerKey(K key) {
        Integer count = this.keyRegister.get(key);
        if (count == null) {
            this.keyRegister.put(key, 1);
        } else {
            this.keyRegister.put(key, count + 1);
        }
    }

    protected void registerKey(ObjectId upper, K key) {
        Integer count;
        Map<K, Integer> keyCounts = this.keysByUpper.get(upper);
        if (keyCounts == null) {
            keyCounts = new HashMap<K, Integer>();
            this.keysByUpper.put(upper, keyCounts);
        }
        if ((count = keyCounts.get(key)) == null) {
            keyCounts.put(key, 1);
        } else {
            keyCounts.put(key, count + 1);
        }
        this.registerKey(key);
    }

    protected boolean unregisterKey(K key) {
        Integer count = this.keyRegister.get(key);
        if (count == null) {
            return false;
        }
        if (count == 1) {
            this.keyRegister.remove(key);
        } else {
            this.keyRegister.put(key, count - 1);
        }
        return true;
    }

    protected boolean unregisterKey(ObjectId upper, K key) {
        Map<K, Integer> keyCounts = this.keysByUpper.get(upper);
        if (keyCounts == null) {
            return false;
        }
        Integer count = keyCounts.get(key);
        if (count == null) {
            return false;
        }
        if (count == 1) {
            keyCounts.remove(key);
        } else {
            keyCounts.put(key, count - 1);
        }
        if (!this.unregisterKey(key)) {
            logger.error("keyRegister should have specified key");
            return false;
        }
        return true;
    }

    protected void lowerAddKey(K key) throws IOException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean addKey(ObjectId upper, K key) throws IOException {
        this.checkActive();
        Map<K, Integer> map = this.keyRegister;
        synchronized (map) {
            if (!this.keyRegister.containsKey(key)) {
                this.lowerAddKey(key);
            }
            this.registerKey(upper, key);
            return true;
        }
    }

    @Override
    public boolean addKey(K key) throws IOException {
        return this.addKey(this.getDefaultAppId(), key);
    }

    protected CompletableFuture<Boolean> lowerAddKeyAsync(K key) {
        return CompletableFuture.completedFuture(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CompletableFuture<Boolean> addKeyAsync(ObjectId upper, K key) {
        this.checkActive();
        boolean exists = false;
        CompletionStage<Boolean> ret = CompletableFuture.completedFuture(true);
        Map<K, Integer> map = this.keyRegister;
        synchronized (map) {
            exists = this.keyRegister.containsKey(key);
        }
        if (!exists) {
            ret = this.lowerAddKeyAsync(key);
            ret = ret.whenComplete((result, ex) -> {
                if (ex != null) {
                    logger.warn("addKeyAsync: {}", ex);
                }
                if (result.booleanValue()) {
                    Map<K, Integer> map = this.keyRegister;
                    synchronized (map) {
                        this.registerKey(upper, key);
                    }
                }
            });
        } else {
            map = this.keyRegister;
            synchronized (map) {
                this.registerKey(upper, key);
            }
        }
        return ret;
    }

    @Override
    public CompletableFuture<Boolean> addKeyAsync(K key) {
        return this.addKeyAsync(this.getDefaultAppId(), key);
    }

    protected void lowerRemoveKey(K key) throws IOException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean removeKey(ObjectId upper, K key) throws IOException {
        this.checkActive();
        if (key instanceof PrimaryKey || key instanceof PeerId) {
            throw new IllegalArgumentException("Primary key or Peer Id cannot be removed (leave instead)");
        }
        Map<K, Integer> map = this.keyRegister;
        synchronized (map) {
            block6: {
                if (this.keyRegister.containsKey(key)) break block6;
                return false;
            }
            if (this.numOfRegisteredKey(key) == 1) {
                this.lowerRemoveKey(key);
            }
            return this.unregisterKey(upper, key);
        }
    }

    @Override
    public boolean removeKey(K key) throws IOException {
        return this.removeKey(this.getDefaultAppId(), key);
    }

    protected CompletableFuture<Boolean> lowerRemoveKeyAsync(K key) {
        return CompletableFuture.completedFuture(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CompletableFuture<Boolean> removeKeyAsync(ObjectId upper, K key) {
        int num;
        this.checkActive();
        CompletionStage<Boolean> ret = CompletableFuture.completedFuture(false);
        if (key instanceof PrimaryKey || key instanceof PeerId) {
            throw new IllegalArgumentException("Primary key or Peer Id cannot be removed (leave instead)");
        }
        Map<K, Integer> map = this.keyRegister;
        synchronized (map) {
            if (!this.keyRegister.containsKey(key)) {
                return ret;
            }
            num = this.numOfRegisteredKey(key);
        }
        if (num == 1) {
            ret = this.lowerRemoveKeyAsync(key);
            ret = ret.whenComplete((result, ex) -> {
                if (ex != null) {
                    logger.warn("removeKeyAsync: {}, {}", (Object)key, ex);
                }
                if (result.booleanValue()) {
                    Map<K, Integer> map = this.keyRegister;
                    synchronized (map) {
                        this.unregisterKey(upper, key);
                    }
                }
            });
        } else {
            map = this.keyRegister;
            synchronized (map) {
                this.unregisterKey(upper, key);
            }
        }
        return ret;
    }

    @Override
    public CompletableFuture<Boolean> removeKeyAsync(K key) {
        return this.removeKeyAsync(this.getDefaultAppId(), key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<K> getKeys(ObjectId upper) {
        Map<K, Integer> map = this.keyRegister;
        synchronized (map) {
            Map<K, Integer> keyCounts = this.keysByUpper.get(upper);
            if (keyCounts == null) {
                return new HashSet();
            }
            return new HashSet<K>(keyCounts.keySet());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<K> getKeys() {
        Map<K, Integer> map = this.keyRegister;
        synchronized (map) {
            return new HashSet<K>(this.keyRegister.keySet());
        }
    }

    @Override
    public boolean join() throws ProtocolUnsupportedException, IOException {
        return this.join(this.lowerTrans.getEndpoint().newSameTypeEndpoint((String)Overlay.DEFAULT_SEED.value()));
    }

    @Override
    public boolean join(String spec) throws ProtocolUnsupportedException, IOException {
        return this.join(this.lowerTrans.getEndpoint().newSameTypeEndpoint(spec));
    }

    @Override
    public boolean join(Endpoint seed) throws IOException {
        return this.join(Collections.singleton(seed));
    }

    @Override
    public abstract boolean join(Collection<? extends Endpoint> var1) throws IOException;

    @Override
    public abstract boolean leave() throws IOException;

    @Override
    public boolean isJoined() {
        return this.isJoined;
    }

    @Override
    public String toString0() {
        return String.valueOf(super.toString0()) + ", keys=" + this.keysByUpper;
    }
}

