/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.identity.federation.bindings.jboss.auth;

import java.security.Principal;
import java.security.acl.Group;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.login.LoginException;
import javax.xml.ws.Dispatch;
import org.apache.log4j.Logger;
import org.jboss.security.SimplePrincipal;
import org.jboss.security.auth.callback.ObjectCallback;
import org.jboss.security.auth.spi.AbstractServerLoginModule;
import org.picketlink.identity.federation.bindings.jboss.subject.PicketLinkGroup;
import org.picketlink.identity.federation.bindings.jboss.subject.PicketLinkPrincipal;
import org.picketlink.identity.federation.core.exceptions.ProcessingException;
import org.picketlink.identity.federation.core.factories.JBossAuthCacheInvalidationFactory;
import org.picketlink.identity.federation.core.saml.v2.util.AssertionUtil;
import org.picketlink.identity.federation.core.util.StringUtil;
import org.picketlink.identity.federation.core.wstrust.STSClient;
import org.picketlink.identity.federation.core.wstrust.STSClientConfig;
import org.picketlink.identity.federation.core.wstrust.SamlCredential;
import org.picketlink.identity.federation.core.wstrust.WSTrustException;
import org.picketlink.identity.federation.core.wstrust.plugins.saml.SAMLUtil;
import org.picketlink.identity.federation.saml.v2.assertion.AssertionType;
import org.picketlink.identity.federation.saml.v2.assertion.NameIDType;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class SAML2STSCommonLoginModule
extends AbstractServerLoginModule {
    protected static Logger log = Logger.getLogger(SAML2STSCommonLoginModule.class);
    protected boolean trace = log.isTraceEnabled();
    protected String stsConfigurationFile;
    protected Principal principal;
    protected SamlCredential credential;
    protected AssertionType assertion;
    protected boolean enableCacheInvalidation = false;
    protected String securityDomain = null;
    protected boolean localValidation = false;
    protected String localValidationSecurityDomain;
    protected String roleKey = "Role";
    protected Map<String, Object> options = new HashMap<String, Object>();
    protected Map<String, Object> rawOptions = new HashMap<String, Object>();
    public static final String STS_CONFIG_FILE = "configFile";
    public static final String ENDPOINT_ADDRESS = "endpointAddress";
    public static final String PORT_NAME = "portName";
    public static final String SERVICE_NAME = "serviceName";
    public static final String USERNAME_KEY = "username";
    public static final String PASSWORD_KEY = "password";
    protected boolean localTestingOnly = false;

    public void initialize(Subject subject, CallbackHandler callbackHandler, Map<String, ?> sharedState, Map<String, ?> options) {
        String localValidationStr;
        String roleKeyStr;
        super.initialize(subject, callbackHandler, sharedState, options);
        this.options.putAll(options);
        this.rawOptions.putAll(options);
        if (this.trace) {
            log.trace(options);
        }
        this.stsConfigurationFile = (String)this.options.remove(STS_CONFIG_FILE);
        String cacheInvalidation = (String)this.options.remove("cache.invalidation");
        if (cacheInvalidation != null && !cacheInvalidation.isEmpty()) {
            this.enableCacheInvalidation = Boolean.parseBoolean(cacheInvalidation);
            this.securityDomain = (String)this.options.remove("jboss.security.security_domain");
            if (this.securityDomain == null || this.securityDomain.isEmpty()) {
                throw new RuntimeException("PL00076: Option not set:jboss.security.security_domain");
            }
        }
        if (StringUtil.isNotNull((String)(roleKeyStr = (String)options.get("roleKey")))) {
            this.roleKey = roleKeyStr.trim();
        }
        if (StringUtil.isNotNull((String)(localValidationStr = (String)options.get("localValidation")))) {
            String localTestingOnlyStr;
            this.localValidation = Boolean.parseBoolean(localValidationStr);
            this.localValidationSecurityDomain = (String)options.get("localValidationSecurityDomain");
            if (!this.localValidationSecurityDomain.startsWith("java:jboss/jaas/")) {
                this.localValidationSecurityDomain = "java:jboss/jaas//" + this.localValidationSecurityDomain;
            }
            if (StringUtil.isNotNull((String)(localTestingOnlyStr = (String)options.get("localTestingOnly")))) {
                this.localTestingOnly = Boolean.valueOf(localTestingOnlyStr);
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    public boolean login() throws LoginException {
        if (super.login()) {
            sharedPrincipal = this.sharedState.get("javax.security.auth.login.name");
            if (sharedPrincipal instanceof Principal) {
                this.principal = (Principal)sharedPrincipal;
            } else {
                try {
                    this.principal = this.createIdentity(sharedPrincipal.toString());
                }
                catch (Exception e) {
                    throw new LoginException("PL00102: Processing Exception:Failed to create principal: " + e.getMessage());
                }
            }
            credential = this.sharedState.get("javax.security.auth.login.password");
            if (!(credential instanceof SamlCredential)) {
                throw new LoginException("PL00095: Wrong type:SAML2STSLoginModule: Shared credential is not a SAML credential");
            }
            this.credential = (SamlCredential)credential;
            return true;
        }
        if (this.stsConfigurationFile == null) {
            throw new LoginException("PL00039: SAML2STSLoginModule: Failed to validate assertion: STS configuration file not specified");
        }
        callback = new ObjectCallback(null);
        assertionElement = null;
        try {
            this.callbackHandler.handle(new Callback[]{callback});
            if (!(callback.getCredential() instanceof SamlCredential)) {
                throw new IllegalArgumentException("PL00095: Wrong type:SAML2STSLoginModule: Supplied credential is not a SAML credential.We got " + callback.getCredential().getClass());
            }
            this.credential = (SamlCredential)callback.getCredential();
            assertionElement = this.credential.getAssertionAsElement();
        }
        catch (Exception e) {
            exception = new LoginException("PL00041: SAML2STSLoginModule: Error handling callback::" + e.getMessage());
            exception.initCause(e);
            throw exception;
        }
        if (this.localValidation) {
            if (this.trace) {
                SAML2STSCommonLoginModule.log.trace((Object)"Local Validation is being Performed");
            }
            try {
                isValid = this.localValidation(assertionElement);
                if (!isValid || !this.trace) ** GOTO lbl58
                SAML2STSCommonLoginModule.log.trace((Object)"Local Validation passed.");
            }
            catch (Exception e) {
                le = new LoginException();
                le.initCause(e);
                throw le;
            }
        } else {
            if (this.trace) {
                SAML2STSCommonLoginModule.log.trace((Object)"Local Validation is disabled. Verifying with STS");
            }
            client = this.getSTSClient();
            try {
                isValid = client.validateToken(assertionElement);
                if (!isValid) {
                    throw new LoginException("PL00080: Invalid Assertion:SAML2STSLoginModule: Supplied assertion was considered invalid by the STS");
                }
            }
            catch (WSTrustException we) {
                exception = new LoginException("PL00080: Invalid Assertion:SAML2STSLoginModule: Failed to validate assertion using STS: " + we.getMessage());
                exception.initCause(we);
                throw exception;
            }
        }
lbl58:
        // 3 sources

        try {
            this.assertion = SAMLUtil.fromElement((Element)assertionElement);
            subject = this.assertion.getSubject();
            if (subject != null && (baseID = subject.getSubType().getBaseID()) instanceof NameIDType) {
                nameID = (NameIDType)baseID;
                this.principal = new PicketLinkPrincipal(nameID.getValue());
                if (this.enableCacheInvalidation) {
                    cacheExpiry = JBossAuthCacheInvalidationFactory.getCacheExpiry();
                    expiry = AssertionUtil.getExpiration((AssertionType)this.assertion);
                    if (expiry != null) {
                        expiryDate = expiry.toGregorianCalendar().getTime();
                        if (this.trace) {
                            SAML2STSCommonLoginModule.log.trace((Object)("Creating Cache Entry for JBoss at [" + new Date() + " ] , with expiration set to SAML expiry=" + expiryDate));
                        }
                        cacheExpiry.register(this.securityDomain, expiryDate, this.principal);
                    } else {
                        SAML2STSCommonLoginModule.log.warn((Object)("SAML Assertion has been found to have no expiration: ID = " + this.assertion.getID()));
                    }
                }
            }
        }
        catch (Exception e) {
            exception = new LoginException("PL00044: SAML2STSLoginModule: Failed to parse assertion element:" + e.getMessage());
            exception.initCause(e);
            throw exception;
        }
        if (this.getUseFirstPass()) {
            this.sharedState.put("javax.security.auth.login.name", this.principal);
            this.sharedState.put("javax.security.auth.login.password", this.credential);
        }
        this.loginOk = true;
        return true;
    }

    protected Principal getIdentity() {
        return this.principal;
    }

    protected Group[] getRoleSets() throws LoginException {
        if (this.assertion == null) {
            try {
                this.assertion = SAMLUtil.fromElement((Element)this.credential.getAssertionAsElement());
            }
            catch (Exception e) {
                LoginException le = new LoginException("PL00044: SAML2STSLoginModule: Failed to parse assertion element: " + e.getMessage());
                le.initCause(e);
                throw le;
            }
        }
        if (this.trace) {
            try {
                log.trace((Object)("Assertion from where roles will be sought=" + AssertionUtil.asString((AssertionType)this.assertion)));
            }
            catch (ProcessingException ignore) {
                // empty catch block
            }
        }
        ArrayList roleKeys = new ArrayList();
        if (StringUtil.isNotNull((String)this.roleKey)) {
            roleKeys.addAll(StringUtil.tokenize((String)this.roleKey));
        }
        String groupName = "Roles";
        PicketLinkGroup rolesGroup = new PicketLinkGroup(groupName);
        List roles = AssertionUtil.getRoles((AssertionType)this.assertion, roleKeys);
        for (String role : roles) {
            rolesGroup.addMember((Principal)new SimplePrincipal(role));
        }
        return new Group[]{rolesGroup};
    }

    protected STSClient getSTSClient() {
        STSClientConfig.Builder builder = null;
        STSClient client = null;
        if (this.rawOptions.containsKey(STS_CONFIG_FILE)) {
            builder = new STSClientConfig.Builder(this.stsConfigurationFile);
            client = new STSClient(builder.build());
        } else {
            builder = new STSClientConfig.Builder();
            builder.endpointAddress((String)this.rawOptions.get(ENDPOINT_ADDRESS));
            builder.portName((String)this.rawOptions.get(PORT_NAME)).serviceName((String)this.rawOptions.get(SERVICE_NAME));
            builder.username((String)this.rawOptions.get(USERNAME_KEY)).password((String)this.rawOptions.get(PASSWORD_KEY));
            String passwordString = (String)this.rawOptions.get(PASSWORD_KEY);
            if (passwordString != null && passwordString.startsWith("MASK-")) {
                String salt = (String)this.rawOptions.get("salt");
                if (StringUtil.isNullOrEmpty((String)salt)) {
                    throw new RuntimeException("PL00076: Option not set:Salt");
                }
                String iCount = (String)this.rawOptions.get("iterationCount");
                if (StringUtil.isNullOrEmpty((String)iCount)) {
                    throw new RuntimeException("PL00076: Option not set:Iteration Count");
                }
                int iterationCount = Integer.parseInt(iCount);
                try {
                    builder.password(StringUtil.decode((String)passwordString, (String)salt, (int)iterationCount));
                }
                catch (Exception e) {
                    throw new RuntimeException("PL00047: SAML2STSLoginModule: Unable to decode password:" + passwordString);
                }
            }
            client = new STSClient(builder.build());
        }
        if (!this.options.isEmpty()) {
            Dispatch dispatch = client.getDispatch();
            for (Map.Entry<String, Object> entry : this.options.entrySet()) {
                dispatch.getRequestContext().put(entry.getKey(), entry.getValue());
            }
        }
        return client;
    }

    protected abstract boolean localValidation(Element var1) throws Exception;
}

