/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.trust.jbossws.handler;

import java.io.InputStream;
import java.security.Principal;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;
import javax.servlet.ServletContext;
import javax.xml.namespace.QName;
import javax.xml.soap.SOAPBody;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPMessage;
import javax.xml.ws.handler.MessageContext;
import javax.xml.ws.handler.soap.SOAPMessageContext;
import org.jboss.security.AuthorizationManager;
import org.jboss.security.SecurityContext;
import org.jboss.security.SimplePrincipal;
import org.jboss.security.callbacks.SecurityContextCallbackHandler;
import org.picketlink.identity.federation.core.exceptions.ConfigurationException;
import org.picketlink.identity.federation.core.exceptions.ProcessingException;
import org.picketlink.trust.jbossws.handler.AbstractPicketLinkTrustHandler;
import org.picketlink.trust.jbossws.handler.SecurityActions;
import org.picketlink.trust.jbossws.util.JBossWSNativeStackUtil;
import org.picketlink.trust.jbossws.util.JBossWSSERoleExtractor;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractWSAuthorizationHandler
extends AbstractPicketLinkTrustHandler {
    public static final String UNCHECKED = "unchecked";
    protected Map<String, List<String>> cache = new HashMap<String, List<String>>();

    @Override
    protected boolean handleInbound(MessageContext msgContext) {
        logger.trace("Handling Inbound Message");
        this.trace(msgContext);
        ServletContext context = this.getServletContext(msgContext);
        InputStream is = this.getWSSE(context);
        if (is == null) {
            throw logger.jbossWSUnableToLoadJBossWSSEConfigError();
        }
        QName portName = (QName)msgContext.get((Object)"javax.xml.ws.wsdl.port");
        QName opName = (QName)msgContext.get((Object)"javax.xml.ws.wsdl.operation");
        if (portName == null) {
            portName = JBossWSNativeStackUtil.getPortNameViaReflection(this.getClass(), msgContext);
        }
        if (portName == null) {
            throw logger.nullValueError("port name from the message context");
        }
        if (opName == null) {
            opName = this.getOperationName(msgContext);
        }
        if (opName == null) {
            throw logger.nullValueError("operation name from the message context");
        }
        List<String> roles = null;
        String key = portName.getLocalPart() + "_" + opName.toString();
        if (this.cache.containsKey(key)) {
            roles = this.cache.get(key);
        } else {
            try {
                roles = JBossWSSERoleExtractor.getRoles(is, portName.getLocalPart(), opName.toString());
            }
            catch (ProcessingException e) {
                throw new RuntimeException(e);
            }
            this.cache.put(key, roles);
        }
        if (!roles.contains(UNCHECKED)) {
            AuthorizationManager authorizationManager = null;
            try {
                authorizationManager = this.getAuthorizationManager(msgContext);
            }
            catch (ConfigurationException e) {
                logger.authorizationManagerError(e);
                throw new RuntimeException(e);
            }
            Subject subject = SecurityActions.getAuthenticatedSubject();
            Set<Principal> expectedRoles = this.rolesSet(roles);
            if (!authorizationManager.doesUserHaveRole(null, expectedRoles)) {
                SecurityContext sc = SecurityActions.getSecurityContext();
                StringBuilder builder = new StringBuilder("Authorization Failed:Subject=");
                builder.append(subject).append(":Expected Roles=").append(expectedRoles);
                SecurityContextCallbackHandler scbh = new SecurityContextCallbackHandler(sc);
                builder.append("::Actual Roles=").append(authorizationManager.getSubjectRoles(subject, (CallbackHandler)scbh));
                logger.error(builder.toString());
                throw logger.jbossWSAuthorizationFailed();
            }
        }
        return true;
    }

    protected Set<Principal> rolesSet(List<String> roles) {
        HashSet<Principal> principals = new HashSet<Principal>();
        for (String role : roles) {
            principals.add((Principal)new SimplePrincipal(role));
        }
        return principals;
    }

    protected InputStream getWSSE(ServletContext context) {
        if (context == null) {
            throw logger.nullValueError("Servlet Context");
        }
        InputStream is = context.getResourceAsStream("/WEB-INF/jboss-wsse.xml");
        return is;
    }

    protected InputStream load(ClassLoader cl) {
        InputStream is = null;
        is = cl.getResourceAsStream("WEB-INF/jboss-wsse.xml");
        if (is == null) {
            is = cl.getResourceAsStream("/WEB-INF/jboss-wsse.xml");
        }
        return is;
    }

    private QName getOperationName(MessageContext msgContext) {
        SOAPMessageContext soapMessageContext = (SOAPMessageContext)msgContext;
        SOAPMessage soapMessage = soapMessageContext.getMessage();
        try {
            SOAPBody soapBody = soapMessage.getSOAPBody();
            Node child = soapBody.getFirstChild();
            String childNamespace = child.getNamespaceURI();
            String childName = child.getLocalName();
            return new QName(childNamespace, childName);
        }
        catch (SOAPException e) {
            logger.jbossWSErrorGettingOperationName((Throwable)e);
            return null;
        }
    }

    protected AuthorizationManager getAuthorizationManager(MessageContext msgContext) throws ConfigurationException {
        return (AuthorizationManager)this.lookupJNDI("java:jboss/jaas/" + this.getSecurityDomainName(msgContext) + "/authorizationMgr");
    }
}

