/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.identity.federation.bindings.jboss.auth.mapping;

import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jboss.security.identity.Role;
import org.jboss.security.identity.RoleGroup;
import org.jboss.security.identity.plugins.SimpleRole;
import org.jboss.security.identity.plugins.SimpleRoleGroup;
import org.jboss.security.mapping.MappingProvider;
import org.jboss.security.mapping.MappingResult;
import org.picketlink.identity.federation.PicketLinkLogger;
import org.picketlink.identity.federation.PicketLinkLoggerFactory;
import org.picketlink.identity.federation.core.wstrust.plugins.saml.SAMLUtil;
import org.picketlink.identity.federation.saml.v2.assertion.AssertionType;
import org.picketlink.identity.federation.saml.v2.assertion.AttributeStatementType;
import org.picketlink.identity.federation.saml.v2.assertion.AttributeType;
import org.picketlink.identity.federation.saml.v2.assertion.StatementAbstractType;
import org.w3c.dom.Element;

public class STSGroupMappingProvider
implements MappingProvider<RoleGroup> {
    private static final PicketLinkLogger logger = PicketLinkLoggerFactory.getLogger();
    private MappingResult<RoleGroup> result;
    private String tokenRoleAttributeName;

    public void init(Map<String, Object> contextMap) {
        Object tokenRoleAttributeObject = contextMap.get("token-role-attribute-name");
        this.tokenRoleAttributeName = tokenRoleAttributeObject != null ? (String)tokenRoleAttributeObject : "role";
        logger.trace("Initialized with " + contextMap);
    }

    public void performMapping(Map<String, Object> contextMap, RoleGroup Group2) {
        Object tokenObject;
        logger.debug("performMapping with map as " + contextMap);
        if (contextMap == null) {
            logger.mappingContextNull();
        }
        if (!((tokenObject = contextMap.get("org.picketlink.identity.federation.core.wstrust.lm.stsToken")) instanceof Element)) {
            logger.debug("Did not find a token " + Element.class.getName() + " under " + "org.picketlink.identity.federation.core.wstrust.lm.stsToken" + " in the map");
        }
        try {
            Element tokenElement = (Element)tokenObject;
            AssertionType assertion = SAMLUtil.fromElement((Element)tokenElement);
            AttributeStatementType attributeStatement = this.getAttributeStatement(assertion);
            if (attributeStatement != null) {
                SimpleRoleGroup rolesGroup = new SimpleRoleGroup("Roles");
                List attributeList = attributeStatement.getAttributes();
                for (AttributeStatementType.ASTChoiceType obj : attributeList) {
                    AttributeType attribute = obj.getAttribute();
                    if (attribute == null || !this.tokenRoleAttributeName.equals(attribute.getName())) continue;
                    for (Object value : attribute.getAttributeValue()) {
                        rolesGroup.addRole((Role)new SimpleRole((String)value));
                    }
                }
                this.result.setMappedObject((Object)rolesGroup);
                logger.trace("Mapped roles to " + rolesGroup);
            }
        }
        catch (Exception e) {
            logger.authFailedToParseSAMLAssertion((Throwable)e);
        }
    }

    public void setMappingResult(MappingResult<RoleGroup> mappingResult) {
        this.result = mappingResult;
    }

    public boolean supports(Class<?> p) {
        return RoleGroup.class.isAssignableFrom(p);
    }

    private AttributeStatementType getAttributeStatement(AssertionType assertion) {
        Set statementList = assertion.getStatements();
        if (statementList.size() != 0) {
            for (StatementAbstractType statement : statementList) {
                if (!(statement instanceof AttributeStatementType)) continue;
                return (AttributeStatementType)statement;
            }
        }
        return null;
    }
}

