/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.trust.jbossws.jaas;

import java.net.URI;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.net.ssl.SSLSocketFactory;
import javax.security.auth.login.LoginException;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.XMLGregorianCalendar;
import javax.xml.namespace.QName;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPFactory;
import javax.xml.ws.Binding;
import javax.xml.ws.Dispatch;
import javax.xml.ws.handler.Handler;
import org.picketlink.common.PicketLinkLogger;
import org.picketlink.common.PicketLinkLoggerFactory;
import org.picketlink.common.exceptions.fed.WSTrustException;
import org.picketlink.common.util.StringUtil;
import org.picketlink.identity.federation.bindings.jboss.subject.PicketLinkPrincipal;
import org.picketlink.identity.federation.core.wstrust.STSClient;
import org.picketlink.identity.federation.core.wstrust.STSClientConfig;
import org.picketlink.identity.federation.core.wstrust.STSClientCreationCallBack;
import org.picketlink.identity.federation.core.wstrust.STSClientFactory;
import org.picketlink.identity.federation.core.wstrust.SamlCredential;
import org.picketlink.identity.federation.core.wstrust.auth.STSIssuingLoginModule;
import org.picketlink.identity.federation.core.wstrust.wrappers.RequestSecurityToken;
import org.picketlink.identity.federation.ws.trust.ValidateTargetType;
import org.picketlink.trust.jbossws.PicketLinkDispatch;
import org.picketlink.trust.jbossws.handler.BinaryTokenHandler;
import org.picketlink.trust.jbossws.handler.MapBasedTokenHandler;
import org.picketlink.trust.jbossws.jaas.SecurityActions;
import org.w3c.dom.Element;

public class JBWSTokenIssuingLoginModule
extends STSIssuingLoginModule {
    private static final PicketLinkLogger logger = PicketLinkLoggerFactory.getLogger();
    public static final String WSA_ISSUER = "wsaIssuer";
    public static final String WSP_APPIESTO = "wspAppliesTo";

    protected STSClientConfig.Builder createBuilder() {
        STSClientConfig.Builder builder = super.createBuilder();
        builder.wsaIssuer((String)this.options.get(WSA_ISSUER));
        builder.wspAppliesTo((String)this.options.get(WSP_APPIESTO));
        return builder;
    }

    protected STSClient createWSTrustClient(final STSClientConfig config) {
        try {
            return STSClientFactory.getInstance((int)this.maxClientsInPool).createPool(this.initialNumberOfClients, new STSClientCreationCallBack(){

                public STSClient createClient() {
                    String binaryTokenKey = (String)JBWSTokenIssuingLoginModule.this.options.get("map.token.key");
                    if (binaryTokenKey == null) {
                        binaryTokenKey = SecurityActions.getSystemProperty("map.token.key", "ClientID");
                    }
                    Object binaryToken = JBWSTokenIssuingLoginModule.this.sharedState.get(binaryTokenKey);
                    HashMap STSClientOptions = new HashMap(JBWSTokenIssuingLoginModule.this.options);
                    if (binaryToken != null) {
                        STSClientOptions.put(binaryTokenKey, binaryToken);
                    }
                    return new JBWSTokenClient(config, STSClientOptions);
                }

                public String getKey() {
                    return config.getServiceName() + "|" + config.getPortName() + "|" + config.getEndPointAddress();
                }
            });
        }
        catch (Exception e) {
            throw logger.authCouldNotCreateWSTrustClient((Throwable)e);
        }
    }

    public boolean commit() throws LoginException {
        boolean result = super.commit();
        if (result) {
            SamlCredential samlCredential = null;
            Set<Object> creds = this.subject.getPublicCredentials();
            for (Object cred : creds) {
                if (!(cred instanceof SamlCredential)) continue;
                samlCredential = (SamlCredential)cred;
                break;
            }
            if (samlCredential == null) {
                throw logger.authSAMLCredentialNotAvailable();
            }
            PicketLinkPrincipal principal = new PicketLinkPrincipal("");
            if (super.isUseFirstPass()) {
                this.sharedState.put("javax.security.auth.login.name", principal);
                this.sharedState.put("javax.security.auth.login.password", samlCredential);
            }
        }
        return result;
    }

    public class JBWSTokenClient
    extends STSClient {
        private String requestType;
        private DatatypeFactory dataTypefactory;

        public JBWSTokenClient() {
            this.requestType = "http://docs.oasis-open.org/ws-sx/ws-trust/200512/Issue";
            try {
                this.dataTypefactory = DatatypeFactory.newInstance();
            }
            catch (DatatypeConfigurationException dce) {
                throw logger.wsTrustUnableToGetDataTypeFactory((Throwable)dce);
            }
        }

        public JBWSTokenClient(STSClientConfig config) {
            super(config);
            this.requestType = "http://docs.oasis-open.org/ws-sx/ws-trust/200512/Issue";
            this.requestType = config.getRequestType();
            try {
                this.dataTypefactory = DatatypeFactory.newInstance();
            }
            catch (DatatypeConfigurationException dce) {
                throw logger.wsTrustUnableToGetDataTypeFactory((Throwable)dce);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public JBWSTokenClient(STSClientConfig config, Map<String, ? super Object> options) {
            boolean bool;
            String soapBinding;
            super(config);
            this.requestType = "http://docs.oasis-open.org/ws-sx/ws-trust/200512/Issue";
            try {
                this.dataTypefactory = DatatypeFactory.newInstance();
            }
            catch (DatatypeConfigurationException dce) {
                throw logger.wsTrustUnableToGetDataTypeFactory((Throwable)dce);
            }
            this.requestType = (String)options.get("requestType");
            if (this.requestType == null) {
                this.requestType = config.getRequestType();
            }
            if ((soapBinding = (String)options.get("soapBinding")) != null) {
                this.setSoapBinding(soapBinding);
            }
            Dispatch dispatch = super.getDispatch();
            String overrideDispatchStr = (String)options.get("overrideDispatch");
            if (StringUtil.isNotNull((String)overrideDispatchStr) && (bool = Boolean.valueOf(overrideDispatchStr).booleanValue())) {
                dispatch = new PicketLinkDispatch(dispatch, (String)options.get("endpointAddress"));
                String useWSSE = (String)options.get("useWSSE");
                if (StringUtil.isNotNull((String)useWSSE) && useWSSE.equalsIgnoreCase("true")) {
                    ((PicketLinkDispatch)dispatch).setUseWSSE(true);
                }
            }
            Binding binding = dispatch.getBinding();
            List handlers = binding.getHandlerChain();
            String handlerStr = (String)options.get("handlerChain");
            if (StringUtil.isNotNull((String)handlerStr)) {
                List tokens = StringUtil.tokenize((String)handlerStr);
                for (String token : tokens) {
                    if (token.equalsIgnoreCase("binary")) {
                        BinaryTokenHandler binaryTokenHandler = new BinaryTokenHandler();
                        handlers.add(binaryTokenHandler);
                        continue;
                    }
                    if (token.equalsIgnoreCase("map")) {
                        MapBasedTokenHandler mapBasedHandler = new MapBasedTokenHandler(options);
                        handlers.add(mapBasedHandler);
                        continue;
                    }
                    String className = token.equalsIgnoreCase("saml2") ? "org.picketlink.trust.jbossws.handler.SAML2Handler" : token;
                    ClassLoader cl = SecurityActions.getClassLoader(((Object)((Object)this)).getClass());
                    try {
                        handlers.add((Handler)cl.loadClass(className).newInstance());
                    }
                    catch (Exception e) {
                        throw logger.authUnableToInstantiateHandler(token, (Throwable)e);
                    }
                }
            }
            binding.setHandlerChain(handlers);
            this.setDispatch(dispatch);
            String securityDomainForFactory = (String)options.get("securityDomainForFactory");
            if (StringUtil.isNotNull((String)securityDomainForFactory)) {
                logger.trace("We got security domain for domain ssl factory = " + securityDomainForFactory);
                logger.trace("Setting it on the system property org.jboss.security.ssl.domain.name");
                String sslFactoryName = "org.jboss.security.ssl.JaasSecurityDomainSocketFactory";
                SecurityActions.setSystemProperty("org.jboss.security.ssl.domain.name", securityDomainForFactory);
                dispatch.getRequestContext().put("org.jboss.ws.socketFactory", sslFactoryName);
                if (dispatch instanceof PicketLinkDispatch) {
                    ClassLoader cl = SecurityActions.getClassLoader(((Object)((Object)this)).getClass());
                    SSLSocketFactory socketFactory = null;
                    if (cl != null) {
                        try {
                            Class<?> clazz = cl.loadClass(sslFactoryName);
                            socketFactory = (SSLSocketFactory)clazz.newInstance();
                        }
                        catch (Exception e) {
                            cl = SecurityActions.getContextClassLoader();
                            try {
                                Class<?> clazz = cl.loadClass(sslFactoryName);
                                socketFactory = (SSLSocketFactory)clazz.newInstance();
                            }
                            catch (Exception e1) {
                                throw logger.jbossWSUnableToCreateSSLSocketFactory((Throwable)e1);
                            }
                        }
                        finally {
                            if (socketFactory == null) {
                                throw logger.jbossWSUnableToFindSSLSocketFactory();
                            }
                            ((PicketLinkDispatch)dispatch).setSSLSocketFactory(socketFactory);
                        }
                    } else {
                        logger.trace("Classloader is null. Unable to set the SSLSocketFactory on PicketLinkDispatch");
                    }
                }
            }
        }

        public Element issueToken(RequestSecurityToken request) throws WSTrustException {
            if (this.requestType.equals("http://docs.oasis-open.org/ws-sx/ws-trust/200512/Validate")) {
                request.setRequestType(URI.create(this.requestType));
                ValidateTargetType validateTarget = new ValidateTargetType();
                try {
                    String sUserName = JBWSTokenIssuingLoginModule.this.getSharedUsername();
                    char[] cPassword = JBWSTokenIssuingLoginModule.this.getSharedPassword();
                    Element wsseUsernameToken = this.createUsernameToken(sUserName, cPassword != null ? new String(cPassword) : null);
                    validateTarget.add((Object)wsseUsernameToken);
                    request.setValidateTarget(validateTarget);
                }
                catch (SOAPException e) {
                    throw new WSTrustException((Throwable)e);
                }
            }
            return super.issueToken(request);
        }

        private Element createUsernameToken(String usernameValue, String passwordValue) throws SOAPException {
            QName usernameTokenName = new QName("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd", "UsernameToken", "wsse");
            QName usernameName = new QName("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd", "Username", "wsse");
            QName passwordName = new QName("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd", "Password", "wsse");
            QName createdName = new QName("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd", "Created", "wsu");
            SOAPFactory factory = SOAPFactory.newInstance();
            SOAPElement usernametoken = factory.createElement(usernameTokenName);
            usernametoken.addNamespaceDeclaration("wsse", "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd");
            usernametoken.addNamespaceDeclaration("wsu", "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd");
            SOAPElement username = factory.createElement(usernameName);
            username.addTextNode(usernameValue);
            SOAPElement password = factory.createElement(passwordName);
            password.addAttribute(new QName("Type"), "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-username-token-profile-1.0#PasswordText");
            password.addTextNode(passwordValue);
            SOAPElement created = factory.createElement(createdName);
            XMLGregorianCalendar createdCal = this.dataTypefactory.newXMLGregorianCalendar(new GregorianCalendar()).normalize();
            created.addTextNode(createdCal.toXMLFormat());
            usernametoken.addChildElement(username);
            usernametoken.addChildElement(password);
            usernametoken.addChildElement(created);
            return usernametoken;
        }
    }
}

