/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.identity.federation;

import org.jboss.logging.BasicLogger;
import org.jboss.logging.Cause;
import org.jboss.logging.LogMessage;
import org.jboss.logging.Logger;
import org.jboss.logging.Message;
import org.jboss.logging.MessageLogger;
import org.picketlink.identity.federation.core.exceptions.ConfigurationException;

@MessageLogger(projectCode="PLFED")
public interface PicketLinkLoggerMessages
extends BasicLogger {
    public static final PicketLinkLoggerMessages ROOT_LOGGER = (PicketLinkLoggerMessages)Logger.getMessageLogger(PicketLinkLoggerMessages.class, (String)PicketLinkLoggerMessages.class.getPackage().getName());
    public static final PicketLinkLoggerMessages AUDIT_LOGGER = (PicketLinkLoggerMessages)Logger.getMessageLogger(PicketLinkLoggerMessages.class, (String)(PicketLinkLoggerMessages.class.getPackage().getName() + ".audit"));

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=200, value="[PicketLink Audit] %s")
    public void auditEvent(String var1);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=201, value="Keystore is null. so setting it up")
    public void keyStoreSetup();

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=202, value="No public key found for alias = %s")
    public void keyStoreNullPublicKeyForAlias(String var1);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=203, value="Assertion has expired with id=%s")
    public void samlAssertionExpired(String var1);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=204, value="%s configuration file loaded")
    public void stsConfigurationFileLoaded(String var1);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=205, value="Service Provider is setting the CanonicalizationMethod on XMLSignatureUtil: %s")
    public void samlSPSettingCanonicalizationMethod(String var1);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=206, value="Identity Provider is setting the CanonicalizationMethod on XMLSignatureUtil: %s")
    public void samlIDPSettingCanonicalizationMethod(String var1);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=207, value="Did not find picketlink-sts.xml. We will install default configuration")
    public void samlIDPInstallingDefaultSTSConfig();

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=208, value="Cannot dispatch to the logout page: no request dispatcher: %s")
    public void samlSPCouldNotDispatchToLogoutPage(String var1);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=209, value="Using logger implementation: %s")
    public void usingLoggerImplementation(String var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=210, value="%s is not an instance of SecurityTokenRegistry - using default registry")
    public void stsTokenRegistryInvalidType(String var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=211, value="Error instantiating token registry class - using default registry")
    public void stsTokenRegistryInstantiationError();

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=212, value="Revocation registry option not specified: cancelled ids will not be persisted!")
    public void stsRevocationRegistryNotSpecified();

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=213, value="%s is not an instance of RevocationRegistry - using default registry")
    public void stsRevocationRegistryInvalidType(String var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=214, value="Error instantiating revocation registry class - using default registry")
    public void stsRevocationRegistryInstantiationError();

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=215, value="%s configuration file not found using TCCL")
    public void stsConfigurationFileNotFoundTCL(String var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=216, value="%s configuration file not found using TCCL")
    public void stsConfigurationFileNotFoundClassLoader(String var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=217, value="%s configuration file not found using URL. Using default configuration values")
    public void stsUsingDefaultConfiguration(String var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=218, value="Secret key could not be encrypted because the endpoint's PKC has not been specified")
    public void stsSecretKeyNotEncrypted();

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=219, value="SAML Assertion has been found to have no expiration: ID = %s")
    public void authSAMLAssertionWithoutExpiration(String var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=220, value="Attribute provider not installed: %s is not an instance of SAML20TokenAttributeProvider")
    public void stsWrongAttributeProviderTypeNotInstalled(String var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=221, value="Error instantiating attribute provider")
    public void stsAttributeProviderInstantiationError(@Cause Throwable var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=222, value="Assertion Element = %s")
    public void samlAssertion(String var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=223, value="Active Session Count = %s")
    public void samlIdentityServerActiveSessionCount(int var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=224, value="Session Created with id = %s ::active session count = %s")
    public void samlIdentityServerSessionCreated(String var1, int var2);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=225, value="Session Destroyed with id = %s ::active session count = %s")
    public void samlIdentityServerSessionDestroyed(String var1, int var2);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=226, value="Was not able to create security token. Just sending message without binary token")
    public void jbossWSUnableToCreateSecurityToken();

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=227, value="Unable to set the Identity Participant Stack Class. Will just use the default")
    public void samlIDPUnableToSetParticipantStackUsingDefault(@Cause Throwable var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=228, value="Security Token digital signature has NOT been verified. Either the STS has been configured not to sign tokens or the STS key pair has not been properly specified.")
    public void stsSecurityTokenSignatureNotVerified();

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=229, value="Security token should be encrypted but no encrypting key could be found")
    public void stsSecurityTokenShouldBeEncrypted();

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=230, value="Security Token registry option not specified: Issued Tokens will not be persisted!")
    public void stsTokenRegistryNotSpecified();

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=231, value="Lifetime has not been specified. Using the default timeout value.")
    public void stsTokenTimeoutNotSpecified();

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=264, value="Security Token with id = %s has already been persisted.")
    public void samlSecurityTokenAlreadyPersisted(String var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=265, value="Security Token with id = %s was not found in the registry.")
    public void samlSecurityTokenNotFoundInRegistry(String var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=232, value="Exception loading the identity providers")
    public void samlMetaDataIdentityProviderLoadingError(@Cause Throwable var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=233, value="Exception loading the service providers")
    public void samlMetaDataServiceProviderLoadingError(@Cause Throwable var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=234, value="Cannot validate signature of assertion")
    public void signatureAssertionValidationError(@Cause Throwable var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=235, value="Exception in getting TrustKeyManager")
    public void trustKeyManagerCreationError(@Cause Throwable var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=236, value="Cannot get schema")
    public void xmlCouldNotGetSchema(@Cause Throwable var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=237, value="Exception initializing role generator")
    public void samlHandlerRoleGeneratorSetupError(@Cause Throwable var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=239, value="Key Pair cannot be found")
    public void samlHandlerKeyPairNotFound();

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=240, value="Error when trying to sign message for redirection")
    public void samlHandlerErrorSigningRedirectBindingMessage(@Cause Throwable var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=241, value="Error validating signature")
    public void samlHandlerErrorValidatingSignature(@Cause Throwable var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=242, value="Error in base64 decoding saml message")
    public void samlBase64DecodingError(@Cause Throwable var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=243, value="Exception in parsing saml message")
    public void samlParsingError(@Cause Throwable var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=244, value="Mapping Context returned is null")
    public void attributeManagerMappingContextNull();

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=245, value="Exception in attribute mapping")
    public void attributeManagerError(@Cause Throwable var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=246, value="Could not obtain security context.")
    public void couldNotObtainSecurityContext();

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=247, value="SAML Assertion parsing failed")
    public void authSAMLAssertionParsingFailed(@Cause Throwable var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=248, value="Unable to issue assertion")
    public void authSAMLAssertionIssuingFailed(@Cause Throwable var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=249, value="Unable to create binary token")
    public void jbossWSUnableToCreateBinaryToken(@Cause Throwable var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=250, value="Exception writing SOAP Message")
    public void jbossWSUnableToWriteSOAPMessage(@Cause Throwable var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=251, value="Exception using backup method to get op name")
    public void jbossWSErrorGettingOperationname(@Cause Throwable var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=252, value="Exception handling saml 11 use case")
    public void samlIDPHandlingSAML11Error(@Cause Throwable var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=253, value="Exception in processing request")
    public void samlIDPRequestProcessingError(@Cause Throwable var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=254, value="Exception dealing with handler configuration")
    public void samlHandlerConfigurationError(@Cause Throwable var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=255, value="Falling back on local Form Authentication if available")
    public void samlSPFallingBackToLocalFormAuthentication();

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=256, value="Unable to obtain the IDP SSO Descriptor from metadata")
    public void samlSPUnableToGetIDPDescriptorFromMetadata();

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=257, value="Verification of InResponseTo failed. InResponseTo from SAML response is %s. Value of request Id from HTTP session is %s")
    public void samlHandlerFailedInResponseToVerification(String var1, String var2);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=258, value="Exception in processing authentication")
    public void samlHandlerAuthenticationError(@Cause Throwable var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=259, value="The provider %s could not be added")
    public void jceProviderCouldNotBeLoaded(String var1, @Cause Throwable var2);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=260, value="Error parsing the response from the IDP. Check the strict post binding configuration on both IDP and SP side.")
    public void samlResponseFromIDPParsingFailed();

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=261, value="Error during the logout process.")
    public void samlLogoutError(@Cause Throwable var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=262, value="Could not forward to error page: %s")
    public void samlErrorPageForwardError(String var1, @Cause Throwable var2);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=263, value="Service Provider could not handle the request.")
    public void samlSPHandleRequestError(@Cause Throwable var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=266, value="Error loading the AuthenticationManager.")
    public void authenticationManagerError(@Cause ConfigurationException var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=267, value="Error loading the AuthorizationManager.")
    public void authorizationManagerError(@Cause ConfigurationException var1);
}

