/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.social.openid;

import java.io.IOException;
import java.lang.reflect.Method;
import java.security.Principal;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.catalina.Session;
import org.apache.catalina.authenticator.FormAuthenticator;
import org.apache.catalina.connector.Request;
import org.apache.catalina.connector.Response;
import org.apache.catalina.deploy.LoginConfig;
import org.apache.log4j.Logger;
import org.picketlink.common.util.StringUtil;
import org.picketlink.social.openid.OpenIDProcessor;
import org.picketlink.social.openid.SecurityActions;

public class OpenIDConsumerAuthenticator
extends FormAuthenticator {
    protected static Logger log = Logger.getLogger(OpenIDConsumerAuthenticator.class);
    protected boolean trace = log.isTraceEnabled();
    public static ThreadLocal<Principal> cachedPrincipal = new ThreadLocal();
    public static ThreadLocal<List<String>> cachedRoles = new ThreadLocal();
    public static String EMPTY_PASSWORD = "EMPTY";
    private String returnURL = null;
    private String requiredAttributes = "name,email,ax_firstName,ax_lastName,ax_fullName,ax_email";
    private String optionalAttributes = null;
    protected List<String> roles = new ArrayList<String>();
    protected boolean saveRestoreRequest = true;
    protected OpenIDProcessor processor = null;
    private Method theSuperRegisterMethod = null;

    public void setReturnURL(String returnURL) {
        this.returnURL = StringUtil.getSystemPropertyAsString((String)returnURL);
    }

    public void setRequiredAttributes(String requiredAttributes) {
        this.requiredAttributes = requiredAttributes;
    }

    public void setOptionalAttributes(String optionalAttributes) {
        this.optionalAttributes = optionalAttributes;
    }

    public void setSaveRestoreRequest(boolean saveRestoreRequest) {
        this.saveRestoreRequest = saveRestoreRequest;
    }

    public void setRoleString(String roleStr) {
        if (roleStr == null) {
            throw new RuntimeException("Role String is null in configuration");
        }
        List tokens = StringUtil.tokenize((String)roleStr);
        for (String token : tokens) {
            this.roles.add(token);
        }
    }

    public boolean authenticate(HttpServletRequest request, HttpServletResponse response, LoginConfig loginConfig) throws IOException {
        if (!(request instanceof Request)) {
            throw new IOException("Not of type Catalina request");
        }
        if (!(response instanceof Response)) {
            throw new IOException("Not of type Catalina response");
        }
        return this.authenticate((Request)request, (Response)response, loginConfig);
    }

    public boolean authenticate(Request request, HttpServletResponse response, LoginConfig config) throws IOException {
        if (response instanceof Response) {
            Response catalinaResponse = (Response)response;
            return this.authenticate(request, catalinaResponse, config);
        }
        throw new RuntimeException("Wrong type of response:" + response);
    }

    public boolean authenticate(Request request, Response response, LoginConfig loginConfig) throws IOException {
        Principal userPrincipal;
        if (this.processor == null) {
            this.processor = new OpenIDProcessor(this.returnURL, this.requiredAttributes, this.optionalAttributes);
        }
        if ((userPrincipal = request.getUserPrincipal()) != null) {
            if (this.trace) {
                log.trace((Object)("Logged in as:" + userPrincipal));
            }
            return true;
        }
        if (!this.processor.isInitialized()) {
            try {
                this.processor.initialize(this.roles);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        HttpSession httpSession = request.getSession();
        String state = (String)httpSession.getAttribute("STATE");
        if (this.trace) {
            log.trace((Object)("state=" + state));
        }
        if (STATES.FINISH.name().equals(state)) {
            return true;
        }
        if (state == null || state.isEmpty()) {
            return this.processor.prepareAndSendAuthRequest(request, response);
        }
        if (state.equals(STATES.AUTH.name())) {
            Principal principal;
            Session session = request.getSessionInternal(true);
            if (this.saveRestoreRequest) {
                this.saveRequest(request, session);
            }
            if ((principal = this.processor.processIncomingAuthResult(request, response, this.context.getRealm())) == null) {
                throw new RuntimeException("Principal was null. Maybe login modules need to be configured properly.");
            }
            String principalName = principal.getName();
            request.getSessionInternal().setNote("org.apache.catalina.session.USERNAME", (Object)principalName);
            request.getSessionInternal().setNote("org.apache.catalina.session.PASSWORD", (Object)"");
            request.setUserPrincipal(principal);
            if (this.saveRestoreRequest) {
                this.restoreRequest(request, request.getSessionInternal());
            }
            if (this.trace) {
                log.trace((Object)("Logged in as:" + principal));
            }
            this.registerWithAuthenticatorBase(request, response, principal, principalName);
            request.getSession().setAttribute("STATE", (Object)STATES.FINISH.name());
            return true;
        }
        return false;
    }

    protected void registerWithAuthenticatorBase(Request request, Response response, Principal principal, String userName) {
        block5: {
            try {
                this.register(request, response, principal, "FORM", userName, "");
            }
            catch (NoSuchMethodError nse) {
                if (this.theSuperRegisterMethod == null) {
                    Class[] args = new Class[]{Request.class, HttpServletResponse.class, Principal.class, String.class, String.class, String.class};
                    Class<?> superClass = ((Object)((Object)this)).getClass().getSuperclass();
                    this.theSuperRegisterMethod = SecurityActions.getMethod(superClass, "register", args);
                }
                if (this.theSuperRegisterMethod == null) break block5;
                Object[] objectArgs = new Object[]{request, response.getResponse(), principal, "FORM", userName, OpenIDProcessor.EMPTY_PASSWORD};
                try {
                    this.theSuperRegisterMethod.invoke((Object)this, objectArgs);
                }
                catch (Exception e) {
                    log.error((Object)"Unable to register:", (Throwable)e);
                }
            }
        }
    }

    private static enum STATES {
        AUTH,
        AUTHZ,
        FINISH;

    }
}

