/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.identity.federation.bindings.tomcat;

import java.io.IOException;
import java.security.AccessController;
import java.security.Principal;
import java.security.PrivilegedAction;
import java.util.Set;
import java.util.UUID;
import javax.security.auth.Subject;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.catalina.Realm;
import org.apache.catalina.Session;
import org.apache.catalina.authenticator.FormAuthenticator;
import org.apache.catalina.connector.Request;
import org.apache.catalina.connector.Response;
import org.apache.catalina.deploy.LoginConfig;
import org.picketlink.identity.federation.PicketLinkLogger;
import org.picketlink.identity.federation.PicketLinkLoggerFactory;
import org.picketlink.identity.federation.bindings.tomcat.SubjectSecurityInteraction;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PicketLinkAuthenticator
extends FormAuthenticator {
    private static final PicketLinkLogger logger = PicketLinkLoggerFactory.getLogger();
    protected String authMethod = "SECURITY_DOMAIN";
    protected boolean needSubjectPrincipalSubstitution = true;
    protected SubjectSecurityInteraction subjectInteraction = null;
    protected String subjectInteractionClassName = "org.picketlink.identity.federation.bindings.jboss.subject.PicketLinkJBossSubjectInteraction";

    public PicketLinkAuthenticator() {
        logger.trace("PicketLinkAuthenticator Created");
    }

    public void setAuthMethod(String authMethod) {
        this.authMethod = authMethod;
    }

    public void setNeedSubjectPrincipalSubstitution(String needSubjectPrincipalSubstitutionVal) {
        this.needSubjectPrincipalSubstitution = Boolean.valueOf(needSubjectPrincipalSubstitutionVal);
    }

    public void setSubjectInteractionClassName(String subjectRetrieverClassName) {
        this.subjectInteractionClassName = subjectRetrieverClassName;
    }

    public boolean authenticate(Request request, Response response, LoginConfig loginConfig) throws IOException {
        String userName;
        logger.trace("Authenticating user");
        Principal principal = request.getUserPrincipal();
        if (principal != null) {
            logger.trace("Already authenticated '" + principal.getName() + "'");
            return true;
        }
        Session session = request.getSessionInternal(true);
        String password = userName = UUID.randomUUID().toString();
        Realm realm = this.context.getRealm();
        Principal originalPrincipal = principal = realm.authenticate(userName, password);
        if (principal != null) {
            if (this.needSubjectPrincipalSubstitution) {
                principal = this.getSubjectPrincipal();
                if (principal == null) {
                    throw new RuntimeException("Principal from subject is null");
                }
                principal = realm.authenticate(principal.getName(), password);
            }
            session.setNote("org.apache.catalina.session.USERNAME", (Object)principal.getName());
            session.setNote("org.apache.catalina.session.PASSWORD", (Object)password);
            request.setUserPrincipal(principal);
            this.register(request, response, principal, this.authMethod, principal.getName(), password);
            if (originalPrincipal != null && this.needSubjectPrincipalSubstitution) {
                this.subjectInteraction.cleanup(originalPrincipal);
            }
            return true;
        }
        return false;
    }

    public boolean authenticate(HttpServletRequest request, HttpServletResponse response, LoginConfig loginConfig) throws IOException {
        return this.authenticate((Request)request, (Response)response, loginConfig);
    }

    protected Principal getSubjectPrincipal() {
        Set<Principal> principals;
        Subject subject;
        if (this.subjectInteraction == null) {
            Class<?> clazz = this.loadClass(((Object)((Object)this)).getClass(), this.subjectInteractionClassName);
            try {
                this.subjectInteraction = (SubjectSecurityInteraction)clazz.newInstance();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        if ((subject = this.subjectInteraction.get()) != null && !(principals = subject.getPrincipals()).isEmpty()) {
            return subject.getPrincipals().iterator().next();
        }
        return null;
    }

    Class<?> loadClass(final Class<?> theClass, final String fqn) {
        return (Class)AccessController.doPrivileged(new PrivilegedAction<Class<?>>(){

            @Override
            public Class<?> run() {
                ClassLoader classLoader = theClass.getClassLoader();
                Class<?> clazz = PicketLinkAuthenticator.this.loadClass(classLoader, fqn);
                if (clazz == null) {
                    classLoader = Thread.currentThread().getContextClassLoader();
                    clazz = PicketLinkAuthenticator.this.loadClass(classLoader, fqn);
                }
                return clazz;
            }
        });
    }

    Class<?> loadClass(final ClassLoader cl, final String fqn) {
        return (Class)AccessController.doPrivileged(new PrivilegedAction<Class<?>>(){

            @Override
            public Class<?> run() {
                try {
                    return cl.loadClass(fqn);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    return null;
                }
            }
        });
    }
}

