/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.identity.federation.bindings.tomcat.sp;

import java.io.IOException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.Cookie;
import org.apache.catalina.Context;
import org.apache.catalina.Session;
import org.apache.catalina.Valve;
import org.apache.catalina.connector.Request;
import org.apache.catalina.connector.Response;
import org.apache.catalina.valves.ValveBase;
import org.picketlink.common.PicketLinkLogger;
import org.picketlink.common.PicketLinkLoggerFactory;
import org.picketlink.common.util.StringUtil;
import org.picketlink.identity.federation.bindings.tomcat.sp.SecurityActions;
import org.picketlink.identity.federation.bindings.tomcat.sp.plugins.PropertiesAccountMapProvider;

public abstract class AbstractAccountChooserValve
extends ValveBase {
    protected static final PicketLinkLogger logger = PicketLinkLoggerFactory.getLogger();
    public static final String ACCOUNT_CHOOSER_COOKIE_NAME = "picketlink.account.name";
    public static final String ACCOUNT_PARAMETER = "idp";
    public static final String AUTHENTICATING = "AUTHENTICATING";
    protected String domainName;
    protected String accountChooserPage = "/accountChooser.html";
    protected ConcurrentHashMap<String, String> idpMap = new ConcurrentHashMap();
    protected AccountIDPMapProvider accountIDPMapProvider = new PropertiesAccountMapProvider();

    public void setDomainName(String domainName) {
        this.domainName = domainName;
    }

    public void setAccountIDPMapProvider(String idpMapProviderName) {
        if (StringUtil.isNotNull((String)idpMapProviderName)) {
            Class<?> clazz = SecurityActions.loadClass(((Object)((Object)this)).getClass(), idpMapProviderName);
            try {
                this.accountIDPMapProvider = (AccountIDPMapProvider)clazz.newInstance();
            }
            catch (InstantiationException e) {
                logger.processingError((Throwable)e);
            }
            catch (IllegalAccessException e) {
                logger.processingError((Throwable)e);
            }
        }
    }

    public void setAccountChooserPage(String pageName) {
        this.accountChooserPage = pageName;
    }

    public void setNext(Valve valve) {
        super.setNext(valve);
        try {
            Context context = (Context)this.getContainer();
            this.accountIDPMapProvider.setServletContext(context.getServletContext());
            this.idpMap.putAll(this.accountIDPMapProvider.getIDPMap());
        }
        catch (IOException e) {
            logger.processingError((Throwable)e);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public void invoke(Request request, Response response) throws IOException, ServletException {
        Session session = request.getSessionInternal();
        if (this.idpMap.isEmpty()) {
            this.idpMap.putAll(this.accountIDPMapProvider.getIDPMap());
        }
        String sessionState = (String)session.getNote("STATE");
        String cookieValue = this.cookieValue(request);
        if (cookieValue != null || AUTHENTICATING.equals(sessionState)) {
            this.proceedToAuthentication(request, response, cookieValue);
            return;
        }
        String idpChosenKey = request.getParameter(ACCOUNT_PARAMETER);
        if (idpChosenKey == null) {
            this.saveRequest(request, request.getSessionInternal());
            Context context = (Context)this.getContainer();
            RequestDispatcher requestDispatcher = context.getServletContext().getRequestDispatcher(this.accountChooserPage);
            if (requestDispatcher == null) return;
            requestDispatcher.forward((ServletRequest)request, (ServletResponse)response);
            return;
        }
        String chosenIDP = this.idpMap.get(idpChosenKey);
        if (chosenIDP != null) {
            request.setAttribute("picketlink.desired.idp", (Object)chosenIDP);
            session.setNote("STATE", (Object)AUTHENTICATING);
            this.proceedToAuthentication(request, response, idpChosenKey);
            return;
        }
        logger.configurationFileMissing(":IDP Mapping");
        throw new ServletException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void proceedToAuthentication(Request request, Response response, String cookieValue) throws IOException, ServletException {
        try {
            this.getNext().invoke(request, response);
        }
        finally {
            Session session = request.getSessionInternal();
            String state = (String)session.getNote("STATE");
            if (request.getUserPrincipal() != null && StringUtil.isNotNull((String)state)) {
                session.removeNote("STATE");
                Context context = (Context)this.getContainer();
                String contextpath = context.getPath();
                if (cookieValue == null) {
                    cookieValue = request.getParameter(ACCOUNT_PARAMETER);
                }
                Cookie cookie = new Cookie(ACCOUNT_CHOOSER_COOKIE_NAME, cookieValue);
                cookie.setPath(contextpath);
                cookie.setMaxAge(-1);
                response.addCookie(cookie);
            }
        }
    }

    protected String cookieValue(Request request) {
        Cookie[] cookies = request.getCookies();
        if (cookies != null) {
            for (Cookie cookie : cookies) {
                String cookieValue;
                String chosenIDP;
                String cookieName = cookie.getName();
                String cookieDomain = cookie.getDomain();
                if (cookieDomain != null && cookieDomain.equalsIgnoreCase(this.domainName)) {
                    if (!ACCOUNT_CHOOSER_COOKIE_NAME.equals(cookieName) || (chosenIDP = this.idpMap.get(cookieValue = cookie.getValue())) == null) continue;
                    request.setAttribute("picketlink.desired.idp", (Object)chosenIDP);
                    return cookieValue;
                }
                if (!ACCOUNT_CHOOSER_COOKIE_NAME.equals(cookieName) || (chosenIDP = this.idpMap.get(cookieValue = cookie.getValue())) == null) continue;
                request.setAttribute("picketlink.desired.idp", (Object)chosenIDP);
                return cookieValue;
            }
        }
        return null;
    }

    protected abstract void saveRequest(Request var1, Session var2) throws IOException;

    protected abstract boolean restoreRequest(Request var1, Session var2) throws IOException;

    public static interface AccountIDPMapProvider {
        public void setServletContext(ServletContext var1);

        public void setClassLoader(ClassLoader var1);

        public Map<String, String> getIDPMap() throws IOException;
    }
}

