/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.identity.federation.bindings.wildfly.rest;

import java.net.URI;
import java.security.Principal;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.xml.datatype.XMLGregorianCalendar;
import org.picketlink.common.constants.JBossSAMLURIConstants;
import org.picketlink.identity.federation.bindings.wildfly.rest.STSEndpoint;
import org.picketlink.identity.federation.core.interfaces.ProtocolContext;
import org.picketlink.identity.federation.core.saml.v2.common.SAMLProtocolContext;
import org.picketlink.identity.federation.core.saml.v2.util.AssertionUtil;
import org.picketlink.identity.federation.core.saml.v2.util.XMLTimeUtil;
import org.picketlink.identity.federation.saml.v2.assertion.AssertionType;
import org.picketlink.identity.federation.saml.v2.assertion.BaseIDAbstractType;
import org.picketlink.identity.federation.saml.v2.assertion.NameIDType;
import org.picketlink.identity.federation.saml.v2.assertion.SubjectConfirmationDataType;
import org.picketlink.identity.federation.saml.v2.assertion.SubjectConfirmationType;
import org.picketlink.identity.federation.saml.v2.assertion.SubjectType;
import org.picketlink.identity.federation.web.util.PostBindingUtil;

@Path(value="/saml")
public class SAMLEndpoint
extends STSEndpoint {
    private String subjectConfirmationMethod = JBossSAMLURIConstants.SUBJECT_CONFIRMATION_BEARER.get();

    @POST
    public Response generateAssertion(@Context HttpServletRequest httpServletRequest, @Context HttpServletResponse httpServletResponse) throws Exception {
        Principal principal = httpServletRequest.getUserPrincipal();
        if (principal == null) {
            return Response.status((int)403).build();
        }
        XMLGregorianCalendar issueInstant = XMLTimeUtil.getIssueInstant();
        SubjectType subjectType = new SubjectType();
        NameIDType nameIDType = new NameIDType();
        nameIDType.setFormat(URI.create(JBossSAMLURIConstants.NAMEID_FORMAT_PERSISTENT.get()));
        nameIDType.setValue(principal.getName());
        SubjectType.STSubType subType = new SubjectType.STSubType();
        subType.addBaseID((BaseIDAbstractType)nameIDType);
        subjectType.setSubType(subType);
        SubjectConfirmationType subjectConfirmation = new SubjectConfirmationType();
        subjectConfirmation.setMethod(this.subjectConfirmationMethod);
        SubjectConfirmationDataType subjectConfirmationData = new SubjectConfirmationDataType();
        subjectConfirmationData.setInResponseTo("REST_REQUEST");
        subjectConfirmationData.setNotOnOrAfter(issueInstant);
        subjectConfirmation.setSubjectConfirmationData(subjectConfirmationData);
        subjectType.addConfirmation(subjectConfirmation);
        SAMLProtocolContext samlProtocolContext = new SAMLProtocolContext();
        samlProtocolContext.setSubjectType(subjectType);
        NameIDType issuerNameIDType = new NameIDType();
        issuerNameIDType.setValue(this.issuer);
        samlProtocolContext.setIssuerID(issuerNameIDType);
        this.checkAndSetUpSTS();
        this.sts.issueToken((ProtocolContext)samlProtocolContext);
        AssertionType assertionType = samlProtocolContext.getIssuedAssertion();
        String base64EncodedAssertion = PostBindingUtil.base64Encode((String)AssertionUtil.asString((AssertionType)assertionType));
        return Response.status((int)200).entity((Object)base64EncodedAssertion).build();
    }
}

