/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.identity.federation.bindings.wildfly.rest;

import javax.annotation.PostConstruct;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.ws.rs.core.Context;
import org.picketlink.identity.federation.bindings.wildfly.providers.OAuth2TokenProvider;
import org.picketlink.identity.federation.core.interfaces.SecurityTokenProvider;
import org.picketlink.identity.federation.core.sts.PicketLinkCoreSTS;

public class STSEndpoint {
    @Context
    protected ServletContext servletContext;
    @Context
    protected ServletConfig servletConfig;
    protected String issuer = null;
    protected PicketLinkCoreSTS sts = null;

    @PostConstruct
    public void initialize() {
        if (this.servletConfig != null) {
            this.issuer = this.servletConfig.getInitParameter("issuer");
            if (this.issuer == null) {
                this.issuer = "PicketLink_SAML_REST";
            }
        }
        this.checkAndSetUpSTS();
    }

    protected void checkAndSetUpSTS() {
        if (this.sts == null) {
            if (this.servletContext != null) {
                this.sts = (PicketLinkCoreSTS)this.servletContext.getAttribute("STS");
            }
            if (this.sts == null) {
                this.sts = PicketLinkCoreSTS.instance();
                this.sts.installDefaultConfiguration(new String[0]);
                try {
                    this.sts.getConfiguration().addTokenProvider("urn:oauth:2:0", (SecurityTokenProvider)OAuth2TokenProvider.class.newInstance());
                }
                catch (InstantiationException e) {
                    e.printStackTrace();
                }
                catch (IllegalAccessException e) {
                    e.printStackTrace();
                }
                if (this.servletContext != null) {
                    this.servletContext.setAttribute("STS", (Object)this.sts);
                }
            }
        }
    }
}

