/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.idm.impl.cache;

import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.infinispan.Cache;
import org.infinispan.lifecycle.ComponentStatus;
import org.infinispan.manager.DefaultCacheManager;
import org.infinispan.tree.Fqn;
import org.infinispan.tree.TreeCache;
import org.infinispan.tree.TreeCacheFactory;
import org.picketlink.idm.common.exception.IdentityException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractInfinispanCacheProvider {
    private Logger log = Logger.getLogger(this.getClass().getName());
    private TreeCache<Object, Object> cache;
    public static final String CONFIG_FILE_OPTION = "cache.configFile";
    public static final String CONFIG_NAME_OPTION = "cache.configName";
    public static final String CONFIG_CACHE_REGISTRY_OPTION = "cache.cacheRegistryName";
    public static final String NULL_NS_NODE = "PL_COMMON_NS";
    public static final String NODE_COMMON_ROOT = "COMMON_ROOT";

    public void initialize(Map<String, String> properties, Object configurationRegistry) {
        Cache infinispanCache;
        String registryName = properties.get(CONFIG_CACHE_REGISTRY_OPTION);
        if (registryName != null) {
            try {
                this.cache = this.getCacheFromRegistry(configurationRegistry, registryName);
                return;
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Cannot find Infinispan 'Cache' object in configuration registry with provided name: " + registryName, e);
            }
        }
        String configFile = properties.get(CONFIG_FILE_OPTION);
        String configName = properties.get(CONFIG_NAME_OPTION);
        if (configFile == null) {
            throw new IllegalArgumentException("Cannot find 'cache.configFile' in passed properties. Failed to initialize cache provider.");
        }
        if (configName == null) {
            throw new IllegalArgumentException("Cannot find 'cache.configName' in passed properties. Failed to initialize cache provider.");
        }
        try {
            DefaultCacheManager manager = new DefaultCacheManager(configFile, true);
            infinispanCache = manager.getCache(configName);
        }
        catch (IOException ioe) {
            throw new IllegalArgumentException("Failed to initialize cache due to IO error", ioe);
        }
        this.cache = new TreeCacheFactory().createTreeCache(infinispanCache);
        this.log.info("Infinispan cache for Picketlink IDM created successfuly. cache name: " + this.cache.getCache().getName());
    }

    public void initialize(InputStream cacheConfigStream, String configName) {
        if (cacheConfigStream == null) {
            throw new IllegalArgumentException("Infinispan configuration InputStream is null");
        }
        try {
            DefaultCacheManager manager = new DefaultCacheManager(cacheConfigStream, true);
            Cache infinispanCache = manager.getCache(configName);
            this.cache = new TreeCacheFactory().createTreeCache(infinispanCache);
        }
        catch (IOException ioe) {
            throw new IllegalArgumentException("Failed to initialize cache due to IO error", ioe);
        }
        this.log.info("Infinispan cache for Picketlink IDM created successfuly. cache name: " + this.cache.getCache().getName());
    }

    public void initialize(Cache infinispanCache) {
        this.cache = new TreeCacheFactory().createTreeCache(infinispanCache);
        ComponentStatus status = infinispanCache.getStatus();
        if (status.startAllowed()) {
            this.cache.start();
        }
        this.log.info("Infinispan cache for Picketlink IDM created successfuly. cache name: " + this.cache.getCache().getName());
    }

    public void invalidate(String ns) {
        boolean success = this.getCache().removeNode(this.getNamespacedFqn(ns));
        if (this.log.isLoggable(Level.FINER)) {
            this.log.finer(this.toString() + "Invalidating namespace:" + ns + "; success=" + success);
        }
    }

    public void invalidateAll() {
        boolean success = this.getCache().removeNode(this.getRootNode());
        if (this.log.isLoggable(Level.FINER)) {
            this.log.finer(this.toString() + "Invalidating whole cache - success=" + success);
        }
    }

    public String getNamespace(String commonId) {
        if (commonId == null) {
            return NODE_COMMON_ROOT;
        }
        return commonId;
    }

    public String getNamespace(String commonId, String sessionId) {
        if (sessionId == null) {
            return this.getNamespace(commonId);
        }
        return commonId + "/" + sessionId;
    }

    protected abstract Fqn getRootNode();

    protected abstract TreeCache<Object, Object> getCacheFromRegistry(Object var1, String var2) throws IdentityException;

    protected Fqn getNamespacedFqn(String ns) {
        String namespace = ns != null ? ns : NULL_NS_NODE;
        namespace = namespace.replaceAll("/", "_");
        return Fqn.fromString((String)(this.getRootNode() + "/" + namespace));
    }

    protected Fqn getFqn(String ns, String node, Object o) {
        return Fqn.fromString((String)(this.getNamespacedFqn(ns) + "/" + node + "/" + o));
    }

    protected Fqn getFqn(String ns, String node) {
        return Fqn.fromString((String)(this.getNamespacedFqn(ns) + "/" + node));
    }

    protected TreeCache getCache() {
        return this.cache;
    }
}

