/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.idm.impl.store;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Random;
import junit.framework.Assert;
import org.picketlink.idm.api.SortOrder;
import org.picketlink.idm.impl.api.BinaryCredential;
import org.picketlink.idm.impl.api.IdentitySearchCriteriaImpl;
import org.picketlink.idm.impl.api.PasswordCredential;
import org.picketlink.idm.impl.api.SimpleAttribute;
import org.picketlink.idm.impl.store.IdentityStoreTestContext;
import org.picketlink.idm.impl.store.IdentityTypeEnum;
import org.picketlink.idm.impl.store.RelationshipTypeEnum;
import org.picketlink.idm.spi.model.IdentityObject;
import org.picketlink.idm.spi.model.IdentityObjectAttribute;
import org.picketlink.idm.spi.model.IdentityObjectCredential;
import org.picketlink.idm.spi.model.IdentityObjectRelationshipType;
import org.picketlink.idm.spi.model.IdentityObjectType;
import org.picketlink.idm.spi.search.IdentityObjectSearchCriteria;
import org.picketlink.idm.spi.store.IdentityObjectSearchCriteriaType;

public class CommonIdentityStoreTest
extends Assert {
    IdentityStoreTestContext testContext;

    public CommonIdentityStoreTest(IdentityStoreTestContext context) {
        this.testContext = context;
    }

    public void setTestContext(IdentityStoreTestContext testContext) {
        this.testContext = testContext;
    }

    public IdentityStoreTestContext getTestContext() {
        return this.testContext;
    }

    public void testStorePersistence() throws Exception {
        this.testContext.begin();
        IdentityObject user1 = this.testContext.getStore().createIdentityObject(this.testContext.getCtx(), "Adam", (IdentityObjectType)IdentityTypeEnum.USER);
        IdentityObject user2 = this.testContext.getStore().createIdentityObject(this.testContext.getCtx(), "Eva", (IdentityObjectType)IdentityTypeEnum.USER);
        IdentityObject group1 = this.testContext.getStore().createIdentityObject(this.testContext.getCtx(), "Devision1", (IdentityObjectType)IdentityTypeEnum.ORGANIZATION);
        IdentityObject group2 = this.testContext.getStore().createIdentityObject(this.testContext.getCtx(), "Devision2", (IdentityObjectType)IdentityTypeEnum.ORGANIZATION);
        IdentityObject group3 = this.testContext.getStore().createIdentityObject(this.testContext.getCtx(), "Devision3", (IdentityObjectType)IdentityTypeEnum.ORGANIZATION);
        IdentityObject group4 = this.testContext.getStore().createIdentityObject(this.testContext.getCtx(), "Devision4", (IdentityObjectType)IdentityTypeEnum.ORGANIZATION);
        this.testContext.flush();
        CommonIdentityStoreTest.assertEquals((int)0, (int)this.testContext.getStore().getIdentityObjectsCount(this.testContext.getCtx(), (IdentityObjectType)IdentityTypeEnum.ROLE));
        CommonIdentityStoreTest.assertEquals((int)2, (int)this.testContext.getStore().getIdentityObjectsCount(this.testContext.getCtx(), (IdentityObjectType)IdentityTypeEnum.USER));
        CommonIdentityStoreTest.assertEquals((int)4, (int)this.testContext.getStore().getIdentityObjectsCount(this.testContext.getCtx(), (IdentityObjectType)IdentityTypeEnum.ORGANIZATION));
        this.testContext.flush();
        this.testContext.getStore().removeIdentityObject(this.testContext.getCtx(), user1);
        this.testContext.getStore().removeIdentityObject(this.testContext.getCtx(), group1);
        this.testContext.getStore().removeIdentityObject(this.testContext.getCtx(), group2);
        CommonIdentityStoreTest.assertEquals((int)1, (int)this.testContext.getStore().getIdentityObjectsCount(this.testContext.getCtx(), (IdentityObjectType)IdentityTypeEnum.USER));
        CommonIdentityStoreTest.assertEquals((int)2, (int)this.testContext.getStore().getIdentityObjectsCount(this.testContext.getCtx(), (IdentityObjectType)IdentityTypeEnum.ORGANIZATION));
        this.testContext.getStore().removeIdentityObject(this.testContext.getCtx(), user2);
        this.testContext.getStore().removeIdentityObject(this.testContext.getCtx(), group3);
        this.testContext.getStore().removeIdentityObject(this.testContext.getCtx(), group4);
        CommonIdentityStoreTest.assertEquals((int)0, (int)this.testContext.getStore().getIdentityObjectsCount(this.testContext.getCtx(), (IdentityObjectType)IdentityTypeEnum.USER));
        CommonIdentityStoreTest.assertEquals((int)0, (int)this.testContext.getStore().getIdentityObjectsCount(this.testContext.getCtx(), (IdentityObjectType)IdentityTypeEnum.ORGANIZATION));
        user1 = this.testContext.getStore().createIdentityObject(this.testContext.getCtx(), "Adam/Ewa/Toto", (IdentityObjectType)IdentityTypeEnum.USER);
        CommonIdentityStoreTest.assertNotNull((Object)this.testContext.getStore().findIdentityObject(this.testContext.getCtx(), "Adam/Ewa/Toto", (IdentityObjectType)IdentityTypeEnum.USER));
        user1 = this.testContext.getStore().createIdentityObject(this.testContext.getCtx(), "Adam//Ewa////Toto*%.$", (IdentityObjectType)IdentityTypeEnum.USER);
        CommonIdentityStoreTest.assertNotNull((Object)this.testContext.getStore().findIdentityObject(this.testContext.getCtx(), "Adam//Ewa////Toto*%.$", (IdentityObjectType)IdentityTypeEnum.USER));
        this.testContext.commit();
    }

    public void testFindMethods() throws Exception {
        this.testContext.begin();
        IdentityObject user1 = this.testContext.getStore().createIdentityObject(this.testContext.getCtx(), "Adam", (IdentityObjectType)IdentityTypeEnum.USER);
        IdentityObject user2 = this.testContext.getStore().createIdentityObject(this.testContext.getCtx(), "Eva", (IdentityObjectType)IdentityTypeEnum.USER);
        IdentityObject group1 = this.testContext.getStore().createIdentityObject(this.testContext.getCtx(), "Devision1", (IdentityObjectType)IdentityTypeEnum.ORGANIZATION);
        IdentityObject group2 = this.testContext.getStore().createIdentityObject(this.testContext.getCtx(), "Devision2", (IdentityObjectType)IdentityTypeEnum.ORGANIZATION);
        IdentityObject group3 = this.testContext.getStore().createIdentityObject(this.testContext.getCtx(), "Devision3", (IdentityObjectType)IdentityTypeEnum.ORGANIZATION);
        IdentityObject group4 = this.testContext.getStore().createIdentityObject(this.testContext.getCtx(), "Devision4", (IdentityObjectType)IdentityTypeEnum.ORGANIZATION);
        this.testContext.flush();
        IdentityObject xx = this.testContext.getStore().findIdentityObject(this.testContext.getCtx(), "Adam", (IdentityObjectType)IdentityTypeEnum.USER);
        CommonIdentityStoreTest.assertEquals((String)xx.getId().toLowerCase(), (String)user1.getId().toLowerCase());
        xx = this.testContext.getStore().findIdentityObject(this.testContext.getCtx(), user2.getId());
        CommonIdentityStoreTest.assertEquals((String)xx.getId().toLowerCase(), (String)user2.getId().toLowerCase());
        Collection results = this.testContext.getStore().findIdentityObject(this.testContext.getCtx(), (IdentityObjectType)IdentityTypeEnum.USER, null);
        CommonIdentityStoreTest.assertEquals((int)2, (int)results.size());
        results = this.testContext.getStore().findIdentityObject(this.testContext.getCtx(), (IdentityObjectType)IdentityTypeEnum.ORGANIZATION, null);
        CommonIdentityStoreTest.assertEquals((int)4, (int)results.size());
        results = this.testContext.getStore().findIdentityObject(this.testContext.getCtx(), (IdentityObjectType)IdentityTypeEnum.ROLE, null);
        CommonIdentityStoreTest.assertEquals((int)0, (int)results.size());
        this.testContext.commit();
    }

    public void testAttributes() throws Exception {
        this.testContext.begin();
        IdentityObject user1 = this.testContext.getStore().createIdentityObject(this.testContext.getCtx(), "Adam", (IdentityObjectType)IdentityTypeEnum.USER);
        IdentityObject user2 = this.testContext.getStore().createIdentityObject(this.testContext.getCtx(), "Eva", (IdentityObjectType)IdentityTypeEnum.USER);
        this.testContext.flush();
        IdentityObjectAttribute[] attrs = new IdentityObjectAttribute[]{new SimpleAttribute("key1", (Object[])new String[]{"val1", "val2", "val3"}), new SimpleAttribute("key2", (Object[])new String[]{"val1", "val2", "val3", "val4"})};
        this.testContext.getStore().addAttributes(this.testContext.getCtx(), user1, attrs);
        this.testContext.flush();
        Map persistedAttrs = this.testContext.getStore().getAttributes(this.testContext.getCtx(), user1);
        CommonIdentityStoreTest.assertEquals((int)2, (int)persistedAttrs.keySet().size());
        CommonIdentityStoreTest.assertTrue((boolean)persistedAttrs.containsKey("key1"));
        CommonIdentityStoreTest.assertEquals((int)3, (int)((IdentityObjectAttribute)persistedAttrs.get("key1")).getSize());
        CommonIdentityStoreTest.assertTrue((boolean)persistedAttrs.containsKey("key2"));
        CommonIdentityStoreTest.assertEquals((int)4, (int)((IdentityObjectAttribute)persistedAttrs.get("key2")).getSize());
        this.testContext.flush();
        attrs = new IdentityObjectAttribute[]{new SimpleAttribute("key3", (Object[])new String[]{"val1"})};
        this.testContext.getStore().addAttributes(this.testContext.getCtx(), user1, attrs);
        this.testContext.flush();
        persistedAttrs = this.testContext.getStore().getAttributes(this.testContext.getCtx(), user1);
        CommonIdentityStoreTest.assertEquals((int)3, (int)persistedAttrs.keySet().size());
        CommonIdentityStoreTest.assertTrue((boolean)persistedAttrs.containsKey("key1"));
        CommonIdentityStoreTest.assertEquals((int)3, (int)((IdentityObjectAttribute)persistedAttrs.get("key1")).getSize());
        CommonIdentityStoreTest.assertTrue((boolean)persistedAttrs.containsKey("key2"));
        CommonIdentityStoreTest.assertEquals((int)4, (int)((IdentityObjectAttribute)persistedAttrs.get("key2")).getSize());
        CommonIdentityStoreTest.assertTrue((boolean)persistedAttrs.containsKey("key3"));
        CommonIdentityStoreTest.assertEquals((int)1, (int)((IdentityObjectAttribute)persistedAttrs.get("key3")).getSize());
        this.testContext.flush();
        attrs = new IdentityObjectAttribute[]{new SimpleAttribute("key3", (Object[])new String[]{"val2"})};
        this.testContext.getStore().addAttributes(this.testContext.getCtx(), user1, attrs);
        this.testContext.flush();
        persistedAttrs = this.testContext.getStore().getAttributes(this.testContext.getCtx(), user1);
        CommonIdentityStoreTest.assertEquals((int)3, (int)persistedAttrs.keySet().size());
        CommonIdentityStoreTest.assertTrue((boolean)persistedAttrs.containsKey("key3"));
        CommonIdentityStoreTest.assertEquals((int)2, (int)((IdentityObjectAttribute)persistedAttrs.get("key3")).getSize());
        this.testContext.flush();
        this.testContext.getStore().updateAttributes(this.testContext.getCtx(), user1, attrs);
        this.testContext.flush();
        persistedAttrs = this.testContext.getStore().getAttributes(this.testContext.getCtx(), user1);
        CommonIdentityStoreTest.assertEquals((int)3, (int)persistedAttrs.keySet().size());
        CommonIdentityStoreTest.assertTrue((boolean)persistedAttrs.containsKey("key3"));
        CommonIdentityStoreTest.assertEquals((int)1, (int)((IdentityObjectAttribute)persistedAttrs.get("key3")).getSize());
        this.testContext.flush();
        this.testContext.getStore().removeAttributes(this.testContext.getCtx(), user1, new String[]{"key3"});
        this.testContext.flush();
        persistedAttrs = this.testContext.getStore().getAttributes(this.testContext.getCtx(), user1);
        CommonIdentityStoreTest.assertEquals((int)2, (int)persistedAttrs.keySet().size());
        this.testContext.commit();
    }

    public void testRelationships() throws Exception {
        this.testContext.begin();
        IdentityObject user1 = this.testContext.getStore().createIdentityObject(this.testContext.getCtx(), "Adam", (IdentityObjectType)IdentityTypeEnum.USER);
        IdentityObject user2 = this.testContext.getStore().createIdentityObject(this.testContext.getCtx(), "Eva", (IdentityObjectType)IdentityTypeEnum.USER);
        IdentityObject group1 = this.testContext.getStore().createIdentityObject(this.testContext.getCtx(), "Devision1", (IdentityObjectType)IdentityTypeEnum.ORGANIZATION);
        IdentityObject group2 = this.testContext.getStore().createIdentityObject(this.testContext.getCtx(), "Devision2", (IdentityObjectType)IdentityTypeEnum.ORGANIZATION);
        IdentityObject group3 = this.testContext.getStore().createIdentityObject(this.testContext.getCtx(), "Devision3", (IdentityObjectType)IdentityTypeEnum.ORGANIZATION);
        IdentityObject group4 = this.testContext.getStore().createIdentityObject(this.testContext.getCtx(), "Devision4", (IdentityObjectType)IdentityTypeEnum.ORGANIZATION);
        this.testContext.flush();
        this.testContext.getStore().createRelationship(this.testContext.getCtx(), group1, user1, (IdentityObjectRelationshipType)RelationshipTypeEnum.JBOSS_IDENTITY_MEMBERSHIP, null, false);
        this.testContext.getStore().createRelationship(this.testContext.getCtx(), group2, user1, (IdentityObjectRelationshipType)RelationshipTypeEnum.JBOSS_IDENTITY_MEMBERSHIP, null, false);
        this.testContext.flush();
        CommonIdentityStoreTest.assertEquals((int)1, (int)this.testContext.getStore().resolveRelationships(this.testContext.getCtx(), group1, user1, null).size());
        CommonIdentityStoreTest.assertEquals((int)0, (int)this.testContext.getStore().resolveRelationships(this.testContext.getCtx(), user1, group1, null).size());
        CommonIdentityStoreTest.assertEquals((int)1, (int)this.testContext.getStore().resolveRelationships(this.testContext.getCtx(), group2, user1, null).size());
        CommonIdentityStoreTest.assertEquals((int)0, (int)this.testContext.getStore().resolveRelationships(this.testContext.getCtx(), user1, group2, null).size());
        this.testContext.getStore().removeRelationship(this.testContext.getCtx(), group2, user1, (IdentityObjectRelationshipType)RelationshipTypeEnum.JBOSS_IDENTITY_MEMBERSHIP, null);
        this.testContext.flush();
        CommonIdentityStoreTest.assertEquals((int)1, (int)this.testContext.getStore().resolveRelationships(this.testContext.getCtx(), group1, user1, null).size());
        CommonIdentityStoreTest.assertEquals((int)0, (int)this.testContext.getStore().resolveRelationships(this.testContext.getCtx(), user1, group1, null).size());
        CommonIdentityStoreTest.assertEquals((int)0, (int)this.testContext.getStore().resolveRelationships(this.testContext.getCtx(), group2, user1, null).size());
        CommonIdentityStoreTest.assertEquals((int)0, (int)this.testContext.getStore().resolveRelationships(this.testContext.getCtx(), user1, group2, null).size());
        this.testContext.getStore().removeRelationships(this.testContext.getCtx(), user1, group1, false);
        CommonIdentityStoreTest.assertEquals((int)0, (int)this.testContext.getStore().resolveRelationships(this.testContext.getCtx(), group1, user1, null).size());
        CommonIdentityStoreTest.assertEquals((int)0, (int)this.testContext.getStore().resolveRelationships(this.testContext.getCtx(), user1, group1, null).size());
        CommonIdentityStoreTest.assertEquals((int)0, (int)this.testContext.getStore().resolveRelationships(this.testContext.getCtx(), group2, user1, null).size());
        CommonIdentityStoreTest.assertEquals((int)0, (int)this.testContext.getStore().resolveRelationships(this.testContext.getCtx(), user1, group2, null).size());
        this.testContext.flush();
        this.testContext.getStore().createRelationship(this.testContext.getCtx(), group1, user1, (IdentityObjectRelationshipType)RelationshipTypeEnum.JBOSS_IDENTITY_MEMBERSHIP, null, false);
        this.testContext.getStore().createRelationship(this.testContext.getCtx(), group1, user2, (IdentityObjectRelationshipType)RelationshipTypeEnum.JBOSS_IDENTITY_MEMBERSHIP, null, false);
        this.testContext.flush();
        CommonIdentityStoreTest.assertEquals((int)2, (int)this.testContext.getStore().findIdentityObject(this.testContext.getCtx(), group1, (IdentityObjectRelationshipType)RelationshipTypeEnum.JBOSS_IDENTITY_MEMBERSHIP, true, null).size());
        CommonIdentityStoreTest.assertEquals((int)0, (int)this.testContext.getStore().findIdentityObject(this.testContext.getCtx(), group1, (IdentityObjectRelationshipType)RelationshipTypeEnum.JBOSS_IDENTITY_MEMBERSHIP, false, null).size());
        CommonIdentityStoreTest.assertEquals((int)1, (int)this.testContext.getStore().findIdentityObject(this.testContext.getCtx(), user1, (IdentityObjectRelationshipType)RelationshipTypeEnum.JBOSS_IDENTITY_MEMBERSHIP, false, null).size());
        CommonIdentityStoreTest.assertEquals((int)1, (int)this.testContext.getStore().findIdentityObject(this.testContext.getCtx(), user2, (IdentityObjectRelationshipType)RelationshipTypeEnum.JBOSS_IDENTITY_MEMBERSHIP, false, null).size());
        CommonIdentityStoreTest.assertEquals((int)0, (int)this.testContext.getStore().findIdentityObject(this.testContext.getCtx(), group2, (IdentityObjectRelationshipType)RelationshipTypeEnum.JBOSS_IDENTITY_MEMBERSHIP, false, null).size());
        CommonIdentityStoreTest.assertEquals((int)0, (int)this.testContext.getStore().findIdentityObject(this.testContext.getCtx(), group2, (IdentityObjectRelationshipType)RelationshipTypeEnum.JBOSS_IDENTITY_MEMBERSHIP, true, null).size());
        this.testContext.commit();
    }

    public void testPasswordCredential() throws Exception {
        this.testContext.begin();
        IdentityObject user1 = this.testContext.getStore().createIdentityObject(this.testContext.getCtx(), "Adam", (IdentityObjectType)IdentityTypeEnum.USER);
        IdentityObject user2 = this.testContext.getStore().createIdentityObject(this.testContext.getCtx(), "Eva", (IdentityObjectType)IdentityTypeEnum.USER);
        PasswordCredential passwordCredential1 = new PasswordCredential("Password2000");
        PasswordCredential passwordCredential2 = new PasswordCredential("Password2001");
        CommonIdentityStoreTest.assertTrue((boolean)this.testContext.getStore().getSupportedFeatures().isCredentialSupported((IdentityObjectType)IdentityTypeEnum.USER, passwordCredential1.getType()));
        this.testContext.getStore().updateCredential(this.testContext.getCtx(), user1, (IdentityObjectCredential)passwordCredential1);
        this.testContext.getStore().updateCredential(this.testContext.getCtx(), user2, (IdentityObjectCredential)passwordCredential2);
        CommonIdentityStoreTest.assertTrue((boolean)this.testContext.getStore().validateCredential(this.testContext.getCtx(), user1, (IdentityObjectCredential)passwordCredential1));
        CommonIdentityStoreTest.assertTrue((boolean)this.testContext.getStore().validateCredential(this.testContext.getCtx(), user2, (IdentityObjectCredential)passwordCredential2));
        CommonIdentityStoreTest.assertFalse((boolean)this.testContext.getStore().validateCredential(this.testContext.getCtx(), user1, (IdentityObjectCredential)passwordCredential2));
        CommonIdentityStoreTest.assertFalse((boolean)this.testContext.getStore().validateCredential(this.testContext.getCtx(), user2, (IdentityObjectCredential)passwordCredential1));
        this.testContext.commit();
    }

    public void testBinaryCredential() throws Exception {
        this.testContext.begin();
        IdentityObject user1 = this.testContext.getStore().createIdentityObject(this.testContext.getCtx(), "Adam2", (IdentityObjectType)IdentityTypeEnum.USER);
        IdentityObject user2 = this.testContext.getStore().createIdentityObject(this.testContext.getCtx(), "Eva2", (IdentityObjectType)IdentityTypeEnum.USER);
        Random random = new Random();
        byte[] data1 = new byte[512000];
        random.nextBytes(data1);
        byte[] data2 = new byte[921600];
        random.nextBytes(data2);
        BinaryCredential binaryCredential1 = new BinaryCredential(data1);
        BinaryCredential binaryCredential2 = new BinaryCredential(data2);
        CommonIdentityStoreTest.assertTrue((boolean)this.testContext.getStore().getSupportedFeatures().isCredentialSupported((IdentityObjectType)IdentityTypeEnum.USER, binaryCredential1.getType()));
        this.testContext.getStore().updateCredential(this.testContext.getCtx(), user1, (IdentityObjectCredential)binaryCredential1);
        this.testContext.getStore().updateCredential(this.testContext.getCtx(), user2, (IdentityObjectCredential)binaryCredential2);
        CommonIdentityStoreTest.assertTrue((boolean)this.testContext.getStore().validateCredential(this.testContext.getCtx(), user1, (IdentityObjectCredential)binaryCredential1));
        CommonIdentityStoreTest.assertTrue((boolean)this.testContext.getStore().validateCredential(this.testContext.getCtx(), user2, (IdentityObjectCredential)binaryCredential2));
        CommonIdentityStoreTest.assertFalse((boolean)this.testContext.getStore().validateCredential(this.testContext.getCtx(), user1, (IdentityObjectCredential)binaryCredential2));
        CommonIdentityStoreTest.assertFalse((boolean)this.testContext.getStore().validateCredential(this.testContext.getCtx(), user2, (IdentityObjectCredential)binaryCredential1));
        this.testContext.commit();
    }

    public void testCriteria() throws Exception {
        this.testContext.begin();
        IdentityObject group1 = this.testContext.getStore().createIdentityObject(this.testContext.getCtx(), "Division1", (IdentityObjectType)IdentityTypeEnum.USER);
        IdentityObject group2 = this.testContext.getStore().createIdentityObject(this.testContext.getCtx(), "Division2", (IdentityObjectType)IdentityTypeEnum.USER);
        IdentityObject group3 = this.testContext.getStore().createIdentityObject(this.testContext.getCtx(), "Division3", (IdentityObjectType)IdentityTypeEnum.USER);
        IdentityObject group4 = this.testContext.getStore().createIdentityObject(this.testContext.getCtx(), "Company1", (IdentityObjectType)IdentityTypeEnum.USER);
        IdentityObject group5 = this.testContext.getStore().createIdentityObject(this.testContext.getCtx(), "Company2", (IdentityObjectType)IdentityTypeEnum.USER);
        IdentityObject group6 = this.testContext.getStore().createIdentityObject(this.testContext.getCtx(), "Entity1", (IdentityObjectType)IdentityTypeEnum.USER);
        IdentityObject group7 = this.testContext.getStore().createIdentityObject(this.testContext.getCtx(), "Entity2", (IdentityObjectType)IdentityTypeEnum.USER);
        IdentityObject group8 = this.testContext.getStore().createIdentityObject(this.testContext.getCtx(), "Entity3", (IdentityObjectType)IdentityTypeEnum.USER);
        Collection results = null;
        IdentityObjectSearchCriteria criteria = null;
        if (this.testContext.getStore().getSupportedFeatures().isSearchCriteriaTypeSupported((IdentityObjectType)IdentityTypeEnum.USER, IdentityObjectSearchCriteriaType.NAME_FILTER)) {
            criteria = (IdentityObjectSearchCriteria)new IdentitySearchCriteriaImpl().nameFilter("*");
            results = this.testContext.getStore().findIdentityObject(this.testContext.getCtx(), (IdentityObjectType)IdentityTypeEnum.USER, criteria);
            CommonIdentityStoreTest.assertEquals((int)8, (int)results.size());
            criteria = (IdentityObjectSearchCriteria)new IdentitySearchCriteriaImpl().nameFilter("D*");
            results = this.testContext.getStore().findIdentityObject(this.testContext.getCtx(), (IdentityObjectType)IdentityTypeEnum.USER, criteria);
            CommonIdentityStoreTest.assertEquals((int)3, (int)results.size());
            criteria = (IdentityObjectSearchCriteria)new IdentitySearchCriteriaImpl().nameFilter("*2");
            results = this.testContext.getStore().findIdentityObject(this.testContext.getCtx(), (IdentityObjectType)IdentityTypeEnum.USER, criteria);
            CommonIdentityStoreTest.assertEquals((int)3, (int)results.size());
            criteria = (IdentityObjectSearchCriteria)new IdentitySearchCriteriaImpl().nameFilter("*3");
            results = this.testContext.getStore().findIdentityObject(this.testContext.getCtx(), (IdentityObjectType)IdentityTypeEnum.USER, criteria);
            CommonIdentityStoreTest.assertEquals((int)2, (int)results.size());
            criteria = (IdentityObjectSearchCriteria)new IdentitySearchCriteriaImpl().nameFilter("Company1");
            results = this.testContext.getStore().findIdentityObject(this.testContext.getCtx(), (IdentityObjectType)IdentityTypeEnum.USER, criteria);
            CommonIdentityStoreTest.assertEquals((int)1, (int)results.size());
            criteria = (IdentityObjectSearchCriteria)new IdentitySearchCriteriaImpl().nameFilter("Toronto");
            results = this.testContext.getStore().findIdentityObject(this.testContext.getCtx(), (IdentityObjectType)IdentityTypeEnum.USER, criteria);
            CommonIdentityStoreTest.assertEquals((int)0, (int)results.size());
        }
        if (this.testContext.getStore().getSupportedFeatures().isSearchCriteriaTypeSupported((IdentityObjectType)IdentityTypeEnum.USER, IdentityObjectSearchCriteriaType.PAGE)) {
            criteria = (IdentityObjectSearchCriteria)new IdentitySearchCriteriaImpl().page(0, 3);
            results = this.testContext.getStore().findIdentityObject(this.testContext.getCtx(), (IdentityObjectType)IdentityTypeEnum.USER, criteria);
            CommonIdentityStoreTest.assertEquals((int)3, (int)results.size());
            criteria = (IdentityObjectSearchCriteria)new IdentitySearchCriteriaImpl().page(2, 2);
            results = this.testContext.getStore().findIdentityObject(this.testContext.getCtx(), (IdentityObjectType)IdentityTypeEnum.USER, criteria);
            CommonIdentityStoreTest.assertEquals((int)2, (int)results.size());
        }
        if (this.testContext.getStore().getSupportedFeatures().isSearchCriteriaTypeSupported((IdentityObjectType)IdentityTypeEnum.USER, IdentityObjectSearchCriteriaType.SORT)) {
            criteria = (IdentityObjectSearchCriteria)new IdentitySearchCriteriaImpl().sort(SortOrder.ASCENDING);
            results = this.testContext.getStore().findIdentityObject(this.testContext.getCtx(), (IdentityObjectType)IdentityTypeEnum.USER, criteria);
            CommonIdentityStoreTest.assertEquals((int)8, (int)results.size());
            CommonIdentityStoreTest.assertEquals((String)"Company1", (String)((IdentityObject)((List)results).get(0)).getName());
            CommonIdentityStoreTest.assertEquals((String)"Entity3", (String)((IdentityObject)((List)results).get(7)).getName());
            criteria = (IdentityObjectSearchCriteria)new IdentitySearchCriteriaImpl().sort(SortOrder.DESCENDING);
            results = this.testContext.getStore().findIdentityObject(this.testContext.getCtx(), (IdentityObjectType)IdentityTypeEnum.USER, criteria);
            CommonIdentityStoreTest.assertEquals((int)8, (int)results.size());
            CommonIdentityStoreTest.assertEquals((String)"Company1", (String)((IdentityObject)((List)results).get(7)).getName());
            CommonIdentityStoreTest.assertEquals((String)"Entity3", (String)((IdentityObject)((List)results).get(0)).getName());
            if (this.testContext.getStore().getSupportedFeatures().isSearchCriteriaTypeSupported((IdentityObjectType)IdentityTypeEnum.USER, IdentityObjectSearchCriteriaType.PAGE)) {
                criteria = (IdentityObjectSearchCriteria)new IdentitySearchCriteriaImpl().sort(SortOrder.ASCENDING).page(0, 3);
                results = this.testContext.getStore().findIdentityObject(this.testContext.getCtx(), (IdentityObjectType)IdentityTypeEnum.USER, criteria);
                CommonIdentityStoreTest.assertEquals((int)3, (int)results.size());
                CommonIdentityStoreTest.assertEquals((String)"Company1", (String)((IdentityObject)((List)results).get(0)).getName());
                CommonIdentityStoreTest.assertEquals((String)"Division1", (String)((IdentityObject)((List)results).get(2)).getName());
                criteria = (IdentityObjectSearchCriteria)new IdentitySearchCriteriaImpl().sort(SortOrder.ASCENDING).page(3, 1);
                results = this.testContext.getStore().findIdentityObject(this.testContext.getCtx(), (IdentityObjectType)IdentityTypeEnum.USER, criteria);
                CommonIdentityStoreTest.assertEquals((int)1, (int)results.size());
                CommonIdentityStoreTest.assertEquals((int)1, (int)results.size());
                CommonIdentityStoreTest.assertEquals((String)"Division2", (String)((IdentityObject)((List)results).get(0)).getName());
            }
        }
        if (this.testContext.getStore().getSupportedFeatures().isSearchCriteriaTypeSupported((IdentityObjectType)IdentityTypeEnum.USER, IdentityObjectSearchCriteriaType.ATTRIBUTE_FILTER)) {
            SimpleAttribute phone = new SimpleAttribute("phone", (Object[])new String[]{"777 777 777"});
            SimpleAttribute description = new SimpleAttribute("description", (Object[])new String[]{"sample desc"});
            this.testContext.getStore().addAttributes(this.testContext.getCtx(), group1, new IdentityObjectAttribute[]{phone, description});
            criteria = (IdentityObjectSearchCriteria)new IdentitySearchCriteriaImpl().attributeValuesFilter("phone", new String[]{"777 777 777"}).attributeValuesFilter("description", new String[]{"sample desc"});
            results = this.testContext.getStore().findIdentityObject(this.testContext.getCtx(), (IdentityObjectType)IdentityTypeEnum.USER, criteria);
            CommonIdentityStoreTest.assertEquals((int)1, (int)results.size());
        }
        this.testContext.commit();
    }
}

