/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.idm.impl.store.ldap;

import java.util.Hashtable;
import javax.naming.NamingException;
import javax.naming.ldap.InitialLdapContext;
import org.picketlink.idm.impl.configuration.IdentityConfigurationImpl;
import org.picketlink.idm.impl.configuration.IdentityStoreConfigurationContextImpl;
import org.picketlink.idm.impl.configuration.jaxb2.JAXB2IdentityConfiguration;
import org.picketlink.idm.impl.store.CommonIdentityStoreTest;
import org.picketlink.idm.impl.store.IdentityStoreTestContext;
import org.picketlink.idm.impl.store.ldap.LDAPIdentityStoreImpl;
import org.picketlink.idm.spi.configuration.IdentityConfigurationContextRegistry;
import org.picketlink.idm.spi.configuration.IdentityStoreConfigurationContext;
import org.picketlink.idm.spi.configuration.metadata.IdentityConfigurationMetaData;
import org.picketlink.idm.spi.configuration.metadata.IdentityStoreConfigurationMetaData;
import org.picketlink.idm.spi.store.IdentityStore;
import org.picketlink.idm.spi.store.IdentityStoreInvocationContext;
import org.picketlink.idm.spi.store.IdentityStoreSession;
import org.picketlink.idm.test.support.ldap.LDAPTestPOJO;

public class LDAPIdentityStoreTestCase
extends LDAPTestPOJO
implements IdentityStoreTestContext {
    CommonIdentityStoreTest commonTest;
    IdentityStoreInvocationContext ctx;
    IdentityStore store;

    public void setUp() throws Exception {
        super.start();
        this.commonTest = new CommonIdentityStoreTest((IdentityStoreTestContext)this);
        IdentityConfigurationMetaData configurationMD = JAXB2IdentityConfiguration.createConfigurationMetaData((String)this.getIdentityConfig());
        IdentityConfigurationContextRegistry registry = (IdentityConfigurationContextRegistry)new IdentityConfigurationImpl().configure(configurationMD);
        IdentityStoreConfigurationMetaData storeMD = null;
        for (IdentityStoreConfigurationMetaData metaData : configurationMD.getIdentityStores()) {
            if (!metaData.getId().equals("LDAP Identity Store")) continue;
            storeMD = metaData;
            break;
        }
        IdentityStoreConfigurationContextImpl context = new IdentityStoreConfigurationContextImpl(configurationMD, registry, storeMD);
        this.store = new LDAPIdentityStoreImpl("LDAP Identity Store");
        this.store.bootstrap((IdentityStoreConfigurationContext)context);
        final IdentityStoreSession storeSession = this.store.createIdentityStoreSession();
        this.ctx = new IdentityStoreInvocationContext(){

            public IdentityStoreSession getIdentityStoreSession() {
                return storeSession;
            }

            public String getRealmId() {
                return "testRealm";
            }

            public String getSessionId() {
                return "";
            }
        };
    }

    public void tearDown() throws Exception {
        super.stop();
    }

    public void flush() throws Exception {
    }

    public IdentityStore getStore() {
        return this.store;
    }

    public IdentityStoreInvocationContext getCtx() {
        return this.ctx;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSimple() throws Exception {
        this.populateClean();
        Hashtable<String, String> env = new Hashtable<String, String>();
        env.put("java.naming.factory.initial", this.directoryConfig.getContextFactory());
        env.put("java.naming.provider.url", this.directoryConfig.getDescription());
        env.put("java.naming.security.authentication", "simple");
        env.put("java.naming.security.principal", this.directoryConfig.getAdminDN());
        env.put("java.naming.security.credentials", this.directoryConfig.getAdminPassword());
        InitialLdapContext ldapCtx = null;
        try {
            ldapCtx = new InitialLdapContext(env, null);
            System.out.println("Attributes: " + ldapCtx.getAttributes(this.directoryConfig.getCleanUpDN()));
        }
        catch (NamingException e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (ldapCtx != null) {
                    ldapCtx.close();
                }
            }
            catch (NamingException e) {
                e.printStackTrace();
            }
        }
    }

    public void testRelationships() throws Exception {
        this.populateClean();
        this.commonTest.testRelationships();
    }

    public void testStorePersistence() throws Exception {
        this.populateClean();
        this.commonTest.testStorePersistence();
    }

    public void testFindMethods() throws Exception {
        this.populateClean();
        this.commonTest.testFindMethods();
    }

    public void testCriteria() throws Exception {
        this.populateClean();
        this.commonTest.testCriteria();
    }

    public void testCredentials() throws Exception {
        this.populateClean();
        this.commonTest.testPasswordCredential();
    }

    public void begin() throws Exception {
    }

    public void commit() throws Exception {
    }
}

