/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.idm.test.support.ldap;

import java.io.OutputStream;
import java.net.URL;
import java.util.Hashtable;
import javax.naming.Binding;
import javax.naming.Context;
import javax.naming.NamingEnumeration;
import javax.naming.directory.DirContext;
import javax.naming.ldap.InitialLdapContext;
import javax.naming.ldap.LdapContext;
import org.opends.server.tools.LDAPModify;
import org.picketlink.idm.test.support.IdentityTestPOJO;
import org.picketlink.idm.test.support.ldap.DSConfig;
import org.picketlink.idm.test.support.opends.OpenDSService;

public class LDAPTestPOJO
extends IdentityTestPOJO {
    public String EMBEDDED_OPEN_DS_DIRECTORY_NAME = "EmbeddedOpenDS";
    protected DSConfig directoryConfig;
    public String directories = "datasources/directories.xml";
    private String directoryName = this.EMBEDDED_OPEN_DS_DIRECTORY_NAME;
    public static Hashtable<String, String> env = new Hashtable();
    OpenDSService openDSService = new OpenDSService(null);

    public void start() throws Exception {
        this.overrideFromProperties();
        this.directoryConfig = DSConfig.obtainConfig(this.directories, this.directoryName);
        this.identityConfig = this.directoryConfig.getConfigFile();
        super.start();
        env.put("java.naming.factory.initial", this.directoryConfig.getContextFactory());
        env.put("java.naming.provider.url", this.directoryConfig.getDescription());
        env.put("java.naming.security.authentication", "simple");
        env.put("java.naming.security.principal", this.directoryConfig.getAdminDN());
        env.put("java.naming.security.credentials", this.directoryConfig.getAdminPassword());
        if (this.directoryName.equals(this.EMBEDDED_OPEN_DS_DIRECTORY_NAME)) {
            this.openDSService.start();
        }
    }

    public void stop() throws Exception {
        this.cleanUp(new InitialLdapContext(env, null));
        super.stop();
        if (this.directoryName.equals(this.EMBEDDED_OPEN_DS_DIRECTORY_NAME)) {
            this.openDSService.stop();
        }
    }

    public void overrideFromProperties() throws Exception {
        String trustStorePassword;
        String trustStorePath;
        String dirName = System.getProperties().getProperty("directoryName");
        if (dirName != null && dirName.length() > 0 && !dirName.startsWith("$")) {
            this.setDirectoryName(dirName);
        }
        if ((trustStorePath = System.getProperties().getProperty("trustStorePath")) != null && !trustStorePath.startsWith("$")) {
            System.setProperty("javax.net.ssl.trustStore", trustStorePath);
        }
        if ((trustStorePassword = System.getProperties().getProperty("trustStorePassword")) != null && !trustStorePassword.startsWith("$")) {
            System.setProperty("javax.net.ssl.trustStorePassword", trustStorePassword);
        }
    }

    public void setDirectoryName(String directoryName) {
        this.directoryName = directoryName;
    }

    public String getDirectoryName() {
        return this.directoryName;
    }

    public void populateClean() throws Exception {
        String ldif = this.directoryConfig.getPopulateLdif();
        if (ldif != null && ldif.length() != 0) {
            this.populateLDIF(this.directoryConfig.getPopulateLdif());
        }
    }

    public void populateLDIF(String ldif) throws Exception {
        URL ldifURL = Thread.currentThread().getContextClassLoader().getResource(ldif);
        System.out.println("LDIF: " + ldifURL.toURI().getPath());
        String[] cmd = new String[]{"-h", this.directoryConfig.getHost(), "-p", this.directoryConfig.getPort(), "-D", this.directoryConfig.getAdminDN(), "-w", this.directoryConfig.getAdminPassword(), "-a", "-f", ldifURL.toURI().getPath()};
        if (this.directoryName.equals(this.EMBEDDED_OPEN_DS_DIRECTORY_NAME)) {
            System.out.println("Populate success: " + (LDAPModify.mainModify((String[])cmd, (boolean)false, (OutputStream)System.out, (OutputStream)System.err) == 0));
        } else {
            System.out.println("Populate success: " + (LDAPModify.mainModify((String[])cmd) == 0));
        }
    }

    protected void cleanUp(DirContext ldapCtx) throws Exception {
        try {
            String dn = this.directoryConfig.getCleanUpDN();
            System.out.println("Removing: " + dn);
            this.removeContext(ldapCtx, dn);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected void removeContext(Context mainCtx, String name) throws Exception {
        Context deleteCtx = (Context)mainCtx.lookup(name);
        NamingEnumeration<Binding> subDirs = mainCtx.listBindings(name);
        while (subDirs.hasMoreElements()) {
            Binding binding = (Binding)subDirs.nextElement();
            String subName = binding.getName();
            this.removeContext(deleteCtx, subName);
        }
        mainCtx.unbind(name);
    }

    public LdapContext getLdapContext() throws Exception {
        return new InitialLdapContext(env, null);
    }
}

