/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.idm.impl.api;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.picketlink.idm.api.IdentitySession;
import org.picketlink.idm.api.IdentitySessionFactory;
import org.picketlink.idm.common.exception.IdentityException;
import org.picketlink.idm.impl.api.session.IdentitySessionImpl;
import org.picketlink.idm.impl.configuration.IdentitySessionConfigurationContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IdentitySessionFactoryImpl
implements IdentitySessionFactory,
Serializable {
    private static final long serialVersionUID = 3806145082462607359L;
    private final Map<String, IdentitySession> realmMap = new HashMap<String, IdentitySession>();
    private final Map<String, IdentitySessionConfigurationContext> sessionContextMap;

    public IdentitySessionFactoryImpl(Map<String, IdentitySessionConfigurationContext> sessionContextMap) {
        this.sessionContextMap = sessionContextMap;
    }

    @Override
    public void close() {
    }

    @Override
    public boolean isClosed() {
        return false;
    }

    @Override
    public IdentitySession createIdentitySession(String realmName) throws IdentityException {
        if (!this.sessionContextMap.containsKey(realmName)) {
            throw new IdentityException("Cannot find configured realm with a given name: " + realmName);
        }
        IdentitySessionConfigurationContext sessionConfigCtx = this.sessionContextMap.get(realmName);
        IdentitySessionImpl newSession = new IdentitySessionImpl(sessionConfigCtx.getRealmName(), sessionConfigCtx.getRepository(), sessionConfigCtx.getTypeMapper(), sessionConfigCtx.getApiCacheProvider(), sessionConfigCtx.getIdentityConfigurationContext(), sessionConfigCtx.getRealmOptions());
        this.realmMap.put(realmName, newSession);
        return newSession;
    }

    @Override
    public IdentitySession getCurrentIdentitySession(String realmName) throws IdentityException {
        if (this.realmMap.containsKey(realmName)) {
            return this.realmMap.get(realmName);
        }
        return this.createIdentitySession(realmName);
    }
}

