/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.idm.impl.store.ldap;

import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.picketlink.idm.impl.store.ldap.LDAPIdentityObjectTypeConfiguration;
import org.picketlink.idm.spi.configuration.metadata.IdentityObjectAttributeMetaData;
import org.picketlink.idm.spi.configuration.metadata.IdentityObjectTypeMetaData;
import org.picketlink.idm.spi.configuration.metadata.RelationshipMetaData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimpleLDAPIdentityObjectTypeConfiguration
implements LDAPIdentityObjectTypeConfiguration {
    private final String idAttributeName;
    private final String passwordAttributeName;
    private final String[] ctxDNs;
    private final String entrySearchFilter;
    private final String entrySearchScope;
    private final boolean allowCreateEntry;
    private final Map<String, String[]> createEntryAttributeValues;
    private final String[] allowedMembershipTypes;
    private final String parentMembershipAttributeName;
    private final String parentMembershipAttributePlaceholder;
    private final boolean isParentMembershipAttributeDN;
    private final boolean allowEmptyMemberships;
    private final Map<String, String> attributeNames;
    private final String childMembershipAttributeName;
    private final boolean isChildMembershipAttributeDN;
    private final boolean isChildMembershipAttributeVirtual;
    private final boolean allowEmptyPassword;
    private final String enclosePasswordWith;
    private final String passwordEncoding;
    private final Map<String, String[]> updatePasswordAttributeValues;
    private final boolean subentryMembershipLookup;
    public static final String ID_ATTRIBUTE_NAME = "idAttributeName";
    public static final String PASSWORD_ATTRIBUTE_NAME = "passwordAttributeName";
    public static final String CTX_DNS = "ctxDNs";
    public static final String ENTRY_SEARCH_FILTER = "entrySearchFilter";
    public static final String ENTRY_SEARCH_SCOPE = "entrySearchScope";
    public static final String ALLOW_CREATE_ENTRY = "allowCreateEntry";
    public static final String PARENT_MEMBERSHIP_ATTRIBUTE_NAME = "parentMembershipAttributeName";
    public static final String PARENT_MEMBERSHIP_ATTRIBUTE_PLACEHOLDER = "parentMembershipAttributePlaceholder";
    public static final String IS_PARENT_MEMBERSHIP_ATTRIBUTE_DN = "isParentMembershipAttributeDN";
    public static final String ALLOW_EMPTY_MEMBERSHIPS = "isAllowEmptyMemberships";
    public static final String CREATE_ENTRY_ATTRIBUTE_VALUES = "createEntryAttributeValues";
    public static final String CHILD_MEMBERSHIP_ATTRIBUTE_NAME = "childMembershipAttributeName";
    public static final String CHILD_MEMBERSHIP_ATTRIBUTE_DN = "childMembershipAttributeDN";
    public static final String CHILD_MEMBERSHIP_ATTRIBUTE_VIRTUAL = "childMembershipAttributeVirtual";
    public static final String ALLOW_EMPTY_PASSWORD = "allowEmptyPassword";
    public static final String ENCLOSE_PASSWORD_WITH = "enclosePasswordWith";
    public static final String PASSWORD_ENCODIGN = "passwordEncoding";
    public static final String SUBENTRY_MEMBERSHIP_LOOKUP = "subentryMembershipLookup";
    public static final String PASSWORD_UPDATE_ATTRIBUTE_VALUES = "passwordUpdateAttributeValues";

    public SimpleLDAPIdentityObjectTypeConfiguration(IdentityObjectTypeMetaData objectTypeMD) {
        this.idAttributeName = objectTypeMD.getOptionSingleValue(ID_ATTRIBUTE_NAME);
        this.passwordAttributeName = objectTypeMD.getOptionSingleValue(PASSWORD_ATTRIBUTE_NAME);
        this.entrySearchFilter = objectTypeMD.getOptionSingleValue(ENTRY_SEARCH_FILTER);
        this.entrySearchScope = objectTypeMD.getOptionSingleValue(ENTRY_SEARCH_SCOPE);
        this.parentMembershipAttributeName = objectTypeMD.getOptionSingleValue(PARENT_MEMBERSHIP_ATTRIBUTE_NAME);
        this.parentMembershipAttributePlaceholder = objectTypeMD.getOptionSingleValue(PARENT_MEMBERSHIP_ATTRIBUTE_PLACEHOLDER);
        this.childMembershipAttributeName = objectTypeMD.getOptionSingleValue(CHILD_MEMBERSHIP_ATTRIBUTE_NAME);
        this.enclosePasswordWith = objectTypeMD.getOptionSingleValue(ENCLOSE_PASSWORD_WITH);
        this.passwordEncoding = objectTypeMD.getOptionSingleValue(PASSWORD_ENCODIGN);
        String allowCreateEntry = objectTypeMD.getOptionSingleValue(ALLOW_CREATE_ENTRY);
        this.allowCreateEntry = allowCreateEntry != null && allowCreateEntry.equalsIgnoreCase("true");
        String isMembershipAttributeDN = objectTypeMD.getOptionSingleValue(IS_PARENT_MEMBERSHIP_ATTRIBUTE_DN);
        this.isParentMembershipAttributeDN = isMembershipAttributeDN != null && isMembershipAttributeDN.equalsIgnoreCase("true");
        String allowEmptyMemberships = objectTypeMD.getOptionSingleValue(ALLOW_EMPTY_MEMBERSHIPS);
        this.allowEmptyMemberships = allowEmptyMemberships != null && allowEmptyMemberships.equalsIgnoreCase("true");
        String isChildMembershipAttributeDN = objectTypeMD.getOptionSingleValue(CHILD_MEMBERSHIP_ATTRIBUTE_DN);
        this.isChildMembershipAttributeDN = isChildMembershipAttributeDN != null && isChildMembershipAttributeDN.equalsIgnoreCase("true");
        String isChildMembershipAttributeVirtual = objectTypeMD.getOptionSingleValue(CHILD_MEMBERSHIP_ATTRIBUTE_DN);
        this.isChildMembershipAttributeVirtual = isChildMembershipAttributeVirtual == null || !isChildMembershipAttributeVirtual.equalsIgnoreCase("false");
        String allowEmptyPassword = objectTypeMD.getOptionSingleValue(ALLOW_EMPTY_PASSWORD);
        this.allowEmptyPassword = allowEmptyPassword != null && allowEmptyPassword.equalsIgnoreCase("true");
        String subentryMembershipLookup = objectTypeMD.getOptionSingleValue(SUBENTRY_MEMBERSHIP_LOOKUP);
        this.subentryMembershipLookup = subentryMembershipLookup != null && subentryMembershipLookup.equalsIgnoreCase("true");
        LinkedList<String> relationships = new LinkedList<String>();
        if (objectTypeMD.getRelationships() != null) {
            for (RelationshipMetaData relationshipMetaData : objectTypeMD.getRelationships()) {
                relationships.add(relationshipMetaData.getIdentityObjectTypeRef());
            }
        }
        this.allowedMembershipTypes = relationships.toArray(new String[relationships.size()]);
        HashMap<String, String> attrsNames = new HashMap<String, String>();
        for (IdentityObjectAttributeMetaData attributeMetaData : objectTypeMD.getAttributes()) {
            attrsNames.put(attributeMetaData.getName(), attributeMetaData.getStoreMapping());
        }
        this.attributeNames = Collections.unmodifiableMap(attrsNames);
        List<String> dns = objectTypeMD.getOption(CTX_DNS);
        this.ctxDNs = dns != null ? dns.toArray(new String[dns.size()]) : null;
        HashMap createEntryAttributesMap = new HashMap();
        List<String> createAttributes = objectTypeMD.getOption(CREATE_ENTRY_ATTRIBUTE_VALUES);
        if (createAttributes != null && createAttributes.size() > 0) {
            for (String attribute : createAttributes) {
                String[] parts = attribute.split("=", 2);
                if (parts.length != 2) continue;
                String name = parts[0];
                String value = parts[1];
                if (!createEntryAttributesMap.containsKey(name)) {
                    LinkedList<String> list = new LinkedList<String>();
                    list.add(value);
                    createEntryAttributesMap.put(name, list);
                    continue;
                }
                ((List)createEntryAttributesMap.get(name)).add(value);
            }
            HashMap createEntryAttributesArray = new HashMap();
            for (Map.Entry entry : createEntryAttributesMap.entrySet()) {
                createEntryAttributesArray.put(entry.getKey(), ((List)entry.getValue()).toArray(new String[((List)entry.getValue()).size()]));
            }
            this.createEntryAttributeValues = Collections.unmodifiableMap(createEntryAttributesArray);
        } else {
            this.createEntryAttributeValues = Collections.unmodifiableMap(new HashMap());
        }
        HashMap updatePasswordAttributesMap = new HashMap();
        List<String> passwordUpdateAttributes = objectTypeMD.getOption(PASSWORD_UPDATE_ATTRIBUTE_VALUES);
        if (passwordUpdateAttributes != null && passwordUpdateAttributes.size() > 0) {
            for (String attribute : passwordUpdateAttributes) {
                String[] parts = attribute.split("=", 2);
                if (parts.length != 2) continue;
                String name = parts[0];
                String value = parts[1];
                if (!updatePasswordAttributesMap.containsKey(name)) {
                    LinkedList<String> list = new LinkedList<String>();
                    list.add(value);
                    updatePasswordAttributesMap.put(name, list);
                    continue;
                }
                ((List)updatePasswordAttributesMap.get(name)).add(value);
            }
            HashMap createEntryAttributesArray = new HashMap();
            for (Map.Entry entry : updatePasswordAttributesMap.entrySet()) {
                createEntryAttributesArray.put(entry.getKey(), ((List)entry.getValue()).toArray(new String[((List)entry.getValue()).size()]));
            }
            this.updatePasswordAttributeValues = Collections.unmodifiableMap(createEntryAttributesArray);
        } else {
            this.updatePasswordAttributeValues = Collections.unmodifiableMap(new HashMap());
        }
    }

    @Override
    public String getIdAttributeName() {
        return this.idAttributeName;
    }

    @Override
    public String[] getCtxDNs() {
        return (String[])this.ctxDNs.clone();
    }

    @Override
    public String getEntrySearchFilter() {
        return this.entrySearchFilter;
    }

    @Override
    public boolean isAllowCreateEntry() {
        return this.allowCreateEntry;
    }

    @Override
    public Map<String, String[]> getCreateEntryAttributeValues() {
        return this.createEntryAttributeValues;
    }

    @Override
    public String[] getAllowedMembershipTypes() {
        return (String[])this.allowedMembershipTypes.clone();
    }

    @Override
    public String getParentMembershipAttributeName() {
        return this.parentMembershipAttributeName;
    }

    @Override
    public String getParentMembershipAttributePlaceholder() {
        return this.parentMembershipAttributePlaceholder;
    }

    @Override
    public boolean isParentMembershipAttributeDN() {
        return this.isParentMembershipAttributeDN;
    }

    @Override
    public boolean isAllowEmptyMemberships() {
        return this.allowEmptyMemberships;
    }

    @Override
    public String getAttributeMapping(String name) {
        return this.attributeNames.get(name);
    }

    @Override
    public String getPasswordAttributeName() {
        return this.passwordAttributeName;
    }

    @Override
    public Set<String> getMappedAttributesNames() {
        return Collections.unmodifiableSet(this.attributeNames.keySet());
    }

    @Override
    public String getEntrySearchScope() {
        return this.entrySearchScope;
    }

    public Map<String, String> getAttributeNames() {
        return this.attributeNames;
    }

    @Override
    public String getChildMembershipAttributeName() {
        return this.childMembershipAttributeName;
    }

    @Override
    public boolean isChildMembershipAttributeDN() {
        return this.isChildMembershipAttributeDN;
    }

    @Override
    public boolean isChildMembershipAttributeVirtual() {
        return this.isChildMembershipAttributeVirtual;
    }

    @Override
    public boolean isAllowEmptyPassword() {
        return this.allowEmptyPassword;
    }

    @Override
    public String getEnclosePasswordWith() {
        return this.enclosePasswordWith;
    }

    @Override
    public String getPasswordEncoding() {
        return this.passwordEncoding;
    }

    @Override
    public Map<String, String[]> getUpdatePasswordAttributeValues() {
        return this.updatePasswordAttributeValues;
    }

    @Override
    public boolean isSubentryMembershipLookup() {
        return this.subentryMembershipLookup;
    }
}

