/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.idm.impl.cache;

import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jboss.cache.Cache;
import org.jboss.cache.DefaultCacheFactory;
import org.jboss.cache.Fqn;
import org.jboss.cache.Node;
import org.picketlink.idm.impl.api.SimpleAttribute;
import org.picketlink.idm.impl.types.SimpleIdentityObject;
import org.picketlink.idm.impl.types.SimpleIdentityObjectRelationship;
import org.picketlink.idm.impl.types.SimpleIdentityObjectRelationshipType;
import org.picketlink.idm.impl.types.SimpleIdentityObjectType;
import org.picketlink.idm.spi.cache.IdentityObjectRelationshipNameSearch;
import org.picketlink.idm.spi.cache.IdentityObjectRelationshipSearch;
import org.picketlink.idm.spi.cache.IdentityObjectSearch;
import org.picketlink.idm.spi.cache.IdentityStoreCacheProvider;
import org.picketlink.idm.spi.configuration.IdentityRepositoryConfigurationContext;
import org.picketlink.idm.spi.model.IdentityObject;
import org.picketlink.idm.spi.model.IdentityObjectAttribute;
import org.picketlink.idm.spi.model.IdentityObjectRelationship;
import org.picketlink.idm.spi.model.IdentityObjectRelationshipType;
import org.picketlink.idm.spi.model.IdentityObjectType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JBossCacheIdentityStoreCacheProviderImpl
implements IdentityStoreCacheProvider {
    private static Logger log = Logger.getLogger(JBossCacheIdentityStoreCacheProviderImpl.class.getName());
    private Cache cache;
    public static final String CONFIG_FILE_OPTION = "cache.configFile";
    public static final String CONFIG_CACHE_REGISTRY_OPTION = "cache.cacheRegistryName";
    public static final String NODE_OBJECT_KEY = "object";
    public static final String NODE_SEARCH_KEY = "search";
    public static final String NODE_SEARCH_UNIQUE_KEY = "query_unique";
    public static final String NODE_MAIN_ROOT = "IDM_ROOT";
    public static final String NODE_COMMON_ROOT = "COMMON_ROOT";
    public static final String NODE_IO_COUNT = "NODE_IO_COUNT";
    public static final String NODE_IO_ATTRIBUTES = "NODE_IO_ATTRIBUTES";
    public static final String NODE_REL_PROPS = "NODE_REL_PROPS";
    public static final String NODE_REL_NAME_PROPS = "NODE_REL_NAME_PROPS";
    public static final String NODE_IO_SEARCH = "NODE_IO_SEARCH";
    public static final String NODE_IO_REL_SEARCH = "NODE_IO_REL_SEARCH";
    public static final String NODE_IO_REL_NAME_SEARCH = "NODE_IO_REL_NAME_SEARCH";

    private Fqn getNamespacedFqn(String ns) {
        return Fqn.fromElements((Object[])new String[]{"NODE_MAIN_ROOT", ns});
    }

    private Fqn getFqn(String ns, String node, Object o) {
        return Fqn.fromElements((Object[])new Object[]{this.getNamespacedFqn(ns), node, o});
    }

    private Fqn getFqn(String ns, String node) {
        return Fqn.fromElements((Object[])new Serializable[]{this.getNamespacedFqn(ns), node});
    }

    public void initialize(Map<String, String> properties, IdentityRepositoryConfigurationContext configurationContext) {
        DefaultCacheFactory factory = new DefaultCacheFactory();
        String registryName = properties.get(CONFIG_CACHE_REGISTRY_OPTION);
        if (registryName != null) {
            try {
                this.cache = (Cache)configurationContext.getConfigurationRegistry().getObject(registryName);
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Cannot find JBoss Cache 'Cache' object in configuration registry with providedname: " + registryName);
            }
            return;
        }
        String config = properties.get(CONFIG_FILE_OPTION);
        if (config == null) {
            throw new IllegalArgumentException("Cannot find 'cache.configFile' in passed properties. Failed to initializecache provider.");
        }
        this.cache = factory.createCache(config);
        this.cache.create();
        this.cache.start();
    }

    Cache getCache() {
        return this.cache;
    }

    public void invalidate(String ns) {
        this.cache.getRoot().removeChild(this.getNamespacedFqn(ns));
        if (log.isLoggable(Level.FINER)) {
            log.finer(this.toString() + "Invalidating namespace:" + ns);
        }
    }

    public String getNamespace(String storeId) {
        if (storeId == null) {
            return NODE_COMMON_ROOT;
        }
        return storeId;
    }

    public String getNamespace(String storeId, String sessionId) {
        if (sessionId == null) {
            return this.getNamespace(storeId);
        }
        return storeId + "/" + sessionId;
    }

    public String getNamespace(String storeId, String sessionId, String realmId) {
        if (realmId == null) {
            return this.getNamespace(sessionId);
        }
        return storeId + "/" + sessionId + "/" + realmId;
    }

    public void putIdentityObjectCount(String ns, String type, int count) {
        Fqn nodeFqn = this.getFqn(ns, NODE_IO_COUNT, type);
        Node ioNode = this.getCache().getRoot().addChild(nodeFqn);
        ioNode.put((Object)NODE_OBJECT_KEY, (Object)count);
        if (log.isLoggable(Level.FINER)) {
            log.finer(this.toString() + "IdentityObject count stored in cache: " + count + "; type=" + type + ";namespace=" + ns);
        }
    }

    public int getIdentityObjectCount(String ns, String type) {
        Fqn nodeFqn = this.getFqn(ns, NODE_IO_COUNT, type);
        Node node = this.getCache().getRoot().getChild(nodeFqn);
        if (node != null) {
            int count = -1;
            Integer i = (Integer)node.get((Object)NODE_OBJECT_KEY);
            if (i != null) {
                count = i;
            }
            if (log.isLoggable(Level.FINER) && count != -1) {
                log.finer(this.toString() + "IdentityObject count found in cache: " + count + "; type=" + type + ";namespace=" + ns);
            }
            return count;
        }
        return -1;
    }

    public void invalidateIdentityObjectCount(String ns, String type) {
        this.getCache().getRoot().removeChild(Fqn.fromElements((Object[])new Serializable[]{this.getNamespacedFqn(ns), NODE_IO_COUNT, type}));
        if (log.isLoggable(Level.FINER)) {
            log.finer(this.toString() + "Invalidating IdentityObject count. Namespace:" + ns + "; type=" + type + ";namespace=" + ns);
        }
    }

    public void putIdentityObjectSearch(String ns, IdentityObjectSearch search, Collection<IdentityObject> results) {
        Fqn nodeFqn = this.getFqn(ns, NODE_IO_SEARCH, search.hashCode());
        Node ioNode = this.getCache().getRoot().addChild(nodeFqn);
        ioNode.put((Object)NODE_OBJECT_KEY, this.safeCopyIO(results));
        if (log.isLoggable(Level.FINER)) {
            log.finer(this.toString() + "IdentityObject search stored in cache: results.size()=" + results.size() + ";namespace=" + ns);
        }
    }

    public Collection<IdentityObject> getIdentityObjectSearch(String ns, IdentityObjectSearch search) {
        Fqn nodeFqn = this.getFqn(ns, NODE_IO_SEARCH, search.hashCode());
        Node node = this.getCache().getRoot().getChild(nodeFqn);
        if (node != null) {
            Collection results = (Collection)node.get((Object)NODE_OBJECT_KEY);
            if (log.isLoggable(Level.FINER) && results != null) {
                log.finer(this.toString() + "IdentityObject search found in cache: results.size()=" + results.size() + ";namespace=" + ns);
            }
            return results;
        }
        return null;
    }

    public void invalidateIdentityObjectSearches(String ns) {
        this.getCache().getRoot().removeChild(this.getFqn(ns, NODE_IO_SEARCH));
        if (log.isLoggable(Level.FINER)) {
            log.finer(this.toString() + "Invalidating IdentityObject searches. Namespace:" + ns);
        }
    }

    public void putIdentityObjectRelationshipSearch(String ns, IdentityObjectRelationshipSearch search, Set<IdentityObjectRelationship> results) {
        Fqn nodeFqn = this.getFqn(ns, NODE_IO_REL_SEARCH, search.hashCode());
        Node ioNode = this.getCache().getRoot().addChild(nodeFqn);
        ioNode.put((Object)NODE_OBJECT_KEY, this.safeCopyIOR(results));
        if (log.isLoggable(Level.FINER)) {
            log.finer(this.toString() + "IdentityObjectRelationship search stored in cache: results.size()=" + results.size() + ";namespace=" + ns);
        }
    }

    public Set<IdentityObjectRelationship> getIdentityObjectRelationshipSearch(String ns, IdentityObjectRelationshipSearch search) {
        Fqn nodeFqn = this.getFqn(ns, NODE_IO_REL_SEARCH, search.hashCode());
        Node node = this.getCache().getRoot().getChild(nodeFqn);
        if (node != null) {
            Set results = (Set)node.get((Object)NODE_OBJECT_KEY);
            if (log.isLoggable(Level.FINER) && results != null) {
                log.finer(this.toString() + "IdentityObjectRelationship search found in cache: results.size()=" + results.size() + ";namespace=" + ns);
            }
            return results;
        }
        return null;
    }

    public void invalidateIdentityObjectRelationshipSearches(String ns) {
        this.getCache().getRoot().removeChild(this.getFqn(ns, NODE_IO_REL_SEARCH));
        if (log.isLoggable(Level.FINER)) {
            log.finer(this.toString() + "Invalidating IdentityObjectRelationship searches. Namespace:" + ns);
        }
    }

    public void putIdentityObjectRelationshipNameSearch(String ns, IdentityObjectRelationshipNameSearch search, Set<String> results) {
        Fqn nodeFqn = this.getFqn(ns, NODE_IO_REL_NAME_SEARCH, search.hashCode());
        Node ioNode = this.getCache().getRoot().addChild(nodeFqn);
        ioNode.put((Object)NODE_OBJECT_KEY, results);
        if (log.isLoggable(Level.FINER)) {
            log.finer(this.toString() + "IdentityObjectRelationshipName search stored in cache: results.size()=" + results.size() + ";namespace=" + ns);
        }
    }

    public Set<String> getIdentityObjectRelationshipNameSearch(String ns, IdentityObjectRelationshipNameSearch search) {
        Fqn nodeFqn = this.getFqn(ns, NODE_IO_REL_NAME_SEARCH, search.hashCode());
        Node node = this.getCache().getRoot().getChild(nodeFqn);
        if (node != null) {
            Set results = (Set)node.get((Object)NODE_OBJECT_KEY);
            if (log.isLoggable(Level.FINER) && results != null) {
                log.finer(this.toString() + "IdentityObjectRelationshipName search found in cache: results.size()=" + results.size() + ";namespace=" + ns);
            }
            return results;
        }
        return null;
    }

    public void invalidateIdentityObjectRelationshipNameSearches(String ns) {
        this.getCache().getRoot().removeChild(this.getFqn(ns, NODE_IO_REL_NAME_SEARCH));
        if (log.isLoggable(Level.FINER)) {
            log.finer(this.toString() + "Invalidating IdentityObjectRelationshipName searches. Namespace:" + ns);
        }
    }

    public void putProperties(String ns, IdentityObjectRelationship relationship, Map<String, String> properties) {
        Fqn nodeFqn = this.getFqn(ns, NODE_REL_PROPS, this.decode(relationship));
        Node ioNode = this.getCache().getRoot().addChild(nodeFqn);
        ioNode.put((Object)NODE_OBJECT_KEY, properties);
        if (log.isLoggable(Level.FINER)) {
            log.finer(this.toString() + "IdentityObjectRelationship properties stored in cache: relationship=" + relationship + "; properties.size()=" + properties.size() + ";namespace=" + ns);
        }
    }

    private String decode(IdentityObjectRelationship r) {
        return r.getFromIdentityObject().getIdentityType().getName() + r.getFromIdentityObject().getName() + r.getToIdentityObject().getIdentityType().getName() + r.getToIdentityObject().getName() + r.getType().getName();
    }

    public Map<String, String> getProperties(String ns, IdentityObjectRelationship relationship) {
        Fqn nodeFqn = this.getFqn(ns, NODE_REL_PROPS, this.decode(relationship));
        Node node = this.getCache().getRoot().getChild(nodeFqn);
        if (node != null) {
            Map props = (Map)node.get((Object)NODE_OBJECT_KEY);
            if (log.isLoggable(Level.FINER) && props != null) {
                log.finer(this.toString() + "IdentityObjectRelationship properties found in cache: properties.size()=" + props.size() + "; relationship=" + relationship + ";namespace=" + ns);
            }
            return props;
        }
        return null;
    }

    public void invalidateRelationshipProperties(String ns, IdentityObjectRelationship relationship) {
        this.getCache().getRoot().removeChild(this.getFqn(ns, NODE_REL_PROPS, this.decode(relationship)));
        if (log.isLoggable(Level.FINER)) {
            log.finer(this.toString() + "Invalidating IdentityObjectRelationship properties. Namespace:" + ns + "; relationship=" + relationship + ";namespace=" + ns);
        }
    }

    public void invalidateRelationshipProperties(String ns) {
        this.getCache().getRoot().removeChild(this.getFqn(ns, NODE_REL_PROPS));
        if (log.isLoggable(Level.FINER)) {
            log.finer(this.toString() + "Invalidating IdentityObjectRelationship properties. Namespace:" + ns);
        }
    }

    public void putProperties(String ns, String name, Map<String, String> properties) {
        Fqn nodeFqn = this.getFqn(ns, NODE_REL_NAME_PROPS, name);
        Node ioNode = this.getCache().getRoot().addChild(nodeFqn);
        ioNode.put((Object)NODE_OBJECT_KEY, properties);
        if (log.isLoggable(Level.FINER)) {
            log.finer(this.toString() + "IdentityObjectRelationshipName properties stored in cache: name=" + name + "; properties.size()=" + properties.size() + ";namespace=" + ns);
        }
    }

    public Map<String, String> getProperties(String ns, String name) {
        Fqn nodeFqn = this.getFqn(ns, NODE_REL_NAME_PROPS, name);
        Node node = this.getCache().getRoot().getChild(nodeFqn);
        if (node != null) {
            Map props = (Map)node.get((Object)NODE_OBJECT_KEY);
            if (log.isLoggable(Level.FINER) && props != null) {
                log.finer(this.toString() + "IdentityObjectRelationshipName properties found in cache: properties.size()=" + props.size() + "; name=" + name + ";namespace=" + ns);
            }
            return props;
        }
        return null;
    }

    public void invalidateRelationshipNameProperties(String ns, String relationship) {
        this.getCache().getRoot().removeChild(this.getFqn(ns, NODE_REL_NAME_PROPS, relationship));
        if (log.isLoggable(Level.FINER)) {
            log.finer(this.toString() + "Invalidating IdentityObjectRelationshipName properties." + " Namespace:" + ns + "; name=" + relationship);
        }
    }

    public void invalidateRelationshipNameProperties(String ns) {
        this.getCache().getRoot().removeChild(this.getFqn(ns, NODE_REL_NAME_PROPS));
        if (log.isLoggable(Level.FINER)) {
            log.finer(this.toString() + "Invalidating IdentityObjectRelationshipName properties. " + "Namespace:" + ns);
        }
    }

    public void putIdentityObjectAttributes(String ns, IdentityObject io, Map<String, IdentityObjectAttribute> attributes) {
        Fqn nodeFqn = this.getFqn(ns, NODE_IO_ATTRIBUTES, io.getIdentityType().getName() + io.getName());
        Node ioNode = this.getCache().getRoot().addChild(nodeFqn);
        ioNode.put((Object)NODE_OBJECT_KEY, this.safeCopyAttr(attributes));
        if (log.isLoggable(Level.FINER)) {
            log.finer(this.toString() + "IdentityObject attributes stored in cache: io=" + io + "; attributes.size()=" + attributes.size() + ";namespace=" + ns);
        }
    }

    public Map<String, IdentityObjectAttribute> getIdentityObjectAttributes(String ns, IdentityObject io) {
        Fqn nodeFqn = this.getFqn(ns, NODE_IO_ATTRIBUTES, io.getIdentityType().getName() + io.getName());
        Node node = this.getCache().getRoot().getChild(nodeFqn);
        if (node != null) {
            Map props = (Map)node.get((Object)NODE_OBJECT_KEY);
            if (log.isLoggable(Level.FINER) && props != null) {
                log.finer(this.toString() + "IIdentityObject attributes found in cache: attributes.size()=" + props.size() + "; io=" + io + ";namespace=" + ns);
            }
            return props;
        }
        return null;
    }

    public void invalidateIdentityObjectAttriubtes(String ns, IdentityObject io) {
        this.getCache().getRoot().removeChild(this.getFqn(ns, NODE_IO_ATTRIBUTES, io.getIdentityType().getName() + io.getName()));
        if (log.isLoggable(Level.FINER)) {
            log.finer(this.toString() + "Invalidating IdentityObject attributes. Namespace:" + ns + "; io=" + io);
        }
    }

    public void invalidateIdentityObjectAttriubtes(String ns) {
        this.getCache().getRoot().removeChild(this.getFqn(ns, NODE_IO_ATTRIBUTES));
        if (log.isLoggable(Level.FINER)) {
            log.finer(this.toString() + "Invalidating IdentityObject attributes. Namespace:" + ns);
        }
    }

    private List<IdentityObject> safeCopyIO(Collection<IdentityObject> res) {
        LinkedList<IdentityObject> nr = new LinkedList<IdentityObject>();
        for (IdentityObject io : res) {
            nr.add((IdentityObject)new SimpleIdentityObject(io.getName(), (IdentityObjectType)new SimpleIdentityObjectType(io.getIdentityType().getName())));
        }
        return nr;
    }

    private Set<IdentityObjectRelationship> safeCopyIOR(Set<IdentityObjectRelationship> res) {
        HashSet<IdentityObjectRelationship> nr = new HashSet<IdentityObjectRelationship>();
        for (IdentityObjectRelationship ior : res) {
            SimpleIdentityObject from = new SimpleIdentityObject(ior.getFromIdentityObject().getName(), (IdentityObjectType)new SimpleIdentityObjectType(ior.getFromIdentityObject().getIdentityType().getName()));
            SimpleIdentityObject to = new SimpleIdentityObject(ior.getToIdentityObject().getName(), (IdentityObjectType)new SimpleIdentityObjectType(ior.getToIdentityObject().getIdentityType().getName()));
            nr.add((IdentityObjectRelationship)new SimpleIdentityObjectRelationship((IdentityObject)from, (IdentityObject)to, ior.getName(), (IdentityObjectRelationshipType)new SimpleIdentityObjectRelationshipType(ior.getType().getName())));
        }
        return nr;
    }

    private Map<String, IdentityObjectAttribute> safeCopyAttr(Map<String, IdentityObjectAttribute> res) {
        HashMap<String, IdentityObjectAttribute> nr = new HashMap<String, IdentityObjectAttribute>();
        for (IdentityObjectAttribute attr : res.values()) {
            nr.put(attr.getName(), (IdentityObjectAttribute)new SimpleAttribute(attr));
        }
        return nr;
    }
}

