/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.idm.impl.api.session.managers;

import java.io.Serializable;
import java.util.Collection;
import java.util.Map;
import org.picketlink.idm.api.Attribute;
import org.picketlink.idm.api.Credential;
import org.picketlink.idm.api.Group;
import org.picketlink.idm.api.IdentitySearchCriteria;
import org.picketlink.idm.api.IdentitySession;
import org.picketlink.idm.api.IdentityType;
import org.picketlink.idm.api.Role;
import org.picketlink.idm.api.RoleType;
import org.picketlink.idm.api.User;
import org.picketlink.idm.api.event.EventListener;
import org.picketlink.idm.api.event.IdentityTypeEventListener;
import org.picketlink.idm.api.event.RelationshipEventListener;
import org.picketlink.idm.api.event.RoleEventListener;
import org.picketlink.idm.api.event.RoleTypeEventListener;
import org.picketlink.idm.cache.APICacheProvider;
import org.picketlink.idm.impl.api.IdentitySearchCriteriaImpl;
import org.picketlink.idm.impl.api.SimpleAttribute;
import org.picketlink.idm.impl.api.model.GroupKey;
import org.picketlink.idm.impl.api.model.SimpleGroup;
import org.picketlink.idm.impl.api.model.SimpleUser;
import org.picketlink.idm.impl.api.session.IdentitySessionImpl;
import org.picketlink.idm.impl.api.session.context.IdentitySessionContext;
import org.picketlink.idm.impl.types.SimpleIdentityObject;
import org.picketlink.idm.spi.model.IdentityObject;
import org.picketlink.idm.spi.model.IdentityObjectAttribute;
import org.picketlink.idm.spi.model.IdentityObjectType;
import org.picketlink.idm.spi.repository.IdentityStoreRepository;
import org.picketlink.idm.spi.search.IdentityObjectSearchCriteria;
import org.picketlink.idm.spi.store.IdentityStoreInvocationContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractManager
implements Serializable {
    protected final IdentitySessionImpl identitySession;
    protected final APICacheProvider cache;
    protected final String cacheNS;

    protected AbstractManager(IdentitySessionImpl session) {
        this.identitySession = session;
        this.cache = session.getApiCacheProvider();
        this.cacheNS = session.getCacheNS();
    }

    public IdentitySession getIdentitySession() {
        return this.identitySession;
    }

    public IdentitySearchCriteria createIdentitySearchCriteria() {
        return new IdentitySearchCriteriaImpl();
    }

    protected IdentitySessionContext getSessionContext() {
        if (this.identitySession instanceof IdentitySessionImpl) {
            return this.identitySession.getSessionContext();
        }
        return null;
    }

    protected IdentityStoreRepository getRepository() {
        return this.getSessionContext().getIdentityStoreRepository();
    }

    protected IdentityStoreInvocationContext getInvocationContext() {
        return this.getSessionContext().resolveStoreInvocationContext();
    }

    protected User createUser(IdentityObject identityObject) {
        return new SimpleUser(identityObject.getName());
    }

    protected User createUserFromId(String name) {
        return new SimpleUser(name);
    }

    protected Group createGroup(IdentityObject identityObject) {
        String groupType = this.getSessionContext().getIdentityObjectTypeMapper().getGroupType(identityObject.getIdentityType());
        return new SimpleGroup(identityObject.getName(), groupType);
    }

    protected IdentityType createIdentityTypeFromId(String id) {
        if (GroupKey.validateKey(id)) {
            GroupKey groupKey = new GroupKey(id);
            return new SimpleGroup(groupKey);
        }
        return new SimpleUser(id);
    }

    protected IdentityObject createIdentityObject(User user) {
        IdentityObjectType iot = this.getSessionContext().getIdentityObjectTypeMapper().getIdentityObjectType();
        return new SimpleIdentityObject(user.getKey(), iot);
    }

    protected IdentityObject createIdentityObjectForUserName(String userName) {
        IdentityObjectType iot = this.getSessionContext().getIdentityObjectTypeMapper().getIdentityObjectType();
        return new SimpleIdentityObject(userName, iot);
    }

    protected IdentityObject createIdentityObject(Group group) {
        IdentityObjectType iot = this.getSessionContext().getIdentityObjectTypeMapper().getIdentityObjectType(group.getGroupType());
        return new SimpleIdentityObject(group.getName(), group.getKey(), iot);
    }

    protected IdentityObject createIdentityObjectForGroupId(String groupId) {
        GroupKey key = new GroupKey(groupId);
        IdentityObjectType iot = this.getSessionContext().getIdentityObjectTypeMapper().getIdentityObjectType(key.getType());
        return new SimpleIdentityObject(key.getName(), null, iot);
    }

    protected IdentityObject createIdentityObject(IdentityType identityType) {
        if (identityType instanceof User) {
            return this.createIdentityObject((User)identityType);
        }
        if (identityType instanceof Group) {
            return this.createIdentityObject((Group)identityType);
        }
        throw new IllegalStateException("Not supported IdentityType extension: " + identityType.getClass());
    }

    protected IdentityObject createIdentityObject(String id) {
        if (GroupKey.validateKey(id)) {
            GroupKey groupKey = new GroupKey(id);
            return this.createIdentityObjectForGroupId(id);
        }
        return this.createIdentityObjectForUserName(id);
    }

    protected Group createGroupFromId(String id) {
        return new SimpleGroup(new GroupKey(id));
    }

    protected IdentityObjectSearchCriteria convertSearchControls(IdentitySearchCriteria criteria) {
        if (criteria == null) {
            return null;
        }
        if (criteria instanceof IdentityObjectSearchCriteria) {
            return (IdentityObjectSearchCriteria)criteria;
        }
        throw new IllegalArgumentException("Not supported IdentitySearchCriteria implementation: " + criteria.getClass());
    }

    protected IdentityObjectType getUserObjectType() {
        return this.getSessionContext().getIdentityObjectTypeMapper().getIdentityObjectType();
    }

    protected IdentityObjectType getIdentityObjectType(String groupType) {
        return this.getSessionContext().getIdentityObjectTypeMapper().getIdentityObjectType(groupType);
    }

    protected IdentityObjectAttribute[] convertAttributes(Attribute[] attributes) {
        IdentityObjectAttribute[] convertedAttributes = new IdentityObjectAttribute[attributes.length];
        for (int i = 0; i < attributes.length; ++i) {
            convertedAttributes[i] = this.convertAttribute(attributes[i]);
        }
        return convertedAttributes;
    }

    protected Attribute[] convertAttributes(IdentityObjectAttribute[] attributes) {
        Attribute[] convertedAttributes = new Attribute[attributes.length];
        for (int i = 0; i < attributes.length; ++i) {
            convertedAttributes[i] = this.convertAttribute(attributes[i]);
        }
        return convertedAttributes;
    }

    protected Attribute convertAttribute(IdentityObjectAttribute attribute) {
        if (attribute instanceof Attribute) {
            return (Attribute)attribute;
        }
        return new SimpleAttribute(attribute);
    }

    protected IdentityObjectAttribute convertAttribute(Attribute attribute) {
        if (attribute instanceof IdentityObjectAttribute) {
            return (IdentityObjectAttribute)attribute;
        }
        return new SimpleAttribute(attribute);
    }

    protected void checkNotNullArgument(Object arg, String name) {
        if (arg == null) {
            throw new IllegalArgumentException(name + " cannot be null");
        }
    }

    protected void checkObjectName(String name) {
        if (name.contains("/")) {
            throw new IllegalArgumentException("name cannot contain '/' character");
        }
    }

    public void preCreate(IdentityType identityType) {
        for (EventListener el : this.identitySession.getListeners()) {
            if (!(el instanceof IdentityTypeEventListener)) continue;
            ((IdentityTypeEventListener)el).preCreate((IdentitySession)this.identitySession, identityType);
        }
    }

    public void postCreate(IdentityType identityType) {
        for (EventListener el : this.identitySession.getListeners()) {
            if (!(el instanceof IdentityTypeEventListener)) continue;
            ((IdentityTypeEventListener)el).postCreate((IdentitySession)this.identitySession, identityType);
        }
    }

    public void preRemove(IdentityType identityType) {
        for (EventListener el : this.identitySession.getListeners()) {
            if (!(el instanceof IdentityTypeEventListener)) continue;
            ((IdentityTypeEventListener)el).preRemove((IdentitySession)this.identitySession, identityType);
        }
    }

    public void postRemove(IdentityType identityType) {
        for (EventListener el : this.identitySession.getListeners()) {
            if (!(el instanceof IdentityTypeEventListener)) continue;
            ((IdentityTypeEventListener)el).postRemove((IdentitySession)this.identitySession, identityType);
        }
    }

    public void preAttributesAdd(IdentityType identityType, Attribute[] attributes) {
        for (EventListener el : this.identitySession.getListeners()) {
            if (!(el instanceof IdentityTypeEventListener)) continue;
            ((IdentityTypeEventListener)el).preAttributesAdd((IdentitySession)this.identitySession, identityType, attributes);
        }
    }

    public void postAttributesAdd(IdentityType identityType, Attribute[] attributes) {
        for (EventListener el : this.identitySession.getListeners()) {
            if (!(el instanceof IdentityTypeEventListener)) continue;
            ((IdentityTypeEventListener)el).postAttributesAdd((IdentitySession)this.identitySession, identityType, attributes);
        }
    }

    public void preAttributesRemove(IdentityType identityType, String[] attributes) {
        for (EventListener el : this.identitySession.getListeners()) {
            if (!(el instanceof IdentityTypeEventListener)) continue;
            ((IdentityTypeEventListener)el).preAttributesRemove((IdentitySession)this.identitySession, identityType, attributes);
        }
    }

    public void postAttributesRemove(IdentityType identityType, String[] attributes) {
        for (EventListener el : this.identitySession.getListeners()) {
            if (!(el instanceof IdentityTypeEventListener)) continue;
            ((IdentityTypeEventListener)el).postAttributesRemove((IdentitySession)this.identitySession, identityType, attributes);
        }
    }

    public void preAttributesUpdate(IdentityType identityType, Attribute[] attributes) {
        for (EventListener el : this.identitySession.getListeners()) {
            if (!(el instanceof IdentityTypeEventListener)) continue;
            ((IdentityTypeEventListener)el).preAttributesUpdate((IdentitySession)this.identitySession, identityType, attributes);
        }
    }

    public void postAttributesUpdate(IdentityType identityType, Attribute[] attributes) {
        for (EventListener el : this.identitySession.getListeners()) {
            if (!(el instanceof IdentityTypeEventListener)) continue;
            ((IdentityTypeEventListener)el).postAttributesUpdate((IdentitySession)this.identitySession, identityType, attributes);
        }
    }

    public void preCredentialUpdate(User user, Credential credential) {
        for (EventListener el : this.identitySession.getListeners()) {
            if (!(el instanceof IdentityTypeEventListener)) continue;
            ((IdentityTypeEventListener)el).preCredentialUpdate((IdentitySession)this.identitySession, user, credential);
        }
    }

    public void postCredentialUpdate(User user, Credential credential) {
        for (EventListener el : this.identitySession.getListeners()) {
            if (!(el instanceof IdentityTypeEventListener)) continue;
            ((IdentityTypeEventListener)el).postCredentialUpdate((IdentitySession)this.identitySession, user, credential);
        }
    }

    public void preUserAssociationCreate(Group parent, User childs) {
        for (EventListener el : this.identitySession.getListeners()) {
            if (!(el instanceof RelationshipEventListener)) continue;
            ((RelationshipEventListener)el).preUserAssociationCreate((IdentitySession)this.identitySession, parent, childs);
        }
    }

    public void preGroupAssociationCreate(Group parent, Group childs) {
        for (EventListener el : this.identitySession.getListeners()) {
            if (!(el instanceof RelationshipEventListener)) continue;
            ((RelationshipEventListener)el).preGroupAssociationCreate((IdentitySession)this.identitySession, parent, childs);
        }
    }

    public void postUserAssociationCreate(Group parent, User childs) {
        for (EventListener el : this.identitySession.getListeners()) {
            if (!(el instanceof RelationshipEventListener)) continue;
            ((RelationshipEventListener)el).postUserAssociationCreate((IdentitySession)this.identitySession, parent, childs);
        }
    }

    public void postGroupAssociationCreate(Group parent, Group childs) {
        for (EventListener el : this.identitySession.getListeners()) {
            if (!(el instanceof RelationshipEventListener)) continue;
            ((RelationshipEventListener)el).postGroupAssociationCreate((IdentitySession)this.identitySession, parent, childs);
        }
    }

    public void preUserAssociationRemove(Group parent, User childs) {
        for (EventListener el : this.identitySession.getListeners()) {
            if (!(el instanceof RelationshipEventListener)) continue;
            ((RelationshipEventListener)el).preUserAssociationRemove((IdentitySession)this.identitySession, parent, childs);
        }
    }

    public void preGroupAssociationRemove(Group parent, Group childs) {
        for (EventListener el : this.identitySession.getListeners()) {
            if (!(el instanceof RelationshipEventListener)) continue;
            ((RelationshipEventListener)el).preGroupAssociationRemove((IdentitySession)this.identitySession, parent, childs);
        }
    }

    public void postUserAssociationRemove(Group parent, User childs) {
        for (EventListener el : this.identitySession.getListeners()) {
            if (!(el instanceof RelationshipEventListener)) continue;
            ((RelationshipEventListener)el).postUserAssociationRemove((IdentitySession)this.identitySession, parent, childs);
        }
    }

    public void postGroupAssociationRemove(Group parent, Group childs) {
        for (EventListener el : this.identitySession.getListeners()) {
            if (!(el instanceof RelationshipEventListener)) continue;
            ((RelationshipEventListener)el).postGroupAssociationRemove((IdentitySession)this.identitySession, parent, childs);
        }
    }

    public void preCreate(RoleType roleType) {
        for (EventListener el : this.identitySession.getListeners()) {
            if (!(el instanceof RoleTypeEventListener)) continue;
            ((RoleTypeEventListener)el).preCreate((IdentitySession)this.identitySession, roleType);
        }
    }

    public void postCreate(RoleType roleType) {
        for (EventListener el : this.identitySession.getListeners()) {
            if (!(el instanceof RoleTypeEventListener)) continue;
            ((RoleTypeEventListener)el).postCreate((IdentitySession)this.identitySession, roleType);
        }
    }

    public void preRemove(RoleType roleType) {
        for (EventListener el : this.identitySession.getListeners()) {
            if (!(el instanceof RoleTypeEventListener)) continue;
            ((RoleTypeEventListener)el).preRemove((IdentitySession)this.identitySession, roleType);
        }
    }

    public void postRemove(RoleType roleType) {
        for (EventListener el : this.identitySession.getListeners()) {
            if (!(el instanceof RoleTypeEventListener)) continue;
            ((RoleTypeEventListener)el).postRemove((IdentitySession)this.identitySession, roleType);
        }
    }

    public void prePropertiesSet(RoleType roleType, Map<String, String> properties) {
        for (EventListener el : this.identitySession.getListeners()) {
            if (!(el instanceof RoleTypeEventListener)) continue;
            ((RoleTypeEventListener)el).prePropertiesSet((IdentitySession)this.identitySession, roleType, properties);
        }
    }

    public void postPropertiesSet(RoleType roleType, Map<String, String> properties) {
        for (EventListener el : this.identitySession.getListeners()) {
            if (!(el instanceof RoleTypeEventListener)) continue;
            ((RoleTypeEventListener)el).postPropertiesSet((IdentitySession)this.identitySession, roleType, properties);
        }
    }

    public void preCreate(Role role) {
        for (EventListener el : this.identitySession.getListeners()) {
            if (!(el instanceof RoleEventListener)) continue;
            ((RoleEventListener)el).preCreate((IdentitySession)this.identitySession, role);
        }
    }

    public void postCreate(Role role) {
        for (EventListener el : this.identitySession.getListeners()) {
            if (!(el instanceof RoleEventListener)) continue;
            ((RoleEventListener)el).postCreate((IdentitySession)this.identitySession, role);
        }
    }

    public void preRemove(Role role) {
        for (EventListener el : this.identitySession.getListeners()) {
            if (!(el instanceof RoleEventListener)) continue;
            ((RoleEventListener)el).preRemove((IdentitySession)this.identitySession, role);
        }
    }

    public void postRemove(Role role) {
        for (EventListener el : this.identitySession.getListeners()) {
            if (!(el instanceof RoleEventListener)) continue;
            ((RoleEventListener)el).postRemove((IdentitySession)this.identitySession, role);
        }
    }

    public void prePropertiesSet(Role role, Map<String, String> properties) {
        for (EventListener el : this.identitySession.getListeners()) {
            if (!(el instanceof RoleEventListener)) continue;
            ((RoleEventListener)el).prePropertiesSet((IdentitySession)this.identitySession, role, properties);
        }
    }

    public void postPropertiesSet(Role role, Map<String, String> properties) {
        for (EventListener el : this.identitySession.getListeners()) {
            if (!(el instanceof RoleEventListener)) continue;
            ((RoleEventListener)el).postPropertiesSet((IdentitySession)this.identitySession, role, properties);
        }
    }

    public void prePropertiesRemove(RoleType roleType, Collection<String> names) {
        for (EventListener el : this.identitySession.getListeners()) {
            if (!(el instanceof RoleTypeEventListener)) continue;
            ((RoleTypeEventListener)el).prePropertiesRemove((IdentitySession)this.identitySession, roleType, names);
        }
    }

    public void postPropertiesRemove(RoleType roleType, Collection<String> names) {
        for (EventListener el : this.identitySession.getListeners()) {
            if (!(el instanceof RoleTypeEventListener)) continue;
            ((RoleTypeEventListener)el).postPropertiesRemove((IdentitySession)this.identitySession, roleType, names);
        }
    }

    public void prePropertiesRemove(Role role, Collection<String> names) {
        for (EventListener el : this.identitySession.getListeners()) {
            if (!(el instanceof RoleEventListener)) continue;
            ((RoleEventListener)el).postPropertiesRemove((IdentitySession)this.identitySession, role, names);
        }
    }

    public void postPropertiesRemove(Role role, Collection<String> names) {
        for (EventListener el : this.identitySession.getListeners()) {
            if (!(el instanceof RoleEventListener)) continue;
            ((RoleEventListener)el).postPropertiesRemove((IdentitySession)this.identitySession, role, names);
        }
    }
}

