/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.util;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ReusableThread
implements Runnable {
    volatile Thread thread = null;
    Runnable task = null;
    String thread_name = "ReusableThread";
    volatile boolean suspended = false;
    protected static final Log log = LogFactory.getLog(ReusableThread.class);
    final long TASK_JOIN_TIME = 3000L;

    public ReusableThread() {
    }

    public ReusableThread(String thread_name) {
        this.thread_name = thread_name;
    }

    public boolean done() {
        return this.task == null;
    }

    public boolean available() {
        return this.done();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isAlive() {
        ReusableThread reusableThread = this;
        synchronized (reusableThread) {
            return this.thread != null && this.thread.isAlive();
        }
    }

    public void start() {
        if (this.thread == null || this.thread != null && !this.thread.isAlive()) {
            this.thread = new Thread((Runnable)this, this.thread_name);
            this.thread.setDaemon(true);
            this.thread.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        Thread tmp = null;
        if (log.isTraceEnabled()) {
            log.trace((Object)"entering THIS");
        }
        ReusableThread reusableThread = this;
        synchronized (reusableThread) {
            if (log.isTraceEnabled()) {
                log.trace((Object)("entered THIS (thread=" + this.printObj(this.thread) + ", task=" + this.printObj(this.task) + ", suspended=" + this.suspended + ')'));
            }
            if (this.thread != null && this.thread.isAlive()) {
                tmp = this.thread;
                this.thread = null;
                this.task = null;
                if (log.isTraceEnabled()) {
                    log.trace((Object)"notifying thread");
                }
                this.notifyAll();
                if (log.isTraceEnabled()) {
                    log.trace((Object)"notifying thread completed");
                }
            }
            this.thread = null;
            this.task = null;
        }
        if (tmp != null && tmp.isAlive()) {
            long s1 = System.currentTimeMillis();
            long s2 = 0L;
            if (log.isTraceEnabled()) {
                log.trace((Object)"join(3000)");
            }
            tmp.interrupt();
            try {
                tmp.join(3000L);
            }
            catch (Exception e) {
                // empty catch block
            }
            s2 = System.currentTimeMillis();
            if (log.isTraceEnabled()) {
                log.trace((Object)("join(3000) completed in " + (s2 - s1)));
            }
            if (tmp.isAlive() && log.isErrorEnabled()) {
                log.error((Object)"thread is still alive");
            }
            tmp = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void suspend() {
        ReusableThread reusableThread = this;
        synchronized (reusableThread) {
            if (log.isTraceEnabled()) {
                log.trace((Object)("suspended=" + this.suspended + ", task=" + this.printObj(this.task)));
            }
            if (this.suspended) {
                return;
            }
            this.suspended = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resume() {
        ReusableThread reusableThread = this;
        synchronized (reusableThread) {
            this.suspended = false;
            this.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean assignTask(Runnable t) {
        ReusableThread reusableThread = this;
        synchronized (reusableThread) {
            this.start();
            if (this.task == null) {
                this.task = t;
                this.notifyAll();
                return true;
            }
            if (log.isErrorEnabled()) {
                log.error((Object)("already working on a thread: current_task=" + this.task + ", new task=" + t + ", thread=" + this.thread + ", is alive=" + (this.thread != null ? "" + this.thread.isAlive() : "null")));
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        while (this.thread != null) {
            ReusableThread reusableThread;
            block35: {
                block34: {
                    try {
                        if (log.isTraceEnabled()) {
                            log.trace((Object)"entering ASSIGN");
                        }
                        reusableThread = this;
                        synchronized (reusableThread) {
                            if (log.isTraceEnabled()) {
                                log.trace((Object)("entered ASSIGN (task=" + this.printObj(this.task) + ", thread=" + this.printObj(this.thread) + ')'));
                            }
                            while (this.task == null && this.thread != null) {
                                if (log.isTraceEnabled()) {
                                    log.trace((Object)"wait ASSIGN");
                                }
                                this.wait();
                                if (!log.isTraceEnabled()) continue;
                                log.trace((Object)"wait ASSIGN completed");
                            }
                        }
                    }
                    catch (InterruptedException ex) {
                        if (!log.isTraceEnabled()) break block34;
                        log.trace((Object)"interrupt on ASSIGN");
                    }
                }
                if (this.thread == null) {
                    return;
                }
                try {
                    if (log.isTraceEnabled()) {
                        log.trace((Object)"entering SUSPEND");
                    }
                    ReusableThread ex = this;
                    synchronized (ex) {
                        if (log.isTraceEnabled()) {
                            log.trace((Object)("entered SUSPEND (suspended=" + this.suspended + ", task=" + this.printObj(this.task) + ')'));
                        }
                        while (this.suspended && this.thread != null) {
                            if (log.isTraceEnabled()) {
                                log.trace((Object)"wait SUSPEND");
                            }
                            this.wait();
                            if (!log.isTraceEnabled()) continue;
                            log.trace((Object)"wait SUSPEND completed");
                        }
                    }
                }
                catch (InterruptedException ex) {
                    if (!log.isTraceEnabled()) break block35;
                    log.trace((Object)"interrupt on RESUME");
                }
            }
            if (this.thread == null) {
                return;
            }
            if (this.task != null) {
                block36: {
                    if (log.isTraceEnabled()) {
                        log.trace((Object)"running task");
                    }
                    try {
                        this.task.run();
                    }
                    catch (Throwable ex) {
                        if (!log.isErrorEnabled()) break block36;
                        log.error((Object)"failed running task", ex);
                    }
                }
                if (log.isTraceEnabled()) {
                    log.trace((Object)"task completed");
                }
            }
            if (log.isTraceEnabled()) {
                log.trace((Object)"entering THIS");
            }
            reusableThread = this;
            synchronized (reusableThread) {
                if (log.isTraceEnabled()) {
                    log.trace((Object)"entered THIS");
                }
                this.task = null;
                if (log.isTraceEnabled()) {
                    log.trace((Object)"notify THIS");
                }
                this.notifyAll();
                if (log.isTraceEnabled()) {
                    log.trace((Object)"notify THIS completed");
                }
            }
        }
        if (log.isTraceEnabled()) {
            log.trace((Object)"terminated");
        }
    }

    String printObj(Object obj) {
        if (obj == null) {
            return "null";
        }
        return "non-null";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitUntilDone() {
        if (log.isTraceEnabled()) {
            log.trace((Object)"entering THIS");
        }
        ReusableThread reusableThread = this;
        synchronized (reusableThread) {
            if (log.isTraceEnabled()) {
                log.trace((Object)("entered THIS (task=" + this.printObj(this.task) + ')'));
            }
            while (this.task != null) {
                try {
                    if (log.isTraceEnabled()) {
                        log.trace((Object)"wait THIS");
                    }
                    this.wait();
                    if (!log.isTraceEnabled()) continue;
                    log.trace((Object)"wait THIS completed");
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }

    public String toString() {
        return "suspended=" + this.suspended;
    }
}

