/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.transaction;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.cache.CacheException;
import org.jboss.cache.InvocationContext;
import org.jboss.cache.RPCManager;
import org.jboss.cache.factories.annotations.Inject;
import org.jboss.cache.factories.annotations.NonVolatile;
import org.jboss.cache.factories.context.ContextFactory;
import org.jboss.cache.jmx.annotations.ManagedAttribute;
import org.jboss.cache.transaction.GlobalTransaction;
import org.jboss.cache.transaction.TransactionContext;
import org.jgroups.Address;

@NonVolatile
public class TransactionTable {
    private static final Log log = LogFactory.getLog(TransactionTable.class);
    private static final boolean trace = log.isTraceEnabled();
    protected final Map<Transaction, GlobalTransaction> tx2gtxMap = new ConcurrentHashMap<Transaction, GlobalTransaction>();
    protected final Map<GlobalTransaction, TransactionContext> gtx2ContextMap = new ConcurrentHashMap<GlobalTransaction, TransactionContext>();
    protected final Map<GlobalTransaction, Transaction> gtx2TxMap = new ConcurrentHashMap<GlobalTransaction, Transaction>();
    private TransactionManager transactionManager = null;
    private RPCManager rpcManager;
    private ContextFactory contextFactory;

    @Inject
    public void initialize(TransactionManager transactionManager, RPCManager rpcManager, ContextFactory contextFactory) {
        this.transactionManager = transactionManager;
        this.rpcManager = rpcManager;
        this.contextFactory = contextFactory;
    }

    public int getNumLocalTransactions() {
        return this.tx2gtxMap.size();
    }

    public int getNumGlobalTransactions() {
        return this.gtx2ContextMap.size();
    }

    public GlobalTransaction get(Transaction tx) {
        if (tx == null) {
            return null;
        }
        return this.tx2gtxMap.get(tx);
    }

    public Transaction getLocalTransaction(GlobalTransaction gtx) {
        if (gtx == null) {
            return null;
        }
        return this.gtx2TxMap.get(gtx);
    }

    public Transaction getLocalTransaction(GlobalTransaction gtx, boolean assertExists) {
        Transaction ltx = this.getLocalTransaction(gtx);
        if (!assertExists) {
            return ltx;
        }
        if (ltx != null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Found local TX=" + ltx + ", global TX=" + gtx));
            }
            return ltx;
        }
        throw new IllegalStateException(" found no local TX for global TX " + gtx);
    }

    public void put(Transaction tx, GlobalTransaction gtx) {
        if (tx == null) {
            log.error((Object)"key (Transaction) is null");
            return;
        }
        this.tx2gtxMap.put(tx, gtx);
        this.gtx2TxMap.put(gtx, tx);
    }

    public TransactionContext get(GlobalTransaction gtx) {
        return gtx != null ? this.gtx2ContextMap.get(gtx) : null;
    }

    public void put(GlobalTransaction tx, TransactionContext transactionContext) {
        if (tx == null) {
            log.error((Object)"key (GlobalTransaction) is null");
            return;
        }
        this.gtx2ContextMap.put(tx, transactionContext);
    }

    public TransactionContext remove(GlobalTransaction tx) {
        if (tx == null) {
            return null;
        }
        this.gtx2TxMap.remove(tx);
        return this.gtx2ContextMap.remove(tx);
    }

    public GlobalTransaction remove(Transaction tx) {
        if (tx == null) {
            return null;
        }
        return this.tx2gtxMap.remove(tx);
    }

    public void remove(GlobalTransaction gtx, Transaction tx) {
        this.gtx2TxMap.remove(gtx);
        this.gtx2ContextMap.remove(gtx);
        this.tx2gtxMap.remove(tx);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.tx2gtxMap.size()).append(" mappings, ");
        sb.append(this.gtx2ContextMap.size()).append(" transactions");
        return sb.toString();
    }

    public String toString(boolean printDetails) {
        if (!printDetails) {
            return this.toString();
        }
        StringBuilder sb = new StringBuilder();
        sb.append("LocalTransactions: ").append(this.tx2gtxMap.size()).append("\n");
        sb.append("GlobalTransactions: ").append(this.gtx2ContextMap.size()).append("\n");
        sb.append("tx2gtxMap:\n");
        for (Map.Entry<Transaction, GlobalTransaction> entry : this.tx2gtxMap.entrySet()) {
            sb.append(entry.getKey()).append(": ").append(entry.getValue()).append("\n");
        }
        sb.append("gtx2EntryMap:\n");
        for (Map.Entry<Object, Object> entry : this.gtx2ContextMap.entrySet()) {
            sb.append(entry.getKey()).append(": ").append(entry.getValue()).append("\n");
        }
        return sb.toString();
    }

    public GlobalTransaction getCurrentTransaction() {
        return this.getCurrentTransaction(true);
    }

    public GlobalTransaction getCurrentTransaction(boolean createIfNotExists) {
        Transaction tx = this.getLocalTransaction();
        if (tx == null) {
            return null;
        }
        if (!TransactionTable.isValid(tx)) {
            int status = -1;
            try {
                status = tx.getStatus();
            }
            catch (SystemException e) {
                // empty catch block
            }
            if (status != 3) {
                log.warn((Object)("status is " + status + " (not ACTIVE or PREPARING); returning null)"));
            } else {
                log.trace((Object)"status is COMMITTED; returning null");
            }
            return null;
        }
        return this.getCurrentTransaction(tx, createIfNotExists);
    }

    protected Transaction getLocalTransaction() {
        if (this.transactionManager == null) {
            return null;
        }
        try {
            return this.transactionManager.getTransaction();
        }
        catch (Throwable t) {
            return null;
        }
    }

    public static boolean isActive(Transaction tx) {
        if (tx == null) {
            return false;
        }
        try {
            int status = tx.getStatus();
            return status == 0;
        }
        catch (SystemException e) {
            return false;
        }
    }

    public static boolean isPreparing(Transaction tx) {
        if (tx == null) {
            return false;
        }
        try {
            int status = tx.getStatus();
            return status == 7;
        }
        catch (SystemException e) {
            return false;
        }
    }

    public static boolean isMarkedAsRollback(Transaction tx) {
        if (tx == null) {
            return false;
        }
        try {
            int status = tx.getStatus();
            return status == 1;
        }
        catch (SystemException e) {
            return false;
        }
    }

    public static boolean isValid(Transaction tx) {
        return TransactionTable.isActive(tx) || TransactionTable.isPreparing(tx) || TransactionTable.isMarkedAsRollback(tx);
    }

    public static void assertTransactionValid(InvocationContext ctx) {
        Transaction tx = ctx.getTransaction();
        if (!TransactionTable.isValid(tx)) {
            try {
                throw new CacheException("Invalid transaction " + tx + ", status = " + (tx == null ? null : Integer.valueOf(tx.getStatus())));
            }
            catch (SystemException e) {
                throw new CacheException("Exception trying to analyse status of transaction " + tx, e);
            }
        }
    }

    public GlobalTransaction getCurrentTransaction(Transaction tx) {
        return this.getCurrentTransaction(tx, true);
    }

    public GlobalTransaction getCurrentTransaction(Transaction tx, boolean createIfNotExists) {
        GlobalTransaction gtx = this.get(tx);
        if (gtx == null && createIfNotExists) {
            TransactionContext transactionContext;
            Address addr = this.rpcManager.getLocalAddress();
            gtx = GlobalTransaction.create(addr);
            this.put(tx, gtx);
            try {
                transactionContext = this.contextFactory.createTransactionContext(tx);
            }
            catch (Exception e) {
                throw new CacheException("Unable to create a transaction entry!", e);
            }
            this.put(gtx, transactionContext);
            if (trace) {
                log.trace((Object)("created new GTX: " + gtx + ", local TX=" + tx));
            }
        }
        return gtx;
    }

    @ManagedAttribute(name="numberOfRegisteredTransactions", description="Number of registered transactions")
    public int getNumberOfRegisteredTransactions() {
        return this.tx2gtxMap.size();
    }

    @ManagedAttribute(name="transactionMap", description="A String representation of the transaction map")
    public String getTransactionMap() {
        return this.tx2gtxMap.toString();
    }
}

