/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.util;

import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.jboss.cache.Cache;
import org.jboss.cache.Fqn;
import org.jboss.cache.Node;
import org.jboss.cache.NodeSPI;
import org.jboss.cache.util.SimpleImmutableEntry;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Caches {
    private Caches() {
    }

    public static <K, V> Map<K, V> asMap(Cache<K, V> cache) {
        if (cache == null) {
            throw new NullPointerException("cache");
        }
        return Caches.asMap(cache.getRoot());
    }

    public static <K, V> Map<K, V> asMap(Node<K, V> node) {
        return new MapNode<K, V>(node);
    }

    public static <K, V> Map<K, V> asSimpleMap(Node<K, V> node) {
        return new SimpleMapNode<K, V>(node);
    }

    public static <K, V> Set<V> asSimpleSet(Node<K, V> node) {
        return new SimpleSetNode<K>(node);
    }

    public static <K, V> Map<K, V> asPartitionedMap(Node<K, V> node) {
        return new PartitionedMapNode<K, V>(node, HashKeySelector.DEFAULT);
    }

    public static <K, V> Map<K, V> asPartitionedMap(Node<K, V> node, ChildSelector<K> ss) {
        return new PartitionedMapNode<K, V>(node, ss);
    }

    public static <K, V> Map<K, V> asPartitionedMap(Cache<K, V> cache) {
        return Caches.asPartitionedMap(cache.getRoot());
    }

    protected static final int hashCode(int i) {
        i ^= i >>> 20 ^ i >>> 12;
        return i ^ i >>> 7 ^ i >>> 4;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class PartitionedMapNode<K, V>
    extends AbstractMap<K, V> {
        private NodeSPI node;
        private ChildSelector<K> selector;

        public PartitionedMapNode(Node<K, V> node, ChildSelector<K> selector) {
            this.node = (NodeSPI)node;
            this.selector = selector;
        }

        @Override
        public Set<Map.Entry<K, V>> entrySet() {
            return new AbstractSet<Map.Entry<K, V>>(){
                Iterator<Node> ci;
                {
                    this.ci = PartitionedMapNode.this.node.getChildren().iterator();
                }

                @Override
                public Iterator<Map.Entry<K, V>> iterator() {
                    return new Iterator<Map.Entry<K, V>>(){
                        Iterator ni;
                        {
                            this.nextChild();
                            this.findNext();
                        }

                        private void nextChild() {
                            this.ni = new SimpleMapNode(ci.next()).entrySet().iterator();
                        }

                        private void findNext() {
                            while (!this.ni.hasNext()) {
                                if (!ci.hasNext()) {
                                    return;
                                }
                                this.nextChild();
                            }
                        }

                        @Override
                        public boolean hasNext() {
                            return this.ni.hasNext();
                        }

                        @Override
                        public Map.Entry<K, V> next() {
                            Map.Entry n = (Map.Entry)this.ni.next();
                            this.findNext();
                            return n;
                        }

                        @Override
                        public void remove() {
                            this.ni.remove();
                        }
                    };
                }

                @Override
                public int size() {
                    return PartitionedMapNode.this.size();
                }
            };
        }

        @Override
        public Set keySet() {
            return new AbstractSet<Map.Entry<K, V>>(){

                @Override
                public Iterator<Map.Entry<K, V>> iterator() {
                    return PartitionedMapNode.super.keySet().iterator();
                }

                @Override
                public boolean remove(Object o) {
                    boolean key = PartitionedMapNode.this.containsKey(o);
                    PartitionedMapNode.this.remove(o);
                    return key;
                }

                @Override
                public boolean contains(Object o) {
                    return PartitionedMapNode.this.containsKey(o);
                }

                @Override
                public int size() {
                    return PartitionedMapNode.super.keySet().size();
                }
            };
        }

        @Override
        public void clear() {
            for (Object o : this.node.getChildrenNames()) {
                this.node.getChild(o).clearData();
            }
        }

        private Fqn fqnFor(Object o) {
            return Fqn.fromRelativeFqn(this.node.getFqn(), this.selector.childName(o));
        }

        @Override
        public boolean containsKey(Object o) {
            Fqn fqn = this.fqnFor(o);
            Set keys = this.node.getCache().getKeys(fqn);
            return keys != null && keys.contains(o);
        }

        @Override
        public V get(Object key) {
            return this.node.getCache().get(this.fqnFor(key), key);
        }

        @Override
        public Object put(Object key, Object value) {
            return this.node.getCache().put(this.fqnFor(key), key, value);
        }

        @Override
        public V remove(Object key) {
            return this.node.getCache().remove(this.fqnFor(key), key);
        }

        @Override
        public int size() {
            int size = 0;
            for (Object o : this.node.getChildrenNames()) {
                Node child = this.node.getChild(o);
                size += child.dataSize();
            }
            return size;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class SimpleSetNode<K>
    extends AbstractSet<K>
    implements Set<K> {
        private Node node;
        private static final String VALUE = "V";

        public <K, V> SimpleSetNode(Node<K, V> node) {
            if (node == null) {
                throw new NullPointerException("node");
            }
            this.node = node;
        }

        @Override
        public void clear() {
            this.node.clearData();
        }

        @Override
        public boolean contains(Object key) {
            return this.node.getKeys().contains(key);
        }

        @Override
        public boolean remove(Object key) {
            return this.node.remove(key) != null;
        }

        @Override
        public int size() {
            return this.node.dataSize();
        }

        @Override
        public boolean add(K arg0) {
            return this.node.put(arg0, VALUE) == null;
        }

        @Override
        public Iterator<K> iterator() {
            final Iterator i = this.node.getKeys().iterator();
            return new Iterator<K>(){
                K key;
                boolean next = false;

                @Override
                public boolean hasNext() {
                    return i.hasNext();
                }

                @Override
                public K next() {
                    this.key = i.next();
                    this.next = true;
                    return this.key;
                }

                @Override
                public void remove() {
                    if (!this.next) {
                        throw new IllegalStateException();
                    }
                    SimpleSetNode.this.node.remove(this.key);
                }
            };
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class SimpleMapNode<K, V>
    extends AbstractMap<K, V> {
        private Node<K, V> node;

        public SimpleMapNode(Node<K, V> node) {
            if (node == null) {
                throw new NullPointerException("node");
            }
            this.node = node;
        }

        @Override
        public void clear() {
            this.node.clearData();
        }

        @Override
        public boolean containsKey(Object key) {
            return this.node.getKeys().contains(key);
        }

        @Override
        public boolean containsValue(Object value) {
            return this.node.getData().containsValue(value);
        }

        @Override
        public Set<Map.Entry<K, V>> entrySet() {
            return this.node.getData().entrySet();
        }

        @Override
        public V get(Object key) {
            return this.node.get(key);
        }

        @Override
        public Set<K> keySet() {
            return this.node.getKeys();
        }

        @Override
        public V put(K key, V value) {
            return this.node.put(key, value);
        }

        @Override
        public void putAll(Map<? extends K, ? extends V> map) {
            this.node.putAll(map);
        }

        @Override
        public V remove(Object key) {
            return this.node.remove(key);
        }

        @Override
        public int size() {
            return this.node.dataSize();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class MapNode<K, V>
    extends AbstractMap<K, V> {
        public static final String KEY = "K";
        private Node node;

        public MapNode(Node<K, V> node) {
            if (node == null) {
                throw new NullPointerException("node");
            }
            this.node = node;
        }

        @Override
        public Set<Map.Entry<K, V>> entrySet() {
            return new AbstractSet<Map.Entry<K, V>>(){

                @Override
                public Iterator<Map.Entry<K, V>> iterator() {
                    final Iterator i = this.set().iterator();
                    return new Iterator<Map.Entry<K, V>>(){
                        Object name;
                        boolean next = false;

                        @Override
                        public boolean hasNext() {
                            return i.hasNext();
                        }

                        @Override
                        public Map.Entry<K, V> next() {
                            Node n = (Node)i.next();
                            this.name = n.getFqn().getLastElement();
                            this.next = true;
                            Object key = n.get(MapNode.KEY);
                            return new SimpleImmutableEntry(this.name, key);
                        }

                        @Override
                        public void remove() {
                            if (!this.next) {
                                throw new IllegalStateException();
                            }
                            MapNode.this.node.removeChild(this.name);
                        }

                        public String toString() {
                            return "Itr name=" + this.name;
                        }
                    };
                }

                private Set<Node<K, V>> set() {
                    return MapNode.this.node.getChildren();
                }

                @Override
                public int size() {
                    return this.set().size();
                }
            };
        }

        @Override
        public void clear() {
            for (Object o : this.node.getChildrenNames()) {
                this.node.removeChild(o);
            }
        }

        @Override
        public boolean containsKey(Object arg0) {
            return this.node.getChild(arg0) != null;
        }

        @Override
        public V get(Object arg0) {
            Node child = this.node.getChild(arg0);
            if (child == null) {
                return null;
            }
            return child.get(KEY);
        }

        @Override
        public boolean isEmpty() {
            return this.node.getChildrenNames().isEmpty();
        }

        @Override
        public Set<K> keySet() {
            return new AbstractSet<K>(){

                private Set set() {
                    return MapNode.this.node.getChildrenNames();
                }

                @Override
                public Iterator<K> iterator() {
                    final Iterator i = this.set().iterator();
                    return new Iterator<K>(){
                        K child;

                        @Override
                        public boolean hasNext() {
                            return i.hasNext();
                        }

                        @Override
                        public K next() {
                            this.child = i.next();
                            return this.child;
                        }

                        @Override
                        public void remove() {
                            if (this.child == null) {
                                throw new IllegalStateException();
                            }
                            MapNode.this.node.removeChild(this.child);
                        }
                    };
                }

                @Override
                public boolean remove(Object key) {
                    return MapNode.this.node.removeChild(key);
                }

                @Override
                public int size() {
                    return this.set().size();
                }
            };
        }

        @Override
        public V put(K arg0, V arg1) {
            return this.node.addChild(Fqn.fromElements(arg0)).put(KEY, arg1);
        }

        @Override
        public V remove(Object arg0) {
            Node child = this.node.getChild(arg0);
            if (child == null) {
                return null;
            }
            Object o = child.remove(KEY);
            this.node.removeChild(arg0);
            return o;
        }

        @Override
        public int size() {
            return this.node.getChildrenNames().size();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class HashKeySelector<T>
    implements ChildSelector<T> {
        static ChildSelector DEFAULT = new HashKeySelector(128);
        protected int segments;

        public HashKeySelector(int segments) {
            this.segments = segments;
            if (Integer.bitCount(segments) != 1) {
                throw new IllegalArgumentException();
            }
            if (segments <= 0) {
                throw new IllegalArgumentException();
            }
        }

        protected final int segmentFor(T key) {
            if (key == null) {
                return 0;
            }
            int hc = key.hashCode();
            return Caches.hashCode(hc) & this.segments - 1;
        }

        @Override
        protected final Fqn childName(int segment) {
            return Fqn.fromElements(Integer.toString(segment));
        }

        @Override
        public final Fqn childName(T key) {
            return this.childName(this.segmentFor(key));
        }

        public String toString() {
            return super.toString() + " segments=" + this.segments;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface ChildSelector<T> {
        public Fqn childName(T var1);
    }
}

