/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.idm.api;

import java.util.Collection;
import java.util.Map;
import org.picketlink.idm.api.Group;
import org.picketlink.idm.api.IdentitySearchCriteria;
import org.picketlink.idm.api.IdentitySession;
import org.picketlink.idm.api.IdentityType;
import org.picketlink.idm.api.Role;
import org.picketlink.idm.api.RoleManagerFeaturesDescription;
import org.picketlink.idm.api.RoleType;
import org.picketlink.idm.api.User;
import org.picketlink.idm.common.exception.IdentityException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public interface RoleManager {
    public IdentitySession getIdentitySession();

    public RoleManagerFeaturesDescription getSupportedFeatures();

    public IdentitySearchCriteria createIdentitySearchCriteria();

    public RoleType createRoleType(String var1) throws IdentityException;

    public void removeRoleType(String var1) throws IdentityException;

    public void removeRoleType(RoleType var1) throws IdentityException;

    public RoleType getRoleType(String var1) throws IdentityException;

    public Collection<RoleType> findRoleTypes(IdentitySearchCriteria var1) throws IdentityException;

    public Collection<RoleType> findRoleTypes() throws IdentityException;

    public Role createRole(RoleType var1, User var2, Group var3) throws IdentityException;

    public Role createRole(String var1, String var2, String var3) throws IdentityException;

    public Role getRole(RoleType var1, User var2, Group var3) throws IdentityException;

    public Role getRole(String var1, String var2, String var3) throws IdentityException;

    public void removeRole(RoleType var1, User var2, Group var3) throws IdentityException;

    public void removeRole(String var1, String var2, String var3) throws IdentityException;

    public void removeRole(Role var1) throws IdentityException;

    public boolean hasRole(User var1, Group var2, RoleType var3) throws IdentityException;

    public boolean hasRole(String var1, String var2, String var3) throws IdentityException;

    public Collection<RoleType> findRoleTypes(User var1, Group var2, IdentitySearchCriteria var3) throws IdentityException;

    public Collection<RoleType> findRoleTypes(String var1, String var2, IdentitySearchCriteria var3) throws IdentityException;

    public Collection<RoleType> findRoleTypes(User var1, Group var2) throws IdentityException;

    public Collection<RoleType> findUserRoleTypes(User var1) throws IdentityException;

    public Collection<RoleType> findUserRoleTypes(User var1, IdentitySearchCriteria var2) throws IdentityException;

    public Collection<RoleType> findUserRoleTypes(String var1, IdentitySearchCriteria var2) throws IdentityException;

    public Collection<RoleType> findGroupRoleTypes(Group var1) throws IdentityException;

    public Collection<RoleType> findGroupRoleTypes(Group var1, IdentitySearchCriteria var2) throws IdentityException;

    public Collection<RoleType> findGroupRoleTypes(String var1, IdentitySearchCriteria var2) throws IdentityException;

    public Collection<Group> findGroupsWithRelatedRole(User var1, IdentitySearchCriteria var2) throws IdentityException;

    public Collection<Group> findGroupsWithRelatedRole(String var1, IdentitySearchCriteria var2) throws IdentityException;

    public Collection<Group> findGroupsWithRelatedRole(User var1, String var2, IdentitySearchCriteria var3) throws IdentityException;

    public Collection<Group> findGroupsWithRelatedRole(String var1, String var2, IdentitySearchCriteria var3) throws IdentityException;

    public Collection<User> findUsersWithRelatedRole(Group var1, IdentitySearchCriteria var2) throws IdentityException;

    public Collection<User> findUsersWithRelatedRole(String var1, IdentitySearchCriteria var2) throws IdentityException;

    public <T extends IdentityType> Collection<Role> findRoles(T var1, RoleType var2) throws IdentityException;

    public <T extends IdentityType> Collection<Role> findRoles(String var1, String var2) throws IdentityException;

    public Map<String, String> getProperties(Role var1) throws IdentityException;

    public Map<String, String> getProperties(RoleType var1) throws IdentityException;

    public Map<String, String> getProperties(String var1) throws IdentityException;

    public void setProperty(Role var1, String var2, String var3) throws IdentityException;

    public void setProperty(RoleType var1, String var2, String var3) throws IdentityException;

    public void setProperty(String var1, String var2, String var3) throws IdentityException;

    public void setProperties(Role var1, Map<String, String> var2) throws IdentityException;

    public void setProperties(RoleType var1, Map<String, String> var2) throws IdentityException;

    public void setProperties(String var1, Map<String, String> var2) throws IdentityException;

    public void removeProperty(Role var1, String var2) throws IdentityException;

    public void removeProperty(RoleType var1, String var2) throws IdentityException;

    public void removeProperty(String var1, String var2) throws IdentityException;
}

