/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.config.parsing;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.jboss.cache.util.FileLookup;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public class ConfigFilesConvertor {
    public void parse(InputStream is, OutputStream os, String xsltFile) throws Exception {
        InputStream xsltInStream = new FileLookup().lookupFile(xsltFile);
        Document document = this.getInputDocument(is);
        Transformer transformer = this.getTransformer(xsltInStream);
        DOMSource source = new DOMSource(document);
        StreamResult result = new StreamResult(os);
        transformer.transform(source, result);
        xsltInStream.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void parse(String inputFile, OutputStream os, String xsltFile) throws Exception {
        InputStream stream = new FileLookup().lookupFile(inputFile);
        try {
            this.parse(stream, os, xsltFile);
            Object var6_5 = null;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            stream.close();
            throw throwable;
        }
        stream.close();
    }

    public static void main(String[] argv) throws Exception {
        File oldConfig;
        String destinationName;
        String sourceName = System.getProperty("source");
        if (sourceName == null) {
            System.err.println("Missing property 'source'.");
            System.exit(1);
        }
        if ((destinationName = System.getProperty("destination")) == null) {
            System.err.println("Missing property 'destination'.");
            System.exit(1);
        }
        if (!(oldConfig = new File(sourceName)).exists()) {
            System.err.println("File specified as input ('" + sourceName + ") does not exist.");
            System.exit(1);
        }
        ConfigFilesConvertor convertor = new ConfigFilesConvertor();
        File destination = new File(destinationName);
        if (!destination.exists()) {
            destination.createNewFile();
        }
        FileInputStream is = new FileInputStream(oldConfig);
        FileOutputStream fos = new FileOutputStream(destinationName);
        convertor.parse(is, (OutputStream)fos, "config2to3.xslt");
        is.close();
        System.out.println("---");
        System.out.println("New configuration file [" + destinationName + "] successfully created.");
        System.out.println("---");
    }

    private Transformer getTransformer(InputStream xsltInStream) throws TransformerConfigurationException {
        TransformerFactory tFactory = TransformerFactory.newInstance();
        StreamSource stylesource = new StreamSource(xsltInStream);
        return tFactory.newTransformer(stylesource);
    }

    private Document getInputDocument(InputStream is) throws ParserConfigurationException, SAXException, IOException {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = factory.newDocumentBuilder();
        return builder.parse(is);
    }
}

