/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.tests;

import java.util.ArrayList;
import java.util.LinkedList;
import junit.framework.Assert;
import junit.framework.TestCase;
import junit.textui.TestRunner;
import org.jgroups.TimeoutException;
import org.jgroups.util.Queue;
import org.jgroups.util.QueueClosedException;
import org.jgroups.util.Util;

public class QueueTest
extends TestCase {
    private Queue queue = null;

    public QueueTest(String Name_) {
        super(Name_);
    }

    public void setUp() throws Exception {
        super.setUp();
        this.queue = new Queue();
    }

    public void tearDown() throws Exception {
        super.tearDown();
        if (this.queue != null) {
            this.queue.reset();
        }
    }

    public void testQueue() {
        try {
            this.queue.add("Q1");
            this.queue.add("Q2");
            this.queue.add("Q3");
            QueueTest.assertEquals((Object)"Q1", (Object)this.queue.peek());
            QueueTest.assertEquals((Object)"Q1", (Object)this.queue.remove());
            QueueTest.assertEquals((Object)"Q2", (Object)this.queue.peek());
            QueueTest.assertEquals((Object)"Q2", (Object)this.queue.remove());
            this.queue.addAtHead("Q4");
            this.queue.add("Q5");
            QueueTest.assertEquals((Object)"Q4", (Object)this.queue.peek());
            QueueTest.assertEquals((Object)"Q4", (Object)this.queue.remove());
            this.queue.close(true);
            try {
                this.queue.add("Q6");
                QueueTest.fail((String)"should not get here");
            }
            catch (QueueClosedException qc) {
                QueueTest.assertTrue((boolean)true);
            }
            int size = this.queue.size();
            this.queue.removeElement("Q5");
            QueueTest.assertEquals((int)(size - 1), (int)this.queue.size());
            QueueTest.assertEquals((Object)"Q3", (Object)this.queue.peek());
            QueueTest.assertEquals((Object)"Q3", (Object)this.queue.remove());
            QueueTest.assertTrue((boolean)this.queue.closed());
            System.out.println("Everything is ok");
        }
        catch (Exception x) {
            System.out.println(x);
            QueueTest.fail();
        }
    }

    public void testCloseWithoutFlush() {
        this.queue.close(false);
        try {
            this.queue.remove();
            QueueTest.fail((String)"we should have gotten a QueueClosedException trying to remove an element from a closed queue");
        }
        catch (QueueClosedException e) {
            QueueTest.assertTrue((String)"queue is closed, this is okay", (boolean)this.queue.closed());
        }
    }

    public void testCloseWithFlush() {
        this.queue.close(true);
        try {
            this.queue.remove();
            QueueTest.fail((String)"we should have gotten a QueueClosedException trying to remove an element from a closed queue");
        }
        catch (QueueClosedException e) {
            QueueTest.assertTrue((String)"queue is closed, this is okay", (boolean)this.queue.closed());
        }
    }

    public void testCloseWithFlush2() throws QueueClosedException {
        this.queue.add(new Integer(1));
        this.queue.add(new Integer(2));
        this.queue.add(new Integer(3));
        this.queue.close(true);
        try {
            for (int i = 1; i <= 3; ++i) {
                Object obj = this.queue.remove();
                QueueTest.assertNotNull((Object)obj);
                QueueTest.assertEquals((Object)obj, (Object)new Integer(i));
            }
            this.queue.remove();
            QueueTest.fail((String)"we should have gotten a QueueClosedException trying to remove an element from a closed queue");
        }
        catch (QueueClosedException e) {
            QueueTest.assertTrue((String)"queue is closed, this is okay", (boolean)this.queue.closed());
        }
    }

    public void testValues() throws QueueClosedException {
        this.queue.add(new Integer(1));
        this.queue.add(new Integer(3));
        this.queue.add(new Integer(99));
        this.queue.add(new Integer(8));
        System.out.println("queue: " + Util.dumpQueue(this.queue));
        int size = this.queue.size();
        QueueTest.assertEquals((int)4, (int)size);
        LinkedList values = this.queue.values();
        QueueTest.assertEquals((int)size, (int)values.size());
    }

    public void testLargeInsertion() {
        String element = "MyElement";
        try {
            System.out.println("Inserting 100000 elements");
            long start = System.currentTimeMillis();
            for (int i = 0; i < 100000; ++i) {
                this.queue.add(element);
            }
            long stop = System.currentTimeMillis();
            System.out.println("Took " + (stop - start) + " msecs");
            System.out.println("Removing 100000 elements");
            start = System.currentTimeMillis();
            while (this.queue.size() > 0) {
                this.queue.remove();
            }
            stop = System.currentTimeMillis();
            System.out.println("Took " + (stop - start) + " msecs");
        }
        catch (Exception ex) {
            System.err.println(ex);
            QueueTest.fail();
        }
    }

    public void testEmptyQueue() {
        QueueTest.assertNull((Object)this.queue.getFirst());
        QueueTest.assertNull((Object)this.queue.getLast());
        QueueTest.assertEquals((Object)this.queue.getFirst(), (Object)this.queue.getLast());
    }

    public void testAddAll() throws QueueClosedException {
        ArrayList<Object> l = new ArrayList<Object>();
        l.add("one");
        l.add("two");
        l.add("three");
        this.queue.addAll(l);
        System.out.println("queue is " + this.queue);
        QueueTest.assertEquals((int)3, (int)this.queue.size());
        QueueTest.assertEquals((Object)"one", (Object)this.queue.remove());
        QueueTest.assertEquals((int)2, (int)this.queue.size());
        QueueTest.assertEquals((Object)"two", (Object)this.queue.remove());
        QueueTest.assertEquals((int)1, (int)this.queue.size());
        QueueTest.assertEquals((Object)"three", (Object)this.queue.remove());
        QueueTest.assertEquals((int)0, (int)this.queue.size());
    }

    public void testInsertionAndRemoval() throws Exception {
        String s1 = "Q1";
        String s2 = "Q2";
        this.queue.add(s1);
        QueueTest.assertTrue((this.queue.getFirst() != null ? 1 : 0) != 0);
        QueueTest.assertTrue((this.queue.getLast() != null ? 1 : 0) != 0);
        QueueTest.assertEquals((Object)this.queue.getFirst(), (Object)this.queue.getLast());
        this.queue.add(s2);
        QueueTest.assertTrue((this.queue.getFirst() != this.queue.getLast() ? 1 : 0) != 0);
        Object o1 = this.queue.peek();
        Object o2 = this.queue.getFirst();
        System.out.println("o1=" + o1 + ", o2=" + o2 + ", o1.equals(o2)=" + o1.equals(o2));
        QueueTest.assertEquals((Object)this.queue.peek(), (Object)this.queue.getFirst());
        this.queue.remove();
        QueueTest.assertEquals((int)1, (int)this.queue.size());
        QueueTest.assertEquals((Object)this.queue.getFirst(), (Object)this.queue.getLast());
        this.queue.remove();
        QueueTest.assertEquals((int)0, (int)this.queue.size());
        QueueTest.assertTrue((this.queue.getFirst() == null ? 1 : 0) != 0);
        QueueTest.assertTrue((this.queue.getLast() == null ? 1 : 0) != 0);
    }

    public void testWaitUntilClosed() {
        this.queue.close(true);
        this.queue.waitUntilClosed(0L);
        QueueTest.assertEquals((int)0, (int)this.queue.size());
    }

    public void testWaitUntilClosed2() {
        this.queue.close(true);
        try {
            this.queue.peek();
            QueueTest.fail((String)"peek() should throw a QueueClosedException");
        }
        catch (QueueClosedException e) {
            QueueTest.assertTrue((e != null ? 1 : 0) != 0);
        }
        QueueTest.assertEquals((int)0, (int)this.queue.size());
    }

    public void testWaitUntilClosed3() throws QueueClosedException {
        this.queue.add("one");
        this.queue.close(true);
        Object obj = this.queue.peek();
        QueueTest.assertEquals((Object)"one", (Object)obj);
        QueueTest.assertEquals((int)1, (int)this.queue.size());
        this.queue.remove();
        try {
            this.queue.peek();
            QueueTest.fail((String)"peek() should throw a QueueClosedException");
        }
        catch (QueueClosedException e) {
            QueueTest.assertTrue((e != null ? 1 : 0) != 0);
        }
        QueueTest.assertEquals((int)0, (int)this.queue.size());
    }

    public void testWaitUntilClosed4() throws QueueClosedException {
        for (int i = 0; i < 10; ++i) {
            this.queue.add(new Integer(i));
        }
        new Thread(){

            public void run() {
                while (!QueueTest.this.queue.closed()) {
                    try {
                        System.out.println("-- removed " + QueueTest.this.queue.remove());
                        Util.sleep(200L);
                    }
                    catch (QueueClosedException e) {
                        break;
                    }
                }
            }
        }.start();
        this.queue.close(true);
        this.queue.waitUntilClosed(0L);
        QueueTest.assertEquals((int)0, (int)this.queue.size());
    }

    public void testWaitUntilClosed5() throws QueueClosedException {
        for (int i = 0; i < 10; ++i) {
            this.queue.add(new Integer(i));
        }
        new Thread(){

            public void run() {
                while (!QueueTest.this.queue.closed()) {
                    try {
                        System.out.println("-- removed " + QueueTest.this.queue.remove());
                        Util.sleep(200L);
                    }
                    catch (QueueClosedException e) {
                        System.out.println("-- queue is closed, cannot remove element");
                        break;
                    }
                }
            }
        }.start();
        Util.sleep(600L);
        this.queue.close(false);
        this.queue.waitUntilClosed(0L);
        QueueTest.assertTrue((this.queue.size() > 0 ? 1 : 0) != 0);
    }

    public void testRemoveElementNoElement() {
        String s1 = "Q1";
        try {
            this.queue.removeElement(s1);
            QueueTest.assertFalse((boolean)this.queue.closed());
            QueueTest.assertEquals((int)0, (int)this.queue.size());
        }
        catch (QueueClosedException ex) {
            QueueTest.fail((String)ex.toString());
        }
    }

    public void testRemoveElementOneElement() {
        String s1 = "Q1";
        try {
            this.queue.add(s1);
            this.queue.removeElement(s1);
            QueueTest.assertEquals((int)0, (int)this.queue.size());
            QueueTest.assertTrue((this.queue.getFirst() == null ? 1 : 0) != 0);
            QueueTest.assertTrue((this.queue.getLast() == null ? 1 : 0) != 0);
        }
        catch (QueueClosedException ex) {
            QueueTest.fail((String)ex.toString());
        }
    }

    public void testRemoveElementTwoElementsFirstFound() {
        String s1 = "Q1";
        String s2 = "Q2";
        try {
            this.queue.add(s1);
            this.queue.add(s2);
            this.queue.removeElement(s1);
            QueueTest.assertEquals((int)1, (int)this.queue.size());
            QueueTest.assertEquals((Object)this.queue.getFirst(), (Object)s2);
            QueueTest.assertEquals((Object)this.queue.getLast(), (Object)s2);
            QueueTest.assertEquals((Object)this.queue.getFirst(), (Object)this.queue.getLast());
        }
        catch (QueueClosedException ex) {
            QueueTest.fail((String)ex.toString());
        }
    }

    public void testRemoveElementTwoElementsSecondFound() {
        String s1 = "Q1";
        String s2 = "Q2";
        try {
            this.queue.add(s1);
            this.queue.add(s2);
            this.queue.removeElement(s2);
            QueueTest.assertEquals((int)1, (int)this.queue.size());
            QueueTest.assertEquals((Object)this.queue.getFirst(), (Object)s1);
            QueueTest.assertEquals((Object)this.queue.getLast(), (Object)s1);
            QueueTest.assertEquals((Object)this.queue.getFirst(), (Object)this.queue.getLast());
        }
        catch (QueueClosedException ex) {
            QueueTest.fail((String)ex.toString());
        }
    }

    public void testRemoveElementThreeElementsFirstFound() {
        String s1 = "Q1";
        String s2 = "Q2";
        String s3 = "Q3";
        try {
            this.queue.add(s1);
            this.queue.add(s2);
            this.queue.add(s3);
            this.queue.removeElement(s1);
            QueueTest.assertEquals((int)2, (int)this.queue.size());
            QueueTest.assertEquals((Object)this.queue.getFirst(), (Object)s2);
            QueueTest.assertEquals((Object)this.queue.getLast(), (Object)s3);
        }
        catch (QueueClosedException ex) {
            QueueTest.fail((String)ex.toString());
        }
    }

    public void testRemoveElementThreeElementsSecondFound() {
        String s1 = "Q1";
        String s2 = "Q2";
        String s3 = "Q3";
        try {
            this.queue.add(s1);
            this.queue.add(s2);
            this.queue.add(s3);
            this.queue.removeElement(s2);
            QueueTest.assertEquals((int)2, (int)this.queue.size());
            QueueTest.assertEquals((Object)this.queue.getFirst(), (Object)s1);
            QueueTest.assertEquals((Object)this.queue.getLast(), (Object)s3);
        }
        catch (QueueClosedException ex) {
            QueueTest.fail((String)ex.toString());
        }
    }

    public void testRemoveElementThreeElementsThirdFound() {
        String s1 = "Q1";
        String s2 = "Q2";
        String s3 = "Q3";
        try {
            this.queue.add(s1);
            this.queue.add(s2);
            this.queue.add(s3);
            this.queue.removeElement(s3);
            QueueTest.assertEquals((int)2, (int)this.queue.size());
            QueueTest.assertEquals((Object)this.queue.getFirst(), (Object)s1);
            QueueTest.assertEquals((Object)this.queue.getLast(), (Object)s2);
        }
        catch (QueueClosedException ex) {
            QueueTest.fail((String)ex.toString());
        }
    }

    public void testRemoveAndClose() {
        try {
            new Thread(){

                public void run() {
                    Util.sleep(1000L);
                    QueueTest.this.queue.close(true);
                }
            }.start();
            this.queue.remove();
            QueueTest.fail((String)"we should not be able to remove an object from a closed queue");
        }
        catch (QueueClosedException ex) {
            QueueTest.assertTrue((boolean)(ex instanceof QueueClosedException));
        }
    }

    public void testRemoveAndCloseWithTimeout() throws TimeoutException {
        try {
            new Thread(){

                public void run() {
                    Util.sleep(1000L);
                    QueueTest.this.queue.close(true);
                }
            }.start();
            this.queue.remove(5000L);
            QueueTest.fail((String)"we should not be able to remove an object from a closed queue");
        }
        catch (QueueClosedException ex) {
            QueueTest.assertTrue((boolean)(ex instanceof QueueClosedException));
        }
        catch (TimeoutException timeout) {
            QueueTest.fail((String)"we should not get a TimeoutException, but a QueueClosedException here");
        }
    }

    public void testInterruptAndRemove() throws QueueClosedException {
        Thread.currentThread().interrupt();
        Object el = null;
        try {
            el = this.queue.remove(2000L);
            QueueTest.fail((String)"we should not get here");
        }
        catch (TimeoutException e) {
            QueueTest.assertNull(el);
        }
    }

    public void testRemoveAndInterrupt() {
        Thread closer = new Thread(){

            public void run() {
                Util.sleep(1000L);
                System.out.println("-- closing queue");
                QueueTest.this.queue.close(false);
            }
        };
        closer.start();
        System.out.println("-- removing element");
        try {
            this.queue.remove();
            QueueTest.fail((String)"we should not get here, as the queue is closed");
        }
        catch (QueueClosedException e) {
            System.out.println("-- received queue closed exception - as expected");
        }
    }

    public void testClear() throws QueueClosedException {
        this.queue.add("one");
        this.queue.add("two");
        QueueTest.assertEquals((int)2, (int)this.queue.size());
        this.queue.close(true);
        QueueTest.assertEquals((int)2, (int)this.queue.size());
        this.queue.clear();
        QueueTest.assertEquals((int)0, (int)this.queue.size());
        this.queue = new Queue();
        this.queue.add("one");
        this.queue.add("two");
        this.queue.clear();
        QueueTest.assertEquals((int)0, (int)this.queue.size());
        this.queue.add("one");
        this.queue.add("two");
        QueueTest.assertEquals((int)2, (int)this.queue.size());
        this.queue.clear();
        QueueTest.assertEquals((int)0, (int)this.queue.size());
    }

    public void testBarrier() {
        RemoveOneItem[] removers = new RemoveOneItem[10];
        int num_dead = 0;
        for (int i = 0; i < removers.length; ++i) {
            removers[i] = new RemoveOneItem(i);
            removers[i].start();
        }
        Util.sleep(1000L);
        System.out.println("-- adding element 99");
        try {
            this.queue.add(new Long(99L));
        }
        catch (Exception ex) {
            System.err.println(ex);
        }
        Util.sleep(5000L);
        System.out.println("-- adding element 100");
        try {
            this.queue.add(new Long(100L));
        }
        catch (Exception ex) {
            System.err.println(ex);
        }
        Util.sleep(1000L);
        for (int i = 0; i < removers.length; ++i) {
            System.out.println("remover #" + i + " is " + (removers[i].isAlive() ? "alive" : "terminated"));
            if (removers[i].isAlive()) continue;
            ++num_dead;
        }
        QueueTest.assertEquals((int)2, (int)num_dead);
    }

    public void testBarrierWithTimeOut() {
        int i;
        RemoveOneItemWithTimeout[] removers = new RemoveOneItemWithTimeout[10];
        int num_dead = 0;
        for (int i2 = 0; i2 < removers.length; ++i2) {
            removers[i2] = new RemoveOneItemWithTimeout(i2, 1000L);
            removers[i2].start();
        }
        Util.sleep(5000L);
        System.out.println("-- adding element 99");
        try {
            this.queue.add(new Long(99L));
        }
        catch (Exception ex) {
            System.err.println(ex);
        }
        Util.sleep(5000L);
        System.out.println("-- adding element 100");
        try {
            this.queue.add(new Long(100L));
        }
        catch (Exception ex) {
            System.err.println(ex);
        }
        Util.sleep(1000L);
        for (i = 0; i < removers.length; ++i) {
            System.out.println("remover #" + i + " is " + (removers[i].isAlive() ? "alive" : "terminated"));
            if (removers[i].isAlive()) continue;
            ++num_dead;
        }
        QueueTest.assertEquals((int)2, (int)num_dead);
        this.queue.close(false);
        Util.sleep(2000L);
        num_dead = 0;
        for (i = 0; i < removers.length; ++i) {
            System.out.println("remover #" + i + " is " + (removers[i].isAlive() ? "alive" : "terminated"));
            if (removers[i].isAlive()) continue;
            ++num_dead;
        }
        QueueTest.assertEquals((int)10, (int)num_dead);
    }

    public void testMultipleWriterOneReader() {
        int i;
        AddOneItem[] adders = new AddOneItem[10];
        int num_dead = 0;
        int num_items = 0;
        int items = 1000;
        for (i = 0; i < adders.length; ++i) {
            adders[i] = new AddOneItem(i, items);
            adders[i].start();
        }
        while (num_items < adders.length * items) {
            try {
                this.queue.remove();
                ++num_items;
            }
            catch (Exception ex) {
                System.err.println(ex);
            }
        }
        Util.sleep(1000L);
        for (i = 0; i < adders.length; ++i) {
            System.out.println("adder #" + i + " is " + (adders[i].isAlive() ? "alive" : "terminated"));
            if (adders[i].isAlive()) continue;
            ++num_dead;
        }
        QueueTest.assertEquals((int)10, (int)num_dead);
        this.queue.close(false);
    }

    public void testConcurrentAddRemove() {
        long NUM = 1000000L;
        long num_received = 0L;
        long start = System.currentTimeMillis();
        new Thread(){

            public void run() {
                int i = 0;
                while ((long)i < 1000000L) {
                    try {
                        QueueTest.this.queue.add(new Object());
                    }
                    catch (QueueClosedException queueClosedException) {
                        // empty catch block
                    }
                    ++i;
                }
            }
        }.start();
        while (num_received < 1000000L) {
            try {
                Object ret = this.queue.remove();
                if (ret == null) continue;
                ++num_received;
            }
            catch (QueueClosedException e) {
                e.printStackTrace();
                QueueTest.fail();
            }
        }
        QueueTest.assertEquals((long)1000000L, (long)num_received);
        long stop = System.currentTimeMillis();
        System.out.println("time to add/remove 1000000 elements: " + (stop - start));
    }

    public void testConcurrentAccess() {
        int i;
        int NUM_THREADS = 10;
        int INTERVAL = 20000;
        Writer[] writers = new Writer[10];
        Reader[] readers = new Reader[10];
        int[] writes = new int[10];
        int[] reads = new int[10];
        long total_reads = 0L;
        long total_writes = 0L;
        for (i = 0; i < writers.length; ++i) {
            readers[i] = new Reader(i, reads);
            readers[i].start();
            writers[i] = new Writer(i, writes);
            writers[i].start();
        }
        Util.sleep(20000L);
        System.out.println("current queue size=" + this.queue.size());
        for (i = 0; i < writers.length; ++i) {
            writers[i].stopThread();
        }
        for (i = 0; i < readers.length; ++i) {
            readers[i].stopThread();
        }
        this.queue.close(false);
        System.out.println("current queue size=" + this.queue.size());
        for (i = 0; i < writers.length; ++i) {
            try {
                writers[i].join(300L);
                readers[i].join(300L);
                continue;
            }
            catch (Exception ex) {
                System.err.println(ex);
            }
        }
        for (i = 0; i < writes.length; ++i) {
            System.out.println("Thread #" + i + ": " + writes[i] + " writes, " + reads[i] + " reads");
            total_writes += (long)writes[i];
            total_reads += (long)reads[i];
        }
        System.out.println("total writes=" + total_writes + ", total_reads=" + total_reads + ", diff=" + Math.abs(total_writes - total_reads));
    }

    public static void main(String[] args) {
        String[] testCaseName = new String[]{QueueTest.class.getName()};
        TestRunner.main((String[])testCaseName);
    }

    class Reader
    extends Thread {
        int rank;
        int num_reads;
        int[] reads;
        boolean running;

        Reader(int i, int[] reads) {
            super("ReaderThread");
            this.num_reads = 0;
            this.reads = null;
            this.running = true;
            this.rank = i;
            this.reads = reads;
            this.setDaemon(true);
        }

        public void run() {
            while (this.running) {
                try {
                    Long el = (Long)QueueTest.this.queue.remove();
                    if (el == null) {
                        System.out.println("QueueTest.Reader.run(): peek() returned null element. queue.size()=" + QueueTest.this.queue.size() + ", queue.closed()=" + QueueTest.this.queue.closed());
                    }
                    Assert.assertNotNull((Object)el);
                    ++this.num_reads;
                }
                catch (QueueClosedException closed) {
                    this.running = false;
                }
                catch (Throwable t) {
                    System.err.println("QueueTest.Reader.run(): exception=" + t);
                }
            }
            this.reads[this.rank] = this.num_reads;
        }

        void stopThread() {
            this.running = false;
        }
    }

    class Writer
    extends Thread {
        int rank;
        int num_writes;
        boolean running;
        int[] writes;

        Writer(int i, int[] writes) {
            super("WriterThread");
            this.rank = 0;
            this.num_writes = 0;
            this.running = true;
            this.writes = null;
            this.rank = i;
            this.writes = writes;
            this.setDaemon(true);
        }

        public void run() {
            while (this.running) {
                try {
                    QueueTest.this.queue.add(new Long(System.currentTimeMillis()));
                    ++this.num_writes;
                }
                catch (QueueClosedException closed) {
                    this.running = false;
                }
                catch (Throwable t) {
                    System.err.println("QueueTest.Writer.run(): exception=" + t);
                }
            }
            this.writes[this.rank] = this.num_writes;
        }

        void stopThread() {
            this.running = false;
        }
    }

    class RemoveOneItemWithTimeout
    extends Thread {
        Long retval;
        int rank;
        long timeout;

        RemoveOneItemWithTimeout(int rank, long timeout) {
            super("RemoveOneItem thread #" + rank);
            this.retval = null;
            this.rank = 0;
            this.timeout = 0L;
            this.rank = rank;
            this.timeout = timeout;
            this.setDaemon(true);
        }

        public void run() {
            boolean finished = false;
            while (!finished) {
                try {
                    this.retval = (Long)QueueTest.this.queue.remove(this.timeout);
                    finished = true;
                }
                catch (QueueClosedException closed) {
                    System.err.println("Thread #" + this.rank + ": queue was closed");
                    finished = true;
                }
                catch (TimeoutException timeoutException) {}
            }
        }

        Long getRetval() {
            return this.retval;
        }
    }

    class RemoveOneItem
    extends Thread {
        Long retval;
        int rank;

        RemoveOneItem(int rank) {
            super("RemoveOneItem thread #" + rank);
            this.retval = null;
            this.rank = 0;
            this.rank = rank;
            this.setDaemon(true);
        }

        public void run() {
            try {
                this.retval = (Long)QueueTest.this.queue.remove();
            }
            catch (QueueClosedException closed) {
                System.err.println("Thread #" + this.rank + ": queue was closed");
            }
        }

        Long getRetval() {
            return this.retval;
        }
    }

    class AddOneItem
    extends Thread {
        Long retval;
        int rank;
        int iteration;

        AddOneItem(int rank, int iteration) {
            super("AddOneItem thread #" + rank);
            this.retval = null;
            this.rank = 0;
            this.iteration = 0;
            this.rank = rank;
            this.iteration = iteration;
            this.setDaemon(true);
        }

        public void run() {
            try {
                for (int i = 0; i < this.iteration; ++i) {
                    QueueTest.this.queue.add(new Long(this.rank));
                }
            }
            catch (QueueClosedException closed) {
                System.err.println("Thread #" + this.rank + ": queue was closed");
            }
        }
    }
}

