/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.idm.impl.api.session.mapper;

import java.io.Serializable;
import java.util.Collections;
import java.util.Map;
import org.picketlink.idm.impl.api.session.mapper.IdentityObjectTypeMapper;
import org.picketlink.idm.impl.types.SimpleIdentityObjectType;
import org.picketlink.idm.spi.model.IdentityObjectType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IdentityObjectTypeMapperImpl
implements IdentityObjectTypeMapper,
Serializable {
    private final Map<String, String> groupTypeMap;
    private final String identityTypeName;

    public IdentityObjectTypeMapperImpl(Map<String, String> map, String identityTypeName) {
        this.groupTypeMap = Collections.unmodifiableMap(map);
        this.identityTypeName = identityTypeName;
    }

    @Override
    public IdentityObjectType getIdentityObjectType() {
        return new SimpleIdentityObjectType(this.identityTypeName);
    }

    @Override
    public IdentityObjectType getIdentityObjectType(String groupType) {
        if (groupType == null) {
            throw new IllegalArgumentException("groupType is null");
        }
        for (Map.Entry<String, String> entry : this.groupTypeMap.entrySet()) {
            if (!entry.getValue().equals(groupType)) continue;
            return new SimpleIdentityObjectType(entry.getKey());
        }
        return null;
    }

    @Override
    public String getGroupType(IdentityObjectType identityObjectType) {
        if (identityObjectType == null) {
            throw new IllegalArgumentException("identityObjectType is null");
        }
        return this.groupTypeMap.get(identityObjectType.getName());
    }

    @Override
    public boolean isGroupType(IdentityObjectType identityObjectType) {
        if (identityObjectType == null) {
            throw new IllegalArgumentException("identityObjectType is null");
        }
        if (this.isIdentity(identityObjectType)) {
            return false;
        }
        return this.groupTypeMap.containsKey(identityObjectType.getName());
    }

    @Override
    public boolean isIdentity(IdentityObjectType identityObjectType) {
        if (identityObjectType == null) {
            throw new IllegalArgumentException("identityObjectType is null");
        }
        return identityObjectType.getName().equals(this.identityTypeName);
    }
}

