/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.config;

import net.jcip.annotations.Immutable;
import org.jboss.cache.config.ConfigurationComponent;
import org.jboss.cache.interceptors.base.CommandInterceptor;

@Immutable
public class CustomInterceptorConfig
extends ConfigurationComponent {
    private CommandInterceptor interceptor;
    private boolean isFirst;
    private boolean isLast;
    private int index = -1;
    private String afterClass;
    private String beforeClass;

    public CustomInterceptorConfig(CommandInterceptor interceptor, boolean first, boolean last, int index, String afterClass, String beforeClass) {
        this.interceptor = interceptor;
        this.isFirst = first;
        this.isLast = last;
        this.index = index;
        this.afterClass = afterClass;
        this.beforeClass = beforeClass;
    }

    public CustomInterceptorConfig(CommandInterceptor interceptor) {
        this.interceptor = interceptor;
    }

    public void setFirst(boolean first) {
        this.testImmutability("first");
        this.isFirst = first;
    }

    public void setLast(boolean last) {
        this.testImmutability("last");
        this.isLast = last;
    }

    public void setIndex(int index) {
        this.testImmutability("index");
        this.index = index;
    }

    public void setAfterClass(String afterClass) {
        this.testImmutability("afterClass");
        this.afterClass = afterClass;
    }

    public void setBeforeClass(String beforeClass) {
        this.testImmutability("beforeClass");
        this.beforeClass = beforeClass;
    }

    public CommandInterceptor getInterceptor() {
        return this.interceptor;
    }

    public boolean isFirst() {
        return this.isFirst;
    }

    public boolean isLast() {
        return this.isLast;
    }

    public int getIndex() {
        return this.index;
    }

    public String getAfterClass() {
        return this.afterClass;
    }

    public String getBeforeClass() {
        return this.beforeClass;
    }

    public String toString() {
        return "CustomInterceptorConfig{interceptor='" + this.interceptor + '\'' + ", isFirst=" + this.isFirst + ", isLast=" + this.isLast + ", index=" + this.index + ", afterClass='" + this.afterClass + '\'' + ", beforeClass='" + this.beforeClass + '\'' + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof CustomInterceptorConfig)) {
            return false;
        }
        CustomInterceptorConfig that = (CustomInterceptorConfig)o;
        if (this.index != that.index) {
            return false;
        }
        if (this.isFirst != that.isFirst) {
            return false;
        }
        if (this.isLast != that.isLast) {
            return false;
        }
        if (this.afterClass != null ? !this.afterClass.equals(that.afterClass) : that.afterClass != null) {
            return false;
        }
        if (this.beforeClass != null ? !this.beforeClass.equals(that.beforeClass) : that.beforeClass != null) {
            return false;
        }
        return !(this.interceptor != null ? !this.interceptor.equals(that.interceptor) : that.interceptor != null);
    }

    public int hashCode() {
        int result = this.interceptor != null ? this.interceptor.hashCode() : 0;
        result = 31 * result + (this.isFirst ? 1 : 0);
        result = 31 * result + (this.isLast ? 1 : 0);
        result = 31 * result + this.index;
        result = 31 * result + (this.afterClass != null ? this.afterClass.hashCode() : 0);
        result = 31 * result + (this.beforeClass != null ? this.beforeClass.hashCode() : 0);
        return result;
    }

    public CustomInterceptorConfig clone() throws CloneNotSupportedException {
        CustomInterceptorConfig dolly = (CustomInterceptorConfig)super.clone();
        dolly.interceptor = this.interceptor;
        dolly.isFirst = this.isFirst;
        dolly.isLast = this.isLast;
        dolly.afterClass = this.afterClass;
        dolly.beforeClass = this.beforeClass;
        return dolly;
    }
}

