/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.factories;

import javax.transaction.TransactionManager;
import org.jboss.cache.config.ConfigurationException;
import org.jboss.cache.factories.ComponentFactory;
import org.jboss.cache.factories.annotations.DefaultFactoryFor;
import org.jboss.cache.transaction.BatchModeTransactionManager;
import org.jboss.cache.transaction.TransactionManagerLookup;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@DefaultFactoryFor(classes={TransactionManager.class})
public class TransactionManagerFactory
extends ComponentFactory {
    @Override
    protected <T> T construct(Class<T> componentType) {
        TransactionManager transactionManager = this.configuration.getRuntimeConfig().getTransactionManager();
        TransactionManagerLookup lookup = null;
        if (transactionManager == null) {
            if (this.configuration.getTransactionManagerLookupClass() != null) {
                try {
                    ClassLoader cl = Thread.currentThread().getContextClassLoader();
                    if (cl == null) {
                        cl = this.getClass().getClassLoader();
                    }
                    Class<?> clazz = cl.loadClass(this.configuration.getTransactionManagerLookupClass());
                    lookup = (TransactionManagerLookup)clazz.newInstance();
                }
                catch (Exception e) {
                    throw new ConfigurationException("Problems looking up transaction manager", e);
                }
            }
            try {
                if (lookup != null) {
                    transactionManager = lookup.getTransactionManager();
                    this.configuration.getRuntimeConfig().setTransactionManager(transactionManager);
                }
            }
            catch (Exception e) {
                this.log.info((Object)"failed looking up TransactionManager, will not use transactions", (Throwable)e);
            }
        }
        if (transactionManager == null && this.configuration.isInvocationBatchingEnabled()) {
            this.log.info((Object)"Using a batchMode transaction manager");
            transactionManager = BatchModeTransactionManager.getInstance();
        }
        return componentType.cast(transactionManager);
    }
}

