/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.idm.impl.model.hibernate;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.picketlink.idm.common.exception.PolicyValidationException;
import org.picketlink.idm.impl.model.hibernate.HibernateIdentityObjectAttribute;
import org.picketlink.idm.impl.model.hibernate.HibernateIdentityObjectCredential;
import org.picketlink.idm.impl.model.hibernate.HibernateIdentityObjectRelationship;
import org.picketlink.idm.impl.model.hibernate.HibernateIdentityObjectType;
import org.picketlink.idm.impl.model.hibernate.HibernateRealm;
import org.picketlink.idm.spi.model.IdentityObject;
import org.picketlink.idm.spi.model.IdentityObjectCredentialType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HibernateIdentityObject
implements IdentityObject {
    public static final String findIdentityObjectByNameAndType = "select o from HibernateIdentityObject o where o.realm.name = :realmName and o.name = :name and o.identityType.name = :typeName";
    public static final String findIdentityObjectsByType = "select o from HibernateIdentityObject o where o.name like :nameFilter and o.realm.name = :realmName and o.identityType.name = :typeName";
    public static final String findIdentityObjectsByTypeOrderedByNameAsc = "select o from HibernateIdentityObject o where o.name like :nameFilter and o.realm.name = :realmName and o.identityType.name = :typeName  order by o.name asc";
    public static final String findIdentityObjectsByTypeOrderedByNameDesc = "select o from HibernateIdentityObject o where o.name like :nameFilter and o.realm.name = :realmName and o.identityType.name = :typeName order by o.name desc";
    public static final String countIdentityObjectsByType = "select count(o.id) from HibernateIdentityObject o where o.realm.name = :realmName and o.identityType.name = :typeName";
    private Long id;
    private String name;
    private HibernateIdentityObjectType identityType;
    private Set<HibernateIdentityObjectRelationship> fromRelationships = new HashSet<HibernateIdentityObjectRelationship>();
    private Set<HibernateIdentityObjectRelationship> toRelationships = new HashSet<HibernateIdentityObjectRelationship>();
    private Set<HibernateIdentityObjectAttribute> attributes = new HashSet<HibernateIdentityObjectAttribute>();
    private Map<String, String> properties = new HashMap<String, String>();
    private Set<HibernateIdentityObjectCredential> credentials = new HashSet<HibernateIdentityObjectCredential>();
    private HibernateRealm realm;

    public HibernateIdentityObject() {
    }

    public HibernateIdentityObject(String name, HibernateIdentityObjectType identityType, HibernateRealm realm) {
        this.name = name;
        this.identityType = identityType;
        this.realm = realm;
    }

    public String getId() {
        return this.id.toString();
    }

    public void setId(String id) {
        this.id = Long.valueOf(id);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public HibernateIdentityObjectType getIdentityType() {
        return this.identityType;
    }

    public void setIdentityType(HibernateIdentityObjectType identityType) {
        this.identityType = identityType;
    }

    public String getFQDN() {
        return null;
    }

    public Set<HibernateIdentityObjectAttribute> getAttributes() {
        return this.attributes;
    }

    public void setAttributes(Set<HibernateIdentityObjectAttribute> attributes) {
        this.attributes = attributes;
    }

    public void addAttribute(HibernateIdentityObjectAttribute attribute) {
        attribute.setIdentityObject(this);
        this.attributes.add(attribute);
    }

    public Map<String, Collection> getAttributesAsMap() {
        HashMap<String, Collection> map = new HashMap<String, Collection>();
        for (HibernateIdentityObjectAttribute attribute : this.attributes) {
            Collection values = attribute.getValues();
            map.put(attribute.getName(), values);
        }
        return Collections.unmodifiableMap(map);
    }

    public void addTextAttribute(String name, String[] values) {
        HibernateIdentityObjectAttribute attr = new HibernateIdentityObjectAttribute(this, name, "text");
        List<String> list = Arrays.asList(values);
        HashSet<String> vals = new HashSet<String>(list);
        attr.setTextValues(vals);
        this.attributes.add(attr);
    }

    public void removeAttribute(String name) {
        HibernateIdentityObjectAttribute attributeToRemove = null;
        for (HibernateIdentityObjectAttribute attribute : this.attributes) {
            if (!attribute.getName().equals(name)) continue;
            attributeToRemove = attribute;
            break;
        }
        if (attributeToRemove != null) {
            this.attributes.remove(attributeToRemove);
        }
    }

    public Set<HibernateIdentityObjectRelationship> getFromRelationships() {
        return this.fromRelationships;
    }

    public void setFromRelationships(Set<HibernateIdentityObjectRelationship> fromRelationships) {
        this.fromRelationships = fromRelationships;
    }

    public void addFromRelationship(HibernateIdentityObjectRelationship fromRelationship) {
        fromRelationship.setFromIdentityObject(this);
        this.fromRelationships.add(fromRelationship);
    }

    public Set<HibernateIdentityObjectRelationship> getToRelationships() {
        return this.toRelationships;
    }

    public void setToRelationships(Set<HibernateIdentityObjectRelationship> toRelationships) {
        this.toRelationships = toRelationships;
    }

    public void addToRelationship(HibernateIdentityObjectRelationship toRelationship) {
        toRelationship.setToIdentityObject(this);
        this.fromRelationships.add(toRelationship);
    }

    public HibernateRealm getRealm() {
        return this.realm;
    }

    public void setRealm(HibernateRealm realm) {
        this.realm = realm;
    }

    public Set<HibernateIdentityObjectCredential> getCredentials() {
        return this.credentials;
    }

    public void setCredentials(Set<HibernateIdentityObjectCredential> credentials) {
        this.credentials = credentials;
    }

    public void addCredential(HibernateIdentityObjectCredential credential) {
        credential.setIdentityObject(this);
        this.credentials.add(credential);
    }

    public boolean hasCredentials() {
        return this.credentials != null && this.credentials.size() > 0;
    }

    public boolean hasCredential(IdentityObjectCredentialType type) {
        if (this.credentials != null) {
            for (HibernateIdentityObjectCredential credential : this.credentials) {
                if (!credential.getType().getName().equals(type.getName())) continue;
                return true;
            }
        }
        return false;
    }

    public HibernateIdentityObjectCredential getCredential(IdentityObjectCredentialType type) {
        if (this.credentials != null) {
            for (HibernateIdentityObjectCredential credential : this.credentials) {
                if (!credential.getType().getName().equals(type.getName())) continue;
                return credential;
            }
        }
        return null;
    }

    public Map<String, String> getProperties() {
        return this.properties;
    }

    public void setProperties(Map<String, String> properties) {
        this.properties = properties;
    }

    public void validatePolicy() throws PolicyValidationException {
    }

    public String toString() {
        return "IdentityObject[id=" + this.getId() + "; name=" + this.getName() + "; type=" + this.getIdentityType().getName() + "]";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof IdentityObject)) {
            return false;
        }
        IdentityObject that = (IdentityObject)o;
        if (this.name != null ? !this.name.equals(that.getName()) : that.getName() != null) {
            return false;
        }
        return !(this.identityType != null ? !this.identityType.equals(that.getIdentityType()) : that.getIdentityType() != null);
    }

    public int hashCode() {
        int result = this.name != null ? this.name.hashCode() : 0;
        result = 31 * result + (this.identityType != null ? this.identityType.hashCode() : 0);
        return result;
    }
}

