/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.idm.impl.api.session.managers;

import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import org.picketlink.idm.api.Group;
import org.picketlink.idm.api.IdentitySearchCriteria;
import org.picketlink.idm.api.IdentitySearchCriteriumType;
import org.picketlink.idm.api.IdentityType;
import org.picketlink.idm.api.Role;
import org.picketlink.idm.api.RoleManager;
import org.picketlink.idm.api.RoleManagerFeaturesDescription;
import org.picketlink.idm.api.RoleType;
import org.picketlink.idm.api.User;
import org.picketlink.idm.common.exception.IdentityException;
import org.picketlink.idm.impl.api.model.SimpleRole;
import org.picketlink.idm.impl.api.model.SimpleRoleType;
import org.picketlink.idm.impl.api.session.IdentitySessionImpl;
import org.picketlink.idm.impl.api.session.managers.AbstractManager;
import org.picketlink.idm.impl.cache.GroupSearchImpl;
import org.picketlink.idm.impl.cache.RoleSearchImpl;
import org.picketlink.idm.impl.cache.RoleTypeSearchImpl;
import org.picketlink.idm.impl.cache.UserSearchImpl;
import org.picketlink.idm.impl.types.SimpleIdentityObjectRelationship;
import org.picketlink.idm.spi.exception.OperationNotSupportedException;
import org.picketlink.idm.spi.model.IdentityObject;
import org.picketlink.idm.spi.model.IdentityObjectRelationship;
import org.picketlink.idm.spi.model.IdentityObjectRelationshipType;
import org.picketlink.idm.spi.model.IdentityObjectType;
import org.picketlink.idm.spi.store.IdentityObjectSearchCriteriaType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RoleManagerImpl
extends AbstractManager
implements RoleManager,
Serializable {
    private static Logger log = Logger.getLogger(RoleManagerImpl.class.getName());
    public static final IdentityObjectRelationshipType ROLE = new IdentityObjectRelationshipType(){

        public String getName() {
            return "JBOSS_IDENTITY_ROLE";
        }
    };
    private final RoleManagerFeaturesDescription featuresDescription = new RoleManagerFeaturesDescription(){

        public boolean isRoleTypeAddRemoveSupported() {
            return RoleManagerImpl.this.getSessionContext().getIdentityStoreRepository().getSupportedFeatures().isRelationshipNameAddRemoveSupported();
        }

        public boolean isRoleTypeSearchCriteriumTypeSupported(IdentitySearchCriteriumType constraintType) {
            IdentityObjectSearchCriteriaType constraint = IdentityObjectSearchCriteriaType.valueOf(constraintType.name());
            if (constraint != null) {
                return RoleManagerImpl.this.getSessionContext().getIdentityStoreRepository().getSupportedFeatures().isRoleNameSearchCriteriaTypeSupported(constraint);
            }
            return false;
        }
    };
    private static final long serialVersionUID = 7246982831145808636L;

    public RoleManagerImpl(IdentitySessionImpl session) {
        super(session);
    }

    protected IdentityObjectRelationship createIdentityObjectRelationship(Role role) {
        return new SimpleIdentityObjectRelationship(this.createIdentityObject(role.getGroup()), this.createIdentityObject(role.getUser()), role.getRoleType().getName(), ROLE);
    }

    @Override
    public RoleManagerFeaturesDescription getSupportedFeatures() {
        return this.featuresDescription;
    }

    @Override
    public RoleType createRoleType(String name) throws IdentityException {
        this.checkNotNullArgument(name, "RoleType name");
        this.checkObjectName(name);
        String roleType = null;
        try {
            this.preCreate(new SimpleRoleType(name));
            roleType = this.getRepository().createRelationshipName(this.getInvocationContext(), name);
            this.postCreate(new SimpleRoleType(name));
        }
        catch (OperationNotSupportedException e) {
            throw new IdentityException("Role management not supported");
        }
        SimpleRoleType result = new SimpleRoleType(roleType);
        if (this.cache != null) {
            this.cache.invalidateAllQueries(this.cacheNS);
            this.cache.invalidateAllSearches(this.cacheNS);
            this.cache.putRoleType(this.cacheNS, result);
        }
        return result;
    }

    @Override
    public void removeRoleType(String name) throws IdentityException {
        this.checkNotNullArgument(name, "RoleType name");
        try {
            this.preRemove(new SimpleRoleType(name));
            this.getRepository().removeRelationshipName(this.getInvocationContext(), name);
            if (this.cache != null) {
                this.cache.invalidateAllQueries(this.cacheNS);
                this.cache.invalidateAllSearches(this.cacheNS);
                this.cache.removeRoleType(this.cacheNS, new SimpleRoleType(name));
            }
            this.postRemove(new SimpleRoleType(name));
        }
        catch (OperationNotSupportedException e) {
            throw new IdentityException("Role management not supported");
        }
    }

    @Override
    public void removeRoleType(RoleType roleType) throws IdentityException {
        this.checkNotNullArgument(roleType, "RoleType");
        this.removeRoleType(roleType.getName());
    }

    @Override
    public RoleType getRoleType(String name) throws IdentityException {
        RoleType roleType;
        this.checkNotNullArgument(name, "RoleType name");
        if (this.cache != null && (roleType = this.cache.getRoleType(this.cacheNS, new SimpleRoleType(name))) != null) {
            return roleType;
        }
        try {
            Set<String> names = this.getRepository().getRelationshipNames(this.getInvocationContext(), null);
            if (names.contains(name)) {
                if (this.cache != null) {
                    this.cache.putRoleType(this.cacheNS, new SimpleRoleType(name));
                }
                return new SimpleRoleType(name);
            }
        }
        catch (OperationNotSupportedException e) {
            throw new IdentityException("Role management not supported");
        }
        return null;
    }

    @Override
    public Collection<RoleType> findRoleTypes(IdentitySearchCriteria criteria) throws IdentityException {
        if (this.cache != null) {
            RoleTypeSearchImpl search = new RoleTypeSearchImpl();
            search.setSearchCriteria(criteria);
            Collection<RoleType> result = this.cache.getRoleTypeSearch(this.cacheNS, search);
            if (result != null) {
                return result;
            }
        }
        try {
            Set<String> names = this.getRepository().getRelationshipNames(this.getInvocationContext(), this.convertSearchControls(criteria));
            HashSet<RoleType> types = new HashSet<RoleType>();
            for (String name : names) {
                types.add(new SimpleRoleType(name));
            }
            if (this.cache != null) {
                RoleTypeSearchImpl search = new RoleTypeSearchImpl();
                search.setSearchCriteria(criteria);
                this.cache.putRoleTypeSearch(this.cacheNS, search, types);
            }
            return types;
        }
        catch (OperationNotSupportedException e) {
            throw new IdentityException("Role management not supported");
        }
    }

    @Override
    public Collection<RoleType> findRoleTypes() throws IdentityException {
        return this.findRoleTypes(null);
    }

    @Override
    public Role createRole(RoleType roleType, User user, Group group) throws IdentityException {
        this.checkNotNullArgument(roleType, "RoleType");
        this.checkNotNullArgument(user, "User");
        this.checkNotNullArgument(group, "Group");
        SimpleRole _role = new SimpleRole(roleType, user, group);
        this.preCreate(_role);
        IdentityObjectRelationship rel = this.getRepository().createRelationship(this.getInvocationContext(), this.createIdentityObject(group), this.createIdentityObject(user), ROLE, roleType.getName(), false);
        SimpleRole role = null;
        if (rel != null) {
            role = new SimpleRole(roleType, user, group);
        }
        if (this.cache != null) {
            this.cache.invalidateAllQueries(this.cacheNS);
            this.cache.invalidateAllSearches(this.cacheNS);
            this.cache.putRole(this.cacheNS, role);
        }
        this.postCreate(_role);
        return role;
    }

    @Override
    public Role createRole(String roleTypeName, String userName, String groupId) throws IdentityException {
        this.checkNotNullArgument(roleTypeName, "RoleType name");
        this.checkNotNullArgument(userName, "User name");
        this.checkNotNullArgument(groupId, "Group Id");
        User user = this.createUserFromId(userName);
        Group group = this.createGroupFromId(groupId);
        return this.createRole(new SimpleRoleType(roleTypeName), user, group);
    }

    @Override
    public void removeRole(RoleType roleType, User user, Group group) throws IdentityException {
        this.checkNotNullArgument(roleType, "RoleType");
        this.checkNotNullArgument(user, "User");
        this.checkNotNullArgument(group, "Group");
        SimpleRole _role = new SimpleRole(roleType, user, group);
        this.preRemove(_role);
        this.getRepository().removeRelationship(this.getInvocationContext(), this.createIdentityObject(group), this.createIdentityObject(user), ROLE, roleType.getName());
        if (this.cache != null) {
            this.cache.invalidateAllQueries(this.cacheNS);
            this.cache.invalidateAllSearches(this.cacheNS);
            this.cache.removeRole(this.cacheNS, _role);
        }
        this.postRemove(_role);
    }

    @Override
    public void removeRole(String roleTypeName, String userName, String groupId) throws IdentityException {
        this.checkNotNullArgument(roleTypeName, "RoleType name");
        this.checkNotNullArgument(userName, "User name");
        this.checkNotNullArgument(groupId, "Group Id");
        User user = this.createUserFromId(userName);
        Group group = this.createGroupFromId(groupId);
        this.removeRole(new SimpleRoleType(roleTypeName), user, group);
    }

    @Override
    public void removeRole(Role role) throws IdentityException {
        this.checkNotNullArgument(role, "Role");
        this.preRemove(role);
        this.getRepository().removeRelationship(this.getInvocationContext(), this.createIdentityObject(role.getGroup()), this.createIdentityObject(role.getUser()), ROLE, role.getRoleType().getName());
        if (this.cache != null) {
            this.cache.invalidateAllQueries(this.cacheNS);
            this.cache.invalidateAllSearches(this.cacheNS);
            this.cache.removeRole(this.cacheNS, role);
        }
        this.postRemove(role);
    }

    @Override
    public boolean hasRole(User user, Group group, RoleType roleType) throws IdentityException {
        this.checkNotNullArgument(roleType, "RoleType");
        this.checkNotNullArgument(user, "User");
        this.checkNotNullArgument(group, "Group");
        if (this.cache != null) {
            Role role = new SimpleRole(roleType, user, group);
            if ((role = this.cache.getRole(this.cacheNS, role)) != null) {
                return true;
            }
        }
        Set<IdentityObjectRelationship> rels = this.getRepository().resolveRelationships(this.getInvocationContext(), this.createIdentityObject(group), this.createIdentityObject(user), ROLE);
        for (IdentityObjectRelationship rel : rels) {
            if (!rel.getType().getName().equals(ROLE.getName()) || rel.getName() == null || !rel.getName().equals(roleType.getName())) continue;
            if (this.cache != null) {
                SimpleRole role = new SimpleRole(roleType, user, group);
                this.cache.putRole(this.cacheNS, role);
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean hasRole(String userName, String groupId, String roleTypeName) throws IdentityException {
        this.checkNotNullArgument(roleTypeName, "RoleType name");
        this.checkNotNullArgument(userName, "User name");
        this.checkNotNullArgument(groupId, "Group Id");
        User user = this.createUserFromId(userName);
        Group group = this.createGroupFromId(groupId);
        return this.hasRole(user, group, new SimpleRoleType(roleTypeName));
    }

    @Override
    public Role getRole(RoleType roleType, User user, Group group) throws IdentityException {
        Set<IdentityObjectRelationship> rels;
        this.checkNotNullArgument(roleType, "RoleType");
        this.checkNotNullArgument(user, "User");
        this.checkNotNullArgument(group, "Group");
        if (this.cache != null) {
            Role role = new SimpleRole(roleType, user, group);
            if ((role = this.cache.getRole(this.cacheNS, role)) != null) {
                return role;
            }
        }
        if ((rels = this.getRepository().resolveRelationships(this.getInvocationContext(), this.createIdentityObject(group), this.createIdentityObject(user), ROLE)).size() == 0) {
            return null;
        }
        for (IdentityObjectRelationship relationship : rels) {
            if (!roleType.getName().equals(relationship.getName())) continue;
            SimpleRole role = new SimpleRole(new SimpleRoleType(relationship.getName()), this.createUser(relationship.getToIdentityObject()), this.createGroup(relationship.getFromIdentityObject()));
            if (this.cache != null) {
                this.cache.putRole(this.cacheNS, role);
            }
            return role;
        }
        return null;
    }

    @Override
    public Role getRole(String roleTypeName, String userId, String groupId) throws IdentityException {
        this.checkNotNullArgument(roleTypeName, "RoleType name");
        this.checkNotNullArgument(userId, "User id");
        this.checkNotNullArgument(groupId, "Group Id");
        User user = this.createUserFromId(userId);
        Group group = this.createGroupFromId(groupId);
        SimpleRoleType roleType = new SimpleRoleType(roleTypeName);
        return this.getRole(roleType, user, group);
    }

    @Override
    public Collection<RoleType> findRoleTypes(User user, Group group) throws IdentityException {
        this.checkNotNullArgument(user, "User");
        this.checkNotNullArgument(group, "Group");
        return this.findRoleTypes(user, group, null);
    }

    @Override
    public Collection<RoleType> findRoleTypes(User user, Group group, IdentitySearchCriteria criteria) throws IdentityException {
        this.checkNotNullArgument(user, "User");
        this.checkNotNullArgument(group, "Group");
        if (this.cache != null) {
            RoleTypeSearchImpl search = new RoleTypeSearchImpl();
            search.setUser(user);
            search.setGroup(group);
            search.setSearchCriteria(criteria);
            Collection<RoleType> results = this.cache.getRoleTypeSearch(this.cacheNS, search);
            if (results != null) {
                return results;
            }
        }
        Set<IdentityObjectRelationship> rels = this.getRepository().resolveRelationships(this.getInvocationContext(), this.createIdentityObject(group), this.createIdentityObject(user), ROLE);
        HashSet<RoleType> types = new HashSet<RoleType>();
        for (IdentityObjectRelationship rel : rels) {
            types.add(new SimpleRoleType(rel.getName()));
        }
        if (this.cache != null) {
            RoleTypeSearchImpl search = new RoleTypeSearchImpl();
            search.setUser(user);
            search.setGroup(group);
            search.setSearchCriteria(criteria);
            this.cache.putRoleTypeSearch(this.cacheNS, search, types);
        }
        return types;
    }

    @Override
    public Collection<RoleType> findRoleTypes(String userName, String groupId, IdentitySearchCriteria criteria) throws IdentityException {
        this.checkNotNullArgument(userName, "User name");
        this.checkNotNullArgument(groupId, "Group Id");
        User user = this.createUserFromId(userName);
        Group group = this.createGroupFromId(groupId);
        return this.findRoleTypes(user, group, criteria);
    }

    @Override
    public Collection<RoleType> findUserRoleTypes(User user) throws IdentityException {
        this.checkNotNullArgument(user, "User");
        return this.findUserRoleTypes(user, null);
    }

    @Override
    public Collection<RoleType> findUserRoleTypes(User user, IdentitySearchCriteria criteria) throws IdentityException {
        this.checkNotNullArgument(user, "User");
        HashSet<RoleType> types = new HashSet<RoleType>();
        if (this.cache != null) {
            RoleTypeSearchImpl search = new RoleTypeSearchImpl();
            search.setUser(user);
            search.setSearchCriteria(criteria);
            Collection<RoleType> results = this.cache.getRoleTypeSearch(this.cacheNS, search);
            if (results != null) {
                return results;
            }
        }
        try {
            Set<String> names = this.getRepository().getRelationshipNames(this.getInvocationContext(), this.createIdentityObject(user), this.convertSearchControls(criteria));
            for (String name : names) {
                types.add(new SimpleRoleType(name));
            }
            if (this.cache != null) {
                RoleTypeSearchImpl search = new RoleTypeSearchImpl();
                search.setUser(user);
                search.setSearchCriteria(criteria);
                this.cache.putRoleTypeSearch(this.cacheNS, search, types);
            }
            return types;
        }
        catch (OperationNotSupportedException e) {
            throw new IdentityException("Role management not supported", e);
        }
    }

    @Override
    public Collection<RoleType> findUserRoleTypes(String userName, IdentitySearchCriteria criteria) throws IdentityException {
        this.checkNotNullArgument(userName, "User name");
        User user = this.createUserFromId(userName);
        return this.findUserRoleTypes(user, criteria);
    }

    @Override
    public Collection<RoleType> findGroupRoleTypes(Group group) throws IdentityException {
        this.checkNotNullArgument(group, "Group");
        return this.findGroupRoleTypes(group, null);
    }

    @Override
    public Collection<RoleType> findGroupRoleTypes(String groupId, IdentitySearchCriteria criteria) throws IdentityException {
        this.checkNotNullArgument(groupId, "Group Id");
        Group group = this.createGroupFromId(groupId);
        return this.findGroupRoleTypes(group, criteria);
    }

    @Override
    public Collection<RoleType> findGroupRoleTypes(Group group, IdentitySearchCriteria criteria) throws IdentityException {
        this.checkNotNullArgument(group, "Group");
        HashSet<RoleType> types = new HashSet<RoleType>();
        if (this.cache != null) {
            RoleTypeSearchImpl search = new RoleTypeSearchImpl();
            search.setGroup(group);
            search.setSearchCriteria(criteria);
            Collection<RoleType> results = this.cache.getRoleTypeSearch(this.cacheNS, search);
            if (results != null) {
                return results;
            }
        }
        try {
            Set<String> names = this.getRepository().getRelationshipNames(this.getInvocationContext(), this.createIdentityObject(group), this.convertSearchControls(criteria));
            for (String name : names) {
                types.add(new SimpleRoleType(name));
            }
            if (this.cache != null) {
                RoleTypeSearchImpl search = new RoleTypeSearchImpl();
                search.setGroup(group);
                search.setSearchCriteria(criteria);
                this.cache.putRoleTypeSearch(this.cacheNS, search, types);
            }
            return types;
        }
        catch (OperationNotSupportedException e) {
            throw new IdentityException("Role management not supported");
        }
    }

    @Override
    public Collection<User> findUsersWithRelatedRole(Group group, IdentitySearchCriteria criteria) throws IdentityException {
        this.checkNotNullArgument(group, "Group");
        LinkedList<User> identities = new LinkedList<User>();
        if (this.cache != null) {
            UserSearchImpl search = new UserSearchImpl();
            search.addRelatedGroupId(group.getKey());
            search.setSearchCriteria(criteria);
            Collection<User> results = this.cache.getUserSearch(this.cacheNS, search);
            if (results != null) {
                return results;
            }
        }
        Collection<IdentityObject> ios = null;
        ios = this.getRepository().findIdentityObject(this.getInvocationContext(), this.createIdentityObject(group), ROLE, true, this.convertSearchControls(criteria));
        for (IdentityObject io : ios) {
            identities.add(this.createUser(io));
        }
        if (this.cache != null) {
            UserSearchImpl search = new UserSearchImpl();
            search.addRelatedGroupId(group.getKey());
            search.setSearchCriteria(criteria);
            this.cache.putUserSearch(this.cacheNS, search, identities);
        }
        return identities;
    }

    @Override
    public Collection<User> findUsersWithRelatedRole(String groupId, IdentitySearchCriteria criteria) throws IdentityException {
        this.checkNotNullArgument(groupId, "Group id");
        Group group = this.createGroupFromId(groupId);
        return this.findUsersWithRelatedRole(group, criteria);
    }

    @Override
    public Collection<Group> findGroupsWithRelatedRole(User user, IdentitySearchCriteria criteria) throws IdentityException {
        this.checkNotNullArgument(user, "User");
        LinkedList<Group> identities = new LinkedList<Group>();
        if (this.cache != null) {
            GroupSearchImpl search = new GroupSearchImpl();
            search.addRelatedUserId(user.getKey());
            search.setSearchCriteria(criteria);
            Collection<Group> results = this.cache.getGroupSearch(this.cacheNS, search);
            if (results != null) {
                return results;
            }
        }
        Collection<IdentityObject> ios = null;
        ios = this.getRepository().findIdentityObject(this.getInvocationContext(), this.createIdentityObject(user), ROLE, false, this.convertSearchControls(criteria));
        for (IdentityObject io : ios) {
            identities.add(this.createGroup(io));
        }
        if (this.cache != null) {
            GroupSearchImpl search = new GroupSearchImpl();
            search.addRelatedUserId(user.getKey());
            search.setSearchCriteria(criteria);
            this.cache.putGroupSearch(this.cacheNS, search, identities);
        }
        return identities;
    }

    @Override
    public Collection<Group> findGroupsWithRelatedRole(String userName, IdentitySearchCriteria criteria) throws IdentityException {
        this.checkNotNullArgument(userName, "User name");
        User user = this.createUserFromId(userName);
        return this.findGroupsWithRelatedRole(user, criteria);
    }

    @Override
    public Collection<Group> findGroupsWithRelatedRole(User user, String groupType, IdentitySearchCriteria criteria) throws IdentityException {
        this.checkNotNullArgument(user, "User");
        LinkedList<Group> identities = new LinkedList<Group>();
        if (this.cache != null) {
            GroupSearchImpl search = new GroupSearchImpl();
            search.addRelatedUserId(user.getKey());
            search.setGroupType(groupType);
            search.setSearchCriteria(criteria);
            Collection<Group> results = this.cache.getGroupSearch(this.cacheNS, search);
            if (results != null) {
                return results;
            }
        }
        Collection<IdentityObject> ios = null;
        ios = this.getRepository().findIdentityObject(this.getInvocationContext(), this.createIdentityObject(user), ROLE, false, this.convertSearchControls(criteria));
        if (groupType != null) {
            IdentityObjectType iot = this.getIdentityObjectType(groupType);
            for (IdentityObject io : ios) {
                if (!io.getIdentityType().getName().equals(iot.getName())) continue;
                identities.add(this.createGroup(io));
            }
        } else {
            for (IdentityObject io : ios) {
                identities.add(this.createGroup(io));
            }
        }
        if (this.cache != null) {
            GroupSearchImpl search = new GroupSearchImpl();
            search.addRelatedUserId(user.getKey());
            search.setGroupType(groupType);
            search.setSearchCriteria(criteria);
            this.cache.putGroupSearch(this.cacheNS, search, identities);
        }
        return identities;
    }

    @Override
    public Collection<Group> findGroupsWithRelatedRole(String userName, String groupType, IdentitySearchCriteria criteria) throws IdentityException {
        this.checkNotNullArgument(userName, "User name");
        User user = this.createUserFromId(userName);
        return this.findGroupsWithRelatedRole(user, groupType, criteria);
    }

    public Collection<Role> findRoles(IdentityType identityType, RoleType roleType) throws IdentityException {
        this.checkNotNullArgument(identityType, "IdentityType");
        HashSet<Role> roles = new HashSet<Role>();
        if (this.cache != null) {
            RoleSearchImpl search = new RoleSearchImpl();
            search.setIdentityTypeId(identityType.getKey());
            search.setRoleType(roleType);
            Collection<Role> results = this.cache.getRoleSearch(this.cacheNS, search);
            if (results != null) {
                return results;
            }
        }
        Set<IdentityObjectRelationship> relationships = null;
        relationships = identityType instanceof User ? this.getRepository().resolveRelationships(this.getInvocationContext(), this.createIdentityObject(identityType), ROLE, false, true, null) : this.getRepository().resolveRelationships(this.getInvocationContext(), this.createIdentityObject(identityType), ROLE, true, true, null);
        for (IdentityObjectRelationship relationship : relationships) {
            if (roleType != null) {
                if (!roleType.getName().equals(relationship.getName())) continue;
                roles.add(new SimpleRole(new SimpleRoleType(relationship.getName()), this.createUser(relationship.getToIdentityObject()), this.createGroup(relationship.getFromIdentityObject())));
                continue;
            }
            roles.add(new SimpleRole(new SimpleRoleType(relationship.getName()), this.createUser(relationship.getToIdentityObject()), this.createGroup(relationship.getFromIdentityObject())));
        }
        if (this.cache != null) {
            RoleSearchImpl search = new RoleSearchImpl();
            search.setIdentityTypeId(identityType.getKey());
            search.setRoleType(roleType);
            this.cache.putRoleSearch(this.cacheNS, search, roles);
        }
        return roles;
    }

    @Override
    public Collection<Role> findRoles(String id, String roleTypeName) throws IdentityException {
        this.checkNotNullArgument(id, "Group id or User name");
        SimpleRoleType roleType = roleTypeName != null ? new SimpleRoleType(roleTypeName) : null;
        return this.findRoles(this.createIdentityTypeFromId(id), (RoleType)roleType);
    }

    @Override
    public Map<String, String> getProperties(RoleType roleType) throws IdentityException {
        Map<String, String> result;
        this.checkNotNullArgument(roleType, "RoleType name");
        if (this.cache != null && (result = this.cache.getProperties(this.cacheNS, roleType)) != null) {
            return result;
        }
        result = this.getRepository().getRelationshipNameProperties(this.getInvocationContext(), roleType.getName());
        if (this.cache != null) {
            this.cache.putProperties(this.cacheNS, roleType, result);
        }
        return result;
    }

    @Override
    public Map<String, String> getProperties(String roleTypeName) throws IdentityException {
        this.checkNotNullArgument(roleTypeName, "RoleType name");
        return this.getProperties(new SimpleRoleType(roleTypeName));
    }

    @Override
    public Map<String, String> getProperties(Role role) throws IdentityException {
        Map<String, String> result;
        this.checkNotNullArgument(role, "Role");
        if (this.cache != null && (result = this.cache.getProperties(this.cacheNS, role)) != null) {
            return result;
        }
        result = this.getRepository().getRelationshipProperties(this.getInvocationContext(), this.createIdentityObjectRelationship(role));
        if (this.cache != null) {
            this.cache.putProperties(this.cacheNS, role, result);
        }
        return result;
    }

    @Override
    public void setProperty(Role role, String name, String value) throws IdentityException {
        this.checkNotNullArgument(role, "Role");
        this.checkNotNullArgument(name, "Property name");
        this.checkNotNullArgument(value, "Property value");
        HashMap<String, String> props = new HashMap<String, String>();
        props.put(name, value);
        this.prePropertiesSet(role, props);
        this.getRepository().setRelationshipProperties(this.getInvocationContext(), this.createIdentityObjectRelationship(role), props);
        if (this.cache != null) {
            this.cache.invalidateRoleProperties(this.cacheNS, role);
            this.cache.putProperties(this.cacheNS, role, this.getProperties(role));
        }
        this.postPropertiesSet(role, props);
    }

    @Override
    public void setProperty(RoleType roleType, String name, String value) throws IdentityException {
        this.checkNotNullArgument(roleType, "RoleType");
        this.checkNotNullArgument(name, "Property name");
        this.checkNotNullArgument(value, "Property value");
        HashMap<String, String> props = new HashMap<String, String>();
        props.put(name, value);
        this.prePropertiesSet(roleType, props);
        this.getRepository().setRelationshipNameProperties(this.getInvocationContext(), roleType.getName(), props);
        if (this.cache != null) {
            this.cache.invalidateRoleTypeProperties(this.cacheNS, roleType);
            this.cache.putProperties(this.cacheNS, roleType, this.getProperties(roleType));
        }
        this.postPropertiesSet(roleType, props);
    }

    @Override
    public void setProperty(String roleTypeName, String name, String value) throws IdentityException {
        this.checkNotNullArgument(roleTypeName, "RoleType name");
        this.checkNotNullArgument(name, "Property name");
        this.checkNotNullArgument(value, "Property value");
        HashMap<String, String> props = new HashMap<String, String>();
        props.put(name, value);
        this.prePropertiesSet(new SimpleRoleType(roleTypeName), props);
        this.setProperty(new SimpleRoleType(roleTypeName), name, value);
        if (this.cache != null) {
            this.cache.invalidateRoleTypeProperties(this.cacheNS, new SimpleRoleType(roleTypeName));
            this.cache.putProperties(this.cacheNS, new SimpleRoleType(roleTypeName), this.getProperties(new SimpleRoleType(roleTypeName)));
        }
        this.postPropertiesSet(new SimpleRoleType(roleTypeName), props);
    }

    @Override
    public void setProperties(Role role, Map<String, String> properties) throws IdentityException {
        this.checkNotNullArgument(role, "Role");
        this.checkNotNullArgument(properties, "Properties");
        this.prePropertiesSet(role, properties);
        this.getRepository().setRelationshipProperties(this.getInvocationContext(), this.createIdentityObjectRelationship(role), properties);
        if (this.cache != null) {
            this.cache.invalidateRoleProperties(this.cacheNS, role);
            this.cache.putProperties(this.cacheNS, role, this.getProperties(role));
        }
        this.postPropertiesSet(role, properties);
    }

    @Override
    public void setProperties(RoleType roleType, Map<String, String> properties) throws IdentityException {
        this.checkNotNullArgument(roleType, "RoleType");
        this.checkNotNullArgument(properties, "Properties");
        this.prePropertiesSet(roleType, properties);
        this.getRepository().setRelationshipNameProperties(this.getInvocationContext(), roleType.getName(), properties);
        if (this.cache != null) {
            this.cache.invalidateRoleTypeProperties(this.cacheNS, roleType);
            this.cache.putProperties(this.cacheNS, roleType, this.getProperties(roleType));
        }
        this.postPropertiesSet(roleType, properties);
    }

    @Override
    public void setProperties(String roleTypeName, Map<String, String> properties) throws IdentityException {
        this.checkNotNullArgument(roleTypeName, "RoleType name");
        this.prePropertiesSet(new SimpleRoleType(roleTypeName), properties);
        this.setProperties(new SimpleRoleType(roleTypeName), properties);
        if (this.cache != null) {
            this.cache.invalidateRoleTypeProperties(this.cacheNS, new SimpleRoleType(roleTypeName));
            this.cache.putProperties(this.cacheNS, new SimpleRoleType(roleTypeName), this.getProperties(new SimpleRoleType(roleTypeName)));
        }
        this.postPropertiesSet(new SimpleRoleType(roleTypeName), properties);
    }

    @Override
    public void removeProperty(Role role, String name) throws IdentityException {
        this.checkNotNullArgument(role, "Role");
        this.checkNotNullArgument(name, "Property name");
        HashSet<String> names = new HashSet<String>();
        names.add(name);
        this.prePropertiesRemove(role, names);
        this.getRepository().removeRelationshipProperties(this.getInvocationContext(), this.createIdentityObjectRelationship(role), names);
        if (this.cache != null) {
            this.cache.invalidateRoleProperties(this.cacheNS, role);
            this.cache.putProperties(this.cacheNS, role, this.getProperties(role));
        }
        this.postPropertiesRemove(role, names);
    }

    @Override
    public void removeProperty(RoleType roleType, String name) throws IdentityException {
        this.checkNotNullArgument(roleType, "RoleType");
        this.checkNotNullArgument(name, "Property name");
        HashSet<String> names = new HashSet<String>();
        names.add(name);
        this.prePropertiesRemove(roleType, names);
        this.getRepository().removeRelationshipNameProperties(this.getInvocationContext(), roleType.getName(), names);
        if (this.cache != null) {
            this.cache.invalidateRoleTypeProperties(this.cacheNS, roleType);
            this.cache.putProperties(this.cacheNS, roleType, this.getProperties(roleType));
        }
        this.postPropertiesRemove(roleType, names);
    }

    @Override
    public void removeProperty(String roleTypeName, String name) throws IdentityException {
        this.checkNotNullArgument(roleTypeName, "RoleType name");
        HashSet<String> names = new HashSet<String>();
        names.add(name);
        this.prePropertiesRemove(new SimpleRoleType(roleTypeName), names);
        this.removeProperty(new SimpleRoleType(roleTypeName), name);
        if (this.cache != null) {
            this.cache.invalidateRoleTypeProperties(this.cacheNS, new SimpleRoleType(roleTypeName));
            this.cache.putProperties(this.cacheNS, new SimpleRoleType(roleTypeName), this.getProperties(new SimpleRoleType(roleTypeName)));
        }
        this.postPropertiesRemove(new SimpleRoleType(roleTypeName), names);
    }
}

