/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.eviction;

import org.jboss.cache.config.ConfigurationException;
import org.jboss.cache.eviction.EvictionAlgorithmConfigBase;
import org.jboss.cache.eviction.FIFOAlgorithm;

public class FIFOAlgorithmConfig
extends EvictionAlgorithmConfigBase {
    private static final long serialVersionUID = -7229715009546277313L;

    public FIFOAlgorithmConfig() {
        this.evictionAlgorithmClassName = FIFOAlgorithm.class.getName();
        this.setMaxNodes(-1);
    }

    public FIFOAlgorithmConfig(int maxNodes) {
        this.evictionAlgorithmClassName = FIFOAlgorithm.class.getName();
        this.setMaxNodes(maxNodes);
    }

    public void validate() throws ConfigurationException {
        super.validate();
        if (this.maxNodes < -1) {
            this.maxNodes = -1;
        }
    }

    public String toString() {
        StringBuilder ret = new StringBuilder();
        ret.append("FIFOAlgorithmConfig: maxNodes = ").append(this.getMaxNodes());
        return ret.toString();
    }

    public void reset() {
        super.reset();
        this.setMaxNodes(-1);
        this.evictionAlgorithmClassName = FIFOAlgorithm.class.getName();
    }

    public FIFOAlgorithmConfig clone() throws CloneNotSupportedException {
        return (FIFOAlgorithmConfig)super.clone();
    }
}

