/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.idm.impl.cache;

import java.io.InputStream;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jboss.cache.Cache;
import org.jboss.cache.CacheStatus;
import org.jboss.cache.DefaultCacheFactory;
import org.jboss.cache.Fqn;
import org.jboss.cache.Node;
import org.picketlink.idm.api.Attribute;
import org.picketlink.idm.api.Group;
import org.picketlink.idm.api.IdentitySearchCriteria;
import org.picketlink.idm.api.Role;
import org.picketlink.idm.api.RoleType;
import org.picketlink.idm.api.User;
import org.picketlink.idm.api.cfg.IdentityConfigurationRegistry;
import org.picketlink.idm.api.query.GroupQuery;
import org.picketlink.idm.api.query.RoleQuery;
import org.picketlink.idm.api.query.UserQuery;
import org.picketlink.idm.cache.APICacheProvider;
import org.picketlink.idm.cache.GroupSearch;
import org.picketlink.idm.cache.RelationshipSearch;
import org.picketlink.idm.cache.RoleSearch;
import org.picketlink.idm.cache.RoleTypeSearch;
import org.picketlink.idm.cache.UserSearch;
import org.picketlink.idm.impl.api.model.GroupKey;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JBossCacheAPICacheProviderImpl
implements APICacheProvider {
    private static Logger log = Logger.getLogger(JBossCacheAPICacheProviderImpl.class.getName());
    private Cache cache;
    public static final String CONFIG_FILE_OPTION = "cache.configFile";
    public static final String CONFIG_CACHE_REGISTRY_OPTION = "cache.cacheRegistryName";
    public static final String CACHE_PROVIDER_REGISTRY_NAME = "cache.providerRegistryName";
    public static final String CACHE_SCOPE = "cache.scope";
    public static final String NODE_OBJECT_KEY = "object";
    public static final String NODE_QUERY_KEY = "query";
    public static final String NODE_QUERY_UNIQUE_KEY = "query_unique";
    public static final String NODE_MAIN_ROOT = "IDM_ROOT";
    public static final String NODE_COMMON_ROOT = "COMMON_ROOT";
    public static final String NODE_USERS = "USERS";
    public static final String NODE_USERS_COUNT = "USERS_COUNT";
    public static final String NODE_USERS_QUERIES = "USERS_QUERIES";
    public static final String NODE_USERS_CRITERIA = "USERS_CRITERIA";
    public static final String NODE_USERS_SEARCHES = "USERS_SEARCHES";
    public static final String NODE_GROUPS = "GROUPS";
    public static final String NODE_GROUPS_COUNT = "GROUPS_COUNT";
    public static final String NODE_GROUPS_QUERIES = "GROUPS_QUERIES";
    public static final String NODE_GROUPS_CRITERIA = "GROUPS_CRITERIA";
    public static final String NODE_GROUPS_SEARCHES = "GROUPS_SEARCHES";
    public static final String NODE_ROLES = "ROLES";
    public static final String NODE_ROLE_TYPES = "ROLE_TYPES";
    public static final String NODE_ROLE_QUERIES = "ROLE_QUERIES";
    public static final String NODE_ATTRIBUTES = "ATTRIBUTES";
    public static final String NODE_ROLE_PROPERTIES = "NODE_ROLE_PROPERTIES";
    public static final String NODE_ROLE_TYPE_PROPERTIES = "NODE_ROLE_TYPE_PROPERTIES";
    public static final String NODE_ROLE_SEARCHES = "NODE_ROLE_SEARCHES";
    public static final String NODE_ROLE_TYPE_SEARCHES = "NODE_ROLE_TYPE_SEARCHES";
    public static final String NODE_RELATIONSHIP_SEARCHES = "NODE_ROLE_TYPE_SEARCHES";
    public static final String NULL_NS_NODE = "PL_COMMON_NS";
    public static final String MAIN_ROOT = "NODE_MAIN_ROOT";
    private int expiration = -1;

    private Fqn getRootNode() {
        return Fqn.fromString((String)"/NODE_MAIN_ROOT");
    }

    private Fqn getNamespacedFqn(String ns) {
        String namespace = ns != null ? ns : NULL_NS_NODE;
        namespace = namespace.replaceAll("/", "_");
        return Fqn.fromString((String)(this.getRootNode() + "/" + namespace));
    }

    private Fqn getFqn(String ns, String node, Object o) {
        return Fqn.fromString((String)(this.getNamespacedFqn(ns) + "/" + node + "/" + o));
    }

    private Fqn getFqn(String ns, String node) {
        return Fqn.fromString((String)(this.getNamespacedFqn(ns) + "/" + node));
    }

    @Override
    public void initialize(Map<String, String> properties, IdentityConfigurationRegistry configurationRegistry) {
        DefaultCacheFactory factory = new DefaultCacheFactory();
        String registryName = properties.get(CONFIG_CACHE_REGISTRY_OPTION);
        if (registryName != null) {
            try {
                this.cache = (Cache)configurationRegistry.getObject(registryName);
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Cannot find JBoss Cache 'Cache' object in configuration registry with providedname: " + registryName);
            }
            return;
        }
        String config = properties.get(CONFIG_FILE_OPTION);
        if (config == null) {
            throw new IllegalArgumentException("Cannot find 'cache.configFile' in passed properties. Failed to initializecache provider.");
        }
        this.cache = factory.createCache(config);
        this.cache.create();
        this.cache.start();
    }

    public void initialize(InputStream jbossCacheConfiguration) {
        DefaultCacheFactory factory = new DefaultCacheFactory();
        if (jbossCacheConfiguration == null) {
            throw new IllegalArgumentException("JBoss Cache configuration InputStream is null");
        }
        this.cache = factory.createCache(jbossCacheConfiguration);
        this.cache.create();
        this.cache.start();
    }

    public void initialize(Cache cache) {
        this.cache = cache;
        CacheStatus status = cache.getCacheStatus();
        if (status.createAllowed()) {
            this.cache.create();
        }
        if (status.startAllowed()) {
            this.cache.start();
        }
    }

    Cache getCache() {
        return this.cache;
    }

    @Override
    public void invalidate(String ns) {
        boolean success = this.cache.getRoot().removeChild(this.getNamespacedFqn(ns));
        if (log.isLoggable(Level.FINER)) {
            log.finer(this.toString() + "Invalidating namespace:" + ns + "; success=" + success);
        }
    }

    @Override
    public void invalidateAll() {
        boolean success = this.cache.getRoot().removeChild(this.getRootNode());
        if (log.isLoggable(Level.FINER)) {
            log.finer(this.toString() + "Invalidating whole cache - success=" + success);
        }
    }

    @Override
    public String getNamespace(String realmId) {
        if (realmId == null) {
            return NODE_COMMON_ROOT;
        }
        return realmId;
    }

    @Override
    public String getNamespace(String realmId, String sessionId) {
        if (sessionId == null) {
            return this.getNamespace(realmId);
        }
        return realmId + "/" + sessionId;
    }

    @Override
    public void putUser(String ns, User user) {
        Fqn nodeFqn = this.getFqn(ns, NODE_USERS, user.getKey());
        Node ioNode = this.getCache().getRoot().addChild(nodeFqn);
        if (ioNode != null) {
            this.setExpiration(ioNode);
            ioNode.put((Object)NODE_OBJECT_KEY, (Object)user);
            if (log.isLoggable(Level.FINER)) {
                log.finer(this.toString() + "User stored in cache: " + user.getId() + ";namespace=" + ns);
            }
        }
    }

    @Override
    public User getUser(String ns, String id) {
        Fqn nodeFqn = this.getFqn(ns, NODE_USERS, id);
        Node node = this.getCache().getRoot().getChild(nodeFqn);
        if (node != null) {
            User user = (User)node.get((Object)NODE_OBJECT_KEY);
            if (log.isLoggable(Level.FINER) && user != null) {
                log.finer(this.toString() + "User found in cache: id=" + user.getId() + ";namespace=" + ns);
            }
            return user;
        }
        return null;
    }

    @Override
    public void removeUser(String ns, String id) {
        Fqn nodeFqn = this.getFqn(ns, NODE_USERS, id);
        this.getCache().getRoot().removeChild(nodeFqn);
        if (log.isLoggable(Level.FINER)) {
            log.finer(this.toString() + "User removed from cache: id= " + id + ";namespace=" + ns);
        }
    }

    @Override
    public void putUsers(String ns, IdentitySearchCriteria criteria, Collection<User> users) {
        Fqn nodeFqn = this.getFqn(ns, NODE_USERS_CRITERIA, criteria != null ? Integer.valueOf(criteria.hashCode()) : null);
        Node ioNode = this.getCache().getRoot().addChild(nodeFqn);
        if (ioNode != null) {
            this.setExpiration(ioNode);
            ioNode.put((Object)NODE_OBJECT_KEY, (Object)this.unmodifiableCollection(users));
            if (log.isLoggable(Level.FINER)) {
                log.finer(this.toString() + "User criteria search stored in cache: users.size()=" + users.size() + "; criteria.hash()=" + criteria + ";namespace=" + ns);
            }
        }
    }

    @Override
    public Collection<User> getUsers(String ns, IdentitySearchCriteria criteria) {
        Fqn nodeFqn = this.getFqn(ns, NODE_USERS_CRITERIA, criteria != null ? Integer.valueOf(criteria.hashCode()) : null);
        Node node = this.getCache().getRoot().getChild(nodeFqn);
        if (node != null) {
            Collection users = (Collection)node.get((Object)NODE_OBJECT_KEY);
            if (log.isLoggable(Level.FINER) && users != null) {
                log.finer(this.toString() + "User criteria search found in cache: users.size()=" + users.size() + "; criteria.hash()=" + criteria + ";namespace=" + ns);
            }
            return users;
        }
        return null;
    }

    @Override
    public void invalidateUsers(String ns) {
        this.getCache().getRoot().removeChild(Fqn.fromString((String)(this.getNamespacedFqn(ns) + "/" + NODE_USERS)));
        this.getCache().getRoot().removeChild(Fqn.fromString((String)(this.getNamespacedFqn(ns) + "/" + NODE_USERS_COUNT)));
        this.getCache().getRoot().removeChild(Fqn.fromString((String)(this.getNamespacedFqn(ns) + "/" + NODE_USERS_CRITERIA)));
        this.getCache().getRoot().removeChild(Fqn.fromString((String)(this.getNamespacedFqn(ns) + "/" + NODE_USERS_QUERIES)));
        this.getCache().getRoot().removeChild(Fqn.fromString((String)(this.getNamespacedFqn(ns) + "/" + NODE_USERS_SEARCHES)));
        if (log.isLoggable(Level.FINER)) {
            log.finer(this.toString() + "Invalidating Users cache. Namespace:" + ns + ";namespace=" + ns);
        }
    }

    @Override
    public void putUserCount(String ns, int count) {
        Fqn nodeFqn = this.getFqn(ns, NODE_USERS_COUNT);
        Node ioNode = this.getCache().getRoot().addChild(nodeFqn);
        if (ioNode != null) {
            this.setExpiration(ioNode);
            ioNode.put((Object)NODE_OBJECT_KEY, (Object)count);
            if (log.isLoggable(Level.FINER)) {
                log.finer(this.toString() + "Users count stored in cache: " + count + ";namespace=" + ns);
            }
        }
    }

    @Override
    public int getUserCount(String ns) {
        Fqn nodeFqn = this.getFqn(ns, NODE_USERS_COUNT);
        Node node = this.getCache().getRoot().getChild(nodeFqn);
        if (node != null) {
            int count = -1;
            Integer i = (Integer)node.get((Object)NODE_OBJECT_KEY);
            if (i != null) {
                count = i;
            }
            if (log.isLoggable(Level.FINER) && count != -1) {
                log.finer(this.toString() + "User count found in cache: " + count + ";namespace=" + ns);
            }
            return count;
        }
        return -1;
    }

    @Override
    public void invalidateUserCount(String ns) {
        this.getCache().getRoot().removeChild(Fqn.fromString((String)(this.getNamespacedFqn(ns) + "/" + NODE_USERS_COUNT)));
        if (log.isLoggable(Level.FINER)) {
            log.finer(this.toString() + "Invalidating User count. Namespace:" + ns + ";namespace=" + ns);
        }
    }

    @Override
    public void putGroup(String ns, Group group) {
        Fqn nodeFqn = this.getFqn(ns, NODE_GROUPS, group.getKey());
        Node ioNode = this.getCache().getRoot().addChild(nodeFqn);
        if (ioNode != null) {
            this.setExpiration(ioNode);
            ioNode.put((Object)NODE_OBJECT_KEY, (Object)group);
            if (log.isLoggable(Level.FINER)) {
                log.finer(this.toString() + "Group stored in cache: " + group.getKey() + ";namespace=" + ns);
            }
        }
    }

    @Override
    public Group getGroup(String ns, String groupType, String groupName) {
        Fqn nodeFqn = this.getFqn(ns, NODE_GROUPS, GroupKey.parseKey(groupName, groupType));
        Node node = this.getCache().getRoot().getChild(nodeFqn);
        if (node != null) {
            Group group = (Group)node.get((Object)NODE_OBJECT_KEY);
            if (log.isLoggable(Level.FINER) && group != null) {
                log.finer(this.toString() + "Group found in cache: id=" + group.getKey() + ";namespace=" + ns);
            }
            return group;
        }
        return null;
    }

    @Override
    public void removeGroup(String ns, String groupType, String groupName) {
        Fqn nodeFqn = this.getFqn(ns, NODE_GROUPS, GroupKey.parseKey(groupName, groupType));
        this.getCache().getRoot().removeChild(nodeFqn);
        if (log.isLoggable(Level.FINER)) {
            log.finer(this.toString() + "Group removed from cache: id= " + GroupKey.parseKey(groupName, groupType) + ";namespace=" + ns);
        }
    }

    @Override
    public void putGroups(String ns, IdentitySearchCriteria criteria, Collection<Group> groups) {
        Fqn nodeFqn = this.getFqn(ns, NODE_GROUPS_CRITERIA, criteria != null ? Integer.valueOf(criteria.hashCode()) : null);
        Node ioNode = this.getCache().getRoot().addChild(nodeFqn);
        if (ioNode != null) {
            this.setExpiration(ioNode);
            ioNode.put((Object)NODE_OBJECT_KEY, (Object)this.unmodifiableCollection(groups));
            if (log.isLoggable(Level.FINER)) {
                log.finer(this.toString() + "Group criteria search stored in cache: groups.size()=" + groups.size() + "; criteria.hash()=" + criteria + ";namespace=" + ns);
            }
        }
    }

    @Override
    public Collection<Group> getGroups(String ns, IdentitySearchCriteria criteria) {
        Fqn nodeFqn = this.getFqn(ns, NODE_GROUPS_CRITERIA, criteria != null ? Integer.valueOf(criteria.hashCode()) : null);
        Node node = this.getCache().getRoot().getChild(nodeFqn);
        if (node != null) {
            Collection groups = (Collection)node.get((Object)NODE_OBJECT_KEY);
            if (log.isLoggable(Level.FINER) && groups != null) {
                log.finer(this.toString() + "Group criteria search found in cache: groups.size()=" + groups.size() + "; criteria.hash()=" + criteria + ";namespace=" + ns);
            }
            return groups;
        }
        return null;
    }

    @Override
    public void invalidateGroups(String ns) {
        this.getCache().getRoot().removeChild(Fqn.fromString((String)(this.getNamespacedFqn(ns) + "/" + NODE_GROUPS)));
        this.getCache().getRoot().removeChild(Fqn.fromString((String)(this.getNamespacedFqn(ns) + "/" + NODE_GROUPS_COUNT)));
        this.getCache().getRoot().removeChild(Fqn.fromString((String)(this.getNamespacedFqn(ns) + "/" + NODE_GROUPS_CRITERIA)));
        this.getCache().getRoot().removeChild(Fqn.fromString((String)(this.getNamespacedFqn(ns) + "/" + NODE_GROUPS_QUERIES)));
        this.getCache().getRoot().removeChild(Fqn.fromString((String)(this.getNamespacedFqn(ns) + "/" + NODE_GROUPS_SEARCHES)));
        if (log.isLoggable(Level.FINER)) {
            log.finer(this.toString() + "Invalidating Groups cache. Namespace:" + ns + ";namespace=" + ns);
        }
    }

    @Override
    public void putGroupCount(String ns, String groupType, int count) {
        Fqn nodeFqn = this.getFqn(ns, NODE_GROUPS_COUNT, groupType);
        Node ioNode = this.getCache().getRoot().addChild(nodeFqn);
        if (ioNode != null) {
            this.setExpiration(ioNode);
            ioNode.put((Object)NODE_OBJECT_KEY, (Object)count);
            if (log.isLoggable(Level.FINER)) {
                log.finer(this.toString() + "Group count stored in cache: type=" + groupType + "; count=" + count + ";namespace=" + ns);
            }
        }
    }

    @Override
    public int getGroupCount(String ns, String groupType) {
        Fqn nodeFqn = this.getFqn(ns, NODE_GROUPS_COUNT, groupType);
        Node node = this.getCache().getRoot().getChild(nodeFqn);
        if (node != null) {
            int count = -1;
            Integer i = (Integer)node.get((Object)NODE_OBJECT_KEY);
            if (i != null) {
                count = i;
            }
            if (log.isLoggable(Level.FINER) && count != -1) {
                log.finer(this.toString() + "Group count found in cache: groupType=" + groupType + "; count=" + count + ";namespace=" + ns);
            }
            return count;
        }
        return -1;
    }

    @Override
    public void invalidateGroupCount(String ns, String groupType) {
        this.cache.getRoot().removeChild(this.getFqn(ns, NODE_GROUPS_COUNT, groupType));
        if (log.isLoggable(Level.FINER)) {
            log.finer(this.toString() + "Invalidating Group count. Namespace:" + ns);
        }
    }

    @Override
    public void putRole(String ns, Role role) {
        Fqn nodeFqn = this.getFqn(ns, NODE_ROLES, role.hashCode());
        Node ioNode = this.getCache().getRoot().addChild(nodeFqn);
        if (ioNode != null) {
            this.setExpiration(ioNode);
            ioNode.put((Object)NODE_OBJECT_KEY, (Object)role);
            if (log.isLoggable(Level.FINER)) {
                log.finer(this.toString() + "Role stored in cache: " + role + ";namespace=" + ns);
            }
        }
    }

    @Override
    public Role getRole(String ns, Role role) {
        Fqn nodeFqn = this.getFqn(ns, NODE_ROLES, role.hashCode());
        Node node = this.getCache().getRoot().getChild(nodeFqn);
        if (node != null) {
            Role result = (Role)node.get((Object)NODE_OBJECT_KEY);
            if (log.isLoggable(Level.FINER) && result != null) {
                log.finer(this.toString() + "Role found in cache: id=" + result + ";namespace=" + ns);
            }
            return result;
        }
        return null;
    }

    @Override
    public void removeRole(String ns, Role role) {
        this.cache.getRoot().removeChild(this.getFqn(ns, NODE_ROLES, role.hashCode()));
    }

    @Override
    public void putRoleType(String ns, RoleType role) {
        Fqn nodeFqn = this.getFqn(ns, NODE_ROLE_TYPES, role.getName());
        Node ioNode = this.getCache().getRoot().addChild(nodeFqn);
        if (ioNode != null) {
            this.setExpiration(ioNode);
            ioNode.put((Object)NODE_OBJECT_KEY, (Object)role);
            if (log.isLoggable(Level.FINER)) {
                log.finer(this.toString() + "RoleType stored in cache: name=" + role.getName() + ";namespace=" + ns);
            }
        }
    }

    @Override
    public RoleType getRoleType(String ns, RoleType role) {
        Fqn nodeFqn = this.getFqn(ns, NODE_ROLE_TYPES, role.getName());
        Node node = this.getCache().getRoot().getChild(nodeFqn);
        if (node != null) {
            RoleType result = (RoleType)node.get((Object)NODE_OBJECT_KEY);
            if (log.isLoggable(Level.FINER) && result != null) {
                log.finer(this.toString() + "RoleType found in cache: name=" + role.getName() + ";namespace=" + ns);
            }
            return result;
        }
        return null;
    }

    @Override
    public void removeRoleType(String ns, RoleType roleType) {
        this.cache.getRoot().removeChild(this.getFqn(ns, NODE_ROLE_TYPES, roleType.getName()));
    }

    @Override
    public void putAttributes(String ns, String id, Map<String, Attribute> attributes) {
        Fqn nodeFqn = this.getFqn(ns, NODE_ATTRIBUTES, id);
        Node ioNode = this.getCache().getRoot().addChild(nodeFqn);
        if (ioNode != null) {
            this.setExpiration(ioNode);
            ioNode.put((Object)NODE_OBJECT_KEY, Collections.unmodifiableMap(attributes));
            if (log.isLoggable(Level.FINER)) {
                log.finer(this.toString() + "Attributes stored in cache: id=" + id + "; attributes.size()=" + attributes.size() + ";namespace=" + ns);
            }
        }
    }

    @Override
    public Map<String, Attribute> getAttributes(String ns, String id) {
        Fqn nodeFqn = this.getFqn(ns, NODE_ATTRIBUTES, id);
        Node node = this.getCache().getRoot().getChild(nodeFqn);
        if (node != null) {
            Map attributes = (Map)node.get((Object)NODE_OBJECT_KEY);
            if (log.isLoggable(Level.FINER) && attributes != null) {
                log.finer(this.toString() + "Attributes search found in cache: attributes.size()=" + attributes.size() + "; id=" + id + ";namespace=" + ns);
            }
            return attributes;
        }
        return null;
    }

    @Override
    public void invalidateAttributes(String ns, String id) {
        this.cache.getRoot().removeChild(this.getFqn(ns, NODE_ATTRIBUTES, id));
        if (log.isLoggable(Level.FINER)) {
            log.finer(this.toString() + "Invalidating Attributes. id=" + id + ";namespace:" + ns);
        }
    }

    @Override
    public void invalidateAttributes(String ns) {
        this.cache.getRoot().removeChild(this.getFqn(ns, NODE_ATTRIBUTES));
        if (log.isLoggable(Level.FINER)) {
            log.finer(this.toString() + "Invalidating Attributes. Namespace:" + ns);
        }
    }

    @Override
    public void putProperties(String ns, Role role, Map<String, String> properties) {
        Fqn nodeFqn = this.getFqn(ns, NODE_ROLE_PROPERTIES, role.hashCode());
        Node ioNode = this.getCache().getRoot().addChild(nodeFqn);
        if (ioNode != null) {
            this.setExpiration(ioNode);
            ioNode.put((Object)NODE_OBJECT_KEY, Collections.unmodifiableMap(properties));
            if (log.isLoggable(Level.FINER)) {
                log.finer(this.toString() + "Role properties stored in cache: role=" + role + "; properties.size()=" + properties.size() + ";namespace=" + ns);
            }
        }
    }

    @Override
    public Map<String, String> getProperties(String ns, Role role) {
        Fqn nodeFqn = this.getFqn(ns, NODE_ROLE_PROPERTIES, role.hashCode());
        Node node = this.getCache().getRoot().getChild(nodeFqn);
        if (node != null) {
            Map props = (Map)node.get((Object)NODE_OBJECT_KEY);
            if (log.isLoggable(Level.FINER) && props != null) {
                log.finer(this.toString() + "Role properties found in cache: properties.size()=" + props.size() + "; role=" + role + ";namespace=" + ns);
            }
            return props;
        }
        return null;
    }

    @Override
    public void invalidateRoleProperties(String ns, Role role) {
        this.cache.getRoot().removeChild(this.getFqn(ns, NODE_ROLE_PROPERTIES, role.hashCode()));
        if (log.isLoggable(Level.FINER)) {
            log.finer(this.toString() + "Invalidating Role properties. role=" + role + "; Namespace:" + ns);
        }
    }

    @Override
    public void invalidateRoleProperties(String ns) {
        this.cache.getRoot().removeChild(this.getFqn(ns, NODE_ROLE_PROPERTIES));
        if (log.isLoggable(Level.FINER)) {
            log.finer(this.toString() + "Invalidating Role properties. Namespace:" + ns);
        }
    }

    @Override
    public void putProperties(String ns, RoleType roleType, Map<String, String> properties) {
        Fqn nodeFqn = this.getFqn(ns, NODE_ROLE_TYPE_PROPERTIES, roleType.hashCode());
        Node ioNode = this.getCache().getRoot().addChild(nodeFqn);
        if (ioNode != null) {
            this.setExpiration(ioNode);
            ioNode.put((Object)NODE_OBJECT_KEY, Collections.unmodifiableMap(properties));
            if (log.isLoggable(Level.FINER)) {
                log.finer(this.toString() + "RoleType properties stored in cache: roleType=" + roleType + "; properties.size()=" + properties.size() + ";namespace=" + ns);
            }
        }
    }

    @Override
    public Map<String, String> getProperties(String ns, RoleType roleType) {
        Fqn nodeFqn = this.getFqn(ns, NODE_ROLE_TYPE_PROPERTIES, roleType.hashCode());
        Node node = this.getCache().getRoot().getChild(nodeFqn);
        if (node != null) {
            Map props = (Map)node.get((Object)NODE_OBJECT_KEY);
            if (log.isLoggable(Level.FINER) && props != null) {
                log.finer(this.toString() + "RoleType properties found in cache: properties.size()=" + props.size() + "; roleType=" + roleType + ";namespace=" + ns);
            }
            return props;
        }
        return null;
    }

    @Override
    public void invalidateRoleTypeProperties(String ns, RoleType roleType) {
        this.cache.getRoot().removeChild(this.getFqn(ns, NODE_ROLE_TYPE_PROPERTIES, roleType.hashCode()));
        if (log.isLoggable(Level.FINER)) {
            log.finer(this.toString() + "Invalidating RoleType properties. roleType=" + roleType + "; Namespace:" + ns);
        }
    }

    @Override
    public void invalidateRoleTypeProperties(String ns) {
        this.cache.getRoot().removeChild(this.getFqn(ns, NODE_ROLE_TYPE_PROPERTIES));
        if (log.isLoggable(Level.FINER)) {
            log.finer(this.toString() + "Invalidating RoleType properties. Namespace:" + ns);
        }
    }

    @Override
    public void invalidateAllSearches(String ns) {
        this.cache.getRoot().removeChild(this.getFqn(ns, NODE_USERS_SEARCHES));
        this.cache.getRoot().removeChild(this.getFqn(ns, NODE_GROUPS_SEARCHES));
        this.cache.getRoot().removeChild(this.getFqn(ns, "NODE_ROLE_TYPE_SEARCHES"));
        this.cache.getRoot().removeChild(this.getFqn(ns, NODE_ROLE_SEARCHES));
        this.cache.getRoot().removeChild(this.getFqn(ns, "NODE_ROLE_TYPE_SEARCHES"));
        this.cache.getRoot().removeChild(this.getFqn(ns, NODE_ROLES));
        this.cache.getRoot().removeChild(this.getFqn(ns, NODE_ROLE_TYPES));
        if (log.isLoggable(Level.FINER)) {
            log.finer(this.toString() + "Invalidating all searches. Namespace:" + ns);
        }
    }

    @Override
    public void putUserSearch(String ns, UserSearch search, Collection<User> results) {
        Fqn nodeFqn = this.getFqn(ns, NODE_USERS_SEARCHES, search.hashCode());
        Node ioNode = this.getCache().getRoot().addChild(nodeFqn);
        if (ioNode != null) {
            this.setExpiration(ioNode);
            ioNode.put((Object)NODE_OBJECT_KEY, (Object)this.unmodifiableCollection(results));
            if (log.isLoggable(Level.FINER)) {
                log.finer(this.toString() + "User search stored in cache: results.size()=" + results.size() + ";namespace=" + ns);
            }
        }
    }

    @Override
    public Collection<User> getUserSearch(String ns, UserSearch search) {
        Fqn nodeFqn = this.getFqn(ns, NODE_USERS_SEARCHES, search.hashCode());
        Node node = this.getCache().getRoot().getChild(nodeFqn);
        if (node != null) {
            Collection props = (Collection)node.get((Object)NODE_OBJECT_KEY);
            if (log.isLoggable(Level.FINER) && props != null) {
                log.finer(this.toString() + "User search found in cache: properties.size()=" + props.size() + ";namespace=" + ns);
            }
            return props;
        }
        return null;
    }

    @Override
    public void putGroupSearch(String ns, GroupSearch search, Collection<Group> results) {
        Fqn nodeFqn = this.getFqn(ns, NODE_GROUPS_SEARCHES, search.hashCode());
        Node ioNode = this.getCache().getRoot().addChild(nodeFqn);
        if (ioNode != null) {
            this.setExpiration(ioNode);
            ioNode.put((Object)NODE_OBJECT_KEY, (Object)this.unmodifiableCollection(results));
            if (log.isLoggable(Level.FINER)) {
                log.finer(this.toString() + "Group search stored in cache: results.size()=" + results.size() + ";namespace=" + ns);
            }
        }
    }

    @Override
    public Collection<Group> getGroupSearch(String ns, GroupSearch search) {
        Fqn nodeFqn = this.getFqn(ns, NODE_GROUPS_SEARCHES, search.hashCode());
        Node node = this.getCache().getRoot().getChild(nodeFqn);
        if (node != null) {
            Collection results = (Collection)node.get((Object)NODE_OBJECT_KEY);
            if (log.isLoggable(Level.FINER) && results != null) {
                log.finer(this.toString() + "Group search found in cache: results.size()=" + results.size() + ";namespace=" + ns);
            }
            return results;
        }
        return null;
    }

    @Override
    public void putRelationshipSearch(String ns, RelationshipSearch search, Boolean result) {
        Fqn nodeFqn = this.getFqn(ns, "NODE_ROLE_TYPE_SEARCHES", search.hashCode());
        Node ioNode = this.getCache().getRoot().addChild(nodeFqn);
        if (ioNode == null) {
            this.setExpiration(ioNode);
            ioNode.put((Object)NODE_OBJECT_KEY, (Object)result);
            if (log.isLoggable(Level.FINER)) {
                log.finer(this.toString() + "Relationship search stored in cache: result=" + result + ";namespace=" + ns);
            }
        }
    }

    @Override
    public Boolean getRelationshipSearch(String ns, RelationshipSearch search) {
        Fqn nodeFqn = this.getFqn(ns, "NODE_ROLE_TYPE_SEARCHES", search.hashCode());
        Node node = this.getCache().getRoot().getChild(nodeFqn);
        if (node != null) {
            Boolean result = (Boolean)node.get((Object)NODE_OBJECT_KEY);
            if (log.isLoggable(Level.FINER) && result != null) {
                log.finer(this.toString() + "Relationship search found in cache: properties.size()=" + result + ";namespace=" + ns);
            }
            return result;
        }
        return null;
    }

    @Override
    public void putRoleSearch(String ns, RoleSearch search, Collection<Role> results) {
        Fqn nodeFqn = this.getFqn(ns, NODE_ROLE_SEARCHES, search.hashCode());
        Node ioNode = this.getCache().getRoot().addChild(nodeFqn);
        if (ioNode != null) {
            this.setExpiration(ioNode);
            ioNode.put((Object)NODE_OBJECT_KEY, (Object)this.unmodifiableCollection(results));
            if (log.isLoggable(Level.FINER)) {
                log.finer(this.toString() + "Role search stored in cache: results.size()=" + results.size() + ";namespace=" + ns);
            }
        }
    }

    @Override
    public Collection<Role> getRoleSearch(String ns, RoleSearch search) {
        Fqn nodeFqn = this.getFqn(ns, NODE_ROLE_SEARCHES, search.hashCode());
        Node node = this.getCache().getRoot().getChild(nodeFqn);
        if (node != null) {
            Collection results = (Collection)node.get((Object)NODE_OBJECT_KEY);
            if (log.isLoggable(Level.FINER) && results != null) {
                log.finer(this.toString() + "Role search found in cache: results.size()=" + results.size() + ";namespace=" + ns);
            }
            return results;
        }
        return null;
    }

    @Override
    public void putRoleTypeSearch(String ns, RoleTypeSearch search, Collection<RoleType> results) {
        Fqn nodeFqn = this.getFqn(ns, "NODE_ROLE_TYPE_SEARCHES", search.hashCode());
        Node ioNode = this.getCache().getRoot().addChild(nodeFqn);
        if (ioNode != null) {
            this.setExpiration(ioNode);
            ioNode.put((Object)NODE_OBJECT_KEY, (Object)this.unmodifiableCollection(results));
            if (log.isLoggable(Level.FINER)) {
                log.finer(this.toString() + "RoleType search stored in cache: results.size()=" + results.size() + ";namespace=" + ns);
            }
        }
    }

    @Override
    public Collection<RoleType> getRoleTypeSearch(String ns, RoleTypeSearch search) {
        Fqn nodeFqn = this.getFqn(ns, "NODE_ROLE_TYPE_SEARCHES", search.hashCode());
        Node node = this.getCache().getRoot().getChild(nodeFqn);
        if (node != null) {
            Collection results = (Collection)node.get((Object)NODE_OBJECT_KEY);
            if (log.isLoggable(Level.FINER) && results != null) {
                log.finer(this.toString() + "RoleType search found in cache: results.size()=" + results.size() + ";namespace=" + ns);
            }
            return results;
        }
        return null;
    }

    @Override
    public void invalidateAllQueries(String ns) {
        this.cache.getRoot().removeChild(this.getFqn(ns, NODE_USERS_QUERIES));
        this.cache.getRoot().removeChild(this.getFqn(ns, NODE_GROUPS_QUERIES));
        this.cache.getRoot().removeChild(this.getFqn(ns, NODE_ROLE_QUERIES));
        if (log.isLoggable(Level.FINER)) {
            log.finer(this.toString() + "Invalidating all queries. Namespace:" + ns);
        }
    }

    @Override
    public void putUserQuery(String ns, UserQuery q, Collection<User> results) {
        Fqn nodeFqn = this.getFqn(ns, NODE_USERS_QUERIES, q.hashCode());
        Node ioNode = this.getCache().getRoot().addChild(nodeFqn);
        if (ioNode != null) {
            this.setExpiration(ioNode);
            ioNode.put((Object)NODE_QUERY_KEY, results);
            if (log.isLoggable(Level.FINER)) {
                log.finer(this.toString() + "User query stored in cache: q.hashCode()=" + q.hashCode() + "; results.size()=" + results.size() + ";namespace=" + ns);
            }
        }
    }

    @Override
    public void putUserQueryUnique(String ns, UserQuery q, User user) {
        Fqn nodeFqn = this.getFqn(ns, NODE_USERS_QUERIES, q.hashCode());
        Node ioNode = this.getCache().getRoot().addChild(nodeFqn);
        if (ioNode != null) {
            this.setExpiration(ioNode);
            ioNode.put((Object)NODE_QUERY_UNIQUE_KEY, (Object)user);
            if (log.isLoggable(Level.FINER)) {
                log.finer(this.toString() + "User query stored in cache: q.hashCode()=" + q.hashCode() + "; user=" + user + ";namespace=" + ns);
            }
        }
    }

    @Override
    public Collection<User> getUserQuery(String ns, UserQuery q) {
        Fqn nodeFqn = this.getFqn(ns, NODE_USERS_QUERIES, q.hashCode());
        Node node = this.getCache().getRoot().getChild(nodeFqn);
        if (node != null) {
            Collection users = (Collection)node.get((Object)NODE_QUERY_KEY);
            if (log.isLoggable(Level.FINER) && users != null) {
                log.finer(this.toString() + "User query found in cache: users.size()=" + users.size() + "; query.hash()=" + q.hashCode() + ";namespace=" + ns);
            }
            return users;
        }
        return null;
    }

    @Override
    public User getUserQueryUnique(String ns, UserQuery q) {
        Fqn nodeFqn = this.getFqn(ns, NODE_USERS_QUERIES, q.hashCode());
        Node node = this.getCache().getRoot().getChild(nodeFqn);
        if (node != null) {
            User users = (User)node.get((Object)NODE_QUERY_UNIQUE_KEY);
            if (log.isLoggable(Level.FINER) && users != null) {
                log.finer(this.toString() + "User query found in cache: user=" + users + ";namespace=" + ns);
            }
            return users;
        }
        return null;
    }

    @Override
    public void invalidateUserQueries(String ns) {
        this.cache.getRoot().removeChild(this.getFqn(ns, NODE_USERS_QUERIES));
        if (log.isLoggable(Level.FINER)) {
            log.finer(this.toString() + "Invalidating User queries. Namespace:" + ns);
        }
    }

    @Override
    public void putGroupQuery(String ns, GroupQuery q, Collection<Group> results) {
        Fqn nodeFqn = this.getFqn(ns, NODE_GROUPS_QUERIES, q.hashCode());
        Node ioNode = this.getCache().getRoot().addChild(nodeFqn);
        if (ioNode != null) {
            this.setExpiration(ioNode);
            ioNode.put((Object)NODE_QUERY_KEY, (Object)this.unmodifiableCollection(results));
            if (log.isLoggable(Level.FINER)) {
                log.finer(this.toString() + "Group query stored in cache: q.hashCode()=" + q.hashCode() + "; results.size()=" + results.size() + ";namespace=" + ns);
            }
        }
    }

    @Override
    public void putGroupQueryUnique(String ns, GroupQuery q, Group group) {
        Fqn nodeFqn = this.getFqn(ns, NODE_GROUPS_QUERIES, q.hashCode());
        Node ioNode = this.getCache().getRoot().addChild(nodeFqn);
        if (ioNode != null) {
            this.setExpiration(ioNode);
            ioNode.put((Object)NODE_QUERY_UNIQUE_KEY, (Object)group);
            if (log.isLoggable(Level.FINER)) {
                log.finer(this.toString() + "Group query stored in cache: q.hashCode()=" + q.hashCode() + "; group=" + group + ";namespace=" + ns);
            }
        }
    }

    @Override
    public Collection<Group> getGroupQuery(String ns, GroupQuery q) {
        Fqn nodeFqn = this.getFqn(ns, NODE_GROUPS_QUERIES, q.hashCode());
        Node node = this.getCache().getRoot().getChild(nodeFqn);
        if (node != null) {
            Collection groups = (Collection)node.get((Object)NODE_QUERY_KEY);
            if (log.isLoggable(Level.FINER) && groups != null) {
                log.finer(this.toString() + "Group query found in cache: groups.size()=" + groups.size() + "; query.hash()=" + q.hashCode() + ";namespace=" + ns);
            }
            return groups;
        }
        return null;
    }

    @Override
    public Group getGroupQueryUnique(String ns, GroupQuery q) {
        Fqn nodeFqn = this.getFqn(ns, NODE_GROUPS_QUERIES, q.hashCode());
        Node node = this.getCache().getRoot().getChild(nodeFqn);
        if (node != null) {
            Group group = (Group)node.get((Object)NODE_QUERY_UNIQUE_KEY);
            if (log.isLoggable(Level.FINER) && group != null) {
                log.finer(this.toString() + "Group query found in cache: group=" + group + ";namespace=" + ns);
            }
            return group;
        }
        return null;
    }

    @Override
    public void invalidateGroupQueries(String ns) {
        this.cache.getRoot().removeChild(this.getFqn(ns, NODE_GROUPS_QUERIES));
        if (log.isLoggable(Level.FINER)) {
            log.finer(this.toString() + "Invalidating Group queries. Namespace:" + ns);
        }
    }

    @Override
    public void putRoleQuery(String ns, RoleQuery q, Collection<Role> results) {
        Fqn nodeFqn = this.getFqn(ns, NODE_ROLE_QUERIES, q.hashCode());
        Node ioNode = this.getCache().getRoot().addChild(nodeFqn);
        if (ioNode != null) {
            this.setExpiration(ioNode);
            ioNode.put((Object)NODE_QUERY_KEY, results);
            if (log.isLoggable(Level.FINER)) {
                log.finer(this.toString() + "Role query stored in cache: q.hashCode()=" + q.hashCode() + "; results.size()=" + results.size() + ";namespace=" + ns);
            }
        }
    }

    @Override
    public void putRoleQueryUnique(String ns, RoleQuery q, Role role) {
        Fqn nodeFqn = this.getFqn(ns, NODE_ROLE_QUERIES, q.hashCode());
        Node ioNode = this.getCache().getRoot().addChild(nodeFqn);
        if (ioNode != null) {
            this.setExpiration(ioNode);
            ioNode.put((Object)NODE_QUERY_UNIQUE_KEY, (Object)role);
            if (log.isLoggable(Level.FINER)) {
                log.finer(this.toString() + "Role query stored in cache: q.hashCode()=" + q.hashCode() + "; role=" + role + ";namespace=" + ns);
            }
        }
    }

    @Override
    public Collection<Role> getRoleQuery(String ns, RoleQuery q) {
        Fqn nodeFqn = this.getFqn(ns, NODE_ROLE_QUERIES, q.hashCode());
        Node node = this.getCache().getRoot().getChild(nodeFqn);
        if (node != null) {
            Collection roles = (Collection)node.get((Object)NODE_QUERY_KEY);
            if (log.isLoggable(Level.FINER) && roles != null) {
                log.finer(this.toString() + "Role query found in cache: users.size()=" + roles.size() + "; query.hash()=" + q.hashCode() + ";namespace=" + ns);
            }
            return roles;
        }
        return null;
    }

    @Override
    public Role getRoleQueryUnique(String ns, RoleQuery q) {
        Fqn nodeFqn = this.getFqn(ns, NODE_ROLE_QUERIES, q.hashCode());
        Node node = this.getCache().getRoot().getChild(nodeFqn);
        if (node != null) {
            Role role = (Role)node.get((Object)NODE_QUERY_UNIQUE_KEY);
            if (log.isLoggable(Level.FINER) && role != null) {
                log.finer(this.toString() + "Role query found in cache: role=" + role + ";namespace=" + ns);
            }
            return role;
        }
        return null;
    }

    @Override
    public void invalidateRoleQueries(String ns) {
        this.cache.getRoot().removeChild(this.getFqn(ns, NODE_ROLE_QUERIES));
        if (log.isLoggable(Level.FINER)) {
            log.finer(this.toString() + "Invalidating Role queries. Namespace:" + ns);
        }
    }

    private Collection unmodifiableCollection(Collection collection) {
        if (collection == null) {
            return collection;
        }
        if (collection instanceof List) {
            return Collections.unmodifiableList((List)collection);
        }
        if (collection instanceof SortedSet) {
            return Collections.unmodifiableSortedSet((SortedSet)collection);
        }
        if (collection instanceof Set) {
            return Collections.unmodifiableSet((Set)collection);
        }
        return Collections.unmodifiableCollection(collection);
    }

    public void setExpiration(Node node) {
        if (this.expiration != -1 && this.expiration > 0) {
            Long future = new Long(System.currentTimeMillis() + (long)this.expiration);
            node.put((Object)"expiration", (Object)future);
        }
    }

    public int getExpiration() {
        return this.expiration;
    }

    public void setExpiration(int expiration) {
        this.expiration = expiration;
    }
}

