/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.commands.read;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.cache.Fqn;
import org.jboss.cache.InvocationContext;
import org.jboss.cache.NodeSPI;
import org.jboss.cache.commands.Visitor;
import org.jboss.cache.commands.read.AbstractDataCommand;

public class GetNodeCommand
extends AbstractDataCommand {
    public static final int METHOD_ID = 31;
    private static final Log log = LogFactory.getLog(GetNodeCommand.class);
    private static final boolean trace = log.isTraceEnabled();

    public GetNodeCommand(Fqn fqn) {
        this.fqn = fqn;
    }

    public GetNodeCommand() {
    }

    public Object perform(InvocationContext ctx) {
        NodeSPI node = ctx.lookUpNode(this.fqn);
        if (node != null && node.isDeleted()) {
            if (trace) {
                log.trace((Object)("Node of type [" + node.getClass().getSimpleName() + "] found but marked as deleted in current scope.  Returning null."));
            }
            return null;
        }
        if (trace) {
            log.trace((Object)("Found node, returning " + node));
        }
        return node;
    }

    public Object acceptVisitor(InvocationContext ctx, Visitor visitor) throws Throwable {
        return visitor.visitGetNodeCommand(ctx, this);
    }

    public int getCommandId() {
        return 31;
    }
}

