/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.idm.integration.jboss5;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.hibernate.Query;
import org.hibernate.SessionFactory;
import org.hibernate.cfg.Configuration;
import org.hibernate.classic.Session;
import org.hibernate.exception.SQLGrammarException;
import org.hibernate.metadata.ClassMetadata;
import org.hibernate.tool.hbm2ddl.SchemaExport;
import org.hibernate.tool.hbm2ddl.SchemaUpdate;

public class HibernatePopulator {
    private static Logger logger = Logger.getLogger(HibernatePopulator.class.getName());
    private static final int RESULT_NONE = 0;
    private static final int RESULT_UPDATE = 1;
    private static final int RESULT_CREATE = 2;
    private boolean doChecking;
    private Configuration config;
    private SessionFactory sessionFactory;

    public HibernatePopulator(boolean doChecking, Configuration config) {
        this.doChecking = doChecking;
        this.config = config;
    }

    public void populateSchema() {
        this.sessionFactory = this.config.buildSessionFactory();
        if (this.doChecking) {
            int check = this.doCheck();
            switch (check) {
                case 0: {
                    break;
                }
                case 1: {
                    this.updateSchema();
                    break;
                }
                case 2: {
                    this.createSchema();
                }
            }
        } else {
            this.createSchema();
        }
        this.sessionFactory.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int doCheck() {
        Session session = null;
        int numOfChecks = 0;
        int bad = 0;
        try {
            session = this.sessionFactory.openSession();
            Collection values = this.sessionFactory.getAllClassMetadata().values();
            numOfChecks = values.size();
            for (ClassMetadata cmd : values) {
                Query query = session.createQuery("from " + cmd.getEntityName());
                query.setFirstResult(0);
                query.setMaxResults(0);
                try {
                    query.list();
                }
                catch (SQLGrammarException e) {
                    ++bad;
                }
            }
        }
        finally {
            this.sessionFactory.close();
        }
        if (bad == 0) {
            logger.fine("The schema was checked as valid");
            return 0;
        }
        if (bad == numOfChecks) {
            logger.fine("The schema was checked as not exists");
            return 2;
        }
        if (bad < numOfChecks) {
            logger.fine("The schema was checked as need updates");
            return 1;
        }
        logger.fine("The schema was checked as need to be created");
        return 2;
    }

    private void createSchema() {
        logger.fine("Creating database schema");
        SchemaExport export = new SchemaExport(this.config);
        export.create(false, true);
    }

    private void destroySchema() {
        logger.fine("Destroying database schema");
        SchemaExport export = new SchemaExport(this.config);
        export.drop(false, true);
    }

    private void updateSchema() {
        logger.fine("Updating database schema");
        SchemaUpdate update = new SchemaUpdate(this.config);
        update.execute(false, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getString(InputStream in) {
        try {
            ByteArrayOutputStream out = new ByteArrayOutputStream(in.available());
            byte[] buffer = new byte[512];
            while (true) {
                int i;
                if ((i = in.read(buffer)) == 0) {
                    continue;
                }
                if (i == -1) break;
                out.write(buffer, 0, i);
            }
            String i = out.toString("UTF-8");
            return i;
        }
        catch (IOException e) {
            logger.log(Level.SEVERE, "error in converting inputstream into string", e);
            String string = null;
            return string;
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException e) {
                    logger.log(Level.SEVERE, "error in closing inputstream", e);
                }
            }
        }
    }
}

