/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.interceptors;

import java.util.List;
import java.util.Vector;
import javax.transaction.Transaction;
import org.jboss.cache.InvocationContext;
import org.jboss.cache.RPCManager;
import org.jboss.cache.buddyreplication.BuddyManager;
import org.jboss.cache.cluster.ReplicationQueue;
import org.jboss.cache.commands.CommandsFactory;
import org.jboss.cache.commands.ReplicableCommand;
import org.jboss.cache.commands.VisitableCommand;
import org.jboss.cache.config.Option;
import org.jboss.cache.factories.annotations.Inject;
import org.jboss.cache.factories.annotations.Start;
import org.jboss.cache.interceptors.base.CommandInterceptor;
import org.jboss.cache.transaction.GlobalTransaction;
import org.jboss.cache.transaction.TransactionContext;
import org.jboss.cache.transaction.TransactionTable;
import org.jgroups.Address;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BaseRpcInterceptor
extends CommandInterceptor {
    private BuddyManager buddyManager;
    private boolean usingBuddyReplication;
    private ReplicationQueue replicationQueue;
    protected TransactionTable txTable;
    private CommandsFactory commandsFactory;
    protected RPCManager rpcManager;
    protected boolean defaultSynchronous;

    @Inject
    public void injectComponents(RPCManager rpcManager, BuddyManager buddyManager, ReplicationQueue replicationQueue, TransactionTable txTable, CommandsFactory commandsFactory) {
        this.rpcManager = rpcManager;
        this.replicationQueue = replicationQueue;
        this.buddyManager = buddyManager;
        this.txTable = txTable;
        this.commandsFactory = commandsFactory;
    }

    @Start
    void init() {
        this.usingBuddyReplication = this.configuration.getBuddyReplicationConfig() != null && this.configuration.getBuddyReplicationConfig().isEnabled();
        this.defaultSynchronous = this.configuration.getCacheMode().isSynchronous();
    }

    protected void checkResponses(List rsps) throws Throwable {
        if (rsps != null) {
            for (Object rsp : rsps) {
                if (rsp == null || !(rsp instanceof Throwable)) continue;
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)"Received Throwable from remote node", (Throwable)rsp);
                }
                throw (Throwable)rsp;
            }
        }
    }

    protected void replicateCall(InvocationContext ctx, ReplicableCommand call, boolean sync, Option o, boolean useOutOfBandMessage) throws Throwable {
        this.replicateCall(ctx, null, call, sync, o, useOutOfBandMessage);
    }

    protected void replicateCall(InvocationContext ctx, ReplicableCommand call, boolean sync, Option o) throws Throwable {
        this.replicateCall(ctx, null, call, sync, o, false);
    }

    protected void replicateCall(InvocationContext ctx, Vector<Address> recipients, ReplicableCommand c, boolean sync, Option o, boolean useOutOfBandMessage) throws Throwable {
        TransactionContext transactionContext;
        Transaction tx;
        long syncReplTimeout = this.configuration.getSyncReplTimeout();
        if (o != null) {
            if (o.isForceAsynchronous()) {
                sync = false;
            } else if (o.isForceSynchronous()) {
                sync = true;
            }
            if (o.getSyncReplTimeout() > 0L) {
                syncReplTimeout = o.getSyncReplTimeout();
            }
        }
        if ((tx = ctx.getTransaction()) != null && (transactionContext = ctx.getTransactionContext()) != null) {
            if (transactionContext.isForceAsyncReplication()) {
                sync = false;
            } else if (transactionContext.isForceSyncReplication()) {
                sync = true;
            }
        }
        this.replicateCall(recipients, c, sync, true, useOutOfBandMessage, false, syncReplTimeout);
    }

    protected void replicateCall(Vector<Address> recipients, ReplicableCommand call, boolean sync, boolean wrapCacheCommandInReplicateMethod, boolean useOutOfBandMessage, boolean isBroadcast, long timeout) throws Throwable {
        if (this.trace) {
            this.log.trace((Object)("Broadcasting call " + call + " to recipient list " + recipients));
        }
        if (!sync && this.replicationQueue != null && !this.usingBuddyReplication) {
            if (this.trace) {
                this.log.trace((Object)("Putting call " + call + " on the replication queue."));
            }
            this.replicationQueue.add(this.commandsFactory.buildReplicateCommand(call));
        } else {
            Vector<Address> callRecipients;
            if (this.usingBuddyReplication && !isBroadcast) {
                call = this.buddyManager.transformFqns((VisitableCommand)call);
            }
            if ((callRecipients = recipients) == null) {
                Vector<Address> vector = callRecipients = this.usingBuddyReplication && !isBroadcast ? this.buddyManager.getBuddyAddressesAsVector() : null;
                if (this.trace) {
                    this.log.trace((Object)("Setting call recipients to " + callRecipients + " since the original list of recipients passed in is null."));
                }
            }
            ReplicableCommand toCall = wrapCacheCommandInReplicateMethod ? this.commandsFactory.buildReplicateCommand(call) : call;
            List<Object> rsps = this.rpcManager.callRemoteMethods(callRecipients, toCall, sync, timeout, useOutOfBandMessage);
            if (this.trace) {
                this.log.trace((Object)("responses=" + rsps));
            }
            if (sync) {
                this.checkResponses(rsps);
            }
        }
    }

    protected boolean skipReplicationOfTransactionMethod(InvocationContext ctx) {
        GlobalTransaction gtx = ctx.getGlobalTransaction();
        return ctx.getTransaction() == null || gtx == null || gtx.isRemote() || ctx.getOptionOverrides().isCacheModeLocal() || !ctx.getTransactionContext().hasModifications();
    }

    protected boolean isTransactionalAndLocal(InvocationContext ctx) {
        GlobalTransaction gtx = ctx.getGlobalTransaction();
        boolean isInitiatedHere = gtx != null && !gtx.isRemote();
        return isInitiatedHere && ctx.getTransaction() != null;
    }

    protected boolean isSynchronous(Option option) {
        if (option != null) {
            if (option.isForceSynchronous()) {
                return true;
            }
            if (option.isForceAsynchronous()) {
                return false;
            }
        }
        return this.defaultSynchronous;
    }

    protected boolean isLocalModeForced(InvocationContext ctx) {
        if (ctx.getOptionOverrides() != null && ctx.getOptionOverrides().isCacheModeLocal()) {
            if (this.trace) {
                this.log.trace((Object)"LOCAL mode forced on invocation.  Suppressing clustered events.");
            }
            return true;
        }
        return false;
    }
}

