/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.util.concurrent;

import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SelfInitializingConcurrentHashMap<K, V>
implements ConcurrentMap<K, V> {
    private volatile ConcurrentMap<K, V> delegate;

    private ConcurrentMap<K, V> getDelegate() {
        if (this.delegate == null) {
            this.init();
        }
        return this.delegate;
    }

    private synchronized void init() {
        if (this.delegate == null) {
            this.delegate = new ConcurrentHashMap(1, 0.75f, 4);
        }
    }

    @Override
    public final V put(K key, V value) {
        return this.getDelegate().put(key, value);
    }

    @Override
    public final V remove(Object key) {
        return this.getDelegate().remove(key);
    }

    @Override
    public final void putAll(Map<? extends K, ? extends V> m) {
        this.getDelegate().putAll(m);
    }

    @Override
    public final V putIfAbsent(K key, V value) {
        return this.getDelegate().putIfAbsent(key, value);
    }

    @Override
    public final boolean replace(K key, V oldValue, V newValue) {
        return this.getDelegate().replace(key, oldValue, newValue);
    }

    @Override
    public final V replace(K key, V value) {
        return this.getDelegate().replace(key, value);
    }

    @Override
    public final boolean remove(Object key, Object value) {
        return this.delegate != null && this.delegate.remove(key, value);
    }

    @Override
    public final int size() {
        return this.delegate == null ? 0 : this.delegate.size();
    }

    @Override
    public final boolean isEmpty() {
        return this.delegate == null || this.delegate.isEmpty();
    }

    @Override
    public final boolean containsKey(Object key) {
        return this.delegate != null && this.delegate.containsKey(key);
    }

    @Override
    public final boolean containsValue(Object value) {
        return this.delegate != null && this.delegate.containsValue(value);
    }

    @Override
    public final V get(Object key) {
        return this.delegate == null ? null : (V)this.delegate.get(key);
    }

    @Override
    public final void clear() {
        if (this.delegate != null) {
            this.delegate.clear();
        }
    }

    @Override
    public final Set<K> keySet() {
        if (this.delegate == null || this.delegate.isEmpty()) {
            return Collections.emptySet();
        }
        return this.delegate.keySet();
    }

    @Override
    public final Collection<V> values() {
        if (this.delegate == null || this.delegate.isEmpty()) {
            return Collections.emptySet();
        }
        return this.delegate.values();
    }

    @Override
    public final Set<Map.Entry<K, V>> entrySet() {
        if (this.delegate == null || this.delegate.isEmpty()) {
            return Collections.emptySet();
        }
        return this.delegate.entrySet();
    }

    public String toString() {
        return "SelfInitializingConcurrentHashMap{delegate=" + this.delegate + '}';
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SelfInitializingConcurrentHashMap that = (SelfInitializingConcurrentHashMap)o;
        return !(this.delegate == null ? that.delegate != null : !this.delegate.equals(that.delegate));
    }

    @Override
    public int hashCode() {
        int result = this.delegate != null ? this.delegate.hashCode() : 0;
        return result;
    }
}

