/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.idm.impl.api.query;

import java.io.Serializable;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import org.picketlink.idm.api.IdentitySearchCriteria;
import org.picketlink.idm.api.IdentitySession;
import org.picketlink.idm.api.Role;
import org.picketlink.idm.api.RoleType;
import org.picketlink.idm.api.query.QueryException;
import org.picketlink.idm.impl.NotYetImplementedException;
import org.picketlink.idm.impl.api.model.SimpleRole;
import org.picketlink.idm.impl.api.query.AbstractQueryExecutor;
import org.picketlink.idm.impl.api.query.RoleQueryImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RoleQueryExecutorImpl
extends AbstractQueryExecutor
implements Serializable {
    private static final long serialVersionUID = -5943827542621450235L;

    public RoleQueryExecutorImpl(IdentitySession identitySession) {
        super(identitySession);
    }

    public Collection<Role> execute(RoleQueryImpl roleQuery) throws QueryException {
        List<Role> mainResults = new LinkedList<Role>();
        try {
            if (roleQuery.user == null && roleQuery.group == null && roleQuery.roleType == null) {
                return mainResults;
            }
            if (roleQuery.user != null && roleQuery.group != null && roleQuery.roleType != null) {
                Role role = this.identitySession.getRoleManager().getRole(roleQuery.roleType, roleQuery.user, roleQuery.group);
                if (role != null) {
                    mainResults.add(role);
                }
                return mainResults;
            }
            if (roleQuery.user != null && roleQuery.group == null && roleQuery.roleType == null) {
                return this.identitySession.getRoleManager().findRoles(roleQuery.user, null);
            }
            if (roleQuery.user != null && roleQuery.group == null && roleQuery.roleType != null) {
                return this.identitySession.getRoleManager().findRoles(roleQuery.user, roleQuery.roleType);
            }
            if (roleQuery.user == null && roleQuery.group != null && roleQuery.roleType == null) {
                return this.identitySession.getRoleManager().findRoles(roleQuery.group, null);
            }
            if (roleQuery.user == null && roleQuery.group != null && roleQuery.roleType != null) {
                return this.identitySession.getRoleManager().findRoles(roleQuery.group, roleQuery.roleType);
            }
            if (roleQuery.user == null && roleQuery.group == null && roleQuery.roleType != null) {
                throw new QueryException("Not enought information to perform a query. Cannot query roles only with a given RoleType");
            }
            if (roleQuery.user != null && roleQuery.group != null && roleQuery.roleType == null) {
                Collection<RoleType> roleTypes = this.identitySession.getRoleManager().findRoleTypes(roleQuery.user, roleQuery.group, (IdentitySearchCriteria)roleQuery.searchCriteria);
                for (RoleType type : roleTypes) {
                    mainResults.add(new SimpleRole(type, roleQuery.user, roleQuery.group));
                }
                return mainResults;
            }
        }
        catch (Exception e) {
            throw new QueryException("Failed to execute query", e);
        }
        mainResults = this.applyCriteriaRoles(roleQuery.searchCriteria, mainResults);
        return mainResults;
    }

    public Role uniqueResult(RoleQueryImpl roleQuery) throws QueryException {
        Collection<Role> results = this.execute(roleQuery);
        if (results.size() > 1) {
            throw new QueryException("More than one result returned");
        }
        if (results.size() == 1) {
            return results.iterator().next();
        }
        return null;
    }

    public List<Role> list(RoleQueryImpl roleQuery) throws QueryException {
        Collection<Role> results = this.execute(roleQuery);
        if (results instanceof List) {
            return (List)results;
        }
        throw new NotYetImplementedException();
    }
}

