/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.loader;

import java.io.ObjectInputStream;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.cache.Fqn;
import org.jboss.cache.Modification;
import org.jboss.cache.loader.AbstractDelegatingCacheLoader;
import org.jboss.cache.loader.CacheLoader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReadOnlyDelegatingCacheLoader
extends AbstractDelegatingCacheLoader {
    private static final Log log = LogFactory.getLog(ReadOnlyDelegatingCacheLoader.class);

    public ReadOnlyDelegatingCacheLoader(CacheLoader cl) {
        super(cl);
    }

    @Override
    public Object put(Fqn name, Object key, Object value) throws Exception {
        log.trace((Object)"Not delegating write operation to underlying cache loader");
        Map map = this.get(name);
        return map == null ? null : map.get(key);
    }

    @Override
    public void put(Fqn name, Map attributes) throws Exception {
        log.trace((Object)"Not delegating write operation to underlying cache loader");
    }

    @Override
    public void put(List<Modification> modifications) throws Exception {
        log.trace((Object)"Not delegating write operation to underlying cache loader");
    }

    @Override
    public Object remove(Fqn fqn, Object key) throws Exception {
        log.trace((Object)"Not delegating write operation to underlying cache loader");
        Map map = this.get(fqn);
        return map == null ? null : map.get(key);
    }

    @Override
    public void remove(Fqn fqn) throws Exception {
        log.trace((Object)"Not delegating write operation to underlying cache loader");
    }

    @Override
    public void removeData(Fqn fqn) throws Exception {
        log.trace((Object)"Not delegating write operation to underlying cache loader");
    }

    @Override
    public void prepare(Object tx, List<Modification> modifications, boolean one_phase) throws Exception {
        log.trace((Object)"Not delegating write operation to underlying cache loader");
    }

    @Override
    public void commit(Object tx) throws Exception {
        log.trace((Object)"Not delegating write operation to underlying cache loader");
    }

    @Override
    public void rollback(Object tx) {
        log.trace((Object)"Not delegating write operation to underlying cache loader");
    }

    @Override
    public void storeEntireState(ObjectInputStream is) throws Exception {
        log.trace((Object)"Not delegating write operation to underlying cache loader");
    }

    @Override
    public void storeState(Fqn subtree, ObjectInputStream is) throws Exception {
        log.trace((Object)"Not delegating write operation to underlying cache loader");
    }
}

