/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.eviction;

import java.util.concurrent.TimeUnit;
import org.jboss.cache.config.ConfigurationComponent;
import org.jboss.cache.config.ConfigurationException;
import org.jboss.cache.config.Dynamic;
import org.jboss.cache.config.EvictionAlgorithmConfig;

public abstract class EvictionAlgorithmConfigBase
extends ConfigurationComponent
implements EvictionAlgorithmConfig {
    private static final long serialVersionUID = 4591691674370188932L;
    protected String evictionAlgorithmClassName;
    @Dynamic
    protected int maxNodes = -1;
    @Dynamic
    protected long minTimeToLive = -1L;

    protected EvictionAlgorithmConfigBase() {
    }

    public String getEvictionAlgorithmClassName() {
        return this.evictionAlgorithmClassName;
    }

    public int getMaxNodes() {
        return this.maxNodes;
    }

    public void setMaxNodes(int maxNodes) {
        this.testImmutability("maxNodes");
        this.maxNodes = maxNodes;
    }

    public long getMinTimeToLive() {
        return this.minTimeToLive;
    }

    public void setMinTimeToLive(long minTimeToLive) {
        this.testImmutability("minTimeToLive");
        this.minTimeToLive = minTimeToLive;
    }

    public void setMinTimeToLive(long time, TimeUnit timeUnit) {
        this.testImmutability("minTimeToLive");
        this.minTimeToLive = timeUnit.toMillis(time);
    }

    @Deprecated
    public void setMinTimeToLiveSeconds(long time) {
        this.setMinTimeToLive(time, TimeUnit.SECONDS);
    }

    public void validate() throws ConfigurationException {
        if (this.evictionAlgorithmClassName == null) {
            throw new ConfigurationException("Eviction algorithm class name cannot be null!");
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!o.getClass().equals(this.getClass())) {
            return false;
        }
        EvictionAlgorithmConfigBase that = (EvictionAlgorithmConfigBase)o;
        if (this.maxNodes != that.maxNodes) {
            return false;
        }
        if (this.minTimeToLive != that.minTimeToLive) {
            return false;
        }
        return !(this.evictionAlgorithmClassName != null ? !this.evictionAlgorithmClassName.equals(that.evictionAlgorithmClassName) : that.evictionAlgorithmClassName != null);
    }

    public int hashCode() {
        int result = this.evictionAlgorithmClassName != null ? this.evictionAlgorithmClassName.hashCode() : 0;
        result = 31 * result + this.maxNodes;
        result = (int)((long)(31 * result) + this.minTimeToLive);
        result = 31 * result + (int)(this.minTimeToLive ^ this.minTimeToLive >>> 32);
        return result;
    }

    public void reset() {
        this.maxNodes = -1;
        this.minTimeToLive = -1L;
    }

    public EvictionAlgorithmConfig clone() throws CloneNotSupportedException {
        return (EvictionAlgorithmConfig)super.clone();
    }
}

