/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.idm.impl.repository;

import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.picketlink.idm.common.exception.IdentityException;
import org.picketlink.idm.impl.cache.CacheIdentityStoreWrapper;
import org.picketlink.idm.spi.cache.IdentityStoreCacheProvider;
import org.picketlink.idm.spi.configuration.IdentityConfigurationContext;
import org.picketlink.idm.spi.configuration.IdentityRepositoryConfigurationContext;
import org.picketlink.idm.spi.configuration.metadata.IdentityRepositoryConfigurationMetaData;
import org.picketlink.idm.spi.configuration.metadata.IdentityStoreMappingMetaData;
import org.picketlink.idm.spi.model.IdentityObject;
import org.picketlink.idm.spi.model.IdentityObjectType;
import org.picketlink.idm.spi.repository.IdentityStoreRepository;
import org.picketlink.idm.spi.store.AttributeStore;
import org.picketlink.idm.spi.store.IdentityStore;
import org.picketlink.idm.spi.store.IdentityStoreInvocationContext;

public abstract class AbstractIdentityStoreRepository
implements IdentityStoreRepository,
Serializable {
    private static Logger log = Logger.getLogger(AbstractIdentityStoreRepository.class.getName());
    protected Map<String, List<IdentityStore>> identityStoreMappings = new HashMap<String, List<IdentityStore>>();
    protected Map<String, List<AttributeStore>> attributeStoreMappings = new HashMap<String, List<AttributeStore>>();
    protected Set<IdentityStore> configuredIdentityStores = new HashSet<IdentityStore>();
    protected Set<AttributeStore> configuredAttributeStores = new HashSet<AttributeStore>();
    protected IdentityStore defaultIdentityStore;
    protected AttributeStore defaultAttributeStore;
    protected IdentityRepositoryConfigurationContext configurationContext;
    public static final String CACHE_OPTION = "cache";
    public static final String CACHE_CONFIG_FILE_OPTION = "cache.configFile";
    public static final String CACHE_PROVIDER_CLASS_OPTION = "cache.providerClass";
    public static final String CACHE_PROVIDER_REGISTRY_NAME = "cache.providerRegistryName";
    public static final String CACHE_SCOPE = "cache.scope";
    public static final String ALLOW_NOT_DEFINED_IDENTITY_OBJECT_TYPES_OPTION = "allowNotDefinedIdentityObjectTypes";
    private boolean allowNotDefinedIdentityObjectTypes = false;

    public void bootstrap(IdentityRepositoryConfigurationContext configurationContext, Map<String, IdentityStore> bootstrappedIdentityStores, Map<String, AttributeStore> bootstrappedAttributeStores) throws IdentityException {
        String allowNotDefinedIOT;
        this.configurationContext = configurationContext;
        IdentityRepositoryConfigurationMetaData configurationMD = configurationContext.getRepositoryConfigurationMetaData();
        String asId = configurationMD.getDefaultAttributeStoreId();
        String isId = configurationMD.getDefaultIdentityStoreId();
        if (asId != null && bootstrappedAttributeStores.keySet().contains(asId)) {
            this.defaultAttributeStore = bootstrappedAttributeStores.get(asId);
            this.configuredAttributeStores.add(this.defaultAttributeStore);
        }
        if ((allowNotDefinedIOT = configurationMD.getOptionSingleValue(ALLOW_NOT_DEFINED_IDENTITY_OBJECT_TYPES_OPTION)) != null && allowNotDefinedIOT.equalsIgnoreCase("true")) {
            this.allowNotDefinedIdentityObjectTypes = true;
        }
        if (isId != null && bootstrappedIdentityStores.keySet().contains(isId)) {
            this.defaultIdentityStore = bootstrappedIdentityStores.get(isId);
            this.configuredIdentityStores.add(this.defaultIdentityStore);
            String cacheOption = configurationMD.getOptionSingleValue(CACHE_OPTION);
            if (cacheOption != null && cacheOption.equalsIgnoreCase("true")) {
                String cacheSupportClass = configurationMD.getOptionSingleValue(CACHE_PROVIDER_CLASS_OPTION);
                String cacheRegistryName = configurationMD.getOptionSingleValue(CACHE_PROVIDER_REGISTRY_NAME);
                String cacheScope = configurationMD.getOptionSingleValue(CACHE_PROVIDER_REGISTRY_NAME);
                if (cacheSupportClass == null && cacheRegistryName == null) {
                    throw new IdentityException("cache.providerClass is missing in the repository configuration");
                }
                IdentityStoreCacheProvider cacheSupport = null;
                HashMap cacheProps = new HashMap();
                for (String key : configurationMD.getOptions().keySet()) {
                    if (!key.startsWith("cache.") || ((List)configurationMD.getOptions().get(key)).size() <= 0) continue;
                    cacheProps.put(key, ((List)configurationMD.getOptions().get(key)).get(0));
                }
                if (cacheRegistryName != null) {
                    try {
                        cacheSupport = (IdentityStoreCacheProvider)configurationContext.getConfigurationRegistry().getObject(cacheRegistryName);
                    }
                    catch (IdentityException e) {
                        if (log.isLoggable(Level.FINER)) {
                            log.log(Level.FINER, "Exception occurred: ", e);
                        }
                        throw new IdentityException("Cannot find IdentityStoreCacheProvider cache provider instancewith provided name:" + cacheRegistryName, (Throwable)e);
                    }
                }
                try {
                    Class<?> cacheClass = null;
                    cacheClass = Class.forName(cacheSupportClass);
                    Constructor<?> ct = cacheClass.getConstructor(new Class[0]);
                    cacheSupport = (IdentityStoreCacheProvider)ct.newInstance(new Object[0]);
                    cacheSupport.initialize(cacheProps, (IdentityConfigurationContext)configurationContext);
                }
                catch (Exception e) {
                    if (log.isLoggable(Level.FINER)) {
                        log.log(Level.FINER, "Exception occurred: ", e);
                    }
                    throw new IdentityException("Cannot instantiate cache provider:" + cacheSupportClass, (Throwable)e);
                }
                this.defaultIdentityStore = new CacheIdentityStoreWrapper(this.defaultIdentityStore, cacheSupport, cacheScope);
            }
        }
        for (IdentityStoreMappingMetaData identityStoreMappingMetaData : configurationMD.getIdentityStoreToIdentityObjectTypeMappings()) {
            String storeId = identityStoreMappingMetaData.getIdentityStoreId();
            List identityObjectTypeMappings = identityStoreMappingMetaData.getIdentityObjectTypeMappings();
            IdentityStore store = bootstrappedIdentityStores.get(storeId);
            String cacheOption = identityStoreMappingMetaData.getOptionSingleValue(CACHE_OPTION);
            if (cacheOption != null && cacheOption.equalsIgnoreCase("true")) {
                String cacheSupportClass = identityStoreMappingMetaData.getOptionSingleValue(CACHE_PROVIDER_CLASS_OPTION);
                String cacheRegistryName = identityStoreMappingMetaData.getOptionSingleValue(CACHE_PROVIDER_REGISTRY_NAME);
                String cacheScope = identityStoreMappingMetaData.getOptionSingleValue(CACHE_PROVIDER_REGISTRY_NAME);
                if (cacheSupportClass == null && cacheRegistryName == null) {
                    throw new IdentityException("cache.providerClass is missing in the <identity-store><options> configuration");
                }
                IdentityStoreCacheProvider cacheSupport = null;
                HashMap cacheProps = new HashMap();
                for (String key : identityStoreMappingMetaData.getOptions().keySet()) {
                    if (!key.startsWith("cache.") || ((List)identityStoreMappingMetaData.getOptions().get(key)).size() <= 0) continue;
                    cacheProps.put(key, ((List)identityStoreMappingMetaData.getOptions().get(key)).get(0));
                }
                if (cacheRegistryName != null) {
                    try {
                        cacheSupport = (IdentityStoreCacheProvider)configurationContext.getConfigurationRegistry().getObject(cacheRegistryName);
                    }
                    catch (IdentityException e) {
                        if (log.isLoggable(Level.FINER)) {
                            log.log(Level.FINER, "Exception occurred: ", e);
                        }
                        throw new IdentityException("Cannot find IdentityStoreCacheProvider cache provider instancewith provided name:" + cacheRegistryName, (Throwable)e);
                    }
                }
                try {
                    Class<?> cacheClass = null;
                    cacheClass = Class.forName(cacheSupportClass);
                    Constructor<?> ct = cacheClass.getConstructor(new Class[0]);
                    cacheSupport = (IdentityStoreCacheProvider)ct.newInstance(new Object[0]);
                    cacheSupport.initialize(cacheProps, (IdentityConfigurationContext)configurationContext);
                }
                catch (Exception e) {
                    if (log.isLoggable(Level.FINER)) {
                        log.log(Level.FINER, "Exception occurred: ", e);
                    }
                    throw new IdentityException("Cannot instantiate cache provider:" + cacheSupportClass, (Throwable)e);
                }
                store = new CacheIdentityStoreWrapper(store, cacheSupport, cacheScope);
            }
            if (store == null) {
                throw new IdentityException("Mapped IdentityStore not available: " + storeId);
            }
            for (String mapping : identityObjectTypeMappings) {
                List<IdentityStore> mappedIS = this.identityStoreMappings.get(mapping);
                if (mappedIS == null) {
                    mappedIS = new LinkedList<IdentityStore>();
                    this.identityStoreMappings.put(mapping, mappedIS);
                }
                mappedIS.add(store);
                this.configuredIdentityStores.add(store);
                List<AttributeStore> mappedAS = this.attributeStoreMappings.get(mapping);
                if (mappedAS == null) {
                    mappedAS = new LinkedList<AttributeStore>();
                    this.attributeStoreMappings.put(mapping, mappedAS);
                }
                mappedAS.add((AttributeStore)store);
                this.configuredAttributeStores.add((AttributeStore)store);
            }
        }
    }

    public Set<IdentityStore> getConfiguredIdentityStores() {
        return new HashSet<IdentityStore>(this.configuredIdentityStores);
    }

    public Set<AttributeStore> getConfiguredAttributeStores() {
        return new HashSet<IdentityStore>(this.configuredIdentityStores);
    }

    public Map<String, IdentityStore> getIdentityStoreMappings() {
        HashMap<String, IdentityStore> firstInTheList = new HashMap<String, IdentityStore>();
        for (Map.Entry<String, List<IdentityStore>> entry : this.identityStoreMappings.entrySet()) {
            if (entry.getValue().size() <= 0) continue;
            firstInTheList.put(entry.getKey(), entry.getValue().get(0));
        }
        return firstInTheList;
    }

    public Map<String, AttributeStore> getAttributeStoreMappings() {
        HashMap<String, AttributeStore> firstInTheList = new HashMap<String, AttributeStore>();
        for (Map.Entry<String, List<AttributeStore>> entry : this.attributeStoreMappings.entrySet()) {
            if (entry.getValue().size() <= 0) continue;
            firstInTheList.put(entry.getKey(), entry.getValue().get(0));
        }
        return firstInTheList;
    }

    public List<IdentityStore> getIdentityStores(IdentityObjectType identityObjectType) throws IdentityException {
        if (this.identityStoreMappings.keySet().contains(identityObjectType.getName())) {
            return this.identityStoreMappings.get(identityObjectType.getName());
        }
        return new LinkedList<IdentityStore>();
    }

    public List<AttributeStore> getAttributeStores(IdentityObjectType identityObjectType) throws IdentityException {
        if (this.attributeStoreMappings.keySet().contains(identityObjectType.getName())) {
            return this.attributeStoreMappings.get(identityObjectType.getName());
        }
        return new LinkedList<AttributeStore>();
    }

    public IdentityStore getIdentityStore(IdentityObjectType identityObjectType) throws IdentityException {
        IdentityStore store = this.getIdentityStoreMappings().get(identityObjectType.getName());
        if (store == null) {
            String option = this.configurationContext.getRepositoryConfigurationMetaData().getOptionSingleValue(ALLOW_NOT_DEFINED_IDENTITY_OBJECT_TYPES_OPTION);
            if (option != null && option.equalsIgnoreCase("true")) {
                return this.defaultIdentityStore;
            }
            throw new IdentityException("IdentityObjectType not mapped in the configuration: " + identityObjectType);
        }
        return store;
    }

    public AttributeStore getAttributeStore(IdentityObjectType identityObjectType) throws IdentityException {
        AttributeStore store = this.getAttributeStoreMappings().get(identityObjectType.getName());
        if (store == null) {
            String option = this.configurationContext.getRepositoryConfigurationMetaData().getOptionSingleValue(ALLOW_NOT_DEFINED_IDENTITY_OBJECT_TYPES_OPTION);
            if (option != null && option.equalsIgnoreCase("true")) {
                return this.defaultIdentityStore;
            }
            throw new IdentityException("IdentityObjectType not mapped in the configuration: " + identityObjectType);
        }
        return store;
    }

    protected boolean hasIdentityObject(IdentityStoreInvocationContext ctx, IdentityStore is, IdentityObject io) throws IdentityException {
        try {
            if (is.findIdentityObject(ctx, io.getName(), io.getIdentityType()) != null) {
                return true;
            }
        }
        catch (IdentityException e) {
            // empty catch block
        }
        return false;
    }

    public boolean isAllowNotDefinedIdentityObjectTypes() {
        return this.allowNotDefinedIdentityObjectTypes;
    }
}

