/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.container.entries.versioned;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Set;
import org.infinispan.container.entries.TransientCacheEntry;
import org.infinispan.container.entries.versioned.Versioned;
import org.infinispan.container.entries.versioned.VersionedTransientCacheValue;
import org.infinispan.container.versioning.EntryVersion;
import org.infinispan.io.UnsignedNumeric;
import org.infinispan.marshall.AbstractExternalizer;
import org.infinispan.util.Util;

public class VersionedTransientCacheEntry
extends TransientCacheEntry
implements Versioned {
    public VersionedTransientCacheEntry(Object key, Object value, EntryVersion version, long maxIdle) {
        this(key, value, version, maxIdle, System.currentTimeMillis());
    }

    public VersionedTransientCacheEntry(Object key, Object value, EntryVersion version, long maxIdle, long lastUsed) {
        super(key, new VersionedTransientCacheValue(value, version, maxIdle, lastUsed));
    }

    VersionedTransientCacheEntry(Object key, VersionedTransientCacheValue cacheValue) {
        super(key, cacheValue);
    }

    @Override
    public EntryVersion getVersion() {
        return ((Versioned)((Object)this.cacheValue)).getVersion();
    }

    @Override
    public void setVersion(EntryVersion version) {
        ((Versioned)((Object)this.cacheValue)).setVersion(version);
    }

    public static class Externalizer
    extends AbstractExternalizer<VersionedTransientCacheEntry> {
        @Override
        public void writeObject(ObjectOutput output, VersionedTransientCacheEntry ice) throws IOException {
            output.writeObject(ice.key);
            output.writeObject(((VersionedTransientCacheEntry)ice).cacheValue.value);
            output.writeObject(((Versioned)((Object)ice.cacheValue)).getVersion());
            UnsignedNumeric.writeUnsignedLong(output, ice.cacheValue.getLastUsed());
            output.writeLong(ice.cacheValue.getMaxIdle());
        }

        @Override
        public VersionedTransientCacheEntry readObject(ObjectInput input) throws IOException, ClassNotFoundException {
            Object k = input.readObject();
            Object v = input.readObject();
            EntryVersion version = (EntryVersion)input.readObject();
            long lastUsed = UnsignedNumeric.readUnsignedLong(input);
            Long maxIdle = input.readLong();
            return new VersionedTransientCacheEntry(k, v, version, maxIdle, lastUsed);
        }

        @Override
        public Integer getId() {
            return 78;
        }

        @Override
        public Set<Class<? extends VersionedTransientCacheEntry>> getTypeClasses() {
            return Util.asSet(VersionedTransientCacheEntry.class);
        }
    }
}

