/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.factories;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

public class KnownComponentNames {
    public static final String ASYNC_TRANSPORT_EXECUTOR = "org.infinispan.executors.transport";
    public static final String ASYNC_NOTIFICATION_EXECUTOR = "org.infinispan.executors.notification";
    public static final String EVICTION_SCHEDULED_EXECUTOR = "org.infinispan.executors.eviction";
    public static final String ASYNC_REPLICATION_QUEUE_EXECUTOR = "org.infinispan.executors.replicationQueue";
    public static final String MODULE_COMMAND_INITIALIZERS = "org.infinispan.modules.command.initializers";
    public static final String MODULE_COMMAND_FACTORIES = "org.infinispan.modules.command.factories";
    public static final String GLOBAL_MARSHALLER = "org.infinispan.marshaller.global";
    public static final String CACHE_MARSHALLER = "org.infinispan.marshaller.cache";
    public static final String CLASS_LOADER = "java.lang.ClassLoader";
    public static final Collection<String> ALL_KNOWN_COMPONENT_NAMES = Arrays.asList("org.infinispan.executors.transport", "org.infinispan.executors.notification", "org.infinispan.executors.eviction", "org.infinispan.executors.replicationQueue", "org.infinispan.modules.command.initializers", "org.infinispan.modules.command.factories", "org.infinispan.marshaller.global", "org.infinispan.marshaller.cache", "java.lang.ClassLoader");
    private static final Map<String, Integer> DEFAULT_THREADCOUNTS = new HashMap<String, Integer>(2);
    private static final Map<String, Integer> DEFAULT_THREADPRIO = new HashMap<String, Integer>(4);

    public static int getDefaultThreads(String componentName) {
        return DEFAULT_THREADCOUNTS.get(componentName);
    }

    public static int getDefaultThreadPrio(String componentName) {
        return DEFAULT_THREADPRIO.get(componentName);
    }

    static {
        DEFAULT_THREADCOUNTS.put(ASYNC_NOTIFICATION_EXECUTOR, 1);
        DEFAULT_THREADCOUNTS.put(ASYNC_TRANSPORT_EXECUTOR, 25);
        DEFAULT_THREADPRIO.put(ASYNC_NOTIFICATION_EXECUTOR, 1);
        DEFAULT_THREADPRIO.put(ASYNC_TRANSPORT_EXECUTOR, 5);
        DEFAULT_THREADPRIO.put(EVICTION_SCHEDULED_EXECUTOR, 1);
        DEFAULT_THREADPRIO.put(ASYNC_REPLICATION_QUEUE_EXECUTOR, 5);
    }
}

