/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.framework.internal.core;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;
import org.eclipse.osgi.framework.internal.core.AbstractBundle;
import org.eclipse.osgi.framework.util.Headers;
import org.osgi.framework.Bundle;

public class ManifestLocalization {
    private AbstractBundle bundle = null;
    private Dictionary rawHeaders = null;
    private Dictionary defaultLocaleHeaders = null;
    private Hashtable cache = new Hashtable(5);

    public ManifestLocalization(AbstractBundle bundle, Dictionary rawHeaders) {
        this.bundle = bundle;
        this.rawHeaders = rawHeaders;
    }

    protected Dictionary getHeaders(String localeString) {
        if (localeString.length() == 0) {
            return this.rawHeaders;
        }
        boolean isDefaultLocale = false;
        String defaultLocale = Locale.getDefault().toString();
        if (localeString.equals(defaultLocale)) {
            if (this.defaultLocaleHeaders != null) {
                return this.defaultLocaleHeaders;
            }
            isDefaultLocale = true;
        }
        try {
            this.bundle.checkValid();
        }
        catch (IllegalStateException illegalStateException) {
            if (this.defaultLocaleHeaders != null) {
                return this.defaultLocaleHeaders;
            }
            return this.rawHeaders;
        }
        ResourceBundle localeProperties = this.getResourceBundle(localeString);
        if (localeProperties == null && !isDefaultLocale) {
            localeProperties = this.getResourceBundle(defaultLocale);
        }
        Enumeration e = this.rawHeaders.keys();
        Headers localeHeaders = new Headers(this.rawHeaders.size());
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            String value = (String)this.rawHeaders.get(key);
            if (value.startsWith("%") && value.length() > 1) {
                String propertiesKey = value.substring(1);
                try {
                    value = localeProperties == null ? propertiesKey : (String)localeProperties.getObject(propertiesKey);
                }
                catch (MissingResourceException missingResourceException) {
                    value = propertiesKey;
                }
            }
            localeHeaders.set(key, value);
        }
        localeHeaders.setReadOnly();
        if (isDefaultLocale) {
            this.defaultLocaleHeaders = localeHeaders;
        }
        return localeHeaders;
    }

    private String[] buildNLVariants(String nl) {
        ArrayList<String> result = new ArrayList<String>();
        while (nl.length() > 0) {
            result.add(nl);
            int i = nl.lastIndexOf(95);
            String string = nl = i < 0 ? "" : nl.substring(0, i);
        }
        result.add("");
        return result.toArray(new String[result.size()]);
    }

    protected ResourceBundle getResourceBundle(String localeString) {
        BundleResourceBundle result;
        String propertiesLocation = (String)this.rawHeaders.get("Bundle-Localization");
        if (propertiesLocation == null) {
            propertiesLocation = "OSGI-INF/l10n/bundle";
        }
        if ((result = (BundleResourceBundle)this.cache.get(localeString)) != null) {
            return (ResourceBundle)((Object)(result.isEmpty() ? null : result));
        }
        String[] nlVarients = this.buildNLVariants(localeString);
        BundleResourceBundle parent = null;
        int i = nlVarients.length - 1;
        while (i >= 0) {
            BundleResourceBundle varientBundle;
            block21: {
                varientBundle = null;
                URL varientURL = this.findResource(String.valueOf(propertiesLocation) + (nlVarients[i].equals("") ? nlVarients[i] : String.valueOf('_') + nlVarients[i]) + ".properties");
                if (varientURL == null) {
                    varientBundle = (BundleResourceBundle)this.cache.get(nlVarients[i]);
                } else {
                    InputStream resourceStream = null;
                    try {
                        try {
                            resourceStream = varientURL.openStream();
                            varientBundle = new LocalizationResourceBundle(resourceStream);
                        }
                        catch (IOException iOException) {
                            if (resourceStream != null) {
                                try {
                                    resourceStream.close();
                                }
                                catch (IOException iOException2) {}
                            }
                            break block21;
                        }
                    }
                    catch (Throwable throwable) {
                        if (resourceStream != null) {
                            try {
                                resourceStream.close();
                            }
                            catch (IOException iOException) {}
                        }
                        throw throwable;
                    }
                    if (resourceStream != null) {
                        try {
                            resourceStream.close();
                        }
                        catch (IOException iOException) {}
                    }
                }
            }
            if (varientBundle == null) {
                varientBundle = new EmptyResouceBundle();
            }
            if (parent != null) {
                varientBundle.setParent((ResourceBundle)((Object)parent));
            }
            this.cache.put(nlVarients[i], varientBundle);
            parent = varientBundle;
            --i;
        }
        result = (BundleResourceBundle)this.cache.get(localeString);
        return (ResourceBundle)((Object)(result.isEmpty() ? null : result));
    }

    private URL findResource(String resource) {
        AbstractBundle searchBundle = this.bundle;
        if (this.bundle.isResolved()) {
            if (this.bundle.isFragment() && this.bundle.getHosts() != null && (searchBundle = this.bundle.getHosts()[0].getBundleHost()).getState() == 1) {
                searchBundle = this.bundle;
            }
            return this.findInResolved(resource, searchBundle);
        }
        return this.findInBundle(resource, searchBundle);
    }

    private URL findInResolved(String filePath, AbstractBundle bundleHost) {
        URL result = this.findInBundle(filePath, bundleHost);
        if (result != null) {
            return result;
        }
        return this.findInFragments(filePath, bundleHost);
    }

    private URL findInBundle(String filePath, AbstractBundle searchBundle) {
        return searchBundle.getEntry(filePath);
    }

    private URL findInFragments(String filePath, AbstractBundle searchBundle) {
        Bundle[] fragments = searchBundle.getFragments();
        URL fileURL = null;
        int i = 0;
        while (fragments != null && i < fragments.length && fileURL == null) {
            if (fragments[i].getState() != 1) {
                fileURL = fragments[i].getEntry(filePath);
            }
            ++i;
        }
        return fileURL;
    }

    private static interface BundleResourceBundle {
        public void setParent(ResourceBundle var1);

        public boolean isEmpty();
    }

    private class EmptyResouceBundle
    extends ResourceBundle
    implements BundleResourceBundle {
        private EmptyResouceBundle() {
        }

        public Enumeration getKeys() {
            return null;
        }

        protected Object handleGetObject(String arg0) throws MissingResourceException {
            return null;
        }

        public void setParent(ResourceBundle parent) {
            super.setParent(parent);
        }

        public boolean isEmpty() {
            if (this.parent == null) {
                return true;
            }
            return ((BundleResourceBundle)((Object)this.parent)).isEmpty();
        }
    }

    private class LocalizationResourceBundle
    extends PropertyResourceBundle
    implements BundleResourceBundle {
        public LocalizationResourceBundle(InputStream in) throws IOException {
            super(in);
        }

        public void setParent(ResourceBundle parent) {
            super.setParent(parent);
        }

        public boolean isEmpty() {
            return false;
        }
    }
}

