/*
 * Decompiled with CFR 0.152.
 */
package org.staxnav;

import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.namespace.QName;
import javax.xml.stream.Location;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.staxnav.Naming;
import org.staxnav.StaxNavException;
import org.staxnav.StaxNavigator;
import org.staxnav.TypeConversionException;
import org.staxnav.ValueType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StaxNavigatorImpl<N>
implements StaxNavigator<N> {
    private final Naming<N> naming;
    private Entry current;
    private final int depth;
    private boolean trimContent;

    public StaxNavigatorImpl(Naming<N> naming, XMLStreamReader stream) throws XMLStreamException {
        if (naming == null) {
            throw new NullPointerException();
        }
        if (stream == null) {
            throw new NullPointerException();
        }
        this.naming = naming;
        this.current = new HeadEntry(stream);
        this.depth = 0;
        this.trimContent = false;
    }

    private StaxNavigatorImpl(Naming<N> naming, Entry current, boolean trimContent) {
        this.naming = naming;
        this.current = current;
        this.depth = current.getElement().getDepth();
        this.trimContent = trimContent;
    }

    @Override
    public N getName() throws StaxNavException {
        if (this.current == null) {
            return null;
        }
        return this.current.getElement().getName(this.naming);
    }

    @Override
    public Naming<N> getNaming() {
        return this.naming;
    }

    @Override
    public String getLocalName() throws StaxNavException {
        if (this.current == null) {
            return null;
        }
        return this.current.getElement().getName().getLocalPart();
    }

    @Override
    public Location getLocation() throws StaxNavException {
        if (this.current == null) {
            return null;
        }
        return this.current.getElement().getLocation();
    }

    @Override
    public int getDepth() throws StaxNavException {
        if (this.current == null) {
            return -1;
        }
        return this.current.getElement().getDepth();
    }

    @Override
    public void setTrimContent(boolean trimContent) {
        this.trimContent = trimContent;
    }

    @Override
    public boolean getTrimContent() {
        return this.trimContent;
    }

    @Override
    public String getContent() throws StaxNavException {
        if (this.current == null) {
            return null;
        }
        return this.current.getElement().getContent(this.trimContent);
    }

    @Override
    public <V> V parseContent(ValueType<V> valueType) throws IllegalStateException, NullPointerException, StaxNavException {
        if (valueType == null) {
            throw new NullPointerException();
        }
        if (this.current == null) {
            return null;
        }
        Entry element = this.current;
        String content = element.getElement().getContent(true);
        if (content == null) {
            throw new IllegalStateException("No content available for parsing");
        }
        try {
            return valueType.parse(content);
        }
        catch (Exception e) {
            if (e instanceof TypeConversionException) {
                throw (TypeConversionException)e;
            }
            throw new TypeConversionException(element.getElement().getLocation(), e, "Could not parse string value " + content);
        }
    }

    @Override
    public String getAttribute(String name) throws NullPointerException, IllegalStateException, StaxNavException {
        if (this.current == null) {
            return null;
        }
        Map<String, String> attributes = this.current.getElement().getAttributes();
        if (attributes.isEmpty()) {
            return null;
        }
        return attributes.get(name);
    }

    @Override
    public StaxNavigator<N> fork() throws StaxNavException {
        StaxNavigatorImpl<N> fork = new StaxNavigatorImpl<N>(this.naming, this.current, this.trimContent);
        if (this.current != null) {
            this.current = this._sibling(null);
        }
        return fork;
    }

    @Override
    public Iterable<StaxNavigator<N>> fork(N name) {
        List elements = Collections.emptyList();
        while (this.find(name)) {
            if (elements.isEmpty()) {
                elements = new LinkedList();
            }
            elements.add(this.current);
            if (this.sibling() != null) continue;
        }
        final List a = elements;
        final boolean trimContent = this.trimContent;
        return new Iterable<StaxNavigator<N>>(){

            @Override
            public Iterator<StaxNavigator<N>> iterator() {
                return new Iterator<StaxNavigator<N>>(){
                    Iterator<Entry> i;
                    {
                        this.i = a.iterator();
                    }

                    @Override
                    public boolean hasNext() {
                        return this.i.hasNext();
                    }

                    @Override
                    public StaxNavigator<N> next() {
                        Entry next = this.i.next();
                        return new StaxNavigatorImpl(StaxNavigatorImpl.this.naming, next, trimContent);
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }
        };
    }

    @Override
    public String getAttribute(QName name) throws NullPointerException, IllegalStateException, StaxNavException {
        if (name == null) {
            throw new NullPointerException("No null attribute name expected");
        }
        if (this.current == null) {
            return null;
        }
        if ("".equals(name.getNamespaceURI())) {
            return this.getAttribute(name.getLocalPart());
        }
        Map<QName, String> qualifiedAttributes = this.current.getElement().getQualifiedAttributes();
        if (qualifiedAttributes.isEmpty()) {
            return null;
        }
        return qualifiedAttributes.get(name);
    }

    @Override
    public String getNamespaceByPrefix(String prefix) throws NullPointerException, StaxNavException {
        if (prefix == null) {
            throw new NullPointerException();
        }
        if (this.current == null) {
            return null;
        }
        return this.current.getElement().getNamespaceByPrefix(prefix);
    }

    @Override
    public N next() throws StaxNavException {
        if (this.current == null) {
            return null;
        }
        this.current = this.current.next(this.depth);
        if (this.current != null) {
            return this.naming.getName(this.current.getElement().getName());
        }
        return null;
    }

    @Override
    public boolean next(N name) throws StaxNavException {
        if (name == null) {
            throw new NullPointerException("No null name accepted");
        }
        if (this.current == null) {
            return false;
        }
        Entry next = this.current.next(this.depth);
        if (next == null) {
            return false;
        }
        N nextName = this.naming.getName(next.getElement().getName());
        if (name.equals(nextName)) {
            this.current = next;
            return true;
        }
        return false;
    }

    @Override
    public N next(Set<N> names) throws StaxNavException {
        if (names == null) {
            throw new NullPointerException();
        }
        if (this.current == null) {
            return null;
        }
        Entry next = this.current.next(this.depth);
        if (next == null) {
            return null;
        }
        N name = this.naming.getName(next.getElement().getName());
        if (names.contains(name)) {
            this.current = next;
            return name;
        }
        return null;
    }

    @Override
    public boolean find(N name) throws StaxNavException {
        if (name == null) {
            throw new NullPointerException("No null name accepted");
        }
        if (this.current == null) {
            return false;
        }
        Entry element = this._find(name);
        if (element != null) {
            this.current = element;
            return true;
        }
        return false;
    }

    private Entry _find(N name) throws StaxNavException {
        for (Entry entry = this.current; entry != null; entry = entry.next()) {
            N findName = this.naming.getName(entry.getElement().getName());
            if (!name.equals(findName)) continue;
            return entry;
        }
        return null;
    }

    @Override
    public N child() throws StaxNavException {
        return this._child(null);
    }

    @Override
    public boolean child(N name) throws NullPointerException, StaxNavException {
        if (name == null) {
            throw new NullPointerException("No null name accepted");
        }
        return this._child(name) != null;
    }

    public N _child(N name) throws StaxNavException {
        Entry next;
        if (this.current == null) {
            return null;
        }
        Entry element = this.current;
        while ((next = element.next()) != null && next.getElement().getDepth() > this.current.getElement().getDepth()) {
            if (next.getElement().getDepth() == this.current.getElement().getDepth() + 1) {
                N nextName = this.naming.getName(next.getElement().getName());
                if (name == null) {
                    this.current = next;
                    return nextName;
                }
                if (name.equals(nextName)) {
                    this.current = next;
                    return nextName;
                }
                element = next;
                continue;
            }
            element = next;
        }
        return null;
    }

    @Override
    public N sibling() throws StaxNavException {
        if (this.current == null) {
            return null;
        }
        Entry sibling = this._sibling(null);
        if (sibling != null) {
            this.current = sibling;
            return sibling.getElement().getName(this.naming);
        }
        return null;
    }

    @Override
    public boolean sibling(N name) throws NullPointerException, StaxNavException {
        if (this.current == null) {
            return false;
        }
        Entry sibling = this._sibling(name);
        if (sibling != null) {
            this.current = sibling;
            return true;
        }
        return false;
    }

    private Entry _sibling(N name) throws StaxNavException {
        Entry next;
        Entry element = this.current;
        while ((next = element.next()) != null && next.getElement().getDepth() >= this.current.getElement().getDepth()) {
            if (next.getElement().getDepth() == this.current.getElement().getDepth()) {
                if (name == null) {
                    return next;
                }
                N siblingName = this.naming.getName(next.getElement().getName());
                if (name.equals(siblingName)) {
                    return next;
                }
                element = next;
                continue;
            }
            element = next;
        }
        return null;
    }

    @Override
    public int descendant(N name) throws NullPointerException, StaxNavException {
        if (name == null) {
            throw new NullPointerException("No null name accepted");
        }
        if (this.current == null) {
            return 0;
        }
        return this._descendant(name);
    }

    private int _descendant(N name) throws StaxNavException {
        Entry next;
        Entry element = this.current;
        while ((next = element.next()) != null && next.getElement().getDepth() >= this.current.getElement().getDepth()) {
            N descendantName = this.naming.getName(next.getElement().getName());
            if (name.equals(descendantName)) {
                int diff = next.getElement().getDepth() - this.current.getElement().getDepth();
                this.current = next;
                return diff;
            }
            element = next;
        }
        return -1;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class Element {
        private final Element parent;
        private final QName name;
        private final int depth;
        private final Object content;
        private final Location location;
        private final Map<String, String> attributes;
        private final Map<QName, String> qualifiedAttributes;
        private final Map<String, String> namespaces;

        private Element(XMLStreamReader stream, Element parent) throws XMLStreamException {
            CharSequence content;
            Map<String, String> namespaces;
            Map<QName, String> qualifiedAttributes;
            Map<String, String> attributes;
            Location location;
            QName name;
            block13: {
                if (stream.getEventType() != 1) {
                    throw new AssertionError();
                }
                name = stream.getName();
                location = stream.getLocation();
                attributes = Collections.emptyMap();
                qualifiedAttributes = Collections.emptyMap();
                int attributeCount = stream.getAttributeCount();
                for (int i = 0; i < attributeCount; ++i) {
                    String attributeValue = stream.getAttributeValue(i);
                    QName attributeName = stream.getAttributeName(i);
                    if ("".equals(attributeName.getNamespaceURI())) {
                        if (attributes.isEmpty()) {
                            attributes = new HashMap();
                        }
                        attributes.put(attributeName.getLocalPart(), attributeValue);
                        continue;
                    }
                    if (qualifiedAttributes.isEmpty()) {
                        qualifiedAttributes = new HashMap();
                    }
                    qualifiedAttributes.put(attributeName, attributeValue);
                }
                int namespaceCount = stream.getNamespaceCount();
                if (namespaceCount > 0) {
                    namespaces = new HashMap();
                    for (int i = 0; i < namespaceCount; ++i) {
                        String namespacePrefix = stream.getNamespacePrefix(i);
                        if (namespacePrefix == null) {
                            namespacePrefix = "";
                        }
                        String namespaceURI = stream.getNamespaceURI(i);
                        namespaces.put(namespacePrefix, namespaceURI);
                    }
                } else {
                    namespaces = Collections.emptyMap();
                }
                CharSequence sb = null;
                String chunk = null;
                content = null;
                while (true) {
                    stream.next();
                    int type = stream.getEventType();
                    if (type == 8 || type == 1) break block13;
                    if (type == 4) {
                        if (chunk == null) {
                            chunk = stream.getText();
                            continue;
                        }
                        if (sb == null) {
                            sb = new StringBuilder(chunk);
                        }
                        ((StringBuilder)sb).append(stream.getText());
                        continue;
                    }
                    if (type == 2) break;
                }
                content = sb != null ? sb : chunk;
            }
            int depth = 1 + (parent != null ? parent.getDepth() : 0);
            this.parent = parent;
            this.name = name;
            this.depth = depth;
            this.content = content;
            this.attributes = attributes;
            this.qualifiedAttributes = qualifiedAttributes;
            this.namespaces = namespaces;
            this.location = location;
        }

        protected Element getParent() {
            return this.parent;
        }

        protected <N> N getName(Naming<N> naming) {
            return naming.getName(this.getName());
        }

        protected String getNamespaceByPrefix(String namespacePrefix) {
            for (Element current = this; current != null; current = current.getParent()) {
                String namespaceURI = current.getNamespaces().get(namespacePrefix);
                if (namespaceURI == null) continue;
                return namespaceURI;
            }
            return null;
        }

        protected String getContent(boolean trim) {
            if (this.content != null) {
                String s = this.content.toString();
                if (trim) {
                    s = s.trim();
                }
                return s;
            }
            return null;
        }

        protected QName getName() {
            return this.name;
        }

        protected int getDepth() {
            return this.depth;
        }

        protected Location getLocation() {
            return this.location;
        }

        protected Map<String, String> getAttributes() {
            return this.attributes;
        }

        protected Map<QName, String> getQualifiedAttributes() {
            return this.qualifiedAttributes;
        }

        protected Map<String, String> getNamespaces() {
            return this.namespaces;
        }

        public String toString() {
            return "Element[name=" + this.name + ",location=" + this.location + "]";
        }
    }

    private static class StreamEntry
    extends Entry {
        private final XMLStreamReader stream;
        private final Element element;
        private StreamEntry next;

        private StreamEntry(XMLStreamReader stream, Element element) {
            this.stream = stream;
            this.next = null;
            this.element = element;
        }

        protected Element getElement() throws StaxNavException {
            return this.element;
        }

        protected boolean hasNext(int depth) throws StaxNavException {
            return this.next(depth) != null;
        }

        protected Entry next(int depth) throws StaxNavException {
            Entry next = this.next();
            if (next != null && next.getElement().getDepth() > depth) {
                return next;
            }
            return null;
        }

        protected Entry next() throws StaxNavException {
            try {
                if (this.next == null) {
                    Element parent = this.element;
                    while (true) {
                        int type;
                        if ((type = this.stream.getEventType()) == 1) {
                            this.next = new StreamEntry(this.stream, new Element(this.stream, parent));
                            break;
                        }
                        if (type == 2) {
                            parent = parent.getParent();
                            this.stream.next();
                            continue;
                        }
                        if (type == 8) break;
                        this.stream.next();
                    }
                }
                return this.next;
            }
            catch (XMLStreamException e) {
                throw new StaxNavException(e);
            }
        }

        public String toString() {
            return "StreamEntry[element=" + this.element + "]";
        }
    }

    private static class HeadEntry
    extends Entry {
        private final XMLStreamReader stream;
        private Entry root;

        private HeadEntry(XMLStreamReader stream) {
            this.stream = stream;
            this.root = null;
        }

        private Entry get() {
            if (this.root == null) {
                try {
                    while (this.stream.hasNext()) {
                        int type = this.stream.getEventType();
                        if (type == 1) {
                            this.root = new StreamEntry(this.stream, new Element(this.stream, null));
                            break;
                        }
                        this.stream.next();
                    }
                }
                catch (XMLStreamException e) {
                    throw new StaxNavException(e);
                }
            }
            if (this.root == null) {
                throw new StaxNavException(this.stream.getLocation(), "No head!!!!");
            }
            return this.root;
        }

        protected boolean hasNext(int depth) throws StaxNavException {
            return this.get().hasNext(depth);
        }

        protected Entry next(int depth) throws StaxNavException {
            return this.get().next(depth);
        }

        protected Entry next() throws StaxNavException {
            return this.get().next();
        }

        protected Element getElement() throws StaxNavException {
            return this.get().getElement();
        }

        public String toString() {
            return "HeadEntry";
        }
    }

    private static abstract class Entry {
        private Entry() {
        }

        protected abstract Element getElement() throws StaxNavException;

        protected abstract boolean hasNext(int var1) throws StaxNavException;

        protected abstract Entry next(int var1) throws StaxNavException;

        protected abstract Entry next() throws StaxNavException;
    }
}

