/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.remoting.responses;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.infinispan.remoting.responses.Response;
import org.infinispan.remoting.rpc.ResponseFilter;
import org.infinispan.remoting.transport.Address;

public final class IgnoreExtraResponsesValidityFilter
implements ResponseFilter {
    private final Set<Address> targets;
    private int missingResponses;

    public IgnoreExtraResponsesValidityFilter(Collection<Address> targets, Address self) {
        this.targets = new HashSet<Address>(targets);
        this.missingResponses = targets.size();
        if (this.targets.contains(self)) {
            --this.missingResponses;
        }
    }

    @Override
    public boolean isAcceptable(Response response, Address address) {
        if (this.targets.contains(address)) {
            --this.missingResponses;
        }
        return true;
    }

    @Override
    public boolean needMoreResponses() {
        return this.missingResponses > 0;
    }
}

