/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.util.concurrent;

import java.io.Serializable;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.Iterator;
import java.util.concurrent.ConcurrentMap;
import org.infinispan.util.concurrent.ConcurrentMapFactory;

public class ConcurrentHashSet<E>
extends AbstractSet<E>
implements Serializable {
    private static final long serialVersionUID = 5312604953511379869L;
    protected final ConcurrentMap<E, Object> map;
    private static final Serializable DUMMY = Integer.valueOf(0);

    public ConcurrentHashSet() {
        this.map = ConcurrentMapFactory.makeConcurrentMap();
    }

    public ConcurrentHashSet(int concurrencyLevel) {
        this.map = ConcurrentMapFactory.makeConcurrentMap(16, concurrencyLevel);
    }

    public ConcurrentHashSet(int initSize, float loadFactor, int concurrencyLevel) {
        this.map = ConcurrentMapFactory.makeConcurrentMap(initSize, loadFactor, concurrencyLevel);
    }

    @Override
    public int size() {
        return this.map.size();
    }

    @Override
    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    @Override
    public boolean contains(Object o) {
        return this.map.containsKey(o);
    }

    @Override
    public Iterator<E> iterator() {
        return this.map.keySet().iterator();
    }

    @Override
    public Object[] toArray() {
        return this.map.keySet().toArray();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        return this.map.keySet().toArray(a);
    }

    @Override
    public boolean add(E o) {
        Object v = this.map.put(o, DUMMY);
        return v == null;
    }

    @Override
    public boolean remove(Object o) {
        Object v = this.map.remove(o);
        return v != null;
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        return this.map.keySet().containsAll(c);
    }

    @Override
    public boolean addAll(Collection<? extends E> c) {
        throw new UnsupportedOperationException("Not supported in this implementation since additional locking is required and cannot directly be delegated to multiple calls to ConcurrentHashMap");
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        throw new UnsupportedOperationException("Not supported in this implementation since additional locking is required and cannot directly be delegated to multiple calls to ConcurrentHashMap");
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        throw new UnsupportedOperationException("Not supported in this implementation since additional locking is required and cannot directly be delegated to multiple calls to ConcurrentHashMap");
    }

    @Override
    public void clear() {
        this.map.clear();
    }
}

