/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.util.concurrent.jdk8backported;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Arrays;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.locks.AbstractQueuedSynchronizer;
import org.infinispan.util.concurrent.jdk7backported.ThreadLocalRandom;
import org.infinispan.util.concurrent.jdk8backported.LongAdder;
import sun.misc.Unsafe;

public class ConcurrentHashMapV8<K, V>
implements ConcurrentMap<K, V>,
Serializable {
    private static final long serialVersionUID = 7249069246763182397L;
    private static final int MAXIMUM_CAPACITY = 0x40000000;
    private static final int DEFAULT_CAPACITY = 16;
    static final int MAX_ARRAY_SIZE = 0x7FFFFFF7;
    private static final int DEFAULT_CONCURRENCY_LEVEL = 16;
    private static final float LOAD_FACTOR = 0.75f;
    private static final int TRANSFER_BUFFER_SIZE = 32;
    private static final int TREE_THRESHOLD = 8;
    static final int MOVED = Integer.MIN_VALUE;
    static final int LOCKED = 0x40000000;
    static final int WAITING = -1073741824;
    static final int HASH_BITS = 0x3FFFFFFF;
    volatile transient Node[] table;
    private final transient LongAdder counter;
    private volatile transient int sizeCtl;
    private transient KeySet<K, V> keySet;
    private transient Values<K, V> values;
    private transient EntrySet<K, V> entrySet;
    private Segment<K, V>[] segments;
    private static final Unsafe UNSAFE;
    private static final long counterOffset;
    private static final long sizeCtlOffset;
    private static final long ABASE;
    private static final int ASHIFT;

    static final Node tabAt(Node[] tab, int i) {
        return (Node)UNSAFE.getObjectVolatile(tab, ((long)i << ASHIFT) + ABASE);
    }

    private static final boolean casTabAt(Node[] tab, int i, Node c, Node v) {
        return UNSAFE.compareAndSwapObject(tab, ((long)i << ASHIFT) + ABASE, c, v);
    }

    private static final void setTabAt(Node[] tab, int i, Node v) {
        UNSAFE.putObjectVolatile(tab, ((long)i << ASHIFT) + ABASE, v);
    }

    private static final int spread(int h) {
        h ^= h >>> 18 ^ h >>> 12;
        return (h ^ h >>> 10) & 0x3FFFFFFF;
    }

    private final void replaceWithTreeBin(Node[] tab, int index, Object key) {
        if (key instanceof Comparable && (tab.length >= 0x40000000 || this.counter.sum() < (long)this.sizeCtl)) {
            TreeBin t = new TreeBin();
            Node e = ConcurrentHashMapV8.tabAt(tab, index);
            while (e != null) {
                t.putTreeNode(e.hash & 0x3FFFFFFF, e.key, e.val);
                e = e.next;
            }
            ConcurrentHashMapV8.setTabAt(tab, index, new Node(Integer.MIN_VALUE, t, null, null));
        }
    }

    private final Object internalGet(Object k) {
        int h = ConcurrentHashMapV8.spread(k.hashCode());
        Node[] tab = this.table;
        block0: while (tab != null) {
            Node e = ConcurrentHashMapV8.tabAt(tab, tab.length - 1 & h);
            while (e != null) {
                Object ev;
                Object ek;
                int eh = e.hash;
                if (eh == Integer.MIN_VALUE) {
                    ek = e.key;
                    if (ek instanceof TreeBin) {
                        return ((TreeBin)ek).getValue(h, k);
                    }
                    tab = (Node[])ek;
                    continue block0;
                }
                if ((eh & 0x3FFFFFFF) == h && (ev = e.val) != null && ((ek = e.key) == k || k.equals(ek))) {
                    return ev;
                }
                e = e.next;
            }
            break block0;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final Object internalReplace(Object k, Object v, Object cv) {
        int i;
        Node f;
        int h = ConcurrentHashMapV8.spread(k.hashCode());
        Object oldVal = null;
        Node[] tab = this.table;
        while (tab != null && (f = ConcurrentHashMapV8.tabAt(tab, i = tab.length - 1 & h)) != null) {
            boolean deleted;
            boolean validated;
            block28: {
                int fh = f.hash;
                if (fh == Integer.MIN_VALUE) {
                    Object fk = f.key;
                    if (fk instanceof TreeBin) {
                        TreeBin t = (TreeBin)fk;
                        boolean validated2 = false;
                        boolean deleted2 = false;
                        t.acquire(0);
                        try {
                            if (ConcurrentHashMapV8.tabAt(tab, i) == f) {
                                validated2 = true;
                                TreeNode p = t.getTreeNode(h, k, t.root);
                                if (p != null) {
                                    Object pv = p.val;
                                    if (cv == null || cv == pv || cv.equals(pv)) {
                                        oldVal = pv;
                                        p.val = v;
                                        if (p.val == null) {
                                            deleted2 = true;
                                            t.deleteTreeNode(p);
                                        }
                                    }
                                }
                            }
                        }
                        finally {
                            t.release(0);
                        }
                        if (!validated2) continue;
                        if (!deleted2) break;
                        this.counter.add(-1L);
                        break;
                    }
                    tab = (Node[])fk;
                    continue;
                }
                if ((fh & 0x3FFFFFFF) != h && f.next == null) break;
                if ((fh & 0x40000000) != 0) {
                    this.checkForResize();
                    f.tryAwaitLock(tab, i);
                    continue;
                }
                if (!f.casHash(fh, fh | 0x40000000)) continue;
                validated = false;
                deleted = false;
                try {
                    if (ConcurrentHashMapV8.tabAt(tab, i) != f) break block28;
                    validated = true;
                    Node e = f;
                    Node pred = null;
                    do {
                        Object ek;
                        Object ev;
                        if ((e.hash & 0x3FFFFFFF) == h && (ev = e.val) != null && ((ek = e.key) == k || k.equals(ek))) {
                            if (cv == null || cv == ev || cv.equals(ev)) {
                                oldVal = ev;
                                e.val = v;
                                if (e.val == null) {
                                    deleted = true;
                                    Node en = e.next;
                                    if (pred != null) {
                                        pred.next = en;
                                    } else {
                                        ConcurrentHashMapV8.setTabAt(tab, i, en);
                                    }
                                }
                            }
                            break;
                        }
                        pred = e;
                    } while ((e = e.next) != null);
                }
                finally {
                    if (!f.casHash(fh | 0x40000000, fh)) {
                        f.hash = fh;
                        Node node = f;
                        synchronized (node) {
                            f.notifyAll();
                        }
                    }
                }
            }
            if (!validated) continue;
            if (!deleted) break;
            this.counter.add(-1L);
            break;
        }
        return oldVal;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final Object internalPut(Object k, Object v) {
        int count;
        block29: {
            Object oldVal;
            int h = ConcurrentHashMapV8.spread(k.hashCode());
            count = 0;
            Node[] tab = this.table;
            while (true) {
                block31: {
                    if (tab == null) {
                        tab = this.initTable();
                        continue;
                    }
                    int i = tab.length - 1 & h;
                    Node f = ConcurrentHashMapV8.tabAt(tab, i);
                    if (f == null) {
                        if (!ConcurrentHashMapV8.casTabAt(tab, i, null, new Node(h, k, v, null))) continue;
                        break block29;
                    }
                    int fh = f.hash;
                    if (fh == Integer.MIN_VALUE) {
                        Object fk = f.key;
                        if (fk instanceof TreeBin) {
                            TreeBin t = (TreeBin)fk;
                            Object oldVal2 = null;
                            t.acquire(0);
                            try {
                                if (ConcurrentHashMapV8.tabAt(tab, i) == f) {
                                    count = 2;
                                    TreeNode p = t.putTreeNode(h, k, v);
                                    if (p != null) {
                                        oldVal2 = p.val;
                                        p.val = v;
                                    }
                                }
                            }
                            finally {
                                t.release(0);
                            }
                            if (count == 0) continue;
                            if (oldVal2 != null) {
                                return oldVal2;
                            }
                            break block29;
                        }
                        tab = (Node[])fk;
                        continue;
                    }
                    if ((fh & 0x40000000) != 0) {
                        this.checkForResize();
                        f.tryAwaitLock(tab, i);
                        continue;
                    }
                    if (!f.casHash(fh, fh | 0x40000000)) continue;
                    oldVal = null;
                    try {
                        if (ConcurrentHashMapV8.tabAt(tab, i) != f) break block31;
                        count = 1;
                        Node e = f;
                        while (true) {
                            Object ek;
                            Object ev;
                            if ((e.hash & 0x3FFFFFFF) == h && (ev = e.val) != null && ((ek = e.key) == k || k.equals(ek))) {
                                oldVal = ev;
                                e.val = v;
                                break;
                            }
                            Node last = e;
                            e = e.next;
                            if (e == null) {
                                last.next = new Node(h, k, v, null);
                                if (count >= 8) {
                                    this.replaceWithTreeBin(tab, i, k);
                                }
                                break;
                            }
                            ++count;
                        }
                    }
                    finally {
                        if (!f.casHash(fh | 0x40000000, fh)) {
                            f.hash = fh;
                            Node node = f;
                            synchronized (node) {
                                f.notifyAll();
                            }
                        }
                    }
                }
                if (count != 0) break;
            }
            if (oldVal != null) {
                return oldVal;
            }
            if (tab.length <= 64) {
                count = 2;
            }
        }
        this.counter.add(1L);
        if (count > 1) {
            this.checkForResize();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final Object internalPutIfAbsent(Object k, Object v) {
        int count;
        block32: {
            Object oldVal;
            int h = ConcurrentHashMapV8.spread(k.hashCode());
            count = 0;
            Node[] tab = this.table;
            while (true) {
                block34: {
                    Object fv;
                    Object fk;
                    if (tab == null) {
                        tab = this.initTable();
                        continue;
                    }
                    int i = tab.length - 1 & h;
                    Node f = ConcurrentHashMapV8.tabAt(tab, i);
                    if (f == null) {
                        if (!ConcurrentHashMapV8.casTabAt(tab, i, null, new Node(h, k, v, null))) continue;
                        break block32;
                    }
                    int fh = f.hash;
                    if (fh == Integer.MIN_VALUE) {
                        fk = f.key;
                        if (fk instanceof TreeBin) {
                            TreeBin t = (TreeBin)fk;
                            oldVal = null;
                            t.acquire(0);
                            try {
                                if (ConcurrentHashMapV8.tabAt(tab, i) == f) {
                                    count = 2;
                                    TreeNode p = t.putTreeNode(h, k, v);
                                    if (p != null) {
                                        oldVal = p.val;
                                    }
                                }
                            }
                            finally {
                                t.release(0);
                            }
                            if (count == 0) continue;
                            if (oldVal != null) {
                                return oldVal;
                            }
                            break block32;
                        }
                        tab = (Node[])fk;
                        continue;
                    }
                    if ((fh & 0x3FFFFFFF) == h && (fv = f.val) != null && ((fk = f.key) == k || k.equals(fk))) {
                        return fv;
                    }
                    Node g = f.next;
                    if (g != null) {
                        Node e = g;
                        do {
                            Object ek;
                            Object ev;
                            if ((e.hash & 0x3FFFFFFF) != h || (ev = e.val) == null || (ek = e.key) != k && !k.equals(ek)) continue;
                            return ev;
                        } while ((e = e.next) != null);
                        this.checkForResize();
                    }
                    if (((fh = f.hash) & 0x40000000) != 0) {
                        this.checkForResize();
                        f.tryAwaitLock(tab, i);
                        continue;
                    }
                    if (ConcurrentHashMapV8.tabAt(tab, i) != f || !f.casHash(fh, fh | 0x40000000)) continue;
                    oldVal = null;
                    try {
                        if (ConcurrentHashMapV8.tabAt(tab, i) != f) break block34;
                        count = 1;
                        Node e = f;
                        while (true) {
                            Object ek;
                            Object ev;
                            if ((e.hash & 0x3FFFFFFF) == h && (ev = e.val) != null && ((ek = e.key) == k || k.equals(ek))) {
                                oldVal = ev;
                                break;
                            }
                            Node last = e;
                            e = e.next;
                            if (e == null) {
                                last.next = new Node(h, k, v, null);
                                if (count >= 8) {
                                    this.replaceWithTreeBin(tab, i, k);
                                }
                                break;
                            }
                            ++count;
                        }
                    }
                    finally {
                        if (!f.casHash(fh | 0x40000000, fh)) {
                            f.hash = fh;
                            Node node = f;
                            synchronized (node) {
                                f.notifyAll();
                            }
                        }
                    }
                }
                if (count != 0) break;
            }
            if (oldVal != null) {
                return oldVal;
            }
            if (tab.length <= 64) {
                count = 2;
            }
        }
        this.counter.add(1L);
        if (count > 1) {
            this.checkForResize();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final Object internalComputeIfAbsent(K k, MappingFunction<? super K, ?> mf) {
        int count;
        Object val;
        block50: {
            boolean added;
            int h = ConcurrentHashMapV8.spread(k.hashCode());
            val = null;
            count = 0;
            Node[] tab = this.table;
            while (true) {
                block52: {
                    Object fv;
                    Object fk;
                    int fh;
                    if (tab == null) {
                        tab = this.initTable();
                        continue;
                    }
                    int i = tab.length - 1 & h;
                    Node f = ConcurrentHashMapV8.tabAt(tab, i);
                    if (f == null) {
                        fh = h | 0x40000000;
                        Node node = new Node(fh, k, null, null);
                        if (ConcurrentHashMapV8.casTabAt(tab, i, null, node)) {
                            count = 1;
                            try {
                                Object obj = mf.map(k);
                                val = obj;
                                if (obj != null) {
                                    node.val = val;
                                }
                            }
                            finally {
                                if (val == null) {
                                    ConcurrentHashMapV8.setTabAt(tab, i, null);
                                }
                                if (!node.casHash(fh, h)) {
                                    node.hash = h;
                                    Node node2 = node;
                                    synchronized (node2) {
                                        node.notifyAll();
                                    }
                                }
                            }
                        }
                        if (count == 0) continue;
                        break block50;
                    }
                    fh = f.hash;
                    if (fh == Integer.MIN_VALUE) {
                        fk = f.key;
                        if (fk instanceof TreeBin) {
                            TreeBin t = (TreeBin)fk;
                            boolean added2 = false;
                            t.acquire(0);
                            try {
                                if (ConcurrentHashMapV8.tabAt(tab, i) == f) {
                                    count = 1;
                                    TreeNode p = t.getTreeNode(h, k, t.root);
                                    if (p != null) {
                                        val = p.val;
                                    } else {
                                        val = mf.map(k);
                                        if (val != null) {
                                            added2 = true;
                                            count = 2;
                                            t.putTreeNode(h, k, val);
                                        }
                                    }
                                }
                            }
                            finally {
                                t.release(0);
                            }
                            if (count == 0) continue;
                            if (!added2) {
                                return val;
                            }
                            break block50;
                        }
                        tab = (Node[])fk;
                        continue;
                    }
                    if ((fh & 0x3FFFFFFF) == h && (fv = f.val) != null && ((fk = f.key) == k || k.equals(fk))) {
                        return fv;
                    }
                    Node g = f.next;
                    if (g != null) {
                        Node e = g;
                        do {
                            Object ek;
                            Object ev;
                            if ((e.hash & 0x3FFFFFFF) != h || (ev = e.val) == null || (ek = e.key) != k && !k.equals(ek)) continue;
                            return ev;
                        } while ((e = e.next) != null);
                        this.checkForResize();
                    }
                    if (((fh = f.hash) & 0x40000000) != 0) {
                        this.checkForResize();
                        f.tryAwaitLock(tab, i);
                        continue;
                    }
                    if (ConcurrentHashMapV8.tabAt(tab, i) != f || !f.casHash(fh, fh | 0x40000000)) continue;
                    added = false;
                    try {
                        if (ConcurrentHashMapV8.tabAt(tab, i) != f) break block52;
                        count = 1;
                        Node e = f;
                        while (true) {
                            Object ek;
                            Object ev;
                            if ((e.hash & 0x3FFFFFFF) == h && (ev = e.val) != null && ((ek = e.key) == k || k.equals(ek))) {
                                val = ev;
                                break;
                            }
                            Node last = e;
                            e = e.next;
                            if (e == null) {
                                val = mf.map(k);
                                if (val != null) {
                                    added = true;
                                    last.next = new Node(h, k, val, null);
                                    if (count >= 8) {
                                        this.replaceWithTreeBin(tab, i, k);
                                    }
                                }
                                break;
                            }
                            ++count;
                        }
                    }
                    finally {
                        if (!f.casHash(fh | 0x40000000, fh)) {
                            f.hash = fh;
                            Node node = f;
                            synchronized (node) {
                                f.notifyAll();
                            }
                        }
                    }
                }
                if (count != 0) break;
            }
            if (!added) {
                return val;
            }
            if (tab.length <= 64) {
                count = 2;
            }
        }
        if (val == null) {
            throw new NullPointerException();
        }
        this.counter.add(1L);
        if (count > 1) {
            this.checkForResize();
        }
        return val;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final Object internalCompute(K k, RemappingFunction<? super K, V> mf) {
        int count;
        boolean added;
        Object val;
        block47: {
            int h = ConcurrentHashMapV8.spread(k.hashCode());
            val = null;
            added = false;
            count = 0;
            Node[] tab = this.table;
            while (true) {
                block49: {
                    int fh;
                    if (tab == null) {
                        tab = this.initTable();
                        continue;
                    }
                    int i = tab.length - 1 & h;
                    Node f = ConcurrentHashMapV8.tabAt(tab, i);
                    if (f == null) {
                        fh = h | 0x40000000;
                        Node node = new Node(fh, k, null, null);
                        if (ConcurrentHashMapV8.casTabAt(tab, i, null, node)) {
                            try {
                                count = 1;
                                val = mf.remap(k, null);
                                if (val != null) {
                                    node.val = val;
                                    added = true;
                                }
                            }
                            finally {
                                if (!added) {
                                    ConcurrentHashMapV8.setTabAt(tab, i, null);
                                }
                                if (!node.casHash(fh, h)) {
                                    node.hash = h;
                                    Node node2 = node;
                                    synchronized (node2) {
                                        node.notifyAll();
                                    }
                                }
                            }
                        }
                        if (count == 0) continue;
                        break block47;
                    }
                    fh = f.hash;
                    if (fh == Integer.MIN_VALUE) {
                        Object fk = f.key;
                        if (fk instanceof TreeBin) {
                            TreeBin t = (TreeBin)fk;
                            t.acquire(0);
                            try {
                                if (ConcurrentHashMapV8.tabAt(tab, i) == f) {
                                    count = 1;
                                    TreeNode p = t.getTreeNode(h, k, t.root);
                                    Object pv = p == null ? null : p.val;
                                    val = mf.remap(k, pv);
                                    if (val != null) {
                                        if (p != null) {
                                            p.val = val;
                                        } else {
                                            count = 2;
                                            added = true;
                                            t.putTreeNode(h, k, val);
                                        }
                                    }
                                }
                            }
                            finally {
                                t.release(0);
                            }
                            if (count == 0) continue;
                            break block47;
                        }
                        tab = (Node[])fk;
                        continue;
                    }
                    if ((fh & 0x40000000) != 0) {
                        this.checkForResize();
                        f.tryAwaitLock(tab, i);
                        continue;
                    }
                    if (!f.casHash(fh, fh | 0x40000000)) continue;
                    try {
                        if (ConcurrentHashMapV8.tabAt(tab, i) != f) break block49;
                        count = 1;
                        Node e = f;
                        while (true) {
                            Object ek;
                            Object ev;
                            if ((e.hash & 0x3FFFFFFF) == h && (ev = e.val) != null && ((ek = e.key) == k || k.equals(ek))) {
                                val = mf.remap(k, ev);
                                if (val != null) {
                                    e.val = val;
                                }
                                break;
                            }
                            Node last = e;
                            e = e.next;
                            if (e == null) {
                                val = mf.remap(k, null);
                                if (val != null) {
                                    last.next = new Node(h, k, val, null);
                                    added = true;
                                    if (count >= 8) {
                                        this.replaceWithTreeBin(tab, i, k);
                                    }
                                }
                                break;
                            }
                            ++count;
                        }
                    }
                    finally {
                        if (!f.casHash(fh | 0x40000000, fh)) {
                            f.hash = fh;
                            Node node = f;
                            synchronized (node) {
                                f.notifyAll();
                            }
                        }
                    }
                }
                if (count != 0) break;
            }
            if (tab.length <= 64) {
                count = 2;
            }
        }
        if (val == null) {
            throw new NullPointerException();
        }
        if (added) {
            this.counter.add(1L);
            if (count > 1) {
                this.checkForResize();
            }
        }
        return val;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void internalPutAll(Map<?, ?> m) {
        this.tryPresize(m.size());
        long delta = 0L;
        boolean npe = false;
        try {
            block15: for (Map.Entry<?, ?> entry : m.entrySet()) {
                int count;
                Object v;
                Object k;
                if (entry == null || (k = entry.getKey()) == null || (v = entry.getValue()) == null) {
                    npe = true;
                    break;
                }
                int h = ConcurrentHashMapV8.spread(k.hashCode());
                Node[] tab = this.table;
                while (true) {
                    block35: {
                        if (tab == null) {
                            tab = this.initTable();
                            continue;
                        }
                        int i = tab.length - 1 & h;
                        Node f = ConcurrentHashMapV8.tabAt(tab, i);
                        if (f == null) {
                            if (!ConcurrentHashMapV8.casTabAt(tab, i, null, new Node(h, k, v, null))) continue;
                            ++delta;
                            continue block15;
                        }
                        int fh = f.hash;
                        if (fh == Integer.MIN_VALUE) {
                            Object fk = f.key;
                            if (fk instanceof TreeBin) {
                                TreeBin t = (TreeBin)fk;
                                boolean validated = false;
                                t.acquire(0);
                                try {
                                    if (ConcurrentHashMapV8.tabAt(tab, i) == f) {
                                        validated = true;
                                        TreeNode p = t.getTreeNode(h, k, t.root);
                                        if (p != null) {
                                            p.val = v;
                                        } else {
                                            t.putTreeNode(h, k, v);
                                            ++delta;
                                        }
                                    }
                                }
                                finally {
                                    t.release(0);
                                }
                                if (!validated) continue;
                                continue block15;
                            }
                            tab = (Node[])fk;
                            continue;
                        }
                        if ((fh & 0x40000000) != 0) {
                            this.counter.add(delta);
                            delta = 0L;
                            this.checkForResize();
                            f.tryAwaitLock(tab, i);
                            continue;
                        }
                        if (!f.casHash(fh, fh | 0x40000000)) continue;
                        count = 0;
                        try {
                            if (ConcurrentHashMapV8.tabAt(tab, i) != f) break block35;
                            count = 1;
                            Node e = f;
                            while (true) {
                                Object ek;
                                Object ev;
                                if ((e.hash & 0x3FFFFFFF) == h && (ev = e.val) != null && ((ek = e.key) == k || k.equals(ek))) {
                                    e.val = v;
                                    break;
                                }
                                Node last = e;
                                e = e.next;
                                if (e == null) {
                                    ++delta;
                                    last.next = new Node(h, k, v, null);
                                    if (count >= 8) {
                                        this.replaceWithTreeBin(tab, i, k);
                                    }
                                    break;
                                }
                                ++count;
                            }
                        }
                        finally {
                            if (!f.casHash(fh | 0x40000000, fh)) {
                                f.hash = fh;
                                Node node = f;
                                synchronized (node) {
                                    f.notifyAll();
                                }
                            }
                        }
                    }
                    if (count != 0) break;
                }
                if (count <= true) continue;
                this.counter.add(delta);
                delta = 0L;
                this.checkForResize();
            }
        }
        finally {
            if (delta != 0L) {
                this.counter.add(delta);
            }
        }
        if (npe) {
            throw new NullPointerException();
        }
    }

    private static final int tableSizeFor(int c) {
        int n = c - 1;
        n |= n >>> 1;
        n |= n >>> 2;
        n |= n >>> 4;
        n |= n >>> 8;
        return (n |= n >>> 16) < 0 ? 1 : (n >= 0x40000000 ? 0x40000000 : n + 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final Node[] initTable() {
        Node[] tab;
        block6: {
            int sc;
            while (true) {
                tab = this.table;
                if (this.table != null) break block6;
                sc = this.sizeCtl;
                if (sc < 0) {
                    Thread.yield();
                    continue;
                }
                if (UNSAFE.compareAndSwapInt(this, sizeCtlOffset, sc, -1)) break;
            }
            try {
                tab = this.table;
                if (this.table == null) {
                    int n = sc > 0 ? sc : 16;
                    this.table = new Node[n];
                    tab = this.table;
                    sc = n - (n >>> 2);
                }
            }
            finally {
                this.sizeCtl = sc;
            }
        }
        return tab;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final void checkForResize() {
        while (true) {
            int sc;
            int n;
            Node[] tab = this.table;
            if (this.table == null || (n = tab.length) >= 0x40000000 || (sc = this.sizeCtl) < 0 || this.counter.sum() < (long)sc || !UNSAFE.compareAndSwapInt(this, sizeCtlOffset, sc, -1)) return;
            try {
                if (tab != this.table) continue;
                this.table = ConcurrentHashMapV8.rebuild(tab);
                sc = (n << 1) - (n >>> 1);
                continue;
            }
            finally {
                this.sizeCtl = sc;
                continue;
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void tryPresize(int size) {
        int sc;
        int c;
        int n = c = size >= 0x20000000 ? 0x40000000 : ConcurrentHashMapV8.tableSizeFor(size + (size >>> 1) + 1);
        while ((sc = this.sizeCtl) >= 0) {
            int n2;
            Node[] tab = this.table;
            if (tab == null || (n2 = tab.length) == 0) {
                int n3 = n2 = sc > c ? sc : c;
                if (!UNSAFE.compareAndSwapInt(this, sizeCtlOffset, sc, -1)) continue;
                try {
                    if (this.table != tab) continue;
                    this.table = new Node[n2];
                    sc = n2 - (n2 >>> 2);
                    continue;
                }
                finally {
                    this.sizeCtl = sc;
                    continue;
                }
            }
            if (c <= sc || n2 >= 0x40000000) break;
            if (!UNSAFE.compareAndSwapInt(this, sizeCtlOffset, sc, -1)) continue;
            try {
                if (this.table != tab) continue;
                this.table = ConcurrentHashMapV8.rebuild(tab);
                sc = (n2 << 1) - (n2 >>> 1);
            }
            finally {
                this.sizeCtl = sc;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final Node[] rebuild(Node[] tab) {
        int bin;
        int n = tab.length;
        Node[] nextTab = new Node[n << 1];
        Node fwd = new Node(Integer.MIN_VALUE, nextTab, null, null);
        int[] buffer = null;
        Node rev = null;
        int nbuffered = 0;
        int bufferIndex = 0;
        int i = bin = n - 1;
        while (true) {
            Node node;
            Node f;
            if ((f = ConcurrentHashMapV8.tabAt(tab, i)) == null) {
                if (bin >= 0) {
                    if (!ConcurrentHashMapV8.casTabAt(tab, i, f, fwd)) {
                        continue;
                    }
                } else {
                    Node g = new Node(-1073741824, nextTab, null, null);
                    if (!ConcurrentHashMapV8.casTabAt(tab, i, f, g)) continue;
                    ConcurrentHashMapV8.setTabAt(nextTab, i, null);
                    ConcurrentHashMapV8.setTabAt(nextTab, i + n, null);
                    ConcurrentHashMapV8.setTabAt(tab, i, fwd);
                    if (!g.casHash(-1073741824, Integer.MIN_VALUE)) {
                        g.hash = Integer.MIN_VALUE;
                        node = g;
                        synchronized (node) {
                            g.notifyAll();
                        }
                    }
                }
            } else {
                int fh = f.hash;
                if (fh == Integer.MIN_VALUE) {
                    Object fk = f.key;
                    if (fk instanceof TreeBin) {
                        TreeBin t = (TreeBin)fk;
                        boolean validated = false;
                        t.acquire(0);
                        try {
                            if (ConcurrentHashMapV8.tabAt(tab, i) == f) {
                                validated = true;
                                ConcurrentHashMapV8.splitTreeBin(nextTab, i, t);
                                ConcurrentHashMapV8.setTabAt(tab, i, fwd);
                            }
                        }
                        finally {
                            t.release(0);
                        }
                        if (!validated) {
                            continue;
                        }
                    }
                } else if ((fh & 0x40000000) == 0 && f.casHash(fh, fh | 0x40000000)) {
                    boolean validated = false;
                    try {
                        if (ConcurrentHashMapV8.tabAt(tab, i) == f) {
                            validated = true;
                            ConcurrentHashMapV8.splitBin(nextTab, i, f);
                            ConcurrentHashMapV8.setTabAt(tab, i, fwd);
                        }
                    }
                    finally {
                        if (!f.casHash(fh | 0x40000000, fh)) {
                            f.hash = fh;
                            node = f;
                            synchronized (node) {
                                f.notifyAll();
                            }
                        }
                    }
                    if (!validated) {
                        continue;
                    }
                } else {
                    if (buffer == null) {
                        buffer = new int[32];
                    }
                    if (bin < 0 && bufferIndex > 0) {
                        int j = buffer[--bufferIndex];
                        buffer[bufferIndex] = i;
                        i = j;
                        continue;
                    }
                    if (bin < 0 || nbuffered >= 32) {
                        f.tryAwaitLock(tab, i);
                        continue;
                    }
                    if (rev == null) {
                        rev = new Node(Integer.MIN_VALUE, tab, null, null);
                    }
                    if (ConcurrentHashMapV8.tabAt(tab, i) != f || (f.hash & 0x40000000) == 0) continue;
                    buffer[nbuffered++] = i;
                    ConcurrentHashMapV8.setTabAt(nextTab, i, rev);
                    ConcurrentHashMapV8.setTabAt(nextTab, i + n, rev);
                }
            }
            if (bin > 0) {
                i = --bin;
                continue;
            }
            if (buffer == null || nbuffered <= 0) break;
            bin = -1;
            bufferIndex = --nbuffered;
            i = buffer[bufferIndex];
        }
        return nextTab;
    }

    private static void splitBin(Node[] nextTab, int i, Node e) {
        int bit = nextTab.length >>> 1;
        int runBit = e.hash & bit;
        Node lastRun = e;
        Node lo = null;
        Node hi = null;
        Node p = e.next;
        while (p != null) {
            int b = p.hash & bit;
            if (b != runBit) {
                runBit = b;
                lastRun = p;
            }
            p = p.next;
        }
        if (runBit == 0) {
            lo = lastRun;
        } else {
            hi = lastRun;
        }
        p = e;
        while (p != lastRun) {
            int ph = p.hash & 0x3FFFFFFF;
            Object pk = p.key;
            Object pv = p.val;
            if ((ph & bit) == 0) {
                lo = new Node(ph, pk, pv, lo);
            } else {
                hi = new Node(ph, pk, pv, hi);
            }
            p = p.next;
        }
        ConcurrentHashMapV8.setTabAt(nextTab, i, lo);
        ConcurrentHashMapV8.setTabAt(nextTab, i + bit, hi);
    }

    private static void splitTreeBin(Node[] nextTab, int i, TreeBin t) {
        Node hn;
        Node p;
        Node ln;
        int bit = nextTab.length >>> 1;
        TreeBin lt = new TreeBin();
        TreeBin ht = new TreeBin();
        int lc = 0;
        int hc = 0;
        Node e = t.first;
        while (e != null) {
            int h = e.hash & 0x3FFFFFFF;
            Object k = e.key;
            Object v = e.val;
            if ((h & bit) == 0) {
                ++lc;
                lt.putTreeNode(h, k, v);
            } else {
                ++hc;
                ht.putTreeNode(h, k, v);
            }
            e = e.next;
        }
        if (lc <= 4) {
            ln = null;
            p = lt.first;
            while (p != null) {
                ln = new Node(p.hash, p.key, p.val, ln);
                p = p.next;
            }
        } else {
            ln = new Node(Integer.MIN_VALUE, lt, null, null);
        }
        ConcurrentHashMapV8.setTabAt(nextTab, i, ln);
        if (hc <= 4) {
            hn = null;
            p = ht.first;
            while (p != null) {
                hn = new Node(p.hash, p.key, p.val, hn);
                p = p.next;
            }
        } else {
            hn = new Node(Integer.MIN_VALUE, ht, null, null);
        }
        ConcurrentHashMapV8.setTabAt(nextTab, i + bit, hn);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void internalClear() {
        long delta = 0L;
        int i = 0;
        Node[] tab = this.table;
        while (tab != null && i < tab.length) {
            Node f = ConcurrentHashMapV8.tabAt(tab, i);
            if (f == null) {
                ++i;
                continue;
            }
            int fh = f.hash;
            if (fh == Integer.MIN_VALUE) {
                Object fk = f.key;
                if (fk instanceof TreeBin) {
                    TreeBin t = (TreeBin)fk;
                    t.acquire(0);
                    try {
                        if (ConcurrentHashMapV8.tabAt(tab, i) != f) continue;
                        Node p = t.first;
                        while (p != null) {
                            p.val = null;
                            --delta;
                            p = p.next;
                        }
                        t.first = null;
                        t.root = null;
                        ++i;
                        continue;
                    }
                    finally {
                        t.release(0);
                        continue;
                    }
                }
                tab = (Node[])fk;
                continue;
            }
            if ((fh & 0x40000000) != 0) {
                this.counter.add(delta);
                delta = 0L;
                f.tryAwaitLock(tab, i);
                continue;
            }
            if (!f.casHash(fh, fh | 0x40000000)) continue;
            try {
                if (ConcurrentHashMapV8.tabAt(tab, i) != f) continue;
                Node e = f;
                while (e != null) {
                    e.val = null;
                    --delta;
                    e = e.next;
                }
                ConcurrentHashMapV8.setTabAt(tab, i, null);
                ++i;
            }
            finally {
                if (f.casHash(fh | 0x40000000, fh)) continue;
                f.hash = fh;
                Node node = f;
                synchronized (node) {
                    f.notifyAll();
                }
            }
        }
        if (delta != 0L) {
            this.counter.add(delta);
        }
    }

    public ConcurrentHashMapV8() {
        this.counter = new LongAdder();
    }

    public ConcurrentHashMapV8(int initialCapacity) {
        if (initialCapacity < 0) {
            throw new IllegalArgumentException();
        }
        int cap = initialCapacity >= 0x20000000 ? 0x40000000 : ConcurrentHashMapV8.tableSizeFor(initialCapacity + (initialCapacity >>> 1) + 1);
        this.counter = new LongAdder();
        this.sizeCtl = cap;
    }

    public ConcurrentHashMapV8(Map<? extends K, ? extends V> m) {
        this.counter = new LongAdder();
        this.sizeCtl = 16;
        this.internalPutAll(m);
    }

    public ConcurrentHashMapV8(int initialCapacity, float loadFactor) {
        this(initialCapacity, loadFactor, 1);
    }

    public ConcurrentHashMapV8(int initialCapacity, float loadFactor, int concurrencyLevel) {
        long size;
        if (!(loadFactor > 0.0f) || initialCapacity < 0 || concurrencyLevel <= 0) {
            throw new IllegalArgumentException();
        }
        if (initialCapacity < concurrencyLevel) {
            initialCapacity = concurrencyLevel;
        }
        int cap = (size = (long)(1.0 + (double)((float)initialCapacity / loadFactor))) >= 0x40000000L ? 0x40000000 : ConcurrentHashMapV8.tableSizeFor((int)size);
        this.counter = new LongAdder();
        this.sizeCtl = cap;
    }

    @Override
    public boolean isEmpty() {
        return this.counter.sum() <= 0L;
    }

    @Override
    public int size() {
        long n = this.counter.sum();
        return n < 0L ? 0 : (n > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)n);
    }

    final long longSize() {
        long n = this.counter.sum();
        return n < 0L ? 0L : n;
    }

    @Override
    public V get(Object key) {
        if (key == null) {
            throw new NullPointerException();
        }
        return (V)this.internalGet(key);
    }

    @Override
    public boolean containsKey(Object key) {
        if (key == null) {
            throw new NullPointerException();
        }
        return this.internalGet(key) != null;
    }

    @Override
    public boolean containsValue(Object value) {
        if (value == null) {
            throw new NullPointerException();
        }
        InternalIterator it = new InternalIterator(this.table);
        while (it.next != null) {
            Object v = it.nextVal;
            if (v == value || value.equals(v)) {
                return true;
            }
            it.advance();
        }
        return false;
    }

    public boolean contains(Object value) {
        return this.containsValue(value);
    }

    @Override
    public V put(K key, V value) {
        if (key == null || value == null) {
            throw new NullPointerException();
        }
        return (V)this.internalPut(key, value);
    }

    @Override
    public V putIfAbsent(K key, V value) {
        if (key == null || value == null) {
            throw new NullPointerException();
        }
        return (V)this.internalPutIfAbsent(key, value);
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> m) {
        this.internalPutAll(m);
    }

    @Override
    public V computeIfAbsent(K key, MappingFunction<? super K, ? extends V> mappingFunction) {
        if (key == null || mappingFunction == null) {
            throw new NullPointerException();
        }
        return (V)this.internalComputeIfAbsent(key, mappingFunction);
    }

    public V compute(K key, RemappingFunction<? super K, V> remappingFunction) {
        if (key == null || remappingFunction == null) {
            throw new NullPointerException();
        }
        return (V)this.internalCompute(key, remappingFunction);
    }

    @Override
    public V remove(Object key) {
        if (key == null) {
            throw new NullPointerException();
        }
        return (V)this.internalReplace(key, null, null);
    }

    @Override
    public boolean remove(Object key, Object value) {
        if (key == null) {
            throw new NullPointerException();
        }
        if (value == null) {
            return false;
        }
        return this.internalReplace(key, null, value) != null;
    }

    @Override
    public boolean replace(K key, V oldValue, V newValue) {
        if (key == null || oldValue == null || newValue == null) {
            throw new NullPointerException();
        }
        return this.internalReplace(key, newValue, oldValue) != null;
    }

    @Override
    public V replace(K key, V value) {
        if (key == null || value == null) {
            throw new NullPointerException();
        }
        return (V)this.internalReplace(key, value, null);
    }

    @Override
    public void clear() {
        this.internalClear();
    }

    @Override
    public Set<K> keySet() {
        KeySet<K, V> ks = this.keySet;
        return ks != null ? ks : (this.keySet = new KeySet(this));
    }

    @Override
    public Collection<V> values() {
        Values<K, V> vs = this.values;
        return vs != null ? vs : (this.values = new Values(this));
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        EntrySet<K, V> es = this.entrySet;
        return es != null ? es : (this.entrySet = new EntrySet(this));
    }

    public Enumeration<K> keys() {
        return new KeyIterator(this);
    }

    public Enumeration<V> elements() {
        return new ValueIterator(this);
    }

    @Override
    public int hashCode() {
        int h = 0;
        InternalIterator it = new InternalIterator(this.table);
        while (it.next != null) {
            h += it.nextKey.hashCode() ^ it.nextVal.hashCode();
            it.advance();
        }
        return h;
    }

    public String toString() {
        InternalIterator it = new InternalIterator(this.table);
        StringBuilder sb = new StringBuilder();
        sb.append('{');
        if (it.next != null) {
            while (true) {
                Object k = it.nextKey;
                Object v = it.nextVal;
                sb.append(k == this ? "(this Map)" : k);
                sb.append('=');
                sb.append(v == this ? "(this Map)" : v);
                it.advance();
                if (it.next == null) break;
                sb.append(',').append(' ');
            }
        }
        return sb.append('}').toString();
    }

    @Override
    public boolean equals(Object o) {
        if (o != this) {
            if (!(o instanceof Map)) {
                return false;
            }
            Map m = (Map)o;
            InternalIterator it = new InternalIterator(this.table);
            while (it.next != null) {
                Object val = it.nextVal;
                Object v = m.get(it.nextKey);
                if (v == null || v != val && !v.equals(val)) {
                    return false;
                }
                it.advance();
            }
            for (Map.Entry e : m.entrySet()) {
                Object v;
                Object mv;
                Object mk = e.getKey();
                if (mk != null && (mv = e.getValue()) != null && (v = this.internalGet(mk)) != null && (mv == v || mv.equals(v))) continue;
                return false;
            }
        }
        return true;
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        if (this.segments == null) {
            this.segments = new Segment[16];
            for (int i = 0; i < this.segments.length; ++i) {
                this.segments[i] = new Segment(0.75f);
            }
        }
        s.defaultWriteObject();
        InternalIterator it = new InternalIterator(this.table);
        while (it.next != null) {
            s.writeObject(it.nextKey);
            s.writeObject(it.nextVal);
            it.advance();
        }
        s.writeObject(null);
        s.writeObject(null);
        this.segments = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        this.segments = null;
        UNSAFE.putObjectVolatile(this, counterOffset, new LongAdder());
        long size = 0L;
        Node p = null;
        while (true) {
            Object k = s.readObject();
            Object v = s.readObject();
            if (k == null || v == null) break;
            int h = ConcurrentHashMapV8.spread(k.hashCode());
            p = new Node(h, k, v, p);
            ++size;
        }
        if (p != null) {
            int n;
            boolean init = false;
            if (size >= 0x20000000L) {
                n = 0x40000000;
            } else {
                int sz = (int)size;
                n = ConcurrentHashMapV8.tableSizeFor(sz + (sz >>> 1) + 1);
            }
            int sc = this.sizeCtl;
            boolean collide = false;
            if (n > sc && UNSAFE.compareAndSwapInt(this, sizeCtlOffset, sc, -1)) {
                Node[] tab;
                try {
                    if (this.table == null) {
                        init = true;
                        tab = new Node[n];
                        int mask = n - 1;
                        while (p != null) {
                            int j = p.hash & mask;
                            Node next = p.next;
                            Node q = p.next = ConcurrentHashMapV8.tabAt(tab, j);
                            ConcurrentHashMapV8.setTabAt(tab, j, p);
                            if (!collide && q != null && q.hash == p.hash) {
                                collide = true;
                            }
                            p = next;
                        }
                        this.table = tab;
                        this.counter.add(size);
                        sc = n - (n >>> 2);
                    }
                }
                finally {
                    this.sizeCtl = sc;
                }
                if (collide) {
                    tab = this.table;
                    block5: for (int i = 0; i < tab.length; ++i) {
                        int c = 0;
                        Node e = ConcurrentHashMapV8.tabAt(tab, i);
                        while (e != null) {
                            if (++c > 8 && e.key instanceof Comparable) {
                                this.replaceWithTreeBin(tab, i, e.key);
                                continue block5;
                            }
                            e = e.next;
                        }
                    }
                }
            }
            if (!init) {
                while (p != null) {
                    this.internalPut(p.key, p.val);
                    p = p.next;
                }
            }
        }
    }

    private static Unsafe getUnsafe() {
        try {
            return Unsafe.getUnsafe();
        }
        catch (SecurityException se) {
            try {
                return AccessController.doPrivileged(new PrivilegedExceptionAction<Unsafe>(){

                    @Override
                    public Unsafe run() throws Exception {
                        Field f = Unsafe.class.getDeclaredField("theUnsafe");
                        f.setAccessible(true);
                        return (Unsafe)f.get(null);
                    }
                });
            }
            catch (PrivilegedActionException e) {
                throw new RuntimeException("Could not initialize intrinsics", e.getCause());
            }
        }
    }

    static {
        int ss;
        try {
            UNSAFE = ConcurrentHashMapV8.getUnsafe();
            Class<ConcurrentHashMapV8> k = ConcurrentHashMapV8.class;
            counterOffset = UNSAFE.objectFieldOffset(k.getDeclaredField("counter"));
            sizeCtlOffset = UNSAFE.objectFieldOffset(k.getDeclaredField("sizeCtl"));
            Class<Node[]> sc = Node[].class;
            ABASE = UNSAFE.arrayBaseOffset(sc);
            ss = UNSAFE.arrayIndexScale(sc);
        }
        catch (Exception e) {
            throw new Error(e);
        }
        if ((ss & ss - 1) != 0) {
            throw new Error("data type scale not a power of two");
        }
        ASHIFT = 31 - Integer.numberOfLeadingZeros(ss);
    }

    static class Segment<K, V>
    implements Serializable {
        private static final long serialVersionUID = 2249069246763182397L;
        final float loadFactor;

        Segment(float lf) {
            this.loadFactor = lf;
        }
    }

    static final class EntrySet<K, V>
    extends MapView<K, V>
    implements Set<Map.Entry<K, V>> {
        EntrySet(ConcurrentHashMapV8<K, V> map) {
            super(map);
        }

        @Override
        public final boolean contains(Object o) {
            Object v;
            Object r;
            Map.Entry e;
            Object k;
            return o instanceof Map.Entry && (k = (e = (Map.Entry)o).getKey()) != null && (r = this.map.get(k)) != null && (v = e.getValue()) != null && (v == r || v.equals(r));
        }

        @Override
        public final boolean remove(Object o) {
            Object v;
            Map.Entry e;
            Object k;
            return o instanceof Map.Entry && (k = (e = (Map.Entry)o).getKey()) != null && (v = e.getValue()) != null && this.map.remove(k, v);
        }

        @Override
        public final Iterator<Map.Entry<K, V>> iterator() {
            return new EntryIterator(this.map);
        }

        @Override
        final Iterator<?> iter() {
            return new SnapshotEntryIterator(this.map);
        }

        @Override
        public final boolean add(Map.Entry<K, V> e) {
            throw new UnsupportedOperationException();
        }

        @Override
        public final boolean addAll(Collection<? extends Map.Entry<K, V>> c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean equals(Object o) {
            Set c;
            return o instanceof Set && ((c = (Set)o) == this || this.containsAll(c) && c.containsAll(this));
        }
    }

    static final class Values<K, V>
    extends MapView<K, V>
    implements Collection<V> {
        Values(ConcurrentHashMapV8<K, V> map) {
            super(map);
        }

        @Override
        public final boolean contains(Object o) {
            return this.map.containsValue(o);
        }

        @Override
        public final boolean remove(Object o) {
            if (o != null) {
                ValueIterator it = new ValueIterator(this.map);
                while (it.hasNext()) {
                    if (!o.equals(it.next())) continue;
                    it.remove();
                    return true;
                }
            }
            return false;
        }

        @Override
        public final Iterator<V> iterator() {
            return new ValueIterator(this.map);
        }

        @Override
        final Iterator<?> iter() {
            return new ValueIterator(this.map);
        }

        @Override
        public final boolean add(V e) {
            throw new UnsupportedOperationException();
        }

        @Override
        public final boolean addAll(Collection<? extends V> c) {
            throw new UnsupportedOperationException();
        }
    }

    static final class KeySet<K, V>
    extends MapView<K, V>
    implements Set<K> {
        KeySet(ConcurrentHashMapV8<K, V> map) {
            super(map);
        }

        @Override
        public final boolean contains(Object o) {
            return this.map.containsKey(o);
        }

        @Override
        public final boolean remove(Object o) {
            return this.map.remove(o) != null;
        }

        @Override
        public final Iterator<K> iterator() {
            return new KeyIterator(this.map);
        }

        @Override
        final Iterator<?> iter() {
            return new KeyIterator(this.map);
        }

        @Override
        public final boolean add(K e) {
            throw new UnsupportedOperationException();
        }

        @Override
        public final boolean addAll(Collection<? extends K> c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean equals(Object o) {
            Set c;
            return o instanceof Set && ((c = (Set)o) == this || this.containsAll(c) && c.containsAll(this));
        }
    }

    static abstract class MapView<K, V> {
        final ConcurrentHashMapV8<K, V> map;
        private static final String oomeMsg = "Required array size too large";

        MapView(ConcurrentHashMapV8<K, V> map) {
            this.map = map;
        }

        public final int size() {
            return this.map.size();
        }

        public final boolean isEmpty() {
            return this.map.isEmpty();
        }

        public final void clear() {
            this.map.clear();
        }

        abstract Iterator<?> iter();

        public abstract boolean contains(Object var1);

        public abstract boolean remove(Object var1);

        public final Object[] toArray() {
            long sz = this.map.longSize();
            if (sz > 0x7FFFFFF7L) {
                throw new OutOfMemoryError(oomeMsg);
            }
            int n = (int)sz;
            Object[] r = new Object[n];
            int i = 0;
            Iterator<?> it = this.iter();
            while (it.hasNext()) {
                if (i == n) {
                    if (n >= 0x7FFFFFF7) {
                        throw new OutOfMemoryError(oomeMsg);
                    }
                    n = n >= 0x3FFFFFFB ? 0x7FFFFFF7 : (n += (n >>> 1) + 1);
                    r = Arrays.copyOf(r, n);
                }
                r[i++] = it.next();
            }
            return i == n ? r : Arrays.copyOf(r, i);
        }

        public final <T> T[] toArray(T[] a) {
            long sz = this.map.longSize();
            if (sz > 0x7FFFFFF7L) {
                throw new OutOfMemoryError(oomeMsg);
            }
            int m = (int)sz;
            T[] r = a.length >= m ? a : (Object[])Array.newInstance(a.getClass().getComponentType(), m);
            int n = r.length;
            int i = 0;
            Iterator<?> it = this.iter();
            while (it.hasNext()) {
                if (i == n) {
                    if (n >= 0x7FFFFFF7) {
                        throw new OutOfMemoryError(oomeMsg);
                    }
                    n = n >= 0x3FFFFFFB ? 0x7FFFFFF7 : (n += (n >>> 1) + 1);
                    r = Arrays.copyOf(r, n);
                }
                r[i++] = it.next();
            }
            if (a == r && i < n) {
                r[i] = null;
                return r;
            }
            return i == n ? r : Arrays.copyOf(r, i);
        }

        public final int hashCode() {
            int h = 0;
            Iterator<?> it = this.iter();
            while (it.hasNext()) {
                h += it.next().hashCode();
            }
            return h;
        }

        public final String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append('[');
            Iterator<?> it = this.iter();
            if (it.hasNext()) {
                while (true) {
                    Object e;
                    sb.append((Object)((e = it.next()) == this ? "(this Collection)" : e));
                    if (!it.hasNext()) break;
                    sb.append(',').append(' ');
                }
            }
            return sb.append(']').toString();
        }

        public final boolean containsAll(Collection<?> c) {
            if (c != this) {
                for (Object e : c) {
                    if (e != null && this.contains(e)) continue;
                    return false;
                }
            }
            return true;
        }

        public final boolean removeAll(Collection<?> c) {
            boolean modified = false;
            Iterator<?> it = this.iter();
            while (it.hasNext()) {
                if (!c.contains(it.next())) continue;
                it.remove();
                modified = true;
            }
            return modified;
        }

        public final boolean retainAll(Collection<?> c) {
            boolean modified = false;
            Iterator<?> it = this.iter();
            while (it.hasNext()) {
                if (c.contains(it.next())) continue;
                it.remove();
                modified = true;
            }
            return modified;
        }
    }

    static final class SnapshotEntry<K, V>
    extends MapEntry<K, V>
    implements Map.Entry<K, V> {
        SnapshotEntry(K key, V val) {
            super(key, val);
        }

        @Override
        public final V setValue(V value) {
            if (value == null) {
                throw new NullPointerException();
            }
            Object v = this.val;
            this.val = value;
            return (V)v;
        }
    }

    static final class WriteThroughEntry<K, V>
    extends MapEntry<K, V>
    implements Map.Entry<K, V> {
        final ConcurrentHashMapV8<K, V> map;

        WriteThroughEntry(K key, V val, ConcurrentHashMapV8<K, V> map) {
            super(key, val);
            this.map = map;
        }

        @Override
        public final V setValue(V value) {
            if (value == null) {
                throw new NullPointerException();
            }
            Object v = this.val;
            this.val = value;
            this.map.put(this.key, value);
            return (V)v;
        }
    }

    static abstract class MapEntry<K, V>
    implements Map.Entry<K, V> {
        final K key;
        V val;

        MapEntry(K key, V val) {
            this.key = key;
            this.val = val;
        }

        @Override
        public final K getKey() {
            return this.key;
        }

        @Override
        public final V getValue() {
            return this.val;
        }

        @Override
        public final int hashCode() {
            return this.key.hashCode() ^ this.val.hashCode();
        }

        public final String toString() {
            return this.key + "=" + this.val;
        }

        @Override
        public final boolean equals(Object o) {
            Object v;
            Map.Entry e;
            Object k;
            return !(!(o instanceof Map.Entry) || (k = (e = (Map.Entry)o).getKey()) == null || (v = e.getValue()) == null || k != this.key && !k.equals(this.key) || v != this.val && !v.equals(this.val));
        }

        @Override
        public abstract V setValue(V var1);
    }

    static final class SnapshotEntryIterator<K, V>
    extends ViewIterator<K, V>
    implements Iterator<Map.Entry<K, V>> {
        SnapshotEntryIterator(ConcurrentHashMapV8<K, V> map) {
            super(map);
        }

        @Override
        public final Map.Entry<K, V> next() {
            if (this.next == null) {
                throw new NoSuchElementException();
            }
            Object k = this.nextKey;
            Object v = this.nextVal;
            this.advance();
            return new SnapshotEntry<Object, Object>(k, v);
        }
    }

    static final class EntryIterator<K, V>
    extends ViewIterator<K, V>
    implements Iterator<Map.Entry<K, V>> {
        EntryIterator(ConcurrentHashMapV8<K, V> map) {
            super(map);
        }

        @Override
        public final Map.Entry<K, V> next() {
            if (this.next == null) {
                throw new NoSuchElementException();
            }
            Object k = this.nextKey;
            Object v = this.nextVal;
            this.advance();
            return new WriteThroughEntry<Object, Object>(k, v, this.map);
        }
    }

    static final class ValueIterator<K, V>
    extends ViewIterator<K, V>
    implements Iterator<V>,
    Enumeration<V> {
        ValueIterator(ConcurrentHashMapV8<K, V> map) {
            super(map);
        }

        @Override
        public final V next() {
            if (this.next == null) {
                throw new NoSuchElementException();
            }
            Object v = this.nextVal;
            this.advance();
            return (V)v;
        }

        @Override
        public final V nextElement() {
            return this.next();
        }
    }

    static final class KeyIterator<K, V>
    extends ViewIterator<K, V>
    implements Iterator<K>,
    Enumeration<K> {
        KeyIterator(ConcurrentHashMapV8<K, V> map) {
            super(map);
        }

        @Override
        public final K next() {
            if (this.next == null) {
                throw new NoSuchElementException();
            }
            Object k = this.nextKey;
            this.advance();
            return (K)k;
        }

        @Override
        public final K nextElement() {
            return this.next();
        }
    }

    static abstract class ViewIterator<K, V>
    extends InternalIterator {
        final ConcurrentHashMapV8<K, V> map;

        ViewIterator(ConcurrentHashMapV8<K, V> map) {
            super(map.table);
            this.map = map;
        }

        public final void remove() {
            if (this.last == null) {
                throw new IllegalStateException();
            }
            this.map.remove(this.last.key);
            this.last = null;
        }

        public final boolean hasNext() {
            return this.next != null;
        }

        public final boolean hasMoreElements() {
            return this.next != null;
        }
    }

    static class InternalIterator {
        Node next;
        Node last;
        Object nextKey;
        Object nextVal;
        Node[] tab;
        int index;
        int baseIndex;
        final int baseLimit;
        final int baseSize;

        InternalIterator(Node[] tab) {
            this.tab = tab;
            this.baseSize = tab == null ? 0 : tab.length;
            this.baseLimit = this.baseSize;
            this.baseIndex = 0;
            this.index = 0;
            this.next = null;
            this.advance();
        }

        InternalIterator(Node[] tab, int lo, int hi) {
            this.tab = tab;
            this.baseSize = tab == null ? 0 : tab.length;
            this.baseLimit = hi <= this.baseSize ? hi : this.baseSize;
            this.baseIndex = lo >= 0 ? lo : 0;
            this.index = this.baseIndex;
            this.next = null;
            this.advance();
        }

        final void advance() {
            Node e = this.last = this.next;
            block0: do {
                if (e != null) {
                    e = e.next;
                }
                while (e == null) {
                    int n;
                    int n2;
                    int i;
                    int b = this.baseIndex;
                    if (b >= this.baseLimit || (i = this.index) < 0) break block0;
                    Node[] t = this.tab;
                    if (this.tab == null || i >= (n2 = t.length)) break block0;
                    e = ConcurrentHashMapV8.tabAt(t, i);
                    if (e != null && e.hash == Integer.MIN_VALUE) {
                        Object ek = e.key;
                        if (ek instanceof TreeBin) {
                            e = ((TreeBin)ek).first;
                        } else {
                            this.tab = (Node[])ek;
                            continue;
                        }
                    }
                    if ((i += this.baseSize) < n2) {
                        n = i;
                    } else {
                        n = b + 1;
                        this.baseIndex = this.baseIndex;
                    }
                    this.index = n;
                }
                this.nextKey = e.key;
            } while ((this.nextVal = e.val) == null);
            this.next = e;
        }
    }

    static final class TreeBin
    extends AbstractQueuedSynchronizer {
        private static final long serialVersionUID = 2249069246763182397L;
        TreeNode root;
        TreeNode first;

        TreeBin() {
        }

        @Override
        public final boolean isHeldExclusively() {
            return this.getState() > 0;
        }

        @Override
        public final boolean tryAcquire(int ignore) {
            if (this.compareAndSetState(0, 1)) {
                this.setExclusiveOwnerThread(Thread.currentThread());
                return true;
            }
            return false;
        }

        @Override
        public final boolean tryRelease(int ignore) {
            this.setExclusiveOwnerThread(null);
            this.setState(0);
            return true;
        }

        @Override
        public final int tryAcquireShared(int ignore) {
            int c;
            do {
                if ((c = this.getState()) <= 0) continue;
                return -1;
            } while (!this.compareAndSetState(c, c - 1));
            return 1;
        }

        @Override
        public final boolean tryReleaseShared(int ignore) {
            int c;
            while (!this.compareAndSetState(c = this.getState(), c + 1)) {
            }
            return c == -1;
        }

        final TreeNode getTreeNode(int h, Object k, TreeNode p) {
            Class<?> c = k.getClass();
            while (p != null) {
                TreeNode r;
                int dir;
                int ph = p.hash;
                if (h < ph) {
                    dir = -1;
                } else if (h > ph) {
                    dir = 1;
                } else {
                    Object pk = p.key;
                    if (pk == k || k.equals(pk)) {
                        return p;
                    }
                    Class<?> pc = pk.getClass();
                    dir = c != pc ? c.getName().compareTo(pc.getName()) : (k instanceof Comparable ? ((Comparable)k).compareTo((Comparable)pk) : 0);
                }
                TreeNode pr = p.right;
                if (dir > 0) {
                    p = pr;
                    continue;
                }
                if (dir == 0 && pr != null && h >= pr.hash && (r = this.getTreeNode(h, k, pr)) != null) {
                    return r;
                }
                p = p.left;
            }
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        final Object getValue(int h, Object k) {
            TreeNode r = null;
            int c = this.getState();
            Node e = this.first;
            while (e != null) {
                if (c <= 0 && this.compareAndSetState(c, c - 1)) {
                    try {
                        r = this.getTreeNode(h, k, this.root);
                        break;
                    }
                    finally {
                        this.releaseShared(0);
                    }
                }
                if ((e.hash & 0x3FFFFFFF) == h && k.equals(e.key)) {
                    r = e;
                    break;
                }
                c = this.getState();
                e = e.next;
            }
            return r == null ? null : r.val;
        }

        final TreeNode putTreeNode(int h, Object k, Object v) {
            Class<?> c = k.getClass();
            TreeNode p = this.root;
            int dir = 0;
            if (p != null) {
                while (true) {
                    TreeNode r;
                    int ph;
                    if (h < (ph = p.hash)) {
                        dir = -1;
                    } else if (h > ph) {
                        dir = 1;
                    } else {
                        Object pk = p.key;
                        if (pk == k || k.equals(pk)) {
                            return p;
                        }
                        pk = p.key;
                        Class<?> pc = pk.getClass();
                        dir = c != pc ? c.getName().compareTo(pc.getName()) : (k instanceof Comparable ? ((Comparable)k).compareTo((Comparable)pk) : 0);
                    }
                    TreeNode pr = p.right;
                    if (dir > 0) {
                        if (pr == null) break;
                        p = pr;
                        continue;
                    }
                    if (dir == 0 && pr != null && h >= pr.hash && (r = this.getTreeNode(h, k, pr)) != null) {
                        return r;
                    }
                    TreeNode pl = p.left;
                    if (pl == null) break;
                    p = pl;
                }
            }
            TreeNode f = this.first;
            TreeNode r = this.first = new TreeNode(h, k, v, f, p);
            if (p == null) {
                this.root = r;
            } else {
                if (dir <= 0) {
                    p.left = r;
                } else {
                    p.right = r;
                }
                if (f != null) {
                    f.prev = r;
                }
                this.fixAfterInsertion(r);
            }
            return null;
        }

        final void deleteTreeNode(TreeNode p) {
            TreeNode replacement;
            TreeNode next = (TreeNode)p.next;
            TreeNode pred = p.prev;
            if (pred == null) {
                this.first = next;
            } else {
                pred.next = next;
            }
            if (next != null) {
                next.prev = pred;
            }
            TreeNode pl = p.left;
            TreeNode pr = p.right;
            if (pl != null && pr != null) {
                TreeNode s = pr;
                while (s.left != null) {
                    s = s.left;
                }
                boolean c = s.red;
                s.red = p.red;
                p.red = c;
                TreeNode sr = s.right;
                TreeNode pp = p.parent;
                if (s == pr) {
                    p.parent = s;
                    s.right = p;
                } else {
                    TreeNode sp = s.parent;
                    p.parent = sp;
                    if (p.parent != null) {
                        if (s == sp.left) {
                            sp.left = p;
                        } else {
                            sp.right = p;
                        }
                    }
                    if ((s.right = pr) != null) {
                        pr.parent = s;
                    }
                }
                p.left = null;
                p.right = sr;
                if (p.right != null) {
                    sr.parent = p;
                }
                if ((s.left = pl) != null) {
                    pl.parent = s;
                }
                if ((s.parent = pp) == null) {
                    this.root = s;
                } else if (p == pp.left) {
                    pp.left = s;
                } else {
                    pp.right = s;
                }
                replacement = sr;
            } else {
                replacement = pl != null ? pl : pr;
            }
            TreeNode pp = p.parent;
            if (replacement == null) {
                if (pp == null) {
                    this.root = null;
                    return;
                }
                replacement = p;
            } else {
                replacement.parent = pp;
                if (pp == null) {
                    this.root = replacement;
                } else if (p == pp.left) {
                    pp.left = replacement;
                } else {
                    pp.right = replacement;
                }
                p.parent = null;
                p.right = null;
                p.left = null;
            }
            if (!p.red) {
                this.fixAfterDeletion(replacement);
            }
            if (p == replacement && (pp = p.parent) != null) {
                if (p == pp.left) {
                    pp.left = null;
                } else if (p == pp.right) {
                    pp.right = null;
                }
                p.parent = null;
            }
        }

        private void rotateLeft(TreeNode p) {
            if (p != null) {
                TreeNode r = p.right;
                TreeNode rl = p.right = r.left;
                if (p.right != null) {
                    rl.parent = p;
                }
                TreeNode pp = r.parent = p.parent;
                if (r.parent == null) {
                    this.root = r;
                } else if (pp.left == p) {
                    pp.left = r;
                } else {
                    pp.right = r;
                }
                r.left = p;
                p.parent = r;
            }
        }

        private void rotateRight(TreeNode p) {
            if (p != null) {
                TreeNode l = p.left;
                TreeNode lr = p.left = l.right;
                if (p.left != null) {
                    lr.parent = p;
                }
                TreeNode pp = l.parent = p.parent;
                if (l.parent == null) {
                    this.root = l;
                } else if (pp.right == p) {
                    pp.right = l;
                } else {
                    pp.left = l;
                }
                l.right = p;
                p.parent = l;
            }
        }

        private void fixAfterInsertion(TreeNode x) {
            TreeNode xpp;
            TreeNode xp;
            x.red = true;
            while (x != null && (xp = x.parent) != null && xp.red && (xpp = xp.parent) != null) {
                TreeNode y;
                TreeNode xppl = xpp.left;
                if (xp == xppl) {
                    y = xpp.right;
                    if (y != null && y.red) {
                        y.red = false;
                        xp.red = false;
                        xpp.red = true;
                        x = xpp;
                        continue;
                    }
                    if (x == xp.right) {
                        x = xp;
                        this.rotateLeft(x);
                        xp = x.parent;
                        TreeNode treeNode = xpp = xp == null ? null : xp.parent;
                    }
                    if (xp == null) continue;
                    xp.red = false;
                    if (xpp == null) continue;
                    xpp.red = true;
                    this.rotateRight(xpp);
                    continue;
                }
                y = xppl;
                if (y != null && y.red) {
                    y.red = false;
                    xp.red = false;
                    xpp.red = true;
                    x = xpp;
                    continue;
                }
                if (x == xp.left) {
                    x = xp;
                    this.rotateRight(x);
                    xp = x.parent;
                    TreeNode treeNode = xpp = xp == null ? null : xp.parent;
                }
                if (xp == null) continue;
                xp.red = false;
                if (xpp == null) continue;
                xpp.red = true;
                this.rotateLeft(xpp);
            }
            TreeNode r = this.root;
            if (r != null && r.red) {
                r.red = false;
            }
        }

        private void fixAfterDeletion(TreeNode x) {
            while (x != null) {
                TreeNode sr;
                TreeNode sl;
                TreeNode sib;
                TreeNode xp;
                if (x.red || (xp = x.parent) == null) {
                    x.red = false;
                    break;
                }
                TreeNode xpl = xp.left;
                if (x == xpl) {
                    sib = xp.right;
                    if (sib != null && sib.red) {
                        sib.red = false;
                        xp.red = true;
                        this.rotateLeft(xp);
                        xp = x.parent;
                        TreeNode treeNode = sib = xp == null ? null : xp.right;
                    }
                    if (sib == null) {
                        x = xp;
                        continue;
                    }
                    sl = sib.left;
                    sr = sib.right;
                    if (!(sr != null && sr.red || sl != null && sl.red)) {
                        sib.red = true;
                        x = xp;
                        continue;
                    }
                    if (sr == null || !sr.red) {
                        if (sl != null) {
                            sl.red = false;
                        }
                        sib.red = true;
                        this.rotateRight(sib);
                        xp = x.parent;
                        TreeNode treeNode = sib = xp == null ? null : xp.right;
                    }
                    if (sib != null) {
                        sib.red = xp == null ? false : xp.red;
                        sr = sib.right;
                        if (sr != null) {
                            sr.red = false;
                        }
                    }
                    if (xp != null) {
                        xp.red = false;
                        this.rotateLeft(xp);
                    }
                    x = this.root;
                    continue;
                }
                sib = xpl;
                if (sib != null && sib.red) {
                    sib.red = false;
                    xp.red = true;
                    this.rotateRight(xp);
                    xp = x.parent;
                    TreeNode treeNode = sib = xp == null ? null : xp.left;
                }
                if (sib == null) {
                    x = xp;
                    continue;
                }
                sl = sib.left;
                sr = sib.right;
                if (!(sl != null && sl.red || sr != null && sr.red)) {
                    sib.red = true;
                    x = xp;
                    continue;
                }
                if (sl == null || !sl.red) {
                    if (sr != null) {
                        sr.red = false;
                    }
                    sib.red = true;
                    this.rotateLeft(sib);
                    xp = x.parent;
                    TreeNode treeNode = sib = xp == null ? null : xp.left;
                }
                if (sib != null) {
                    sib.red = xp == null ? false : xp.red;
                    sl = sib.left;
                    if (sl != null) {
                        sl.red = false;
                    }
                }
                if (xp != null) {
                    xp.red = false;
                    this.rotateRight(xp);
                }
                x = this.root;
            }
        }
    }

    static final class TreeNode
    extends Node {
        TreeNode parent;
        TreeNode left;
        TreeNode right;
        TreeNode prev;
        boolean red;

        TreeNode(int hash, Object key, Object val, Node next, TreeNode parent) {
            super(hash, key, val, next);
            this.parent = parent;
        }
    }

    static class Node {
        volatile int hash;
        final Object key;
        volatile Object val;
        volatile Node next;
        static final int MAX_SPINS = Runtime.getRuntime().availableProcessors() > 1 ? 64 : 1;
        private static final Unsafe UNSAFE;
        private static final long hashOffset;

        Node(int hash, Object key, Object val, Node next) {
            this.hash = hash;
            this.key = key;
            this.val = val;
            this.next = next;
        }

        final boolean casHash(int cmp, int val) {
            return UNSAFE.compareAndSwapInt(this, hashOffset, cmp, val);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        final void tryAwaitLock(Node[] tab, int i) {
            if (tab != null && i >= 0 && i < tab.length) {
                int h;
                int r = ThreadLocalRandom.current().nextInt();
                int spins = MAX_SPINS;
                while (ConcurrentHashMapV8.tabAt(tab, i) == this && ((h = this.hash) & 0x40000000) != 0) {
                    if (spins >= 0) {
                        r ^= r << 1;
                        r ^= r >>> 3;
                        if ((r ^= r << 10) < 0 || --spins != 0) continue;
                        Thread.yield();
                        continue;
                    }
                    if (!this.casHash(h, h | 0xC0000000)) continue;
                    Node node = this;
                    synchronized (node) {
                        if (ConcurrentHashMapV8.tabAt(tab, i) == this && (this.hash & 0xC0000000) == -1073741824) {
                            try {
                                this.wait();
                            }
                            catch (InterruptedException ie) {
                                Thread.currentThread().interrupt();
                            }
                        } else {
                            this.notifyAll();
                        }
                        break;
                    }
                }
            }
        }

        static {
            try {
                UNSAFE = ConcurrentHashMapV8.getUnsafe();
                Class<Node> k = Node.class;
                hashOffset = UNSAFE.objectFieldOffset(k.getDeclaredField("hash"));
            }
            catch (Exception e) {
                throw new Error(e);
            }
        }
    }

    public static interface RemappingFunction<K, V> {
        public V remap(K var1, V var2);
    }

    public static interface MappingFunction<K, V> {
        public V map(K var1);
    }
}

