/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.protocols;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.LockSupport;
import java.util.concurrent.locks.ReentrantLock;
import org.jgroups.Event;
import org.jgroups.Message;
import org.jgroups.annotations.Experimental;
import org.jgroups.annotations.MBean;
import org.jgroups.annotations.ManagedAttribute;
import org.jgroups.annotations.Property;
import org.jgroups.stack.Protocol;

@Experimental
@MBean(description="Limits the sending rate to max_bytes per time_period")
public class RATE_LIMITER
extends Protocol {
    @Property(description="Max number of bytes to be sent in time_period ms. Blocks the sender if exceeded until a new time period has started")
    protected long max_bytes = 500000L;
    @Property(description="Number of milliseconds during which max_bytes bytes can be sent")
    protected long time_period = 1000L;
    @ManagedAttribute(description="Number of bytes sent in the current time period. Reset after every time period.")
    protected long num_bytes_sent_in_period = 0L;
    protected long end_of_current_period = 0L;
    protected final Lock lock = new ReentrantLock();
    @ManagedAttribute
    protected int num_blockings = 0;
    protected long total_block_time = 0L;
    protected volatile boolean running = true;

    @ManagedAttribute(description="Total block time in milliseconds")
    public long getTotalBlockTime() {
        return TimeUnit.MILLISECONDS.convert(this.total_block_time, TimeUnit.NANOSECONDS);
    }

    @ManagedAttribute(description="Average block time in ms (total block time / number of blockings)")
    public double getAverageBlockTime() {
        long block_time_ms = this.getTotalBlockTime();
        return this.num_blockings == 0 ? 0.0 : (double)block_time_ms / (double)this.num_blockings;
    }

    @Override
    public void resetStats() {
        super.resetStats();
        this.num_blockings = 0;
        this.total_block_time = 0L;
    }

    @Override
    public void start() throws Exception {
        super.start();
        this.running = true;
    }

    @Override
    public void stop() {
        this.running = false;
        super.stop();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object down(Event evt) {
        if (evt.getType() == 1) {
            Message msg = (Message)evt.getArg();
            int len = msg.getLength();
            this.lock.lock();
            try {
                if ((long)len > this.max_bytes) {
                    this.log.error("message length (" + len + " bytes) exceeded max_bytes (" + this.max_bytes + "); " + "adjusting max_bytes to " + len);
                    this.max_bytes = len;
                }
                while (this.running) {
                    boolean time_exceeded;
                    boolean size_exceeded = this.num_bytes_sent_in_period + (long)len >= this.max_bytes;
                    boolean bl = time_exceeded = System.nanoTime() >= this.end_of_current_period;
                    if (!size_exceeded && !time_exceeded) {
                        break;
                    }
                    if (time_exceeded) {
                        this.num_bytes_sent_in_period = 0L;
                        this.end_of_current_period = System.nanoTime() + TimeUnit.NANOSECONDS.convert(this.time_period, TimeUnit.MILLISECONDS);
                        continue;
                    }
                    long block_time = this.end_of_current_period - System.nanoTime();
                    if (block_time <= 0L) continue;
                    LockSupport.parkNanos(block_time);
                    ++this.num_blockings;
                    this.total_block_time += block_time;
                }
            }
            finally {
                this.num_bytes_sent_in_period += (long)len;
                this.lock.unlock();
            }
            return this.down_prot.down(evt);
        }
        return this.down_prot.down(evt);
    }

    @Override
    public void init() throws Exception {
        super.init();
        if (this.time_period <= 0L) {
            throw new IllegalArgumentException("time_period needs to be positive");
        }
    }
}

