/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.protocols;

import java.io.DataInput;
import java.io.DataOutput;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.jgroups.Address;
import org.jgroups.Event;
import org.jgroups.Header;
import org.jgroups.Message;
import org.jgroups.View;
import org.jgroups.ViewId;
import org.jgroups.annotations.MBean;
import org.jgroups.annotations.ManagedAttribute;
import org.jgroups.annotations.ManagedOperation;
import org.jgroups.stack.Protocol;
import org.jgroups.util.Util;

@MBean(description="Implementation of total order protocol using a sequencer")
public class SEQUENCER
extends Protocol {
    protected Address local_addr = null;
    protected Address coord = null;
    protected final Collection<Address> members = new ArrayList<Address>();
    protected volatile boolean is_coord = false;
    protected long seqno = 1L;
    protected final Map<Long, byte[]> forward_table = new TreeMap<Long, byte[]>();
    protected final Map<Address, Long> delivery_table = Util.createHashMap();
    protected final Lock seqno_lock = new ReentrantLock();
    protected long forwarded_msgs = 0L;
    protected long bcast_msgs = 0L;
    protected long received_forwards = 0L;
    protected long received_bcasts = 0L;
    protected long delivered_bcasts = 0L;

    @ManagedAttribute
    public boolean isCoordinator() {
        return this.is_coord;
    }

    public Address getCoordinator() {
        return this.coord;
    }

    public Address getLocalAddress() {
        return this.local_addr;
    }

    @ManagedAttribute
    public long getForwarded() {
        return this.forwarded_msgs;
    }

    @ManagedAttribute
    public long getBroadcast() {
        return this.bcast_msgs;
    }

    @ManagedAttribute
    public long getReceivedForwards() {
        return this.received_forwards;
    }

    @ManagedAttribute
    public long getReceivedBroadcasts() {
        return this.received_bcasts;
    }

    @ManagedAttribute(description="Number of messages in the forward-table")
    public int getForwardTableSize() {
        return this.forward_table.size();
    }

    @Override
    @ManagedOperation
    public void resetStats() {
        this.delivered_bcasts = 0L;
        this.received_bcasts = 0L;
        this.received_forwards = 0L;
        this.bcast_msgs = 0L;
        this.forwarded_msgs = 0L;
    }

    @Override
    @ManagedOperation
    public Map<String, Object> dumpStats() {
        Map<String, Object> m = super.dumpStats();
        m.put("forwarded", this.forwarded_msgs);
        m.put("broadcast", this.bcast_msgs);
        m.put("received_forwards", this.received_forwards);
        m.put("received_bcasts", this.received_bcasts);
        m.put("delivered_bcasts", this.delivered_bcasts);
        return m;
    }

    @Override
    @ManagedOperation
    public String printStats() {
        return this.dumpStats().toString();
    }

    @ManagedOperation(description="Prints the next seqnos to be received for all senders")
    public String printDeliveryTable() {
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<Address, Long> entry : this.delivery_table.entrySet()) {
            sb.append(entry.getKey()).append(": ").append(entry.getValue()).append("\n");
        }
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object down(Event evt) {
        switch (evt.getType()) {
            case 1: {
                Message msg = (Message)evt.getArg();
                if (msg.getDest() != null || msg.isFlagSet(Message.NO_TOTAL_ORDER) || msg.isFlagSet(Message.OOB)) break;
                this.seqno_lock.lock();
                try {
                    long next_seqno = this.seqno;
                    if (this.is_coord) {
                        SequencerHeader hdr = new SequencerHeader(2, this.local_addr, next_seqno);
                        msg.putHeader(this.id, hdr);
                        this.broadcast(msg, false);
                    } else {
                        if (msg.getSrc() == null) {
                            msg.setSrc(this.local_addr);
                        }
                        byte[] marshalled_msg = null;
                        try {
                            marshalled_msg = Util.objectToByteBuffer(msg);
                        }
                        catch (Exception ex) {
                            this.log.error("failed marshalling message", ex);
                            Object var7_7 = null;
                            this.seqno_lock.unlock();
                            return var7_7;
                        }
                        if (marshalled_msg != null) {
                            if (this.log.isTraceEnabled()) {
                                this.log.trace(this.local_addr + ": forwarding " + this.local_addr + "::" + this.seqno + " to coord " + this.coord);
                            }
                            this.forwardToCoord(marshalled_msg, next_seqno);
                        }
                    }
                    ++this.seqno;
                }
                finally {
                    this.seqno_lock.unlock();
                }
                return null;
            }
            case 6: {
                this.handleViewChange((View)evt.getArg());
                break;
            }
            case 15: {
                this.handleTmpView((View)evt.getArg());
                break;
            }
            case 8: {
                this.local_addr = (Address)evt.getArg();
            }
        }
        return this.down_prot.down(evt);
    }

    @Override
    public Object up(Event evt) {
        switch (evt.getType()) {
            case 1: {
                SequencerHeader hdr;
                Message msg = (Message)evt.getArg();
                if (msg.isFlagSet(Message.NO_TOTAL_ORDER) || msg.isFlagSet(Message.OOB) || (hdr = (SequencerHeader)msg.getHeader(this.id)) == null) break;
                switch (hdr.type) {
                    case 1: {
                        if (!this.is_coord) {
                            if (this.log.isErrorEnabled()) {
                                this.log.error(this.local_addr + ": non-coord; dropping FORWARD request from " + msg.getSrc());
                            }
                            return null;
                        }
                        this.broadcast(msg, true);
                        ++this.received_forwards;
                        return null;
                    }
                    case 2: {
                        this.deliver(msg, evt, hdr);
                        ++this.received_bcasts;
                        return null;
                    }
                    case 3: {
                        this.unwrapAndDeliver(msg);
                        ++this.received_bcasts;
                        return null;
                    }
                }
                break;
            }
            case 6: {
                Object retval = this.up_prot.up(evt);
                this.handleViewChange((View)evt.getArg());
                return retval;
            }
            case 15: {
                this.handleTmpView((View)evt.getArg());
            }
        }
        return this.up_prot.up(evt);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handleViewChange(View v) {
        List<Address> mbrs = v.getMembers();
        if (mbrs.isEmpty()) {
            return;
        }
        boolean coord_changed = false;
        SEQUENCER sEQUENCER = this;
        synchronized (sEQUENCER) {
            this.members.clear();
            this.members.addAll(mbrs);
            Address prev_coord = this.coord;
            this.coord = mbrs.iterator().next();
            this.is_coord = this.local_addr != null && this.local_addr.equals(this.coord);
            coord_changed = prev_coord != null && !prev_coord.equals(this.coord);
        }
        this.delivery_table.keySet().retainAll(mbrs);
        if (coord_changed) {
            this.resendMessagesInForwardTable();
        }
    }

    private void handleTmpView(View v) {
        List<Address> mbrs = v.getMembers();
        if (mbrs.isEmpty()) {
            return;
        }
        Address new_coord = mbrs.iterator().next();
        if (!new_coord.equals(this.coord) && this.local_addr != null && this.local_addr.equals(new_coord)) {
            this.handleViewChange(v);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void resendMessagesInForwardTable() {
        TreeMap<Long, byte[]> copy;
        Map<Long, byte[]> map = this.forward_table;
        synchronized (map) {
            copy = new TreeMap<Long, byte[]>(this.forward_table);
        }
        for (Map.Entry entry : copy.entrySet()) {
            Long key = (Long)entry.getKey();
            byte[] val = (byte[])entry.getValue();
            Message forward_msg = new Message(this.coord, null, val);
            SequencerHeader hdr = new SequencerHeader(1, this.local_addr, key);
            forward_msg.putHeader(this.id, hdr);
            if (this.log.isTraceEnabled()) {
                this.log.trace(this.local_addr + ": resending " + this.local_addr + "::" + key + " to coord " + this.coord);
            }
            this.down_prot.down(new Event(1, forward_msg));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void forwardToCoord(byte[] marshalled_msg, long seqno) {
        Map<Long, byte[]> map = this.forward_table;
        synchronized (map) {
            this.forward_table.put(seqno, marshalled_msg);
        }
        Message forward_msg = new Message(this.coord, null, marshalled_msg);
        SequencerHeader hdr = new SequencerHeader(1, this.local_addr, seqno);
        forward_msg.putHeader(this.id, hdr);
        this.down_prot.down(new Event(1, forward_msg));
        ++this.forwarded_msgs;
    }

    protected void broadcast(Message msg, boolean copy) {
        Message bcast_msg = null;
        SequencerHeader hdr = (SequencerHeader)msg.getHeader(this.id);
        if (!copy) {
            bcast_msg = msg;
        } else {
            bcast_msg = new Message(null, this.local_addr, msg.getRawBuffer(), msg.getOffset(), msg.getLength());
            SequencerHeader new_hdr = new SequencerHeader(3, hdr.getOriginalSender(), hdr.getSeqno());
            bcast_msg.putHeader(this.id, new_hdr);
        }
        if (this.log.isTraceEnabled()) {
            this.log.trace(this.local_addr + ": broadcasting " + hdr.getOriginalSender() + "::" + hdr.getSeqno());
        }
        this.down_prot.down(new Event(1, bcast_msg));
        ++this.bcast_msgs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void unwrapAndDeliver(Message msg) {
        try {
            SequencerHeader hdr = (SequencerHeader)msg.getHeader(this.id);
            Message msg_to_deliver = (Message)Util.objectFromByteBuffer(msg.getRawBuffer(), msg.getOffset(), msg.getLength());
            long msg_seqno = hdr.getSeqno();
            Address sender = msg_to_deliver.getSrc();
            if (sender.equals(this.local_addr)) {
                Map<Long, byte[]> map = this.forward_table;
                synchronized (map) {
                    this.forward_table.remove(msg_seqno);
                }
            }
            if (!this.canDeliver(sender, msg_seqno)) {
                if (this.log.isWarnEnabled()) {
                    this.log.warn(this.local_addr + ": dropped duplicate message " + sender + "::" + msg_seqno);
                }
                return;
            }
            if (this.log.isTraceEnabled()) {
                this.log.trace(this.local_addr + ": delivering " + hdr.getOriginalSender() + "::" + msg_seqno);
            }
            this.up_prot.up(new Event(1, msg_to_deliver));
            ++this.delivered_bcasts;
        }
        catch (Exception e) {
            this.log.error("failure unmarshalling buffer", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void deliver(Message msg, Event evt, SequencerHeader hdr) {
        Address sender = msg.getSrc();
        if (sender == null) {
            if (this.log.isErrorEnabled()) {
                this.log.error(this.local_addr + ": sender is null, cannot deliver " + sender + "::" + hdr.getSeqno());
            }
            return;
        }
        long msg_seqno = hdr.getSeqno();
        if (sender.equals(this.local_addr)) {
            Map<Long, byte[]> map = this.forward_table;
            synchronized (map) {
                this.forward_table.remove(msg_seqno);
            }
        }
        if (!this.canDeliver(sender, msg_seqno)) {
            if (this.log.isWarnEnabled()) {
                this.log.warn(this.local_addr + ": dropped duplicate message " + sender + "::" + msg_seqno);
            }
            return;
        }
        if (this.log.isTraceEnabled()) {
            this.log.trace(this.local_addr + ": delivering " + sender + "::" + msg_seqno);
        }
        this.up_prot.up(evt);
        ++this.delivered_bcasts;
    }

    protected boolean canDeliver(Address sender, long seqno) {
        Long next_to_deliver = this.delivery_table.get(sender);
        if (next_to_deliver == null) {
            this.delivery_table.put(sender, seqno + 1L);
            return true;
        }
        if (next_to_deliver == seqno) {
            this.delivery_table.put(sender, seqno + 1L);
            return true;
        }
        return false;
    }

    public static class SequencerHeader
    extends Header {
        protected static final byte FORWARD = 1;
        protected static final byte BCAST = 2;
        protected static final byte WRAPPED_BCAST = 3;
        byte type = (byte)-1;
        ViewId tag = null;

        public SequencerHeader() {
        }

        public SequencerHeader(byte type, Address original_sender, long seqno) {
            this.type = type;
            this.tag = new ViewId(original_sender, seqno);
        }

        public Address getOriginalSender() {
            return this.tag != null ? this.tag.getCreator() : null;
        }

        public long getSeqno() {
            return this.tag != null ? this.tag.getId() : -1L;
        }

        @Override
        public String toString() {
            StringBuilder sb = new StringBuilder(64);
            sb.append(this.printType());
            if (this.tag != null) {
                sb.append(" (tag=").append(this.tag).append(")");
            }
            return sb.toString();
        }

        protected final String printType() {
            switch (this.type) {
                case 1: {
                    return "FORWARD";
                }
                case 2: {
                    return "BCAST";
                }
                case 3: {
                    return "WRAPPED_BCAST";
                }
            }
            return "n/a";
        }

        @Override
        public void writeTo(DataOutput out) throws Exception {
            out.writeByte(this.type);
            Util.writeStreamable(this.tag, out);
        }

        @Override
        public void readFrom(DataInput in) throws Exception {
            this.type = in.readByte();
            this.tag = (ViewId)Util.readStreamable(ViewId.class, in);
        }

        @Override
        public int size() {
            int size = 2;
            if (this.tag != null) {
                size += this.tag.serializedSize();
            }
            return size;
        }
    }
}

