/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.protocols.pbcast;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import org.jgroups.Address;
import org.jgroups.Event;
import org.jgroups.Message;
import org.jgroups.View;
import org.jgroups.ViewId;
import org.jgroups.protocols.pbcast.GMS;
import org.jgroups.protocols.pbcast.GmsImpl;
import org.jgroups.protocols.pbcast.JoinRsp;
import org.jgroups.protocols.pbcast.ServerGmsImpl;
import org.jgroups.util.Digest;
import org.jgroups.util.Promise;

public class ParticipantGmsImpl
extends ServerGmsImpl {
    private final List<Address> suspected_mbrs = new ArrayList<Address>(11);
    private final Promise<Boolean> leave_promise = new Promise();

    public ParticipantGmsImpl(GMS g) {
        super(g);
    }

    @Override
    public void init() throws Exception {
        super.init();
        this.suspected_mbrs.clear();
        this.leave_promise.reset();
    }

    @Override
    public void join(Address mbr, boolean useFlushIfPresent) {
        this.wrongMethod("join");
    }

    @Override
    public void joinWithStateTransfer(Address mbr, boolean useFlushIfPresent) {
        this.wrongMethod("join");
    }

    @Override
    public void leave(Address mbr) {
        Address coord;
        int max_tries = 3;
        this.leave_promise.reset();
        if (mbr.equals(this.gms.local_addr)) {
            this.leaving = true;
        }
        while ((coord = this.gms.determineCoordinator()) != null && max_tries-- > 0) {
            if (this.gms.local_addr.equals(coord)) {
                this.gms.becomeCoordinator();
                this.gms.getImpl().leave(mbr);
                return;
            }
            if (this.log.isDebugEnabled()) {
                this.log.debug("sending LEAVE request to " + coord + " (local_addr=" + this.gms.local_addr + ")");
            }
            this.sendLeaveMessage(coord, mbr);
            Boolean result = this.leave_promise.getResult(this.gms.leave_timeout);
            if (result == null) continue;
        }
        this.gms.becomeClient();
    }

    @Override
    public void handleJoinResponse(JoinRsp join_rsp) {
        View v = join_rsp.getView();
        ViewId tmp_vid = v != null ? v.getVid() : null;
        ViewId my_view = this.gms.getViewId();
        if (tmp_vid != null && my_view != null && tmp_vid.compareToIDs(my_view) > 0) {
            this.gms.installView(v);
        }
    }

    @Override
    public void handleLeaveResponse() {
        this.leave_promise.setResult(true);
    }

    @Override
    public void suspect(Address mbr) {
        LinkedHashSet<GmsImpl.Request> suspected = new LinkedHashSet<GmsImpl.Request>(1);
        suspected.add(new GmsImpl.Request(3, mbr, true));
        this.handleMembershipChange(suspected);
    }

    @Override
    public void unsuspect(Address mbr) {
        if (mbr != null) {
            this.suspected_mbrs.remove(mbr);
        }
    }

    @Override
    public void handleMembershipChange(Collection<GmsImpl.Request> requests) {
        LinkedHashSet<Address> suspectedMembers = new LinkedHashSet<Address>(requests.size());
        for (GmsImpl.Request req : requests) {
            if (req.type != 3) continue;
            suspectedMembers.add(req.mbr);
        }
        if (suspectedMembers.isEmpty()) {
            return;
        }
        for (Address mbr : suspectedMembers) {
            if (this.suspected_mbrs.contains(mbr)) continue;
            this.suspected_mbrs.add(mbr);
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug("suspected members=" + suspectedMembers + ", suspected_mbrs=" + this.suspected_mbrs);
        }
        if (this.wouldIBeCoordinator()) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("members are " + this.gms.members + ", coord=" + this.gms.local_addr + ": I'm the new coord !");
            }
            this.gms.becomeCoordinator();
            for (Address mbr : this.suspected_mbrs) {
                this.gms.getViewHandler().add(new GmsImpl.Request(3, mbr, true));
                this.gms.ack_collector.suspect(mbr);
            }
            this.suspected_mbrs.clear();
        }
    }

    @Override
    public void handleViewChange(View new_view, Digest digest) {
        List<Address> mbrs = new_view.getMembers();
        this.suspected_mbrs.clear();
        if (this.leaving && !mbrs.contains(this.gms.local_addr)) {
            return;
        }
        this.gms.installView(new_view, digest);
    }

    boolean wouldIBeCoordinator() {
        List<Address> mbrs = this.gms.members.getMembers();
        mbrs.removeAll(this.suspected_mbrs);
        if (mbrs.size() < 1) {
            return false;
        }
        Address new_coord = mbrs.get(0);
        return this.gms.local_addr.equals(new_coord);
    }

    void sendLeaveMessage(Address coord, Address mbr) {
        Message msg = new Message(coord, null, null);
        msg.setFlag(Message.OOB);
        GMS.GmsHeader hdr = new GMS.GmsHeader(3, mbr);
        msg.putHeader(this.gms.getId(), hdr);
        this.gms.getDownProtocol().down(new Event(1, msg));
    }
}

